# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class DestinyReportOffensePgcrRequest:
    """If you want to report a player causing trouble in a game, this request
    will let you report that player and the specific PGCR in which the trouble
    was caused, along with why.

    Please don't do this just because you dislike the person! I mean, I
    know people will do it anyways, but can you like take a good walk,
    or put a curse on them or something? Do me a solid and reconsider.
    Note that this request object doesn't have the actual PGCR ID nor
    your Account/Character ID in it. We will infer that information from
    your authentication information and the PGCR ID that you pass into
    the URL of the reporting endpoint itself.
    """

    offending_character_id: int = dt.field(
        metadata={
            "description": "Within the PGCR provided when calling the Reporting endpoint, this should be the character ID of the user that you thought was violating terms of use. They must exist in the PGCR provided."
        }
    )
    reason_category_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "So you've decided to report someone instead of cursing them and their descendants. Well, okay then. This is the category or categorie(s) of infractions for which you are reporting the user. These are hash identifiers that map to DestinyReportReasonCategoryDefinition entries."
        }
    )
    reason_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "If applicable, provide a more specific reason(s) within the general category of problems provided by the reasonHash. This is also an identifier for a reason. All reasonHashes provided must be children of at least one the reasonCategoryHashes provided."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "reasonCategoryHashes": to_json(self.reason_category_hashes),
            "reasonHashes": to_json(self.reason_hashes),
            "offendingCharacterId": to_json(self.offending_character_id),
        }
