# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyItemTransferRequest:
    character_id: int
    item_id: int = dt.field(
        metadata={"description": "The instance ID of the item for this action request."}
    )
    item_reference_hash: ManifestReference["DestinyInventoryItemDefinition"]
    membership_type: "BungieMembershipType"
    stack_size: int
    transfer_to_vault: bool

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemReferenceHash": to_json(self.item_reference_hash),
            "stackSize": to_json(self.stack_size),
            "transferToVault": to_json(self.transfer_to_vault),
            "itemId": to_json(self.item_id),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


from bungieapi.generated.components.schemas import BungieMembershipType  # noqa: E402

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
)
