# generated by update to not change manually
import dataclasses as dt
import typing as t
from enum import Enum

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyActionRequest:
    membership_type: "BungieMembershipType"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyCharacterActionRequest:
    character_id: int
    membership_type: "BungieMembershipType"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyItemActionRequest:
    character_id: int
    item_id: int = dt.field(
        metadata={"description": "The instance ID of the item for this action request."}
    )
    membership_type: "BungieMembershipType"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemId": to_json(self.item_id),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyPostmasterTransferRequest:
    character_id: int
    item_id: int = dt.field(
        metadata={"description": "The instance ID of the item for this action request."}
    )
    item_reference_hash: ManifestReference["DestinyInventoryItemDefinition"]
    membership_type: "BungieMembershipType"
    stack_size: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemReferenceHash": to_json(self.item_reference_hash),
            "stackSize": to_json(self.stack_size),
            "itemId": to_json(self.item_id),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyItemSetActionRequest:
    character_id: int
    item_ids: t.Sequence[int]
    membership_type: "BungieMembershipType"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemIds": to_json(self.item_ids),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyItemStateRequest:
    character_id: int
    item_id: int = dt.field(
        metadata={"description": "The instance ID of the item for this action request."}
    )
    membership_type: "BungieMembershipType"
    state: bool

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "state": to_json(self.state),
            "itemId": to_json(self.item_id),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyInsertPlugsActionRequest:
    action_token: str = dt.field(
        metadata={
            "description": "Action token provided by the AwaGetActionToken API call."
        }
    )
    character_id: int
    item_instance_id: int = dt.field(
        metadata={
            "description": "The instance ID of the item having a plug inserted. Only instanced items can have sockets."
        }
    )
    membership_type: "BungieMembershipType"
    plug: "DestinyInsertPlugsRequestEntry" = dt.field(
        metadata={"description": "The plugs being inserted."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "actionToken": to_json(self.action_token),
            "itemInstanceId": to_json(self.item_instance_id),
            "plug": to_json(self.plug),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


@dt.dataclass(frozen=True)
class DestinyInsertPlugsRequestEntry:
    """Represents all of the data related to a single plug to be inserted.

    Note that, while you *can* point to a socket that represents
    infusion, you will receive an error if you attempt to do so. Come on
    guys, let's play nice.
    """

    plug_item_hash: int = dt.field(
        metadata={
            "description": "Plugs are never instanced (except in infusion). So with the hash alone, we should be able to: 1) Infer whether the player actually needs to have the item, or if it's a reusable plug 2) Perform any operation needed to use the Plug, including removing the plug item and running reward sheets."
        }
    )
    socket_array_type: "DestinySocketArrayType" = dt.field(
        metadata={
            "description": 'This property, combined with the socketIndex, tells us which socket we are referring to (since operations can be performed on both Intrinsic and "default" sockets, and they occupy different arrays in the Inventory Item Definition). I know, I know. Don\'t give me that look.'
        }
    )
    socket_index: int = dt.field(
        metadata={
            "description": """The index into the socket array, which identifies the specific socket being operated on. We also need to know the socketArrayType in order to uniquely identify the socket.
Don't point to or try to insert a plug into an infusion socket. It won't work."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "socketIndex": to_json(self.socket_index),
            "socketArrayType": to_json(self.socket_array_type),
            "plugItemHash": to_json(self.plug_item_hash),
        }


class DestinySocketArrayType(Enum):
    """If you look in the DestinyInventoryItemDefinition's "sockets" property,
    you'll see that there are two types of sockets: intrinsic, and
    "socketEntry." Unfortunately, because Intrinsic sockets are a whole
    separate array, it is no longer sufficient to know the index into that
    array to know which socket we're talking about.

    You have to know whether it's in the default "socketEntries" or if
    it's in the "intrinsic" list.
    """

    DEFAULT = 0
    INTRINSIC = 1


@dt.dataclass(frozen=True)
class DestinyInsertPlugsFreeActionRequest:
    character_id: int
    item_id: int = dt.field(
        metadata={"description": "The instance ID of the item for this action request."}
    )
    membership_type: "BungieMembershipType"
    plug: "DestinyInsertPlugsRequestEntry" = dt.field(
        metadata={"description": "The plugs being inserted."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "plug": to_json(self.plug),
            "itemId": to_json(self.item_id),
            "characterId": to_json(self.character_id),
            "membershipType": to_json(self.membership_type),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas import BungieMembershipType  # noqa: E402
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
)
