# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyItemPlugBase:
    can_insert: bool = dt.field(
        metadata={
            "description": "If true, this plug has met all of its insertion requirements. Big if true."
        }
    )
    enable_fail_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": """If a plug is not enabled, this will be populated with indexes into the plug item definition's plug.enabledRules property, so that you can show the reasons why it is not enabled.
This list will be empty if the plug is enabled."""
        }
    )
    enabled: bool = dt.field(
        metadata={
            "description": "If true, this plug will provide its benefits while inserted."
        }
    )
    insert_fail_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": """If the plug cannot be inserted for some reason, this will have the indexes into the plug item definition's plug.insertionRules property, so you can show the reasons why it can't be inserted.
This list will be empty if the plug can be inserted."""
        }
    )
    plug_item_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The hash identifier of the DestinyInventoryItemDefinition that represents this plug."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "plugItemHash": to_json(self.plug_item_hash),
            "canInsert": to_json(self.can_insert),
            "enabled": to_json(self.enabled),
            "insertFailIndexes": to_json(self.insert_fail_indexes),
            "enableFailIndexes": to_json(self.enable_fail_indexes),
        }


@dt.dataclass(frozen=True)
class DestinyItemPlug:
    can_insert: bool = dt.field(
        metadata={
            "description": "If true, this plug has met all of its insertion requirements. Big if true."
        }
    )
    enable_fail_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": """If a plug is not enabled, this will be populated with indexes into the plug item definition's plug.enabledRules property, so that you can show the reasons why it is not enabled.
This list will be empty if the plug is enabled."""
        }
    )
    enabled: bool = dt.field(
        metadata={
            "description": "If true, this plug will provide its benefits while inserted."
        }
    )
    insert_fail_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": """If the plug cannot be inserted for some reason, this will have the indexes into the plug item definition's plug.insertionRules property, so you can show the reasons why it can't be inserted.
This list will be empty if the plug can be inserted."""
        }
    )
    plug_item_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The hash identifier of the DestinyInventoryItemDefinition that represents this plug."
        }
    )
    plug_objectives: t.Sequence["DestinyObjectiveProgress"] = dt.field(
        metadata={
            "description": "Sometimes, Plugs may have objectives: these are often used for flavor and display purposes, but they can be used for any arbitrary purpose (both fortunately and unfortunately). Recently (with Season 2) they were expanded in use to be used as the \"gating\" for whether the plug can be inserted at all. For instance, a Plug might be tracking the number of PVP kills you have made. It will use the parent item's data about that tracking status to determine what to show, and will generally show it using the DestinyObjectiveDefinition's progressDescription property. Refer to the plug's itemHash and objective property for more information if you would like to display even more data."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "plugObjectives": to_json(self.plug_objectives),
            "plugItemHash": to_json(self.plug_item_hash),
            "canInsert": to_json(self.can_insert),
            "enabled": to_json(self.enabled),
            "insertFailIndexes": to_json(self.insert_fail_indexes),
            "enableFailIndexes": to_json(self.enable_fail_indexes),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
)
from bungieapi.generated.components.schemas.destiny.quests import (  # noqa: E402
    DestinyObjectiveProgress,
)
