# generated by update to not change manually
import dataclasses as dt
import typing as t
from enum import Enum

from bungieapi.json import to_json


class FireteamDateRange(Enum):
    ALL = 0
    NOW = 1
    TWENTY_FOUR_HOURS = 2
    FORTY_EIGHT_HOURS = 3
    THIS_WEEK = 4


class FireteamPlatform(Enum):
    ANY = 0
    PLAYSTATION4 = 1
    XBOX_ONE = 2
    BLIZZARD = 3
    STEAM = 4
    STADIA = 5


class FireteamPublicSearchOption(Enum):
    PUBLIC_AND_PRIVATE = 0
    PUBLIC_ONLY = 1
    PRIVATE_ONLY = 2


class FireteamSlotSearch(Enum):
    NO_SLOT_RESTRICTION = 0
    HAS_OPEN_PLAYER_SLOTS = 1
    HAS_OPEN_PLAYER_OR_ALT_SLOTS = 2


@dt.dataclass(frozen=True)
class FireteamSummary:
    activity_type: int
    available_alternate_slot_count: int
    available_player_slot_count: int
    date_created: str
    date_player_modified: str
    fireteam_id: int
    group_id: int
    is_immediate: bool
    is_public: bool
    is_valid: bool
    locale: str
    owner_membership_id: int
    platform: "FireteamPlatform"
    player_slot_count: int
    title: str
    title_before_moderation: str
    alternate_slot_count: t.Optional[int] = None
    date_modified: t.Optional[str] = None
    scheduled_time: t.Optional[str] = None

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "fireteamId": to_json(self.fireteam_id),
            "groupId": to_json(self.group_id),
            "platform": to_json(self.platform),
            "activityType": to_json(self.activity_type),
            "isImmediate": to_json(self.is_immediate),
            "scheduledTime": to_json(self.scheduled_time),
            "ownerMembershipId": to_json(self.owner_membership_id),
            "playerSlotCount": to_json(self.player_slot_count),
            "alternateSlotCount": to_json(self.alternate_slot_count),
            "availablePlayerSlotCount": to_json(self.available_player_slot_count),
            "availableAlternateSlotCount": to_json(self.available_alternate_slot_count),
            "title": to_json(self.title),
            "dateCreated": to_json(self.date_created),
            "dateModified": to_json(self.date_modified),
            "isPublic": to_json(self.is_public),
            "locale": to_json(self.locale),
            "isValid": to_json(self.is_valid),
            "datePlayerModified": to_json(self.date_player_modified),
            "titleBeforeModeration": to_json(self.title_before_moderation),
        }


@dt.dataclass(frozen=True)
class FireteamResponse:
    alternates: t.Sequence["FireteamMember"]
    members: t.Sequence["FireteamMember"]
    summary: "FireteamSummary"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Summary": to_json(self.summary),
            "Members": to_json(self.members),
            "Alternates": to_json(self.alternates),
        }


@dt.dataclass(frozen=True)
class FireteamMember:
    bungie_net_user_info: "UserInfoCard"
    character_id: int
    date_joined: str
    destiny_user_info: "FireteamUserInfoCard"
    has_microphone: bool
    last_platform_invite_attempt_date: str
    last_platform_invite_attempt_result: "FireteamPlatformInviteResult"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "destinyUserInfo": to_json(self.destiny_user_info),
            "bungieNetUserInfo": to_json(self.bungie_net_user_info),
            "characterId": to_json(self.character_id),
            "dateJoined": to_json(self.date_joined),
            "hasMicrophone": to_json(self.has_microphone),
            "lastPlatformInviteAttemptDate": to_json(
                self.last_platform_invite_attempt_date
            ),
            "lastPlatformInviteAttemptResult": to_json(
                self.last_platform_invite_attempt_result
            ),
        }


@dt.dataclass(frozen=True)
class FireteamUserInfoCard:
    fireteam_display_name: str
    fireteam_membership_type: "BungieMembershipType"
    applicable_membership_types: t.Sequence["BungieMembershipType"] = dt.field(
        metadata={
            "description": """The list of Membership Types indicating the platforms on which this Membership can be used.
 Not in Cross Save = its original membership type. Cross Save Primary = Any membership types it is overridding, and its original membership type Cross Save Overridden = Empty list"""
        }
    )
    bungie_global_display_name: str = dt.field(
        metadata={"description": "The bungie global display name, if set."}
    )
    cross_save_override: "BungieMembershipType" = dt.field(
        metadata={
            "description": "If there is a cross save override in effect, this value will tell you the type that is overridding this one."
        }
    )
    display_name: str = dt.field(
        metadata={
            "description": "Display Name the player has chosen for themselves. The display name is optional when the data type is used as input to a platform API."
        }
    )
    icon_path: str = dt.field(metadata={"description": "URL the Icon if available."})
    is_public: bool = dt.field(
        metadata={"description": "If True, this is a public user membership."}
    )
    membership_id: int = dt.field(
        metadata={
            "description": "Membership ID as they user is known in the Accounts service"
        }
    )
    membership_type: "BungieMembershipType" = dt.field(
        metadata={
            "description": "Type of the membership. Not necessarily the native type."
        }
    )
    supplemental_display_name: str = dt.field(
        metadata={
            "description": "A platform specific additional display name - ex: psn Real Name, bnet Unique Name, etc."
        }
    )
    bungie_global_display_name_code: t.Optional[int] = dt.field(
        default=None,
        metadata={"description": "The bungie global display name code, if set."},
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "FireteamDisplayName": to_json(self.fireteam_display_name),
            "FireteamMembershipType": to_json(self.fireteam_membership_type),
            "supplementalDisplayName": to_json(self.supplemental_display_name),
            "iconPath": to_json(self.icon_path),
            "crossSaveOverride": to_json(self.cross_save_override),
            "applicableMembershipTypes": to_json(self.applicable_membership_types),
            "isPublic": to_json(self.is_public),
            "membershipType": to_json(self.membership_type),
            "membershipId": to_json(self.membership_id),
            "displayName": to_json(self.display_name),
            "bungieGlobalDisplayName": to_json(self.bungie_global_display_name),
            "bungieGlobalDisplayNameCode": to_json(
                self.bungie_global_display_name_code
            ),
        }


class FireteamPlatformInviteResult(Enum):
    NONE = 0
    SUCCESS = 1
    ALREADY_IN_FIRETEAM = 2
    THROTTLED = 3
    SERVICE_ERROR = 4


from bungieapi.generated.components.schemas import BungieMembershipType  # noqa: E402

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.user import UserInfoCard  # noqa: E402
