# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class SearchResult:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class PagedQuery:
    current_page: int
    items_per_page: int
    request_continuation_token: str

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemsPerPage": to_json(self.items_per_page),
            "currentPage": to_json(self.current_page),
            "requestContinuationToken": to_json(self.request_continuation_token),
        }
