# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class PartnerOfferClaimRequest:
    bungie_net_membership_id: int
    partner_offer_id: str
    transaction_id: str

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "PartnerOfferId": to_json(self.partner_offer_id),
            "BungieNetMembershipId": to_json(self.bungie_net_membership_id),
            "TransactionId": to_json(self.transaction_id),
        }


@dt.dataclass(frozen=True)
class PartnerOfferSkuHistoryResponse:
    all_offers_applied: bool
    claim_date: str
    localized_description: str
    localized_name: str
    sku_identifier: str
    sku_offers: t.Sequence["PartnerOfferHistoryResponse"]
    transaction_id: str

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "SkuIdentifier": to_json(self.sku_identifier),
            "LocalizedName": to_json(self.localized_name),
            "LocalizedDescription": to_json(self.localized_description),
            "ClaimDate": to_json(self.claim_date),
            "AllOffersApplied": to_json(self.all_offers_applied),
            "TransactionId": to_json(self.transaction_id),
            "SkuOffers": to_json(self.sku_offers),
        }


@dt.dataclass(frozen=True)
class PartnerOfferHistoryResponse:
    is_consumable: bool
    localized_description: str
    localized_name: str
    partner_offer_key: str
    quantity_applied: int
    apply_date: t.Optional[str] = None
    membership_id: t.Optional[int] = None
    membership_type: t.Optional[int] = None

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "PartnerOfferKey": to_json(self.partner_offer_key),
            "MembershipId": to_json(self.membership_id),
            "MembershipType": to_json(self.membership_type),
            "LocalizedName": to_json(self.localized_name),
            "LocalizedDescription": to_json(self.localized_description),
            "IsConsumable": to_json(self.is_consumable),
            "QuantityApplied": to_json(self.quantity_applied),
            "ApplyDate": to_json(self.apply_date),
        }
