# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class GetCredentialTypesForAccountResponse:
    credential_as_string: str
    credential_display_name: str
    credential_type: "BungieCredentialType"
    is_public: bool

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "credentialType": to_json(self.credential_type),
            "credentialDisplayName": to_json(self.credential_display_name),
            "isPublic": to_json(self.is_public),
            "credentialAsString": to_json(self.credential_as_string),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas import BungieCredentialType  # noqa: E402
