# Importmod
![pipeline](https://gitlab.com/portmod/importmod/badges/master/pipeline.svg)
![coverage](https://gitlab.com/portmod/importmod/badges/master/coverage.svg)

A cli tool to import mods into the Portmod Repository Format.

## Updates

Importmod supports detecting updates, and automatically generating packages by pulling data from their upstream projects and scanning the source files.

### Explicit source metadata

Importmod extends portmod's [metadata.yaml](https://portmod.gitlab.io/portmod/repo/metadata.yaml.html) to allow individual packages to specify how their updates to be detected.

For the moment, this is the only way for packages to be included in updates generated by the `importmod update` command.

#### Gitlab

E.g.

```yaml
updates:
  source:
    type: gitlab
    server: https://gitlab.com
    # <user>/<project>
    id: portmod/importmod
```

#### Github

E.g.

```yaml
updates:
  source:
    type: github
    # <user>/<project>
    id: xNVSE/NVSE
```

#### PyPI

E.g.

```yaml
updates:
  source:
    type: pypi
    # Name as used on pypi
    id: importmod
```

#### NexusMods

E.g.

```yaml
updates:
  source:
    type: nexusmods
    # Name as used on pypi
    game: newvegas
    # Numeric mod identifier as is found in a project page's URL
    modid: 67883
```

#### Avoiding Changes to Package files

If package files should just be copied verbatim from the old version (E.g. if they are using [pybuild.info](https://portmod.gitlab.io/portmod/api/pybuild.info.html) to use the version information from the file name) you can flag the packages in the following manner:

```yaml
updates:
  copy: true
```
