/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jira;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.jira.JiraExportResult;
import io.qameta.allure.jira.JiraExportUtils;
import io.qameta.allure.jira.JiraLaunch;
import io.qameta.allure.jira.JiraService;
import io.qameta.allure.jira.JiraServiceBuilder;
import io.qameta.allure.jira.JiraTestResult;
import io.qameta.allure.jira.LaunchStatisticExport;
import io.qameta.allure.util.PropertyUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraExportPlugin
implements Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraExportPlugin.class);
    private static final String ALLURE_JIRA_ENABLED = "ALLURE_JIRA_ENABLED";
    private static final String ALLURE_JIRA_LAUNCH_ISSUES = "ALLURE_JIRA_LAUNCH_ISSUES";
    private final Supplier<JiraService> jiraServiceSupplier;
    private final boolean enabled;
    private final String issues;

    public JiraExportPlugin() {
        this(PropertyUtils.getProperty((String)ALLURE_JIRA_ENABLED).map(Boolean::parseBoolean).orElse(false), PropertyUtils.getProperty((String)ALLURE_JIRA_LAUNCH_ISSUES).orElse(""), () -> new JiraServiceBuilder().defaults().build());
    }

    public JiraExportPlugin(boolean enabled, String issues, Supplier<JiraService> jiraServiceSupplier) {
        this.jiraServiceSupplier = jiraServiceSupplier;
        this.enabled = enabled;
        this.issues = issues;
    }

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        if (this.enabled) {
            JiraService jiraService = this.jiraServiceSupplier.get();
            List<String> issues = JiraExportUtils.splitByComma(this.issues);
            ExecutorInfo executor = JiraExportUtils.getExecutor(launchesResults);
            Statistic statisticToConvert = JiraExportUtils.getStatistic(launchesResults);
            List<LaunchStatisticExport> statistic = JiraExportUtils.convertStatistics(statisticToConvert);
            JiraLaunch launch = JiraExportUtils.getJiraLaunch(executor, statistic);
            this.exportLaunchToJira(jiraService, launch, issues);
            JiraExportUtils.getTestResults(launchesResults).stream().map(testResult -> JiraExportUtils.getJiraTestResult(executor, testResult)).filter(Optional::isPresent).map(Optional::get).forEach(jiraTestResult -> JiraExportUtils.getTestResults(launchesResults).stream().forEach(testResult -> this.exportTestResultToJira(jiraService, (JiraTestResult)jiraTestResult, (TestResult)testResult)));
        }
    }

    private List<JiraExportResult> exportLaunchToJira(JiraService jiraService, JiraLaunch launch, List<String> issues) {
        try {
            List created = jiraService.createJiraLaunch(launch, issues);
            List<JiraExportResult> failedExports = this.findFailuresInExportResult(created);
            if (!failedExports.isEmpty()) {
                this.logErrorResults(failedExports);
            } else {
                LOGGER.info(String.format("Allure launch '%s' synced with issues  successfully%n", issues));
                LOGGER.info(String.format("Results of launch export %n %s", created));
            }
            return created;
        }
        catch (Throwable e) {
            LOGGER.error(String.format("Allure launch sync with issue '%s' error", issues), e);
            throw e;
        }
    }

    private void exportTestResultToJira(JiraService jiraService, JiraTestResult jiraTestResult, TestResult testResult) {
        if (!Objects.equals(jiraTestResult.getTestCaseId(), testResult.getUid())) {
            return;
        }
        try {
            List issues = testResult.getLinks().stream().filter(JiraExportUtils::isIssueLink).map(Link::getName).collect(Collectors.toList());
            List created = jiraService.createTestResult(jiraTestResult, issues);
            List<JiraExportResult> failedExports = this.findFailuresInExportResult(created);
            if (!failedExports.isEmpty()) {
                this.logErrorResults(failedExports);
            } else {
                LOGGER.info("All Test Results have been successfully exported to Jira");
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("Allure test result sync with issue '%s' failed", jiraTestResult.getExternalId()), e);
            throw e;
        }
    }

    private void logErrorResults(List<JiraExportResult> failedExportResults) {
        LOGGER.error(String.format("There was an failure in response%n %s", failedExportResults));
    }

    private List<JiraExportResult> findFailuresInExportResult(List<JiraExportResult> exportResults) {
        return exportResults.stream().filter(exportResult -> exportResult.getStatus().equals(Status.FAILED.value())).collect(Collectors.toList());
    }
}

