/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.xctest;

import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Step;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Time;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ResultsUtils {
    private static final String TEST_NAME = "TestName";
    private static final String TEST_STATUS = "TestStatus";
    private static final String TEST_DURATION = "Duration";
    private static final String TEST_IDENTIFIER = "TestIdentifier";
    private static final String STEP_NAME = "Title";
    private static final String STEP_START_TIME = "StartTimeInterval";
    private static final String STEP_STOP_TIME = "FinishTimeInterval";

    private ResultsUtils() {
    }

    public static TestResult getTestResult(Map<String, Object> props) {
        return new TestResult().setUid(UUID.randomUUID().toString()).setName(ResultsUtils.getTestName(props)).setStatus(ResultsUtils.getTestStatus(props)).setFullName(ResultsUtils.getFullName(props)).setTime(ResultsUtils.getTestTime(props)).setTestStage(new StageResult());
    }

    public static boolean isTest(Map<String, Object> props) {
        return props.containsKey(TEST_STATUS);
    }

    public static String getTestName(Map<String, Object> props) {
        return (String)props.getOrDefault(TEST_NAME, "Unknown");
    }

    private static String getFullName(Map<String, Object> props) {
        return (String)props.getOrDefault(TEST_IDENTIFIER, "Unknown");
    }

    private static Time getTestTime(Map<String, Object> props) {
        return new Time().setDuration(Long.valueOf(ResultsUtils.parseTime(props.getOrDefault(TEST_DURATION, "0").toString())));
    }

    private static Status getTestStatus(Map<String, Object> props) {
        Object status = props.get(TEST_STATUS);
        if (Objects.isNull(status)) {
            return Status.UNKNOWN;
        }
        if ("Success".equals(status)) {
            return Status.PASSED;
        }
        if ("Failure".equals(status)) {
            return Status.FAILED;
        }
        return Status.UNKNOWN;
    }

    public static Step getStep(Map<String, Object> props) {
        return new Step().setName(ResultsUtils.getStepName(props)).setTime(ResultsUtils.getStepTime(props)).setStatus(Status.PASSED);
    }

    private static String getStepName(Map<String, Object> props) {
        return (String)props.getOrDefault(STEP_NAME, "Unknown");
    }

    private static Time getStepTime(Map<String, Object> props) {
        long start = ResultsUtils.parseTime(props.getOrDefault(STEP_START_TIME, "0").toString());
        long stop = ResultsUtils.parseTime(props.getOrDefault(STEP_STOP_TIME, "0").toString());
        return new Time().setStart(Long.valueOf(start)).setStop(Long.valueOf(stop)).setDuration(Long.valueOf(stop - start));
    }

    private static long parseTime(String time) {
        Double doubleTime = Double.parseDouble(time);
        int seconds = doubleTime.intValue();
        return seconds * 1000;
    }
}

