/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.trend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator;
import io.qameta.allure.CompositeAggregator;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.ExecutorInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrendPlugin<T>
extends CompositeAggregator
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrendPlugin.class);
    private final String jsonFileName;
    private final String trendBlockName;

    protected AbstractTrendPlugin(List<Aggregator> aggregators, String jsonFileName, String trendBlockName) {
        super(aggregators);
        this.jsonFileName = jsonFileName;
        this.trendBlockName = trendBlockName;
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path historyFile = directory.resolve("history").resolve(this.jsonFileName);
        if (Files.exists(historyFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(historyFile, new OpenOption[0]);){
                ObjectMapper mapper = context.getValue();
                JsonNode jsonNode = mapper.readTree(is);
                List history = jsonNode != null ? this.getStream(jsonNode).map(child -> this.parseItem(historyFile, mapper, (JsonNode)child)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()) : Collections.emptyList();
                visitor.visitExtra(this.trendBlockName, history);
            }
            catch (IOException e) {
                visitor.error("Could not read " + this.trendBlockName + " file " + historyFile, (Exception)e);
            }
        }
    }

    private Stream<JsonNode> getStream(JsonNode jsonNode) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(jsonNode.elements(), 16), false);
    }

    private Optional<T> parseItem(Path historyFile, ObjectMapper mapper, JsonNode child) {
        try {
            return this.parseItem(mapper, child);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not read {}", (Object)historyFile, (Object)e);
            return Optional.empty();
        }
    }

    protected abstract Optional<T> parseItem(ObjectMapper var1, JsonNode var2) throws JsonProcessingException;

    protected static Optional<ExecutorInfo> extractLatestExecutor(List<LaunchResults> launches) {
        Comparator<ExecutorInfo> comparator = Comparator.comparing(ExecutorInfo::getBuildOrder, Comparator.nullsFirst(Comparator.naturalOrder()));
        return launches.stream().map(launch -> launch.getExtra("executor")).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).max(comparator);
    }
}

