# amphoradata
             Connect information in real time with Amphora Data.                          Learn more at https://docs.amphoradata.com

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.10.11
- Package version: 0.10.11
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import amphora_api_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import amphora_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import amphora_api_client
from amphora_api_client.rest import ApiException
from pprint import pprint

configuration = amphora_api_client.Configuration()
# Configure API key authorization: Bearer
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# Defining host is optional and default to https://app.amphoradata.com
configuration.host = "https://app.amphoradata.com"
# Create an instance of the API class
api_instance = amphora_api_client.ActivitiesApi(amphora_api_client.ApiClient(configuration))
create_activity = amphora_api_client.CreateActivity() # CreateActivity | Metadata of the new activity.

try:
    # Creates a new activity.
    api_response = api_instance.activities_create_activity(create_activity)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActivitiesApi->activities_create_activity: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://app.amphoradata.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**activities_create_activity**](docs/ActivitiesApi.md#activities_create_activity) | **POST** /api/activities | Creates a new activity.
*ActivitiesApi* | [**activities_delete_activity**](docs/ActivitiesApi.md#activities_delete_activity) | **DELETE** /api/activities/{id} | Deletes an activity.
*ActivitiesApi* | [**activities_read_activity**](docs/ActivitiesApi.md#activities_read_activity) | **GET** /api/activities/{id} | Gets the metadata of an activity.
*ActivitiesApi* | [**activities_reference_amphora**](docs/ActivitiesApi.md#activities_reference_amphora) | **PUT** /api/activities/{id}/Runs/{runId}/amphorae/{amphoraId} | References an Amphora during a run.
*ActivitiesApi* | [**activities_start_run**](docs/ActivitiesApi.md#activities_start_run) | **POST** /api/activities/{id}/Runs | Starts a new run of an activity.
*ActivitiesApi* | [**activities_update_run**](docs/ActivitiesApi.md#activities_update_run) | **POST** /api/activities/{id}/Runs/{runId} | Updates and completes a run.
*AmphoraeApi* | [**amphora_quality_get**](docs/AmphoraeApi.md#amphora_quality_get) | **GET** /api/amphorae/{id}/quality | Gets the data quality metrics for this Amphora.
*AmphoraeApi* | [**amphora_quality_set**](docs/AmphoraeApi.md#amphora_quality_set) | **POST** /api/amphorae/{id}/quality | Sets the data quality metrics for this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_create_for_all**](docs/AmphoraeApi.md#amphorae_access_controls_create_for_all) | **POST** /api/amphorae/{id}/AccessControls/ForAll | Creates an Access Control Rule for all on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_create_for_organisation**](docs/AmphoraeApi.md#amphorae_access_controls_create_for_organisation) | **POST** /api/amphorae/{id}/AccessControls/ForOrganisation | Creates an Access Control Rule on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_create_for_user**](docs/AmphoraeApi.md#amphorae_access_controls_create_for_user) | **POST** /api/amphorae/{id}/AccessControls/ForUser | Creates an Access Control rule on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_delete**](docs/AmphoraeApi.md#amphorae_access_controls_delete) | **DELETE** /api/amphorae/{id}/AccessControls/{ruleId} | Deletes an Access Control on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_get_for_all_rule**](docs/AmphoraeApi.md#amphorae_access_controls_get_for_all_rule) | **GET** /api/amphorae/{id}/AccessControls/ForAll | Get&#39;s the &#39;for all&#39; rule, if it exists, else an empty 200.
*AmphoraeApi* | [**amphorae_access_controls_get_organisation_rules**](docs/AmphoraeApi.md#amphorae_access_controls_get_organisation_rules) | **GET** /api/amphorae/{id}/AccessControls/ForOrganisation | Get&#39;s the list of access rules applied to organisations.
*AmphoraeApi* | [**amphorae_access_controls_get_user_rules**](docs/AmphoraeApi.md#amphorae_access_controls_get_user_rules) | **GET** /api/amphorae/{id}/AccessControls/ForUser | Get&#39;s the list of access rules applied to users.
*AmphoraeApi* | [**amphorae_create**](docs/AmphoraeApi.md#amphorae_create) | **POST** /api/amphorae | Creates a new empty Amphora in the user&#39;s organisation.
*AmphoraeApi* | [**amphorae_delete**](docs/AmphoraeApi.md#amphorae_delete) | **DELETE** /api/amphorae/{id} | Deletes an Amphora.
*AmphoraeApi* | [**amphorae_files_create_file_request**](docs/AmphoraeApi.md#amphorae_files_create_file_request) | **POST** /api/amphorae/{id}/files/{file} | Creates a file. Returns a blob URL to upload to.
*AmphoraeApi* | [**amphorae_files_delete_file**](docs/AmphoraeApi.md#amphorae_files_delete_file) | **DELETE** /api/amphorae/{id}/files/{file} | Get&#39;s the contents of a file. Returns application/octet-stream.
*AmphoraeApi* | [**amphorae_files_download_file**](docs/AmphoraeApi.md#amphorae_files_download_file) | **GET** /api/amphorae/{id}/files/{file} | Get&#39;s the contents of a file. Returns application/octet-stream.
*AmphoraeApi* | [**amphorae_files_list_files**](docs/AmphoraeApi.md#amphorae_files_list_files) | **GET** /api/amphorae/{id}/files | Lists an Amphora&#39;s files.
*AmphoraeApi* | [**amphorae_files_query_files**](docs/AmphoraeApi.md#amphorae_files_query_files) | **POST** /api/amphorae/{id}/files | Queries an Amphora&#39;s files.
*AmphoraeApi* | [**amphorae_files_read_file_attributes**](docs/AmphoraeApi.md#amphorae_files_read_file_attributes) | **GET** /api/amphorae/{id}/files/{file}/attributes | Get&#39;s the attributes of a file.
*AmphoraeApi* | [**amphorae_files_write_file_attributes**](docs/AmphoraeApi.md#amphorae_files_write_file_attributes) | **POST** /api/amphorae/{id}/files/{file}/attributes | 
*AmphoraeApi* | [**amphorae_list**](docs/AmphoraeApi.md#amphorae_list) | **GET** /api/amphorae | Gets a list of Amphora for yourself or your org, created or purchased by you (or organisation).
*AmphoraeApi* | [**amphorae_read**](docs/AmphoraeApi.md#amphorae_read) | **GET** /api/amphorae/{id} | Gets details of an Amphora by Id.
*AmphoraeApi* | [**amphorae_signals_create_signal**](docs/AmphoraeApi.md#amphorae_signals_create_signal) | **POST** /api/amphorae/{id}/signals | Associates a signal with an Amphora. Signal is created if not existing.
*AmphoraeApi* | [**amphorae_signals_get_signal**](docs/AmphoraeApi.md#amphorae_signals_get_signal) | **GET** /api/amphorae/{id}/signals/{property} | Get&#39;s the signals associated with an Amphora.
*AmphoraeApi* | [**amphorae_signals_get_signals**](docs/AmphoraeApi.md#amphorae_signals_get_signals) | **GET** /api/amphorae/{id}/signals | Get&#39;s the signals associated with an Amphora.
*AmphoraeApi* | [**amphorae_signals_update_signal**](docs/AmphoraeApi.md#amphorae_signals_update_signal) | **PUT** /api/amphorae/{id}/signals/{signalId} | Associates a signal with an Amphora. Signal is created if not existing.
*AmphoraeApi* | [**amphorae_signals_upload_signal**](docs/AmphoraeApi.md#amphorae_signals_upload_signal) | **POST** /api/amphorae/{id}/signals/values | 
*AmphoraeApi* | [**amphorae_signals_upload_signal2**](docs/AmphoraeApi.md#amphorae_signals_upload_signal2) | **POST** /api/amphorae/{id}/signalValues | 
*AmphoraeApi* | [**amphorae_signals_upload_signal_batch**](docs/AmphoraeApi.md#amphorae_signals_upload_signal_batch) | **POST** /api/amphorae/{id}/signals/batchvalues | 
*AmphoraeApi* | [**amphorae_signals_upload_signal_batch2**](docs/AmphoraeApi.md#amphorae_signals_upload_signal_batch2) | **POST** /api/amphorae/{id}/batchSignalValues | 
*AmphoraeApi* | [**amphorae_update**](docs/AmphoraeApi.md#amphorae_update) | **PUT** /api/amphorae/{id} | Updates the details of an Amphora by Id.
*AmphoraeApi* | [**purchases_purchase**](docs/AmphoraeApi.md#purchases_purchase) | **POST** /api/Amphorae/{id}/Purchases | Purchases an Amphora as the logged in user.
*ApplicationsApi* | [**applications_create_application**](docs/ApplicationsApi.md#applications_create_application) | **POST** /api/applications | Creates a new application. Applications are external websites that Amphora users can sign in to.
*ApplicationsApi* | [**applications_delete_application**](docs/ApplicationsApi.md#applications_delete_application) | **DELETE** /api/applications/{id} | Deletes an application. Must be done by an Organisation administrator.
*ApplicationsApi* | [**applications_read_application**](docs/ApplicationsApi.md#applications_read_application) | **GET** /api/applications/{id} | Gets an application by Id, if it exists.
*ApplicationsApi* | [**applications_update_application**](docs/ApplicationsApi.md#applications_update_application) | **PUT** /api/applications/{id} | Updates an application by Id, if it exists.
*AuthenticationApi* | [**authentication_request_token**](docs/AuthenticationApi.md#authentication_request_token) | **POST** /api/authentication/request | Returns a JWT (JSON Web Token).             
*GeoApi* | [**geo_lookup_location**](docs/GeoApi.md#geo_lookup_location) | **GET** /api/geo/search/fuzzy | Executes a fuzzy location search.
*IdentityApi* | [**identity_get**](docs/IdentityApi.md#identity_get) | **GET** /identity | 
*OrganisationsApi* | [**account_get_plan**](docs/OrganisationsApi.md#account_get_plan) | **GET** /api/Organisations/{id}/Account/Plan | Get&#39;s an Organisation&#39;s plan information.
*OrganisationsApi* | [**account_read**](docs/OrganisationsApi.md#account_read) | **GET** /api/Organisations/{id}/Account | Get&#39;s an Organisation&#39;s account information.
*OrganisationsApi* | [**organisations_create**](docs/OrganisationsApi.md#organisations_create) | **POST** /api/Organisations | Creates a new Organisation. This will assign the logged in user to the organisation.
*OrganisationsApi* | [**organisations_delete**](docs/OrganisationsApi.md#organisations_delete) | **DELETE** /api/Organisations/{id} | Deletes an organisation.
*OrganisationsApi* | [**organisations_read**](docs/OrganisationsApi.md#organisations_read) | **GET** /api/Organisations/{id} | Gets an organisation&#39;s details.
*OrganisationsApi* | [**organisations_read_invitations**](docs/OrganisationsApi.md#organisations_read_invitations) | **GET** /api/Organisations/{id}/Invitations | Gets an organisation&#39;s invitations.
*OrganisationsApi* | [**organisations_terms_of_use_read**](docs/OrganisationsApi.md#organisations_terms_of_use_read) | **GET** /api/Organisations/{id}/TermsOfUse | Get&#39;s a list of an Organisation&#39;s Terms of Use.
*OrganisationsApi* | [**organisations_update**](docs/OrganisationsApi.md#organisations_update) | **PUT** /api/Organisations/{id} | Updates an organisation.
*PermissionApi* | [**permission_get_permissions**](docs/PermissionApi.md#permission_get_permissions) | **POST** /api/permissions | The permission level for each object id in the request.
*SearchApi* | [**search_search_amphorae**](docs/SearchApi.md#search_search_amphorae) | **GET** /api/search/amphorae | Searches for Amphorae.
*SearchApi* | [**search_search_amphorae_by_location**](docs/SearchApi.md#search_search_amphorae_by_location) | **GET** /api/search/amphorae/byLocation | Searches for Amphorae by loction.
*SearchApi* | [**search_search_amphorae_by_organisation**](docs/SearchApi.md#search_search_amphorae_by_organisation) | **GET** /api/search/amphorae/byOrganisation | Searches for Amphorae in an Organisation.
*SearchApi* | [**search_search_organisations**](docs/SearchApi.md#search_search_organisations) | **GET** /api/search/organisations | Searches for Organisations with fuzzy search.
*TermsOfUseApi* | [**terms_of_use_accept**](docs/TermsOfUseApi.md#terms_of_use_accept) | **POST** /api/TermsOfUse/{id}/Accepts | Accepts a Terms of Use.
*TermsOfUseApi* | [**terms_of_use_create**](docs/TermsOfUseApi.md#terms_of_use_create) | **POST** /api/TermsOfUse | Creates a Terms of Use object.
*TermsOfUseApi* | [**terms_of_use_delete**](docs/TermsOfUseApi.md#terms_of_use_delete) | **DELETE** /api/TermsOfUse/{id} | Deletes a Terms of Use object.
*TermsOfUseApi* | [**terms_of_use_list**](docs/TermsOfUseApi.md#terms_of_use_list) | **GET** /api/TermsOfUse | Returns all Terms of Use.
*TermsOfUseApi* | [**terms_of_use_read**](docs/TermsOfUseApi.md#terms_of_use_read) | **GET** /api/TermsOfUse/{id} | Returns all Terms of Use.
*TimeSeriesApi* | [**time_series_query_time_series**](docs/TimeSeriesApi.md#time_series_query_time_series) | **POST** /api/timeseries/query | Updates the details of an Amphora by Id.
*UsersApi* | [**users_create**](docs/UsersApi.md#users_create) | **POST** /api/users | Creates a new User. Returns the password.
*UsersApi* | [**users_read_self**](docs/UsersApi.md#users_read_self) | **GET** /api/users/self | Get&#39;s logged in users information.
*VersionApi* | [**version_get_current_version**](docs/VersionApi.md#version_get_current_version) | **GET** /api/version | Get&#39;s the current server version.


## Documentation For Models

 - [AccessLevelQuery](docs/AccessLevelQuery.md)
 - [AccessLevelResponse](docs/AccessLevelResponse.md)
 - [AccessLevelResponseAllOf](docs/AccessLevelResponseAllOf.md)
 - [AccessRuleDtoBase](docs/AccessRuleDtoBase.md)
 - [Account](docs/Account.md)
 - [Activity](docs/Activity.md)
 - [ActivityAllOf](docs/ActivityAllOf.md)
 - [Address](docs/Address.md)
 - [AggregateSeries](docs/AggregateSeries.md)
 - [AggregateVariable](docs/AggregateVariable.md)
 - [AllAccessRule](docs/AllAccessRule.md)
 - [AmphoraReference](docs/AmphoraReference.md)
 - [AmphoraUser](docs/AmphoraUser.md)
 - [AmphoraUserAllOf](docs/AmphoraUserAllOf.md)
 - [AppLocation](docs/AppLocation.md)
 - [AppLocationAllOf](docs/AppLocationAllOf.md)
 - [AppLocationBase](docs/AppLocationBase.md)
 - [Application](docs/Application.md)
 - [ApplicationAllOf](docs/ApplicationAllOf.md)
 - [ApplicationBase](docs/ApplicationBase.md)
 - [BaseAmphoraUser](docs/BaseAmphoraUser.md)
 - [BasicAmphora](docs/BasicAmphora.md)
 - [BasicAmphoraAllOf](docs/BasicAmphoraAllOf.md)
 - [CreateActivity](docs/CreateActivity.md)
 - [CreateAmphora](docs/CreateAmphora.md)
 - [CreateAmphoraUser](docs/CreateAmphoraUser.md)
 - [CreateAmphoraUserAllOf](docs/CreateAmphoraUserAllOf.md)
 - [CreateAppLocation](docs/CreateAppLocation.md)
 - [CreateApplication](docs/CreateApplication.md)
 - [CreateApplicationAllOf](docs/CreateApplicationAllOf.md)
 - [CreateSignal](docs/CreateSignal.md)
 - [CreateTermsOfUse](docs/CreateTermsOfUse.md)
 - [DateTimeRange](docs/DateTimeRange.md)
 - [DetailedAmphora](docs/DetailedAmphora.md)
 - [DetailedAmphoraAllOf](docs/DetailedAmphoraAllOf.md)
 - [EditAmphora](docs/EditAmphora.md)
 - [EditAmphoraAllOf](docs/EditAmphoraAllOf.md)
 - [Entity](docs/Entity.md)
 - [EventProperty](docs/EventProperty.md)
 - [FileListOptions](docs/FileListOptions.md)
 - [FileListOptionsAllOf](docs/FileListOptionsAllOf.md)
 - [FileQueryOptions](docs/FileQueryOptions.md)
 - [FileQueryOptionsAllOf](docs/FileQueryOptionsAllOf.md)
 - [FuzzySearchResponse](docs/FuzzySearchResponse.md)
 - [GetEvents](docs/GetEvents.md)
 - [GetSeries](docs/GetSeries.md)
 - [Invitation](docs/Invitation.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [NumericVariable](docs/NumericVariable.md)
 - [Organisation](docs/Organisation.md)
 - [OrganisationAccessRule](docs/OrganisationAccessRule.md)
 - [OrganisationAccessRuleAllOf](docs/OrganisationAccessRuleAllOf.md)
 - [OrganisationAllOf](docs/OrganisationAllOf.md)
 - [PagedResponse](docs/PagedResponse.md)
 - [PaginatedResponse](docs/PaginatedResponse.md)
 - [PermissionsRequest](docs/PermissionsRequest.md)
 - [PermissionsResponse](docs/PermissionsResponse.md)
 - [PlanInformation](docs/PlanInformation.md)
 - [PlanTypes](docs/PlanTypes.md)
 - [Position](docs/Position.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [PropertyValues](docs/PropertyValues.md)
 - [PropertyValuesAllOf](docs/PropertyValuesAllOf.md)
 - [Quality](docs/Quality.md)
 - [QueryRequest](docs/QueryRequest.md)
 - [QueryResultPage](docs/QueryResultPage.md)
 - [QueryResultPageAllOf](docs/QueryResultPageAllOf.md)
 - [Result](docs/Result.md)
 - [Run](docs/Run.md)
 - [Signal](docs/Signal.md)
 - [Summary](docs/Summary.md)
 - [TermsOfUse](docs/TermsOfUse.md)
 - [Tsx](docs/Tsx.md)
 - [UpdateApplication](docs/UpdateApplication.md)
 - [UpdateApplicationAllOf](docs/UpdateApplicationAllOf.md)
 - [UpdateRun](docs/UpdateRun.md)
 - [UpdateSignal](docs/UpdateSignal.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [UserAccessRule](docs/UserAccessRule.md)
 - [UserAccessRuleAllOf](docs/UserAccessRuleAllOf.md)
 - [Variable](docs/Variable.md)
 - [VersionInfo](docs/VersionInfo.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




