# Matrix

> This is a Module which can perform Matrix Functions.

---

### Table of Contents
You're sections headers will be used to reference location of destination.

- [Description](##description)
- [Functions-Methods](##functions-methods)
- [Author Info](##author-info)

---

## Description

Matrix can be Created using 2D Arrays (Lists in Python), but Complex Functions like Determinant(N X N), Inverse, Matrix Arithmetic Operations ... is Required. I hope this Module can save your time and effort as well as provide you with some consistency across your Matrix Journey.

[Back To The Top](https://pypi.org/project/scitrix/#matrix)

---

## Functions-Methods

### Methods List

#### __init__(self,r,c)
> This method of the Class will initialize the class by creating a matrix A(r,c). And will create the matrix. All elements will be 0.

> obj=Matrix(3,3)

#### list(self)
> This method of the Class will return the 2-D list.

> lst99 = obj.list()


#### inputAdd(self)
> This Method of the Class will change the elements of the Matrix by User Input.

> obj.inputAdd()

#### listTomatrix(self, lst:list)
> This method of the Class converts the List Parameter to Matrix (self.matrix).

> obj.listTomatrix([1,2,3,4,5,6,7,8,9])

#### printMatrix(self)
> This Method prints the Matrix using Tabulate Module.

> obj.printMatrix()

#### transpose(self)
> This Method Returns a Transpose of the Matrix (self.matrix).

> Return Type -> Matrix

> obj2 = obj.transpose()

#### sizeMatrix(self)
> This Method returns the Dimensions of the Matrix.

> Return Type -> Tuple

> tuple1 = obj.sizeMatrix()

#### matrixMultiplicationConstant(self, int1 : int OR float)
> This Method multiplies the Original Matrix with the Constant (int1).

> A = A * c

> obj.matrixMultiplicationConstant(5)

#### adj(self)
> This Method returns the Adjoint of the Original Matrix.

> Return Type - Matrix

> obj5 = obj.adj()

#### inverse(self)
> This Method returns the Inverse of the Original Matrix.

> Return Type -> Matrix

> obj6 = obj.inverse()

#### mean(self)
> This Method returns the mean of the Original Matrix.

> Return Type -> Float

> float1 = obj.mean()

#### rowMeans(self)
> This Method returns the mean of all rows of the Original Matrix.

> Return Type -> Matrix

> obj7 = obj.rowMeans()

#### colMeans(self)
> This Method returns the mean of all columns of the Original Matrix.

> Return Type -> Matrix

> obj8 = obj.colMeans()

#### rowSum(self)
> This Method returns the sum of all rows of the Original Matrix.

> Return Type -> Matrix

> obj9 = obj.colMeans()

#### colSum(self)
> This Method returns the sum of all columns of the Original Matrix.

> Return Type -> Matrix

> obj10 = obj.colSum()

#### sum(self)
> This Method returns the sum of all elements of the Matrix.

> Return Type -> Float/Int

> var = obj.sum()

#### orthogonalCheck(self)
> This Method returns 1, if the Matrix is orthogonal and 0 if it is not.

> Return Type -> Int

> var = obj.orthogonalCheck()

#### trace(self)
> This Method returns the sum of all diagonal elements of the Matrix.

> Return Type -> Int/Float

> var2 = obj.trace()

#### flatten(self)
> This Method returns 1D list containing all elements, Row-Wise.

> Return Type -> List

> var2 = obj.flatten()

### Functions List

#### matDiv(m1:Matrix, m2:Matrix)
> This Method returns the Result of the Multiplication of 2 Matrices. Both Matrices are the Parameter Matrices, First is the Numerator Matrix and other is the Denominator Matrix (for which the inverse is calculated).

> Return Type -> Matrix

> C = A * B^-1

> obj11 = obj.matDiv(obj, obj2)

#### matMul(m1:Matrix, m2:Matrix)
> This method returns the Result of the Multiplication of 2 Matrices.

> Return Type -> Matrix

> C = A x B

> obj3 = matMul(obj1, obj2)

#### matSum(m1:Matrix, m2:Matrix)
> This Method returns the Result of the Addition of 2 Matrices.
Return Type -> Matrix

> C = A + B

> obj4 = matSum(obj, obj2)

#### matSub(m1:Matrix, m2:Matrix)
> This Method returns the Result of the Subtraction of 2 Matrices.

> Return Type -> Matrix

> C = A - B

> obj4 = matSub(obj, obj2)

#### diag(m1 : Matrix OR List)
> This Function returns the Diagonal Matrix if the parameter is a List, And Returns the List of all the Diagonal Elements of the Matrix if the parameter is a Matrix.

> Return Type -> Matrix/List

> list1 = diag(obj)  OR   obj12 = diag([1,2,3,4,5,6])

#### identity(m1:Matrix)
> This Function returns an Identity Matrix.

> obj13 = identity(obj)

#### determinant(m1:Matrix)
> This Function returns the Deteminant of a Matrix (N x N).

> Return Type -> Float/Int

> det12 = determinant(obj)

[Back To The Top](https://pypi.org/project/scitrix/#matrix)

---

## Author Info

- Instagram - [prak_entech983](https://www.instagram.com/prak_entech983/)
- Youtube - [Prak EnTech](https://www.youtube.com/c/PrakEnTech)

[Back To The Top](https://pypi.org/project/scitrix/#matrix)