from distutils.core import setup
setup(
    name='joinnector',         # How you named your package folder (MyLib)
    packages=['joinnector'],   # Chose the same as "name"
    version='0.1',      # Start with a small number and increase it with every change you make
    # Chose a license from here: https://help.github.com/articles/licensing-a-repository
    license='MIT',
    # Give a short description about your library
    description='Nector python SDK (nector.io is a B2B SaaS loyalty platform that allows the business to target a wider audience and increase customer engagement by rewarding them.)',
    author='Ayush Shukla',                   # Type in your name
    author_email='ayush@nector.io',      # Type in your E-Mail
    url='https://github.com/joinnector/rewardpythonsdk',
    # I explain this later on
    download_url='https://github.com/joinnector/rewardpythonsdk/archive/0.1.tar.gz',
    # Keywords that define your package best
    keywords=['nector', 'reward', 'loyalty', 'coins', 'wallets', 'deals'],
    install_requires=[            # I get to this in a second
        'requests',
    ],
    classifiers=[
        # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
        'Development Status :: 4 - Beta',
        # Define that your audience are developers
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        # Specify which pyhton versions that you want to support
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
    ],
)
