# SpectroscPy 0.3.0
# SpectroscPy is a script package developed by and containing contributions from

    # Karen Oda Hjorth Minde Dundas
    # Magnus Ringholm
    # Yann Cornation
    # Benedicte Ofstad

# The package is released under a LGPL licence.
# For questions, please contact on karen.o.dundas@uit.no

# The modules transform_nc_to_nm and vib_analysis are both to a certain extent derived from similar 
# or corresponding functionality in Dalton, perhaps mainly so for the former.  For questions about
# this, please contact Magnus Ringholm or Benedicte Ofstad.
# Thanks also to Per-Olof Åstrand on these routines

from spectroscpy import transform_cartesian_to_normal, transform_cartesian_to_normal_one_rank, \
                        list_product_int
import numpy as np

T = [[-1.53222357e-02, -1.53669888e-02,  3.22981009e-03,  4.17339724e-03, \
          -4.03628910e-04, -8.54362531e-04,  1.34926938e-03,  4.49367225e-04, \
           3.82717174e-03,  3.82717174e-03,  4.99934357e-04,  4.99934357e-04], \
         [-4.88454589e-04, -6.26090970e-04, -2.86856309e-04,  9.19391454e-04, \
           5.97284936e-04,  1.58823715e-02,  1.09768982e-02, -6.99882244e-03, \
           2.73701158e-04,  2.73701158e-04, -1.35673182e-03, -1.35673182e-03], \
         [-4.54192140e-03, -4.36068019e-03, -1.50488540e-02, -1.51582554e-02, \
          -3.00715936e-03,  3.65915224e-04,  1.45908768e-03,  2.44292779e-03, \
          -1.25212792e-03, -1.25212792e-03,  1.38975339e-03,  1.38975339e-03], \
         [-8.12088720e-03,  8.23711285e-03, -1.38024617e-03,  2.89722009e-03, \
          -3.15677759e-04, -1.33095828e-02,  1.11219814e-02, -8.34146668e-03, \
           2.75611082e-04,  2.75611082e-04, -5.38280697e-04, -5.38280697e-04], \
         [-1.30330770e-02,  1.29622276e-02, -2.92412421e-03,  3.13500922e-03, \
           6.51580249e-04,  8.70769872e-03, -8.33450712e-03,  4.68365240e-03, \
          -2.72170704e-03, -2.72170704e-03, -4.69061937e-03, -4.69061937e-03], \
         [-4.54112240e-03,  4.34618794e-03,  1.50507102e-02, -1.51597004e-02, \
           3.00626300e-03, -3.80756299e-04,  2.39644469e-03,  3.84891461e-03, \
           2.36630565e-03,  2.36630565e-03,  3.41944876e-03,  3.41944876e-03], \
         [ 5.11949879e-04, -5.26040879e-04,  1.11679665e-03,  1.44609639e-04, \
          -1.70604121e-04,  9.86304146e-04,  4.76014716e-04, -6.28537234e-04, \
           1.03458989e-03,  1.03458989e-03,  1.65191704e-03,  1.65191704e-03], \
         [ 8.20763107e-04, -8.20829892e-04,  7.77635494e-04, -7.65522406e-04, \
          -1.48224531e-04, -4.63682059e-04, -1.41811762e-03,  1.17637794e-04, \
          -2.39712892e-03, -2.39712892e-03, -5.11824601e-03, -5.11824601e-03], \
         [ 2.86187714e-04, -3.45501455e-04, -6.03883288e-04,  9.55520056e-04, \
           4.06140663e-03, -1.10939372e-04,  1.58369146e-03,  3.15745632e-03, \
           7.10444015e-05,  7.10444015e-05,  7.22274146e-04,  7.22274146e-04], \
         [ 9.65179904e-04,  9.75287860e-04, -1.23333598e-03, -5.90122785e-04, \
           2.15926978e-04, -9.38468739e-05,  1.69658006e-03, -7.91065274e-05, \
           3.34036618e-03,  3.34036618e-03,  5.85849627e-04,  5.85849627e-04], \
         [ 3.12162589e-05,  4.35411782e-05, -5.75314541e-04,  5.10058319e-04, \
           6.95346750e-05, -1.08571583e-03, -1.87191716e-03,  1.70555954e-03, \
           1.05515724e-04,  1.05515724e-04,  3.80029003e-04,  3.80029003e-04], \
         [ 2.86126589e-04,  3.46414599e-04,  6.03766335e-04,  9.54786680e-04, \
          -4.06135015e-03,  1.11874495e-04,  1.67186928e-03,  3.29067676e-03, \
           4.12962526e-04,  4.12962526e-04,  9.11506680e-04,  9.11506680e-04]]



def test_list_product_int():

    dims = [12, 3, 3]
    ref_prod = 108

    prod = list_product_int(dims)

    assert ref_prod == prod


def test_transform_cartesian_to_normal_one_rank():

    w = [1]
    rank_geo = 1
    c = 1
    offset = [0]
    offset_b = [0]
    ind_w = 0
    num_coordinates = 12
    min_element = 0
    max_element = 11
    num_nongeo_coordinates = 9.0

    A = \
        [-5.52610245e+00, -3.65370945e-01, -2.61304151e+00, -3.65370945e-01, \
         -5.25005566e-02, -2.19417939e-01, -2.61304151e+00, -2.19417939e-01, \
         -1.47930326e+00,  5.92745384e-02, -1.90751361e+00,  6.62896115e-02, \
         -1.90751361e+00, -2.87689901e-01, -1.24484450e+00,  6.62896115e-02, \
         -1.24484450e+00,  2.14281914e-02, -2.79646702e-01, -1.31547355e-01, \
         -2.18406599e+00, -1.31547355e-01, -4.01564846e-02, -2.34258629e-01, \
         -2.18406599e+00, -2.34258629e-01, -2.52571141e+00,  2.48063287e+00, \
          1.97311908e+00,  1.65420672e+00,  1.97311908e+00,  5.15006518e-01, \
          4.89277563e-01,  1.65420672e+00,  4.89277563e-01,  7.23229136e-01, \
          5.79812221e-01,  1.81195853e+00,  7.73857301e-01,  1.81195853e+00, \
          4.13459886e+00,  2.20210342e+00,  7.73857301e-01,  2.20210342e+00, \
          1.28947211e+00,  2.14053068e-01,  1.68894784e-01,  1.29729647e+00, \
          1.68894784e-01,  1.04900203e-01,  1.77224076e+00,  1.29729647e+00, \
          1.77224076e+00,  2.52306162e+00, -1.60891591e+00, -1.65399945e+00, \
          8.98985727e-01, -1.65399945e+00, -5.75373351e-01, -5.69325506e-01, \
          8.98985727e-01, -5.69325506e-01, -1.80110171e+00, -5.65061529e-01, \
         -1.34626290e+00, -8.52846066e-01, -1.34626290e+00, -3.67857250e+00, \
          4.43208043e-01, -8.52846066e-01,  4.43208043e-01, -1.90672161e+00, \
         -4.92628786e-03, -8.86475722e-02, -9.00848379e-02, -8.86475722e-02, \
          1.22252200e-02, -1.07169840e+00, -9.00848379e-02, -1.07169840e+00, \
          8.85057364e+00,  4.65438549e+00,  4.62513170e-02,  5.98490637e-02, \
          4.62513170e-02,  1.12867390e-01,  2.99465883e-01,  5.98490637e-02, \
          2.99465883e-01,  2.55717584e+00, -7.40252306e-02,  1.44181798e+00, \
          1.26991533e-02,  1.44181798e+00, -1.68336464e-01, -1.40046696e+00, \
          1.26991533e-02, -1.40046696e+00,  5.95821305e-01,  7.05199218e-02, \
          5.13001435e-02,  9.76854357e-01,  5.13001435e-02, -7.69689380e-02, \
         -4.66283737e-01,  9.76854357e-01, -4.66283737e-01, -8.84792384e+00]

    ref_B = \
[ 6.04610168e-02, -3.51511034e-02,  2.05866999e-02, -3.51511034e-02,
 -6.06465234e-02, -3.58100052e-02,  2.05866999e-02, -3.58100052e-02,
 -8.24128686e-06,  1.20853567e-01,  4.99878460e-02,  7.95877681e-02,
  4.99878460e-02,  6.28477132e-02,  4.58251209e-02,  7.95877681e-02,
  4.58251209e-02,  6.62798278e-02, -2.34431033e-02, -7.82917396e-03,
  4.02920660e-02, -7.82917396e-03, -1.43042004e-02,  2.32435266e-02,
  4.02920660e-02,  2.32435266e-02,  4.87524728e-02, -1.55313817e-02,
  9.01591482e-03,  1.14149843e-02,  9.01591482e-03,  1.55074847e-02,
 -1.98366331e-02,  1.14149843e-02, -1.98366331e-02,  2.34201827e-05,
  4.39674406e-03,  4.92827591e-04,  7.19780496e-03,  4.92827591e-04,
  3.83525034e-03,  4.19755972e-03,  7.19780496e-03,  4.19755972e-03,
  8.94657661e-02, -2.41613372e-02, -4.31408063e-02, -1.19041034e-02,
 -4.31408063e-02,  2.58697418e-02, -6.88886030e-03, -1.19041034e-02,
 -6.88886030e-03, -2.42915067e-03,  2.42371517e-02, -1.59288332e-02,
  1.22780897e-02, -1.59288332e-02, -2.64278934e-02, -2.32137304e-02,
  1.22780897e-02, -2.32137304e-02,  2.19074206e-03, -2.00670156e-02,
  8.76832892e-03, -9.87290346e-03,  8.76832892e-03,  1.67828539e-02,
  1.41748482e-02, -9.87290346e-03,  1.41748482e-02,  3.28416173e-03,
 -5.91256993e-03, -3.90638950e-03, -2.25545479e-03, -3.90638950e-03,
 -2.54131144e-03, -3.61969717e-03, -2.25545479e-03, -3.61969717e-03,
  8.45388151e-03, -5.91256993e-03, -3.90638950e-03, -2.25545479e-03,
 -3.90638950e-03, -2.54131144e-03, -3.61969717e-03, -2.25545479e-03,
 -3.61969717e-03,  8.45388151e-03, -3.56107198e-03, -2.04527171e-03,
  2.19949938e-03, -2.04527171e-03, -1.18589028e-03, -8.04363048e-03,
  2.19949938e-03, -8.04363048e-03,  4.74696235e-03, -3.56107198e-03,
 -2.04527171e-03,  2.19949938e-03, -2.04527171e-03, -1.18589028e-03,
 -8.04363048e-03,  2.19949938e-03, -8.04363048e-03,  4.74696235e-03]

    B = np.zeros(108)

    transform_cartesian_to_normal_one_rank(w, rank_geo, rank_geo, offset, offset_b, ind_w, \
                                           num_coordinates, min_element, max_element, \
                                           num_nongeo_coordinates, A, B, T, 1)

    assert np.allclose(ref_B, B)

    min_element = 0
    max_element = 5

    cut_T = \
        [[-1.53222357e-02, -1.53669888e-02,  3.22981009e-03,  4.17339724e-03, \
          -4.03628910e-04, -8.54362531e-04], \
         [-4.88454589e-04, -6.26090970e-04, -2.86856309e-04,  9.19391454e-04, \
           5.97284936e-04,  1.58823715e-02], \
         [-4.54192140e-03, -4.36068019e-03, -1.50488540e-02, -1.51582554e-02, \
          -3.00715936e-03,  3.65915224e-04], \
         [-8.12088720e-03,  8.23711285e-03, -1.38024617e-03,  2.89722009e-03, \
          -3.15677759e-04, -1.33095828e-02], \
         [-1.30330770e-02,  1.29622276e-02, -2.92412421e-03,  3.13500922e-03, \
           6.51580249e-04,  8.70769872e-03], \
         [-4.54112240e-03,  4.34618794e-03,  1.50507102e-02, -1.51597004e-02, \
           3.00626300e-03, -3.80756299e-04], \
         [ 5.11949879e-04, -5.26040879e-04,  1.11679665e-03,  1.44609639e-04, \
          -1.70604121e-04,  9.86304146e-04], \
         [ 8.20763107e-04, -8.20829892e-04,  7.77635494e-04, -7.65522406e-04, \
          -1.48224531e-04, -4.63682059e-04], \
         [ 2.86187714e-04, -3.45501455e-04, -6.03883288e-04,  9.55520056e-04, \
           4.06140663e-03, -1.10939372e-04], \
         [ 9.65179904e-04,  9.75287860e-04, -1.23333598e-03, -5.90122785e-04, \
           2.15926978e-04, -9.38468739e-05], \
         [ 3.12162589e-05,  4.35411782e-05, -5.75314541e-04,  5.10058319e-04, \
           6.95346750e-05, -1.08571583e-03], \
         [ 2.86126589e-04,  3.46414599e-04,  6.03766335e-04,  9.54786680e-04, \
          -4.06135015e-03,  1.11874495e-04]]

    ref_B = \
        [ 6.04610168e-02, -3.51511034e-02,  2.05866999e-02, -3.51511034e-02, \
         -6.06465234e-02, -3.58100052e-02,  2.05866999e-02, -3.58100052e-02, \
         -8.24128686e-06,  1.20853567e-01,  4.99878460e-02,  7.95877681e-02, \
          4.99878460e-02,  6.28477132e-02,  4.58251209e-02,  7.95877681e-02, \
          4.58251209e-02,  6.62798278e-02, -2.34431033e-02, -7.82917396e-03, \
          4.02920660e-02, -7.82917396e-03, -1.43042004e-02,  2.32435266e-02, \
          4.02920660e-02,  2.32435266e-02,  4.87524728e-02, -1.55313817e-02, \
          9.01591482e-03,  1.14149843e-02,  9.01591482e-03,  1.55074847e-02, \
         -1.98366331e-02,  1.14149843e-02, -1.98366331e-02,  2.34201827e-05, \
          4.39674406e-03,  4.92827591e-04,  7.19780496e-03,  4.92827591e-04, \
          3.83525034e-03,  4.19755972e-03,  7.19780496e-03,  4.19755972e-03, \
          8.94657661e-02, -2.41613372e-02, -4.31408063e-02, -1.19041034e-02, \
         -4.31408063e-02,  2.58697418e-02, -6.88886030e-03, -1.19041034e-02, \
         -6.88886030e-03, -2.42915067e-03,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00]

    B = np.zeros(108)

    transform_cartesian_to_normal_one_rank(w, rank_geo, rank_geo, offset, offset_b, ind_w, \
                                           num_coordinates, min_element, max_element, \
                                           num_nongeo_coordinates, A, B, cut_T, 1)

    assert np.allclose(ref_B, B)

    min_element = 2
    max_element = 5

    cut_T = \
        [[ 3.22981009e-03,  4.17339724e-03, -4.03628910e-04, -8.54362531e-04], \
         [-2.86856309e-04,  9.19391454e-04,  5.97284936e-04,  1.58823715e-02], \
         [-1.50488540e-02, -1.51582554e-02, -3.00715936e-03,  3.65915224e-04], \
         [-1.38024617e-03,  2.89722009e-03, -3.15677759e-04, -1.33095828e-02], \
         [-2.92412421e-03,  3.13500922e-03,  6.51580249e-04,  8.70769872e-03], \
         [ 1.50507102e-02, -1.51597004e-02,  3.00626300e-03, -3.80756299e-04], \
         [ 1.11679665e-03,  1.44609639e-04, -1.70604121e-04,  9.86304146e-04], \
         [ 7.77635494e-04, -7.65522406e-04, -1.48224531e-04, -4.63682059e-04], \
         [-6.03883288e-04,  9.55520056e-04,  4.06140663e-03, -1.10939372e-04], \
         [-1.23333598e-03, -5.90122785e-04,  2.15926978e-04, -9.38468739e-05], \
         [-5.75314541e-04,  5.10058319e-04,  6.95346750e-05, -1.08571583e-03], \
         [ 6.03766335e-04,  9.54786680e-04, -4.06135015e-03,  1.11874495e-04]]

    ref_B = \
        [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00, -2.34431033e-02, -7.82917396e-03, \
          4.02920660e-02, -7.82917396e-03, -1.43042004e-02,  2.32435266e-02, \
          4.02920660e-02,  2.32435266e-02,  4.87524728e-02, -1.55313817e-02, \
          9.01591482e-03,  1.14149843e-02,  9.01591482e-03,  1.55074847e-02, \
         -1.98366331e-02,  1.14149843e-02, -1.98366331e-02,  2.34201827e-05, \
          4.39674406e-03,  4.92827591e-04,  7.19780496e-03,  4.92827591e-04, \
          3.83525034e-03,  4.19755972e-03,  7.19780496e-03,  4.19755972e-03, \
          8.94657661e-02, -2.41613372e-02, -4.31408063e-02, -1.19041034e-02, \
         -4.31408063e-02,  2.58697418e-02, -6.88886030e-03, -1.19041034e-02, \
         -6.88886030e-03, -2.42915067e-03,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00, \
          0.00000000e+00,  0.00000000e+00,  0.00000000e+00,  0.00000000e+00]

    B = np.zeros(108)
    transform_cartesian_to_normal_one_rank(w, rank_geo, rank_geo, offset, offset_b, ind_w, \
                                           num_coordinates, min_element, max_element, \
                                           num_nongeo_coordinates, A, B, cut_T, 1)

    assert np.allclose(ref_B, B)


def test_transform_cartesian_to_normal():

    dims = [12, 3, 3]
    rank_geo = 1
    num_coordinates = 12
    min_element = 0
    max_element = 11

    A = [[[-5.72175405, -0.39010244, -2.74786949], [-0.39010244, -0.05761531, -0.23744535], \
          [-2.74786949, -0.23744535, -1.56897379]], [[ 0.05690188, -1.93501615,  0.06980268], \
          [-1.93501615, -0.30230842, -1.27727099], [ 0.06980268, -1.27727099,  0.02229694]], \
         [[-0.3093757 , -0.14039159, -2.22960342], [-0.14039159, -0.04757224, -0.24747434], \
          [-2.22960342, -0.24747434, -2.60242744]], [[ 2.54858986,  2.02801871,  1.71865737], \
          [ 2.02801871,  0.56246225,  0.52656324], [ 1.71865737,  0.52656324,  0.76742956]], \
         [[ 0.62649069,  1.88994141,  0.83261901], [ 1.88994141,  4.25321795,  2.3048851 ], \
          [ 0.83261901,  2.3048851 ,  1.36741855]], [[ 0.23472083,  0.18294217,  1.33151503], \
          [ 0.18294217,  0.12131121,  1.80498832], [ 1.33151503,  1.80498832,  2.59970629]], \
         [[-1.63866349, -1.69391634,  0.87752942], [-1.69391634, -0.62516219, -0.61353862], \
          [ 0.87752942, -0.61353862, -1.91033759]], [[-0.60977519, -1.40401008, -0.9184539 ], \
          [-1.40401008, -3.77839795,  0.39142091], [-0.9184539 ,  0.39142091, -2.02184403]], \
         [[-0.00993483, -0.11485363, -0.03174325], [-0.11485363,  0.02568361, -1.05083558], \
          [-0.03174325, -1.05083558,  9.35645406]], [[ 4.81182771,  0.05600007,  0.15168273], \
          [ 0.05600007,  0.12031526,  0.32442073], [ 0.15168273,  0.32442073,  2.71188179]], \
         [[-0.07361738,  1.44908484,  0.01603221], [ 1.44908484, -0.17251157, -1.41903503], \
          [ 0.01603221, -1.41903503,  0.63212856]], [[ 0.08458969,  0.07230306,  0.92983165], \
          [ 0.07230306, -0.09942256, -0.50667839], [ 0.92983165, -0.50667839, -9.35373316]]]

    ref_transformed_A = \
[[[ 6.24435690e-02, -3.63042259e-02,  2.14401936e-02],
  [-3.63042259e-02, -6.26361477e-02, -3.72962072e-02],
  [ 2.14401936e-02, -3.72962072e-02, -9.06371087e-06]],
 [[ 1.25458444e-01,  5.20423322e-02,  8.34157358e-02],
  [ 5.20423322e-02,  6.50703775e-02,  4.80299069e-02],
  [ 8.34157358e-02,  4.80299069e-02,  6.96537595e-02]],
 [[-2.37970666e-02, -7.93763388e-03,  4.05413221e-02],
  [-7.93763388e-03, -1.45319878e-02,  2.33876173e-02],
  [ 4.05413221e-02,  2.33876173e-02,  4.94476239e-02]],
 [[-1.59236753e-02,  9.24345808e-03,  1.14034729e-02],
  [ 9.24345808e-03,  1.58997996e-02, -1.98171311e-02],
  [ 1.14034729e-02, -1.98171311e-02,  2.33746944e-05]],
 [[ 4.60303550e-03,  4.14936954e-04,  7.97344531e-03],
  [ 4.14936954e-04,  4.13298933e-03,  4.64696362e-03],
  [ 7.97344531e-03,  4.64696362e-03,  9.41809099e-02]],
 [[-2.45703238e-02, -4.36328483e-02, -1.21236507e-02],
  [-4.36328483e-02,  2.60312654e-02, -7.01564823e-03],
  [-1.21236507e-02, -7.01564823e-03, -2.52655818e-03]],
 [[ 2.46512365e-02, -1.62232525e-02,  1.26235312e-02],
  [-1.62232525e-02, -2.69054929e-02, -2.38817501e-02],
  [ 1.26235312e-02, -2.38817501e-02,  2.25425649e-03]],
 [[-2.04474786e-02,  8.90575162e-03, -1.01663492e-02],
  [ 8.90575162e-03,  1.70680840e-02,  1.45788306e-02],
  [-1.01663492e-02,  1.45788306e-02,  3.37939361e-03]],
 [[-6.07637625e-03, -4.02409712e-03, -2.34777373e-03],
  [-4.02409712e-03, -2.62263058e-03, -3.72839531e-03],
  [-2.34777373e-03, -3.72839531e-03,  8.69900665e-03]],
 [[-6.07637625e-03, -4.02409712e-03, -2.34777373e-03],
  [-4.02409712e-03, -2.62263058e-03, -3.72839531e-03],
  [-2.34777373e-03, -3.72839531e-03,  8.69900665e-03]],
 [[-3.60052577e-03, -2.14160453e-03,  2.22542690e-03],
  [-2.14160453e-03, -1.28403002e-03, -8.23938187e-03],
  [ 2.22542690e-03, -8.23938187e-03,  4.88455542e-03]],
 [[-3.60052577e-03, -2.14160453e-03,  2.22542690e-03],
  [-2.14160453e-03, -1.28403002e-03, -8.23938187e-03],
  [ 2.22542690e-03, -8.23938187e-03,  4.88455542e-03]]]

    transformed_A = transform_cartesian_to_normal(A, dims, rank_geo, num_coordinates, \
                                                  min_element, max_element, T)

    assert np.allclose(ref_transformed_A, transformed_A)

    min_element = 0
    max_element = 5

    cut_T = \
        [[-1.53222357e-02, -1.53669888e-02,  3.22981009e-03,  4.17339724e-03, \
          -4.03628910e-04, -8.54362531e-04], \
         [-4.88454589e-04, -6.26090970e-04, -2.86856309e-04,  9.19391454e-04, \
           5.97284936e-04,  1.58823715e-02], \
         [-4.54192140e-03, -4.36068019e-03, -1.50488540e-02, -1.51582554e-02, \
          -3.00715936e-03,  3.65915224e-04], \
         [-8.12088720e-03,  8.23711285e-03, -1.38024617e-03,  2.89722009e-03, \
          -3.15677759e-04, -1.33095828e-02], \
         [-1.30330770e-02,  1.29622276e-02, -2.92412421e-03,  3.13500922e-03, \
           6.51580249e-04,  8.70769872e-03], \
         [-4.54112240e-03,  4.34618794e-03,  1.50507102e-02, -1.51597004e-02, \
           3.00626300e-03, -3.80756299e-04], \
         [ 5.11949879e-04, -5.26040879e-04,  1.11679665e-03,  1.44609639e-04, \
          -1.70604121e-04,  9.86304146e-04], \
         [ 8.20763107e-04, -8.20829892e-04,  7.77635494e-04, -7.65522406e-04, \
          -1.48224531e-04, -4.63682059e-04], \
         [ 2.86187714e-04, -3.45501455e-04, -6.03883288e-04,  9.55520056e-04, \
           4.06140663e-03, -1.10939372e-04], \
         [ 9.65179904e-04,  9.75287860e-04, -1.23333598e-03, -5.90122785e-04, \
           2.15926978e-04, -9.38468739e-05], \
         [ 3.12162589e-05,  4.35411782e-05, -5.75314541e-04,  5.10058319e-04, \
           6.95346750e-05, -1.08571583e-03], \
         [ 2.86126589e-04,  3.46414599e-04,  6.03766335e-04,  9.54786680e-04, \
          -4.06135015e-03,  1.11874495e-04]]

    ref_transformed_A = [[[ 6.24435690e-02, -3.63042259e-02,  2.14401936e-02], \
                          [-3.63042259e-02, -6.26361477e-02, -3.72962072e-02], \
                          [ 2.14401936e-02, -3.72962072e-02, -9.06371087e-06]], \
                         [[ 1.25458444e-01,  5.20423322e-02,  8.34157358e-02], \
                          [ 5.20423322e-02,  6.50703775e-02,  4.80299069e-02], \
                          [ 8.34157358e-02,  4.80299069e-02,  6.96537595e-02]], \
                         [[-2.37970666e-02, -7.93763388e-03,  4.05413221e-02], \
                          [-7.93763388e-03, -1.45319878e-02,  2.33876173e-02], \
                          [ 4.05413221e-02,  2.33876173e-02,  4.94476239e-02]], \
                         [[-1.59236753e-02,  9.24345808e-03,  1.14034729e-02], \
                          [ 9.24345808e-03,  1.58997996e-02, -1.98171311e-02], \
                          [ 1.14034729e-02, -1.98171311e-02,  2.33746944e-05]], \
                         [[ 4.60303550e-03,  4.14936954e-04,  7.97344531e-03], \
                          [ 4.14936954e-04,  4.13298933e-03,  4.64696362e-03], \
                          [ 7.97344531e-03,  4.64696362e-03,  9.41809099e-02]], \
                         [[-2.45703238e-02, -4.36328483e-02, -1.21236507e-02], \
                          [-4.36328483e-02,  2.60312654e-02, -7.01564823e-03], \
                          [-1.21236507e-02, -7.01564823e-03, -2.52655818e-03]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]]]


    transformed_A = transform_cartesian_to_normal(A, dims, rank_geo, num_coordinates, \
                                                  min_element, max_element, cut_T)

    assert np.allclose(ref_transformed_A, transformed_A)

    min_element = 2
    max_element = 5

    cut_T = \
        [[ 3.22981009e-03,  4.17339724e-03, -4.03628910e-04, -8.54362531e-04], \
         [-2.86856309e-04,  9.19391454e-04,  5.97284936e-04,  1.58823715e-02], \
         [-1.50488540e-02, -1.51582554e-02, -3.00715936e-03,  3.65915224e-04], \
         [-1.38024617e-03,  2.89722009e-03, -3.15677759e-04, -1.33095828e-02], \
         [-2.92412421e-03,  3.13500922e-03,  6.51580249e-04,  8.70769872e-03], \
         [ 1.50507102e-02, -1.51597004e-02,  3.00626300e-03, -3.80756299e-04], \
         [ 1.11679665e-03,  1.44609639e-04, -1.70604121e-04,  9.86304146e-04], \
         [ 7.77635494e-04, -7.65522406e-04, -1.48224531e-04, -4.63682059e-04], \
         [-6.03883288e-04,  9.55520056e-04,  4.06140663e-03, -1.10939372e-04], \
         [-1.23333598e-03, -5.90122785e-04,  2.15926978e-04, -9.38468739e-05], \
         [-5.75314541e-04,  5.10058319e-04,  6.95346750e-05, -1.08571583e-03], \
         [ 6.03766335e-04,  9.54786680e-04, -4.06135015e-03,  1.11874495e-04]]

    ref_transformed_A = [[[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[-2.37970666e-02, -7.93763388e-03,  4.05413221e-02], \
                          [-7.93763388e-03, -1.45319878e-02,  2.33876173e-02], \
                          [ 4.05413221e-02,  2.33876173e-02,  4.94476239e-02]], \
                         [[-1.59236753e-02,  9.24345808e-03,  1.14034729e-02], \
                          [ 9.24345808e-03,  1.58997996e-02, -1.98171311e-02], \
                          [ 1.14034729e-02, -1.98171311e-02,  2.33746944e-05]], \
                         [[ 4.60303550e-03,  4.14936954e-04,  7.97344531e-03], \
                          [ 4.14936954e-04,  4.13298933e-03,  4.64696362e-03], \
                          [ 7.97344531e-03,  4.64696362e-03,  9.41809099e-02]], \
                         [[-2.45703238e-02, -4.36328483e-02, -1.21236507e-02], \
                          [-4.36328483e-02,  2.60312654e-02, -7.01564823e-03], \
                          [-1.21236507e-02, -7.01564823e-03, -2.52655818e-03]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]], \
                         [[ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00], \
                          [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00]]]

    transformed_A = transform_cartesian_to_normal(A, dims, rank_geo, num_coordinates, \
                                                  min_element, max_element, cut_T)

    assert np.allclose(ref_transformed_A, transformed_A)
