# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class AuditApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def audit_case_get(self, api_key, **kwargs):  # noqa: E501
        """audit_case_get  # noqa: E501

         This endpoint contains Final Audit Reports approved by the Commission since inception. The search can be based on information about the audited committee (Name, FEC ID Number, Type,  Election Cycle) or the issues covered in the report.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audit_case_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str primary_category_id:  Audit category ID (table PK)
        :param list[int] cycle:  Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param list[str] audit_case_id:  Primary/foreign key for audit tables
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int max_election_cycle:  Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.
        :param int min_election_cycle:  Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str sub_category_id:  The finding id of an audit. Finding are a category of broader issues. Each category has an unique ID.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param str committee_designation: Type of committee:         - H or S - Congressional         - P - Presidential         - X or Y or Z - Party         - N or Q - PAC         - I - Independent expenditure         - O - Super PAC
        :param list[int] audit_id:  The audit issue. Each subcategory has an unique ID
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] qq: Name of candidate running for office
        :return: AuditCasePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.audit_case_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.audit_case_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def audit_case_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """audit_case_get  # noqa: E501

         This endpoint contains Final Audit Reports approved by the Commission since inception. The search can be based on information about the audited committee (Name, FEC ID Number, Type,  Election Cycle) or the issues covered in the report.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audit_case_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str primary_category_id:  Audit category ID (table PK)
        :param list[int] cycle:  Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param list[str] audit_case_id:  Primary/foreign key for audit tables
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int max_election_cycle:  Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.
        :param int min_election_cycle:  Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str sub_category_id:  The finding id of an audit. Finding are a category of broader issues. Each category has an unique ID.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param str committee_designation: Type of committee:         - H or S - Congressional         - P - Presidential         - X or Y or Z - Party         - N or Q - PAC         - I - Independent expenditure         - O - Super PAC
        :param list[int] audit_id:  The audit issue. Each subcategory has an unique ID
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] qq: Name of candidate running for office
        :return: AuditCasePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'primary_category_id', 'cycle', 'sort', 'committee_type', 'sort_nulls_last', 'q', 'audit_case_id', 'sort_hide_null', 'max_election_cycle', 'min_election_cycle', 'committee_id', 'sub_category_id', 'per_page', 'candidate_id', 'page', 'committee_designation', 'audit_id', 'sort_null_only', 'qq']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method audit_case_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `audit_case_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'primary_category_id' in params:
            query_params.append(('primary_category_id', params['primary_category_id']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501
        if 'audit_case_id' in params:
            query_params.append(('audit_case_id', params['audit_case_id']))  # noqa: E501
            collection_formats['audit_case_id'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'max_election_cycle' in params:
            query_params.append(('max_election_cycle', params['max_election_cycle']))  # noqa: E501
        if 'min_election_cycle' in params:
            query_params.append(('min_election_cycle', params['min_election_cycle']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'sub_category_id' in params:
            query_params.append(('sub_category_id', params['sub_category_id']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'committee_designation' in params:
            query_params.append(('committee_designation', params['committee_designation']))  # noqa: E501
        if 'audit_id' in params:
            query_params.append(('audit_id', params['audit_id']))  # noqa: E501
            collection_formats['audit_id'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'qq' in params:
            query_params.append(('qq', params['qq']))  # noqa: E501
            collection_formats['qq'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/audit-case/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditCasePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def audit_category_get(self, api_key, **kwargs):  # noqa: E501
        """audit_category_get  # noqa: E501

         This lists the options for the categories and subcategories available in the /audit-search/ endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audit_category_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] primary_category_id:  Audit category ID (table PK)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] primary_category_name: Primary Audit Category     - No Findings or Issues/Not a Committee     - Net Outstanding Campaign/Convention Expenditures/Obligations     - Payments/Disgorgements     - Allocation Issues     - Prohibited Contributions     - Disclosure     - Recordkeeping     - Repayment to US Treasury     - Other     - Misstatement of Financial Activity     - Excessive Contributions     - Failure to File Reports/Schedules/Notices     - Loans     - Referred Findings Not Listed
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: AuditCategoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.audit_category_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.audit_category_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def audit_category_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """audit_category_get  # noqa: E501

         This lists the options for the categories and subcategories available in the /audit-search/ endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audit_category_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] primary_category_id:  Audit category ID (table PK)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] primary_category_name: Primary Audit Category     - No Findings or Issues/Not a Committee     - Net Outstanding Campaign/Convention Expenditures/Obligations     - Payments/Disgorgements     - Allocation Issues     - Prohibited Contributions     - Disclosure     - Recordkeeping     - Repayment to US Treasury     - Other     - Misstatement of Financial Activity     - Excessive Contributions     - Failure to File Reports/Schedules/Notices     - Loans     - Referred Findings Not Listed
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: AuditCategoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'primary_category_id', 'per_page', 'sort', 'page', 'sort_nulls_last', 'primary_category_name', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method audit_category_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `audit_category_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'primary_category_id' in params:
            query_params.append(('primary_category_id', params['primary_category_id']))  # noqa: E501
            collection_formats['primary_category_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'primary_category_name' in params:
            query_params.append(('primary_category_name', params['primary_category_name']))  # noqa: E501
            collection_formats['primary_category_name'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/audit-category/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditCategoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def audit_primary_category_get(self, api_key, **kwargs):  # noqa: E501
        """audit_primary_category_get  # noqa: E501

         This lists the options for the primary categories available in the /audit-search/ endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audit_primary_category_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] primary_category_id:  Audit category ID (table PK)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] primary_category_name: Primary Audit Category     - No Findings or Issues/Not a Committee     - Net Outstanding Campaign/Convention Expenditures/Obligations     - Payments/Disgorgements     - Allocation Issues     - Prohibited Contributions     - Disclosure     - Recordkeeping     - Repayment to US Treasury     - Other     - Misstatement of Financial Activity     - Excessive Contributions     - Failure to File Reports/Schedules/Notices     - Loans     - Referred Findings Not Listed
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: AuditPrimaryCategoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.audit_primary_category_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.audit_primary_category_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def audit_primary_category_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """audit_primary_category_get  # noqa: E501

         This lists the options for the primary categories available in the /audit-search/ endpoint.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audit_primary_category_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] primary_category_id:  Audit category ID (table PK)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] primary_category_name: Primary Audit Category     - No Findings or Issues/Not a Committee     - Net Outstanding Campaign/Convention Expenditures/Obligations     - Payments/Disgorgements     - Allocation Issues     - Prohibited Contributions     - Disclosure     - Recordkeeping     - Repayment to US Treasury     - Other     - Misstatement of Financial Activity     - Excessive Contributions     - Failure to File Reports/Schedules/Notices     - Loans     - Referred Findings Not Listed
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: AuditPrimaryCategoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'primary_category_id', 'per_page', 'sort', 'page', 'sort_nulls_last', 'primary_category_name', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method audit_primary_category_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `audit_primary_category_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'primary_category_id' in params:
            query_params.append(('primary_category_id', params['primary_category_id']))  # noqa: E501
            collection_formats['primary_category_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'primary_category_name' in params:
            query_params.append(('primary_category_name', params['primary_category_name']))  # noqa: E501
            collection_formats['primary_category_name'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/audit-primary-category/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditPrimaryCategoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def names_audit_candidates_get(self, api_key, q, **kwargs):  # noqa: E501
        """names_audit_candidates_get  # noqa: E501

         Search for candidates or committees by name. If you're looking for information on a particular person or group, using a name to find the `candidate_id` or `committee_id` on this endpoint can be a helpful first step.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.names_audit_candidates_get(api_key, q, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] q: Name (candidate or committee) to search for (required)
        :return: AuditCandidateSearchList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.names_audit_candidates_get_with_http_info(api_key, q, **kwargs)  # noqa: E501
        else:
            (data) = self.names_audit_candidates_get_with_http_info(api_key, q, **kwargs)  # noqa: E501
            return data

    def names_audit_candidates_get_with_http_info(self, api_key, q, **kwargs):  # noqa: E501
        """names_audit_candidates_get  # noqa: E501

         Search for candidates or committees by name. If you're looking for information on a particular person or group, using a name to find the `candidate_id` or `committee_id` on this endpoint can be a helpful first step.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.names_audit_candidates_get_with_http_info(api_key, q, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] q: Name (candidate or committee) to search for (required)
        :return: AuditCandidateSearchList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'q']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method names_audit_candidates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `names_audit_candidates_get`')  # noqa: E501
        # verify the required parameter 'q' is set
        if ('q' not in params or
                params['q'] is None):
            raise ValueError('Missing the required parameter `q` when calling `names_audit_candidates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/names/audit_candidates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditCandidateSearchList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def names_audit_committees_get(self, api_key, q, **kwargs):  # noqa: E501
        """names_audit_committees_get  # noqa: E501

         Search for candidates or committees by name. If you're looking for information on a particular person or group, using a name to find the `candidate_id` or `committee_id` on this endpoint can be a helpful first step.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.names_audit_committees_get(api_key, q, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] q: Name (candidate or committee) to search for (required)
        :return: AuditCommitteeSearchList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.names_audit_committees_get_with_http_info(api_key, q, **kwargs)  # noqa: E501
        else:
            (data) = self.names_audit_committees_get_with_http_info(api_key, q, **kwargs)  # noqa: E501
            return data

    def names_audit_committees_get_with_http_info(self, api_key, q, **kwargs):  # noqa: E501
        """names_audit_committees_get  # noqa: E501

         Search for candidates or committees by name. If you're looking for information on a particular person or group, using a name to find the `candidate_id` or `committee_id` on this endpoint can be a helpful first step.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.names_audit_committees_get_with_http_info(api_key, q, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] q: Name (candidate or committee) to search for (required)
        :return: AuditCommitteeSearchList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'q']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method names_audit_committees_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `names_audit_committees_get`')  # noqa: E501
        # verify the required parameter 'q' is set
        if ('q' not in params or
                params['q'] is None):
            raise ValueError('Missing the required parameter `q` when calling `names_audit_committees_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/names/audit_committees/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditCommitteeSearchList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
