# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class CandidateApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def candidate_candidate_id_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular candidate. Use the `candidate_id` to find the most recent information about that candidate.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[int] election_year: Year of election
        :return: CandidateDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular candidate. Use the `candidate_id` to find the most recent information about that candidate.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[int] election_year: Year of election
        :return: CandidateDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'candidate_id', 'federal_funds_flag', 'cycle', 'sort', 'year', 'state', 'name', 'sort_nulls_last', 'sort_hide_null', 'per_page', 'district', 'page', 'incumbent_challenge', 'party', 'has_raised_funds', 'sort_null_only', 'candidate_status', 'office', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'federal_funds_flag' in params:
            query_params.append(('federal_funds_flag', params['federal_funds_flag']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
            collection_formats['name'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'incumbent_challenge' in params:
            query_params.append(('incumbent_challenge', params['incumbent_challenge']))  # noqa: E501
            collection_formats['incumbent_challenge'] = 'multi'  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'has_raised_funds' in params:
            query_params.append(('has_raised_funds', params['has_raised_funds']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'candidate_status' in params:
            query_params.append(('candidate_status', params['candidate_status']))  # noqa: E501
            collection_formats['candidate_status'] = 'multi'  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateDetailPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_history_cycle_get(self, api_key, cycle, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_history_cycle_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_history_cycle_get(api_key, cycle, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_history_cycle_get_with_http_info(api_key, cycle, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_history_cycle_get_with_http_info(api_key, cycle, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_history_cycle_get_with_http_info(self, api_key, cycle, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_history_cycle_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_history_cycle_get_with_http_info(api_key, cycle, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'candidate_id', 'election_full', 'page', 'per_page', 'sort_nulls_last', 'sort', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_history_cycle_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `candidate_candidate_id_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_history_cycle_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cycle' in params:
            path_params['cycle'] = params['cycle']  # noqa: E501
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/history/{cycle}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_history_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_history_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_history_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_history_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_history_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_history_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_history_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_history_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'candidate_id', 'election_full', 'page', 'per_page', 'sort_nulls_last', 'sort', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_history_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_history_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_history_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/history/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_totals_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_totals_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_totals_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool full_election: Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_totals_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_totals_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_totals_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_totals_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_totals_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool full_election: Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'candidate_id', 'per_page', 'cycle', 'sort', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'full_election', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_totals_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_totals_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_totals_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'full_election' in params:
            query_params.append(('full_election', params['full_election']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/totals/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidates_get(self, api_key, **kwargs):  # noqa: E501
        """candidates_get  # noqa: E501

         Fetch basic information about candidates, and use parameters to filter results to the candidates you're looking for.  Each result reflects a unique FEC candidate ID. That ID is particular to the candidate for a particular office sought. If a candidate runs for the same office multiple times, the ID stays the same. If the same person runs for another office — for example, a House candidate runs for a Senate office — that candidate will get a unique ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param date max_first_file_date: Selects all candidates whose first filing was received by the FEC before this date.
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: Name of candidate running for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param date min_first_file_date: Selects all candidates whose first filing was received by the FEC after this date.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year: Year of election
        :return: CandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidates_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.candidates_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def candidates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """candidates_get  # noqa: E501

         Fetch basic information about candidates, and use parameters to filter results to the candidates you're looking for.  Each result reflects a unique FEC candidate ID. That ID is particular to the candidate for a particular office sought. If a candidate runs for the same office multiple times, the ID stays the same. If the same person runs for another office — for example, a House candidate runs for a Senate office — that candidate will get a unique ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param date max_first_file_date: Selects all candidates whose first filing was received by the FEC before this date.
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: Name of candidate running for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param date min_first_file_date: Selects all candidates whose first filing was received by the FEC after this date.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year: Year of election
        :return: CandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'federal_funds_flag', 'cycle', 'sort', 'year', 'state', 'max_first_file_date', 'name', 'sort_nulls_last', 'q', 'sort_hide_null', 'is_active_candidate', 'min_first_file_date', 'per_page', 'office', 'candidate_id', 'district', 'page', 'has_raised_funds', 'incumbent_challenge', 'party', 'candidate_status', 'sort_null_only', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'federal_funds_flag' in params:
            query_params.append(('federal_funds_flag', params['federal_funds_flag']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'max_first_file_date' in params:
            query_params.append(('max_first_file_date', params['max_first_file_date']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
            collection_formats['name'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'is_active_candidate' in params:
            query_params.append(('is_active_candidate', params['is_active_candidate']))  # noqa: E501
        if 'min_first_file_date' in params:
            query_params.append(('min_first_file_date', params['min_first_file_date']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'has_raised_funds' in params:
            query_params.append(('has_raised_funds', params['has_raised_funds']))  # noqa: E501
        if 'incumbent_challenge' in params:
            query_params.append(('incumbent_challenge', params['incumbent_challenge']))  # noqa: E501
            collection_formats['incumbent_challenge'] = 'multi'  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'candidate_status' in params:
            query_params.append(('candidate_status', params['candidate_status']))  # noqa: E501
            collection_formats['candidate_status'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidates_search_get(self, api_key, **kwargs):  # noqa: E501
        """candidates_search_get  # noqa: E501

         Fetch basic information about candidates and their principal committees.  Each result reflects a unique FEC candidate ID. That ID is assigned to the candidate for a particular office sought. If a candidate runs for the same office over time, that ID stays the same. If the same person runs for multiple offices — for example, a House candidate runs for a Senate office — that candidate will get a unique ID for each office.  The candidate endpoints primarily use data from FEC registration [Form 1](http://www.fec.gov/pdf/forms/fecfrm1.pdf), for candidate information, and [Form 2](http://www.fec.gov/pdf/forms/fecfrm2.pdf), for committees information, with additional information to provide context.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_search_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param date max_first_file_date: Selects all candidates whose first filing was received by the FEC before this date.
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: Name of candidate running for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param date min_first_file_date: Selects all candidates whose first filing was received by the FEC after this date.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year: Year of election
        :return: CandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidates_search_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.candidates_search_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def candidates_search_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """candidates_search_get  # noqa: E501

         Fetch basic information about candidates and their principal committees.  Each result reflects a unique FEC candidate ID. That ID is assigned to the candidate for a particular office sought. If a candidate runs for the same office over time, that ID stays the same. If the same person runs for multiple offices — for example, a House candidate runs for a Senate office — that candidate will get a unique ID for each office.  The candidate endpoints primarily use data from FEC registration [Form 1](http://www.fec.gov/pdf/forms/fecfrm1.pdf), for candidate information, and [Form 2](http://www.fec.gov/pdf/forms/fecfrm2.pdf), for committees information, with additional information to provide context.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_search_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param date max_first_file_date: Selects all candidates whose first filing was received by the FEC before this date.
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: Name of candidate running for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param date min_first_file_date: Selects all candidates whose first filing was received by the FEC after this date.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year: Year of election
        :return: CandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'federal_funds_flag', 'cycle', 'sort', 'year', 'state', 'max_first_file_date', 'name', 'sort_nulls_last', 'q', 'sort_hide_null', 'is_active_candidate', 'min_first_file_date', 'per_page', 'office', 'candidate_id', 'district', 'page', 'has_raised_funds', 'incumbent_challenge', 'party', 'candidate_status', 'sort_null_only', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidates_search_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidates_search_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'federal_funds_flag' in params:
            query_params.append(('federal_funds_flag', params['federal_funds_flag']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'max_first_file_date' in params:
            query_params.append(('max_first_file_date', params['max_first_file_date']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
            collection_formats['name'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'is_active_candidate' in params:
            query_params.append(('is_active_candidate', params['is_active_candidate']))  # noqa: E501
        if 'min_first_file_date' in params:
            query_params.append(('min_first_file_date', params['min_first_file_date']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'has_raised_funds' in params:
            query_params.append(('has_raised_funds', params['has_raised_funds']))  # noqa: E501
        if 'incumbent_challenge' in params:
            query_params.append(('incumbent_challenge', params['incumbent_challenge']))  # noqa: E501
            collection_formats['incumbent_challenge'] = 'multi'  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'candidate_status' in params:
            query_params.append(('candidate_status', params['candidate_status']))  # noqa: E501
            collection_formats['candidate_status'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidates/search/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidates_totals_by_office_by_party_get(self, api_key, **kwargs):  # noqa: E501
        """candidates_totals_by_office_by_party_get  # noqa: E501

         Aggregated candidate receipts and disbursements grouped by office by party by cycle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_totals_by_office_by_party_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str office: Federal office candidate runs for: H, S or P
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :return: TotalByOfficeByPartyPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidates_totals_by_office_by_party_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.candidates_totals_by_office_by_party_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def candidates_totals_by_office_by_party_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """candidates_totals_by_office_by_party_get  # noqa: E501

         Aggregated candidate receipts and disbursements grouped by office by party by cycle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_totals_by_office_by_party_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str office: Federal office candidate runs for: H, S or P
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :return: TotalByOfficeByPartyPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'per_page', 'office', 'sort', 'page', 'sort_nulls_last', 'sort_hide_null', 'is_active_candidate', 'sort_null_only', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidates_totals_by_office_by_party_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidates_totals_by_office_by_party_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'is_active_candidate' in params:
            query_params.append(('is_active_candidate', params['is_active_candidate']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidates/totals/by_office/by_party/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TotalByOfficeByPartyPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidates_totals_by_office_get(self, api_key, **kwargs):  # noqa: E501
        """candidates_totals_by_office_get  # noqa: E501

         Aggregated candidate receipts and disbursements grouped by office by cycle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_totals_by_office_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str office: Federal office candidate runs for: H, S or P
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :return: TotalByOfficePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidates_totals_by_office_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.candidates_totals_by_office_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def candidates_totals_by_office_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """candidates_totals_by_office_get  # noqa: E501

         Aggregated candidate receipts and disbursements grouped by office by cycle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_totals_by_office_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str office: Federal office candidate runs for: H, S or P
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] election_year:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :return: TotalByOfficePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'per_page', 'office', 'sort', 'page', 'sort_nulls_last', 'sort_hide_null', 'is_active_candidate', 'sort_null_only', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidates_totals_by_office_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidates_totals_by_office_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'is_active_candidate' in params:
            query_params.append(('is_active_candidate', params['is_active_candidate']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidates/totals/by_office/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TotalByOfficePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidates_totals_get(self, api_key, **kwargs):  # noqa: E501
        """candidates_totals_get  # noqa: E501

         Aggregated candidate receipts and disbursements grouped by cycle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_totals_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param str min_receipts: Minimum aggregated receipts
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_debts_owed_by_committee: Maximum debt
        :param list[str] state: State of candidate
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: Name of candidate running for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param str max_disbursements: Maximum aggregated disbursements
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str max_receipts: Maximum aggregated receipts
        :param list[str] district: District of candidate
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param str min_debts_owed_by_committee: Minimum debt
        :param str max_cash_on_hand_end_period: Maximum cash on hand
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param str min_cash_on_hand_end_period: Minimum cash on hand
        :param list[str] party: Three-letter party code
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_disbursements: Minimum aggregated disbursements
        :param list[int] election_year:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :return: CandidateHistoryTotalPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidates_totals_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.candidates_totals_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def candidates_totals_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """candidates_totals_get  # noqa: E501

         Aggregated candidate receipts and disbursements grouped by cycle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidates_totals_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param str min_receipts: Minimum aggregated receipts
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_debts_owed_by_committee: Maximum debt
        :param list[str] state: State of candidate
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: Name of candidate running for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool is_active_candidate:  Candidates who are actively seeking office. If no value is specified, all candidates are returned. When True is specified, only active candidates are returned. When False is specified, only inactive candidates are returned.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param str max_disbursements: Maximum aggregated disbursements
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str max_receipts: Maximum aggregated receipts
        :param list[str] district: District of candidate
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param str min_debts_owed_by_committee: Minimum debt
        :param str max_cash_on_hand_end_period: Maximum cash on hand
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param str min_cash_on_hand_end_period: Minimum cash on hand
        :param list[str] party: Three-letter party code
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_disbursements: Minimum aggregated disbursements
        :param list[int] election_year:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :return: CandidateHistoryTotalPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'federal_funds_flag', 'min_receipts', 'cycle', 'sort', 'max_debts_owed_by_committee', 'state', 'sort_nulls_last', 'q', 'sort_hide_null', 'is_active_candidate', 'per_page', 'office', 'max_disbursements', 'candidate_id', 'max_receipts', 'district', 'election_full', 'page', 'min_debts_owed_by_committee', 'max_cash_on_hand_end_period', 'has_raised_funds', 'min_cash_on_hand_end_period', 'party', 'sort_null_only', 'min_disbursements', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidates_totals_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidates_totals_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'federal_funds_flag' in params:
            query_params.append(('federal_funds_flag', params['federal_funds_flag']))  # noqa: E501
        if 'min_receipts' in params:
            query_params.append(('min_receipts', params['min_receipts']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'max_debts_owed_by_committee' in params:
            query_params.append(('max_debts_owed_by_committee', params['max_debts_owed_by_committee']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'is_active_candidate' in params:
            query_params.append(('is_active_candidate', params['is_active_candidate']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'max_disbursements' in params:
            query_params.append(('max_disbursements', params['max_disbursements']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'max_receipts' in params:
            query_params.append(('max_receipts', params['max_receipts']))  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'min_debts_owed_by_committee' in params:
            query_params.append(('min_debts_owed_by_committee', params['min_debts_owed_by_committee']))  # noqa: E501
        if 'max_cash_on_hand_end_period' in params:
            query_params.append(('max_cash_on_hand_end_period', params['max_cash_on_hand_end_period']))  # noqa: E501
        if 'has_raised_funds' in params:
            query_params.append(('has_raised_funds', params['has_raised_funds']))  # noqa: E501
        if 'min_cash_on_hand_end_period' in params:
            query_params.append(('min_cash_on_hand_end_period', params['min_cash_on_hand_end_period']))  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'min_disbursements' in params:
            query_params.append(('min_disbursements', params['min_disbursements']))  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidates/totals/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateHistoryTotalPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_candidates_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_candidates_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular candidate. Use the `candidate_id` to find the most recent information about that candidate.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_candidates_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[int] election_year: Year of election
        :return: CandidateDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_candidates_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_candidates_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_candidates_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_candidates_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular candidate. Use the `candidate_id` to find the most recent information about that candidate.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_candidates_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param bool federal_funds_flag: A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str year: See records pertaining to a particular election year. The list of election years is based on a candidate filing a statement of candidacy (F2) for that year.
        :param list[str] state: US state or territory where a candidate runs for office
        :param list[str] name: Name (candidate or committee) to search for. Alias for 'q'.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param list[str] incumbent_challenge: One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool has_raised_funds: A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] candidate_status: One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[int] election_year: Year of election
        :return: CandidateDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'federal_funds_flag', 'cycle', 'sort', 'year', 'state', 'name', 'sort_nulls_last', 'sort_hide_null', 'per_page', 'district', 'page', 'incumbent_challenge', 'party', 'has_raised_funds', 'sort_null_only', 'candidate_status', 'office', 'election_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_candidates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_candidates_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_candidates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'federal_funds_flag' in params:
            query_params.append(('federal_funds_flag', params['federal_funds_flag']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
            collection_formats['name'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'incumbent_challenge' in params:
            query_params.append(('incumbent_challenge', params['incumbent_challenge']))  # noqa: E501
            collection_formats['incumbent_challenge'] = 'multi'  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'has_raised_funds' in params:
            query_params.append(('has_raised_funds', params['has_raised_funds']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'candidate_status' in params:
            query_params.append(('candidate_status', params['candidate_status']))  # noqa: E501
            collection_formats['candidate_status'] = 'multi'  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/candidates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateDetailPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_candidates_history_cycle_get(self, api_key, committee_id, cycle, **kwargs):  # noqa: E501
        """committee_committee_id_candidates_history_cycle_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_candidates_history_cycle_get(api_key, committee_id, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_candidates_history_cycle_get_with_http_info(api_key, committee_id, cycle, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_candidates_history_cycle_get_with_http_info(api_key, committee_id, cycle, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_candidates_history_cycle_get_with_http_info(self, api_key, committee_id, cycle, **kwargs):  # noqa: E501
        """committee_committee_id_candidates_history_cycle_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_candidates_history_cycle_get_with_http_info(api_key, committee_id, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'cycle', 'election_full', 'page', 'per_page', 'sort_nulls_last', 'sort', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_candidates_history_cycle_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_candidates_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_candidates_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `committee_committee_id_candidates_history_cycle_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501
        if 'cycle' in params:
            path_params['cycle'] = params['cycle']  # noqa: E501

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/candidates/history/{cycle}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_candidates_history_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_candidates_history_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_candidates_history_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_candidates_history_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_candidates_history_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_candidates_history_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_candidates_history_get  # noqa: E501

         Find out a candidate's characteristics over time. This is particularly useful if the candidate runs for the same office in different districts or you want to know more about a candidate's previous races.  This information is organized by `candidate_id`, so it won't help you find a candidate who ran for different offices over time; candidates get a new ID for each office.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_candidates_history_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CandidateHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'election_full', 'page', 'per_page', 'sort_nulls_last', 'sort', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_candidates_history_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_candidates_history_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_candidates_history_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/candidates/history/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandidateHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
