# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class CommitteeApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def candidate_candidate_id_committees_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_committees_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_committees_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_committees_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'candidate_id', 'per_page', 'designation', 'cycle', 'year', 'filing_frequency', 'organization_type', 'sort', 'committee_type', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_committees_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_committees_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_committees_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'filing_frequency' in params:
            query_params.append(('filing_frequency', params['filing_frequency']))  # noqa: E501
            collection_formats['filing_frequency'] = 'multi'  # noqa: E501
        if 'organization_type' in params:
            query_params.append(('organization_type', params['organization_type']))  # noqa: E501
            collection_formats['organization_type'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/committees/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeDetailPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_committees_history_cycle_get(self, api_key, cycle, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_cycle_get(api_key, cycle, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_committees_history_cycle_get_with_http_info(api_key, cycle, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_committees_history_cycle_get_with_http_info(api_key, cycle, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_committees_history_cycle_get_with_http_info(self, api_key, cycle, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_cycle_get_with_http_info(api_key, cycle, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'candidate_id', 'designation', 'per_page', 'sort', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_committees_history_cycle_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_committees_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `candidate_candidate_id_committees_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_committees_history_cycle_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cycle' in params:
            path_params['cycle'] = params['cycle']  # noqa: E501
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/committees/history/{cycle}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_committees_history_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_committees_history_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_committees_history_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_committees_history_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'candidate_id', 'designation', 'per_page', 'sort', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_committees_history_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_committees_history_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_committees_history_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/committees/history/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'designation', 'cycle', 'year', 'filing_frequency', 'organization_type', 'sort', 'committee_type', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'filing_frequency' in params:
            query_params.append(('filing_frequency', params['filing_frequency']))  # noqa: E501
            collection_formats['filing_frequency'] = 'multi'  # noqa: E501
        if 'organization_type' in params:
            query_params.append(('organization_type', params['organization_type']))  # noqa: E501
            collection_formats['organization_type'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeDetailPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_history_cycle_get(self, api_key, committee_id, cycle, **kwargs):  # noqa: E501
        """committee_committee_id_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_cycle_get(api_key, committee_id, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_history_cycle_get_with_http_info(api_key, committee_id, cycle, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_history_cycle_get_with_http_info(api_key, committee_id, cycle, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_history_cycle_get_with_http_info(self, api_key, committee_id, cycle, **kwargs):  # noqa: E501
        """committee_committee_id_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_cycle_get_with_http_info(api_key, committee_id, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'cycle', 'designation', 'per_page', 'sort', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_history_cycle_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `committee_committee_id_history_cycle_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501
        if 'cycle' in params:
            path_params['cycle'] = params['cycle']  # noqa: E501

        query_params = []
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/history/{cycle}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_history_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_history_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_history_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_history_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'designation', 'per_page', 'sort', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_history_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_history_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_history_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/history/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committees_get(self, api_key, **kwargs):  # noqa: E501
        """committees_get  # noqa: E501

         Fetch basic information about committees and filers. Use parameters to filter for particular characteristics.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committees_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param date min_last_f1_date: Filter for committees whose latest Form 1 was received on or after this date.
        :param list[str] state: US state or territory
        :param date max_first_file_date: Filter for committees whose first filing was received on or before this date.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_last_f1_date: Filter for committees whose latest Form 1 was received on or before this date.
        :param date min_first_file_date: Filter for committees whose first filing was received on or after this date.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] treasurer_name: Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committees_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.committees_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def committees_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """committees_get  # noqa: E501

         Fetch basic information about committees and filers. Use parameters to filter for particular characteristics.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committees_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param date min_last_f1_date: Filter for committees whose latest Form 1 was received on or after this date.
        :param list[str] state: US state or territory
        :param date max_first_file_date: Filter for committees whose first filing was received on or before this date.
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] q: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_last_f1_date: Filter for committees whose latest Form 1 was received on or before this date.
        :param date min_first_file_date: Filter for committees whose first filing was received on or after this date.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] treasurer_name: Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'organization_type', 'sort', 'designation', 'year', 'min_last_f1_date', 'state', 'max_first_file_date', 'committee_type', 'sort_nulls_last', 'q', 'sort_hide_null', 'max_last_f1_date', 'min_first_file_date', 'committee_id', 'per_page', 'filing_frequency', 'treasurer_name', 'candidate_id', 'page', 'party', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committees_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committees_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'organization_type' in params:
            query_params.append(('organization_type', params['organization_type']))  # noqa: E501
            collection_formats['organization_type'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'min_last_f1_date' in params:
            query_params.append(('min_last_f1_date', params['min_last_f1_date']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'max_first_file_date' in params:
            query_params.append(('max_first_file_date', params['max_first_file_date']))  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'max_last_f1_date' in params:
            query_params.append(('max_last_f1_date', params['max_last_f1_date']))  # noqa: E501
        if 'min_first_file_date' in params:
            query_params.append(('min_first_file_date', params['min_first_file_date']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'filing_frequency' in params:
            query_params.append(('filing_frequency', params['filing_frequency']))  # noqa: E501
            collection_formats['filing_frequency'] = 'multi'  # noqa: E501
        if 'treasurer_name' in params:
            query_params.append(('treasurer_name', params['treasurer_name']))  # noqa: E501
            collection_formats['treasurer_name'] = 'multi'  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committees/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
