# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class DatesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calendar_dates_export_get(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_export_get  # noqa: E501

         Returns CSV or ICS for downloading directly into calendar applications like Google, Outlook or other applications.  Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State filtering now applies to elections, reports and reporting periods.  Presidential pre-primary report due dates are not shown on even years. Filers generally opt to file monthly rather than submit over 50 pre-primary election reports. All reporting deadlines are available at /reporting-dates/ for reference.  This is [the sql function](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V40__omnibus_dates.sql) that creates the calendar.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_export_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] description: Brief description of event
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str renderer:
        :param list[str] summary: Longer description of event
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :return: CalendarDatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calendar_dates_export_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.calendar_dates_export_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def calendar_dates_export_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_export_get  # noqa: E501

         Returns CSV or ICS for downloading directly into calendar applications like Google, Outlook or other applications.  Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State filtering now applies to elections, reports and reporting periods.  Presidential pre-primary report due dates are not shown on even years. Filers generally opt to file monthly rather than submit over 50 pre-primary election reports. All reporting deadlines are available at /reporting-dates/ for reference.  This is [the sql function](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V40__omnibus_dates.sql) that creates the calendar.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_export_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] description: Brief description of event
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str renderer:
        :param list[str] summary: Longer description of event
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :return: CalendarDatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'event_id', 'calendar_category_id', 'per_page', 'min_end_date', 'sort', 'description', 'min_start_date', 'renderer', 'summary', 'page', 'sort_nulls_last', 'sort_hide_null', 'max_end_date', 'sort_null_only', 'max_start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method calendar_dates_export_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `calendar_dates_export_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'event_id' in params:
            query_params.append(('event_id', params['event_id']))  # noqa: E501
        if 'calendar_category_id' in params:
            query_params.append(('calendar_category_id', params['calendar_category_id']))  # noqa: E501
            collection_formats['calendar_category_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_end_date' in params:
            query_params.append(('min_end_date', params['min_end_date']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
            collection_formats['description'] = 'multi'  # noqa: E501
        if 'min_start_date' in params:
            query_params.append(('min_start_date', params['min_start_date']))  # noqa: E501
        if 'renderer' in params:
            query_params.append(('renderer', params['renderer']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
            collection_formats['summary'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'max_end_date' in params:
            query_params.append(('max_end_date', params['max_end_date']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_start_date' in params:
            query_params.append(('max_start_date', params['max_start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/calendar-dates/export/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CalendarDatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def calendar_dates_get(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_get  # noqa: E501

         Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State and report type filtering is no longer available.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] description: Brief description of event
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] summary: Longer description of event
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :return: CalendarDatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calendar_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.calendar_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def calendar_dates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_get  # noqa: E501

         Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State and report type filtering is no longer available.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] description: Brief description of event
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] summary: Longer description of event
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :return: CalendarDatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'event_id', 'calendar_category_id', 'per_page', 'min_end_date', 'sort', 'description', 'min_start_date', 'summary', 'page', 'sort_nulls_last', 'sort_hide_null', 'max_end_date', 'sort_null_only', 'max_start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method calendar_dates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `calendar_dates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'event_id' in params:
            query_params.append(('event_id', params['event_id']))  # noqa: E501
        if 'calendar_category_id' in params:
            query_params.append(('calendar_category_id', params['calendar_category_id']))  # noqa: E501
            collection_formats['calendar_category_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_end_date' in params:
            query_params.append(('min_end_date', params['min_end_date']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
            collection_formats['description'] = 'multi'  # noqa: E501
        if 'min_start_date' in params:
            query_params.append(('min_start_date', params['min_start_date']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'summary' in params:
            query_params.append(('summary', params['summary']))  # noqa: E501
            collection_formats['summary'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'max_end_date' in params:
            query_params.append(('max_end_date', params['max_end_date']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_start_date' in params:
            query_params.append(('max_start_date', params['max_start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/calendar-dates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CalendarDatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def election_dates_get(self, api_key, **kwargs):  # noqa: E501
        """election_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.election_dates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] election_party:  Party, if applicable.
        :param list[str] election_type_id:  Election type id
        :param list[str] election_state:  State or territory of the office sought.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] election_district:  House district of the office sought, if applicable.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] office_sought:  House, Senate or presidential office.
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_election_date:  The maximum date of election.
        :param date min_election_date:  The minimum date of election.
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_primary_general_date:  The maximum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] election_year: Year of election
        :param date min_primary_general_date:  The minimum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :return: InlineResponseDefault
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.election_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.election_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def election_dates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """election_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.election_dates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] election_party:  Party, if applicable.
        :param list[str] election_type_id:  Election type id
        :param list[str] election_state:  State or territory of the office sought.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] election_district:  House district of the office sought, if applicable.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] office_sought:  House, Senate or presidential office.
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_election_date:  The maximum date of election.
        :param date min_election_date:  The minimum date of election.
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_primary_general_date:  The maximum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] election_year: Year of election
        :param date min_primary_general_date:  The minimum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :return: InlineResponseDefault
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'election_party', 'election_type_id', 'election_state', 'sort', 'election_district', 'sort_nulls_last', 'sort_hide_null', 'office_sought', 'min_update_date', 'max_election_date', 'min_election_date', 'min_create_date', 'per_page', 'max_create_date', 'page', 'max_update_date', 'max_primary_general_date', 'sort_null_only', 'election_year', 'min_primary_general_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method election_dates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `election_dates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_party' in params:
            query_params.append(('election_party', params['election_party']))  # noqa: E501
            collection_formats['election_party'] = 'multi'  # noqa: E501
        if 'election_type_id' in params:
            query_params.append(('election_type_id', params['election_type_id']))  # noqa: E501
            collection_formats['election_type_id'] = 'multi'  # noqa: E501
        if 'election_state' in params:
            query_params.append(('election_state', params['election_state']))  # noqa: E501
            collection_formats['election_state'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'election_district' in params:
            query_params.append(('election_district', params['election_district']))  # noqa: E501
            collection_formats['election_district'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'office_sought' in params:
            query_params.append(('office_sought', params['office_sought']))  # noqa: E501
            collection_formats['office_sought'] = 'multi'  # noqa: E501
        if 'min_update_date' in params:
            query_params.append(('min_update_date', params['min_update_date']))  # noqa: E501
        if 'max_election_date' in params:
            query_params.append(('max_election_date', params['max_election_date']))  # noqa: E501
        if 'min_election_date' in params:
            query_params.append(('min_election_date', params['min_election_date']))  # noqa: E501
        if 'min_create_date' in params:
            query_params.append(('min_create_date', params['min_create_date']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'max_create_date' in params:
            query_params.append(('max_create_date', params['max_create_date']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'max_update_date' in params:
            query_params.append(('max_update_date', params['max_update_date']))  # noqa: E501
        if 'max_primary_general_date' in params:
            query_params.append(('max_primary_general_date', params['max_primary_general_date']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'election_year' in params:
            query_params.append(('election_year', params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501
        if 'min_primary_general_date' in params:
            query_params.append(('min_primary_general_date', params['min_primary_general_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/election-dates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponseDefault',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reporting_dates_get(self, api_key, **kwargs):  # noqa: E501
        """reporting_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reporting_dates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param date min_due_date:  The minimum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_due_date:  The maximum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :return: InlineResponseDefault2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reporting_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.reporting_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def reporting_dates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """reporting_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reporting_dates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param date min_due_date:  The minimum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_due_date:  The maximum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :return: InlineResponseDefault2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'min_due_date', 'per_page', 'min_create_date', 'sort', 'max_create_date', 'min_update_date', 'page', 'sort_nulls_last', 'max_update_date', 'sort_hide_null', 'max_due_date', 'report_type', 'sort_null_only', 'report_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method reporting_dates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `reporting_dates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'min_due_date' in params:
            query_params.append(('min_due_date', params['min_due_date']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_create_date' in params:
            query_params.append(('min_create_date', params['min_create_date']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'max_create_date' in params:
            query_params.append(('max_create_date', params['max_create_date']))  # noqa: E501
        if 'min_update_date' in params:
            query_params.append(('min_update_date', params['min_update_date']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'max_update_date' in params:
            query_params.append(('max_update_date', params['max_update_date']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'max_due_date' in params:
            query_params.append(('max_due_date', params['max_due_date']))  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'report_year' in params:
            query_params.append(('report_year', params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reporting-dates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponseDefault2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
