# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class DisbursementsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def schedules_schedule_b_by_purpose_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_by_purpose_get  # noqa: E501

         Schedule B disbursements aggregated by disbursement purpose category. To avoid double counting, memoed items are not included. Purpose is a combination of transaction codes, category codes and disbursement description. See the `disbursement_purpose` sql function within the migrations for more details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_by_purpose_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] purpose: Disbursement purpose category
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleBByPurposePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_b_by_purpose_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_b_by_purpose_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_b_by_purpose_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_by_purpose_get  # noqa: E501

         Schedule B disbursements aggregated by disbursement purpose category. To avoid double counting, memoed items are not included. Purpose is a combination of transaction codes, category codes and disbursement description. See the `disbursement_purpose` sql function within the migrations for more details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_by_purpose_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] purpose: Disbursement purpose category
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleBByPurposePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'purpose', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_b_by_purpose_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_b_by_purpose_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'purpose' in params:
            query_params.append(('purpose', params['purpose']))  # noqa: E501
            collection_formats['purpose'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_b/by_purpose/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleBByPurposePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_b_by_recipient_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_by_recipient_get  # noqa: E501

         Schedule B disbursements aggregated by recipient name. To avoid double counting, memoed items are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_by_recipient_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] recipient_name: Name of the entity receiving the disbursement
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleBByRecipientPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_b_by_recipient_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_b_by_recipient_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_b_by_recipient_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_by_recipient_get  # noqa: E501

         Schedule B disbursements aggregated by recipient name. To avoid double counting, memoed items are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_by_recipient_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] recipient_name: Name of the entity receiving the disbursement
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleBByRecipientPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'page', 'sort_nulls_last', 'sort_hide_null', 'recipient_name', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_b_by_recipient_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_b_by_recipient_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'recipient_name' in params:
            query_params.append(('recipient_name', params['recipient_name']))  # noqa: E501
            collection_formats['recipient_name'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_b/by_recipient/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleBByRecipientPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_b_by_recipient_id_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_by_recipient_id_get  # noqa: E501

         Schedule B disbursements aggregated by recipient committee ID, if applicable. To avoid double counting, memoed items are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_by_recipient_id_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] recipient_id: The FEC identifier should be represented here if the entity receiving the disbursement is registered with the FEC.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleBByRecipientIDPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_b_by_recipient_id_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_b_by_recipient_id_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_b_by_recipient_id_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_by_recipient_id_get  # noqa: E501

         Schedule B disbursements aggregated by recipient committee ID, if applicable. To avoid double counting, memoed items are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_by_recipient_id_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] recipient_id: The FEC identifier should be represented here if the entity receiving the disbursement is registered with the FEC.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleBByRecipientIDPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'recipient_id', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_b_by_recipient_id_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_b_by_recipient_id_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'recipient_id' in params:
            query_params.append(('recipient_id', params['recipient_id']))  # noqa: E501
            collection_formats['recipient_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_b/by_recipient_id/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleBByRecipientIDPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_b_efile_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_efile_get  # noqa: E501

         Efiling endpoints provide real-time campaign finance data received from electronic filers. Efiling endpoints only contain the most recent four months of data and don't contain the processed and coded data that you can find on other endpoints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_efile_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts less than a value.
        :param list[str] disbursement_description: Description of disbursement
        :param str max_amount: Filter for all amounts less than a value.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] recipient_city: City of recipient
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: When sorting by `disbursement_date`, this is populated with the         `disbursement_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] recipient_state: State of recipient
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_date: When sorting by `disbursement_date`, this is populated with the         `disbursement_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :return: ScheduleBEfilePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_b_efile_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_b_efile_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_b_efile_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_efile_get  # noqa: E501

         Efiling endpoints provide real-time campaign finance data received from electronic filers. Efiling endpoints only contain the most recent four months of data and don't contain the processed and coded data that you can find on other endpoints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_efile_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts less than a value.
        :param list[str] disbursement_description: Description of disbursement
        :param str max_amount: Filter for all amounts less than a value.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] recipient_city: City of recipient
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: When sorting by `disbursement_date`, this is populated with the         `disbursement_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] recipient_state: State of recipient
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_date: When sorting by `disbursement_date`, this is populated with the         `disbursement_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :return: ScheduleBEfilePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'min_amount', 'disbursement_description', 'max_amount', 'sort', 'recipient_city', 'image_number', 'page', 'sort_nulls_last', 'sort_hide_null', 'min_date', 'recipient_state', 'sort_null_only', 'max_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_b_efile_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_b_efile_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'disbursement_description' in params:
            query_params.append(('disbursement_description', params['disbursement_description']))  # noqa: E501
            collection_formats['disbursement_description'] = 'multi'  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'recipient_city' in params:
            query_params.append(('recipient_city', params['recipient_city']))  # noqa: E501
            collection_formats['recipient_city'] = 'multi'  # noqa: E501
        if 'image_number' in params:
            query_params.append(('image_number', params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'recipient_state' in params:
            query_params.append(('recipient_state', params['recipient_state']))  # noqa: E501
            collection_formats['recipient_state'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_b/efile/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleBEfilePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_b_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_get  # noqa: E501

         Schedule B filings describe itemized disbursements. This data explains how committees and other filers spend their money. These figures are reported as part of forms F3, F3X and F3P.  The data is divided in two-year periods, called `two_year_transaction_period`, which is derived from the `report_year` submitted of the corresponding form. If no value is supplied, the results will default to the most recent two-year period that is named after the ending, even-numbered year.  Due to the large quantity of Schedule B filings, this endpoint is not paginated by page number. Instead, you can request the next page of results by adding the values in the `last_indexes` object from `pagination` to the URL of your last request. For example, when sorting by `disbursement_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 965191,     per_page: 20,     count: 19303814,     last_indexes: {         last_index: \"230906248\",         last_disbursement_date: \"2014-07-04\"     } } ```  To fetch the next page of sorted results, append `last_index=230906248` and `last_disbursement_date=2014-07-04` to the URL.  We strongly advise paging through these results by using the sort indices (defaults to sort by disbursement date, e.g. `last_disbursement_date`), otherwise some resources may be unintentionally filtered out. This resource uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset.  Note: because the Schedule B data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] recipient_committee_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param int last_index: Index of last result from previous page
        :param list[str] spender_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str min_image_number:
        :param list[str] recipient_city: City of recipient
        :param date last_disbursement_date: When sorting by `disbursement_date`, this is populated with the `disbursement_date` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] disbursement_description: Description of disbursement
        :param float last_disbursement_amount: When sorting by `disbursement_amount`, this is populated with the `disbursement_amount` of the last result.  However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param list[str] spender_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] disbursement_purpose_category: Disbursement purpose category
        :param list[str] recipient_state: State of recipient
        :param list[str] spender_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] recipient_name: Name of the entity receiving the disbursement
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str max_image_number:
        :return: ScheduleBPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_b_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_b_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_b_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_b_get  # noqa: E501

         Schedule B filings describe itemized disbursements. This data explains how committees and other filers spend their money. These figures are reported as part of forms F3, F3X and F3P.  The data is divided in two-year periods, called `two_year_transaction_period`, which is derived from the `report_year` submitted of the corresponding form. If no value is supplied, the results will default to the most recent two-year period that is named after the ending, even-numbered year.  Due to the large quantity of Schedule B filings, this endpoint is not paginated by page number. Instead, you can request the next page of results by adding the values in the `last_indexes` object from `pagination` to the URL of your last request. For example, when sorting by `disbursement_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 965191,     per_page: 20,     count: 19303814,     last_indexes: {         last_index: \"230906248\",         last_disbursement_date: \"2014-07-04\"     } } ```  To fetch the next page of sorted results, append `last_index=230906248` and `last_disbursement_date=2014-07-04` to the URL.  We strongly advise paging through these results by using the sort indices (defaults to sort by disbursement date, e.g. `last_disbursement_date`), otherwise some resources may be unintentionally filtered out. This resource uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset.  Note: because the Schedule B data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] recipient_committee_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param int last_index: Index of last result from previous page
        :param list[str] spender_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str min_image_number:
        :param list[str] recipient_city: City of recipient
        :param date last_disbursement_date: When sorting by `disbursement_date`, this is populated with the `disbursement_date` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] disbursement_description: Description of disbursement
        :param float last_disbursement_amount: When sorting by `disbursement_amount`, this is populated with the `disbursement_amount` of the last result.  However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param list[str] spender_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] disbursement_purpose_category: Disbursement purpose category
        :param list[str] recipient_state: State of recipient
        :param list[str] spender_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] recipient_name: Name of the entity receiving the disbursement
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str max_image_number:
        :return: ScheduleBPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'recipient_committee_id', 'last_index', 'spender_committee_type', 'sort', 'max_amount', 'min_image_number', 'recipient_city', 'last_disbursement_date', 'sort_hide_null', 'min_date', 'line_number', 'max_date', 'committee_id', 'two_year_transaction_period', 'per_page', 'min_amount', 'disbursement_description', 'last_disbursement_amount', 'spender_committee_org_type', 'image_number', 'disbursement_purpose_category', 'recipient_state', 'spender_committee_designation', 'recipient_name', 'sort_null_only', 'max_image_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_b_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_b_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'recipient_committee_id' in params:
            query_params.append(('recipient_committee_id', params['recipient_committee_id']))  # noqa: E501
            collection_formats['recipient_committee_id'] = 'multi'  # noqa: E501
        if 'last_index' in params:
            query_params.append(('last_index', params['last_index']))  # noqa: E501
        if 'spender_committee_type' in params:
            query_params.append(('spender_committee_type', params['spender_committee_type']))  # noqa: E501
            collection_formats['spender_committee_type'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'min_image_number' in params:
            query_params.append(('min_image_number', params['min_image_number']))  # noqa: E501
        if 'recipient_city' in params:
            query_params.append(('recipient_city', params['recipient_city']))  # noqa: E501
            collection_formats['recipient_city'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'last_disbursement_date' in params:
            query_params.append(('last_disbursement_date', params['last_disbursement_date']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'line_number' in params:
            query_params.append(('line_number', params['line_number']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'two_year_transaction_period' in params:
            query_params.append(('two_year_transaction_period', params['two_year_transaction_period']))  # noqa: E501
            collection_formats['two_year_transaction_period'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'disbursement_description' in params:
            query_params.append(('disbursement_description', params['disbursement_description']))  # noqa: E501
            collection_formats['disbursement_description'] = 'multi'  # noqa: E501
        if 'last_disbursement_amount' in params:
            query_params.append(('last_disbursement_amount', params['last_disbursement_amount']))  # noqa: E501
        if 'spender_committee_org_type' in params:
            query_params.append(('spender_committee_org_type', params['spender_committee_org_type']))  # noqa: E501
            collection_formats['spender_committee_org_type'] = 'multi'  # noqa: E501
        if 'image_number' in params:
            query_params.append(('image_number', params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'disbursement_purpose_category' in params:
            query_params.append(('disbursement_purpose_category', params['disbursement_purpose_category']))  # noqa: E501
            collection_formats['disbursement_purpose_category'] = 'multi'  # noqa: E501
        if 'recipient_state' in params:
            query_params.append(('recipient_state', params['recipient_state']))  # noqa: E501
            collection_formats['recipient_state'] = 'multi'  # noqa: E501
        if 'spender_committee_designation' in params:
            query_params.append(('spender_committee_designation', params['spender_committee_designation']))  # noqa: E501
            collection_formats['spender_committee_designation'] = 'multi'  # noqa: E501
        if 'recipient_name' in params:
            query_params.append(('recipient_name', params['recipient_name']))  # noqa: E501
            collection_formats['recipient_name'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_image_number' in params:
            query_params.append(('max_image_number', params['max_image_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_b/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleBPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_b_sub_id_get(self, api_key, sub_id, **kwargs):  # noqa: E501
        """schedules_schedule_b_sub_id_get  # noqa: E501

         Schedule B filings describe itemized disbursements. This data explains how committees and other filers spend their money. These figures are reported as part of forms F3, F3X and F3P.  The data is divided in two-year periods, called `two_year_transaction_period`, which is derived from the `report_year` submitted of the corresponding form. If no value is supplied, the results will default to the most recent two-year period that is named after the ending, even-numbered year.  Due to the large quantity of Schedule B filings, this endpoint is not paginated by page number. Instead, you can request the next page of results by adding the values in the `last_indexes` object from `pagination` to the URL of your last request. For example, when sorting by `disbursement_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 965191,     per_page: 20,     count: 19303814,     last_indexes: {         last_index: \"230906248\",         last_disbursement_date: \"2014-07-04\"     } } ```  To fetch the next page of sorted results, append `last_index=230906248` and `last_disbursement_date=2014-07-04` to the URL.  We strongly advise paging through these results by using the sort indices (defaults to sort by disbursement date, e.g. `last_disbursement_date`), otherwise some resources may be unintentionally filtered out. This resource uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset.  Note: because the Schedule B data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_sub_id_get(api_key, sub_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sub_id: (required)
        :param list[str] recipient_committee_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param int last_index: Index of last result from previous page
        :param list[str] spender_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str min_image_number:
        :param list[str] recipient_city: City of recipient
        :param date last_disbursement_date: When sorting by `disbursement_date`, this is populated with the `disbursement_date` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] disbursement_description: Description of disbursement
        :param float last_disbursement_amount: When sorting by `disbursement_amount`, this is populated with the `disbursement_amount` of the last result.  However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param list[str] spender_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] disbursement_purpose_category: Disbursement purpose category
        :param list[str] recipient_state: State of recipient
        :param list[str] spender_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] recipient_name: Name of the entity receiving the disbursement
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str max_image_number:
        :return: ScheduleBPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_b_sub_id_get_with_http_info(api_key, sub_id, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_b_sub_id_get_with_http_info(api_key, sub_id, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_b_sub_id_get_with_http_info(self, api_key, sub_id, **kwargs):  # noqa: E501
        """schedules_schedule_b_sub_id_get  # noqa: E501

         Schedule B filings describe itemized disbursements. This data explains how committees and other filers spend their money. These figures are reported as part of forms F3, F3X and F3P.  The data is divided in two-year periods, called `two_year_transaction_period`, which is derived from the `report_year` submitted of the corresponding form. If no value is supplied, the results will default to the most recent two-year period that is named after the ending, even-numbered year.  Due to the large quantity of Schedule B filings, this endpoint is not paginated by page number. Instead, you can request the next page of results by adding the values in the `last_indexes` object from `pagination` to the URL of your last request. For example, when sorting by `disbursement_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 965191,     per_page: 20,     count: 19303814,     last_indexes: {         last_index: \"230906248\",         last_disbursement_date: \"2014-07-04\"     } } ```  To fetch the next page of sorted results, append `last_index=230906248` and `last_disbursement_date=2014-07-04` to the URL.  We strongly advise paging through these results by using the sort indices (defaults to sort by disbursement date, e.g. `last_disbursement_date`), otherwise some resources may be unintentionally filtered out. This resource uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset.  Note: because the Schedule B data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_b_sub_id_get_with_http_info(api_key, sub_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sub_id: (required)
        :param list[str] recipient_committee_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param int last_index: Index of last result from previous page
        :param list[str] spender_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str min_image_number:
        :param list[str] recipient_city: City of recipient
        :param date last_disbursement_date: When sorting by `disbursement_date`, this is populated with the `disbursement_date` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] disbursement_description: Description of disbursement
        :param float last_disbursement_amount: When sorting by `disbursement_amount`, this is populated with the `disbursement_amount` of the last result.  However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param list[str] spender_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] disbursement_purpose_category: Disbursement purpose category
        :param list[str] recipient_state: State of recipient
        :param list[str] spender_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] recipient_name: Name of the entity receiving the disbursement
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str max_image_number:
        :return: ScheduleBPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'sub_id', 'recipient_committee_id', 'last_index', 'spender_committee_type', 'sort', 'max_amount', 'min_image_number', 'recipient_city', 'last_disbursement_date', 'sort_hide_null', 'min_date', 'line_number', 'max_date', 'committee_id', 'two_year_transaction_period', 'per_page', 'min_amount', 'disbursement_description', 'last_disbursement_amount', 'spender_committee_org_type', 'image_number', 'disbursement_purpose_category', 'recipient_state', 'spender_committee_designation', 'recipient_name', 'sort_null_only', 'max_image_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_b_sub_id_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_b_sub_id_get`')  # noqa: E501
        # verify the required parameter 'sub_id' is set
        if ('sub_id' not in params or
                params['sub_id'] is None):
            raise ValueError('Missing the required parameter `sub_id` when calling `schedules_schedule_b_sub_id_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sub_id' in params:
            path_params['sub_id'] = params['sub_id']  # noqa: E501

        query_params = []
        if 'recipient_committee_id' in params:
            query_params.append(('recipient_committee_id', params['recipient_committee_id']))  # noqa: E501
            collection_formats['recipient_committee_id'] = 'multi'  # noqa: E501
        if 'last_index' in params:
            query_params.append(('last_index', params['last_index']))  # noqa: E501
        if 'spender_committee_type' in params:
            query_params.append(('spender_committee_type', params['spender_committee_type']))  # noqa: E501
            collection_formats['spender_committee_type'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'min_image_number' in params:
            query_params.append(('min_image_number', params['min_image_number']))  # noqa: E501
        if 'recipient_city' in params:
            query_params.append(('recipient_city', params['recipient_city']))  # noqa: E501
            collection_formats['recipient_city'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'last_disbursement_date' in params:
            query_params.append(('last_disbursement_date', params['last_disbursement_date']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'line_number' in params:
            query_params.append(('line_number', params['line_number']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'two_year_transaction_period' in params:
            query_params.append(('two_year_transaction_period', params['two_year_transaction_period']))  # noqa: E501
            collection_formats['two_year_transaction_period'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'disbursement_description' in params:
            query_params.append(('disbursement_description', params['disbursement_description']))  # noqa: E501
            collection_formats['disbursement_description'] = 'multi'  # noqa: E501
        if 'last_disbursement_amount' in params:
            query_params.append(('last_disbursement_amount', params['last_disbursement_amount']))  # noqa: E501
        if 'spender_committee_org_type' in params:
            query_params.append(('spender_committee_org_type', params['spender_committee_org_type']))  # noqa: E501
            collection_formats['spender_committee_org_type'] = 'multi'  # noqa: E501
        if 'image_number' in params:
            query_params.append(('image_number', params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'disbursement_purpose_category' in params:
            query_params.append(('disbursement_purpose_category', params['disbursement_purpose_category']))  # noqa: E501
            collection_formats['disbursement_purpose_category'] = 'multi'  # noqa: E501
        if 'recipient_state' in params:
            query_params.append(('recipient_state', params['recipient_state']))  # noqa: E501
            collection_formats['recipient_state'] = 'multi'  # noqa: E501
        if 'spender_committee_designation' in params:
            query_params.append(('spender_committee_designation', params['spender_committee_designation']))  # noqa: E501
            collection_formats['spender_committee_designation'] = 'multi'  # noqa: E501
        if 'recipient_name' in params:
            query_params.append(('recipient_name', params['recipient_name']))  # noqa: E501
            collection_formats['recipient_name'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_image_number' in params:
            query_params.append(('max_image_number', params['max_image_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_b/{sub_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleBPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
