# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class ElectioneeringApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def committee_committee_id_electioneering_by_candidate_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_electioneering_by_candidate_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id: (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_electioneering_by_candidate_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_electioneering_by_candidate_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_electioneering_by_candidate_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_electioneering_by_candidate_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id: (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'office', 'candidate_id', 'state', 'district', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_electioneering_by_candidate_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_electioneering_by_candidate_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_electioneering_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/electioneering/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_aggregates_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_aggregates_get  # noqa: E501

        Electioneering communications costs aggregates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_aggregates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.electioneering_aggregates_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.electioneering_aggregates_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def electioneering_aggregates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_aggregates_get  # noqa: E501

        Electioneering communications costs aggregates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_aggregates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'candidate_id', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_aggregates_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `electioneering_aggregates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/aggregates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_by_candidate_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_by_candidate_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.electioneering_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.electioneering_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def electioneering_by_candidate_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_by_candidate_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'per_page', 'cycle', 'sort', 'office', 'candidate_id', 'state', 'district', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_by_candidate_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `electioneering_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_get  # noqa: E501

         An electioneering communication is any broadcast, cable or satellite communication that fulfills each of the following conditions:  _The communication refers to a clearly identified federal candidate._  _The communication is publicly distributed by a television station, radio station, cable television system or satellite system for a fee._  _The communication is distributed within 60 days prior to a general election or 30 days prior to a primary election to federal office._   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int last_index: Index of last result from previous page
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str description:
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum disbursement date
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_date: Maximum disbursement date
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :return: ElectioneeringPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.electioneering_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.electioneering_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def electioneering_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_get  # noqa: E501

         An electioneering communication is any broadcast, cable or satellite communication that fulfills each of the following conditions:  _The communication refers to a clearly identified federal candidate._  _The communication is publicly distributed by a television station, radio station, cable television system or satellite system for a fee._  _The communication is distributed within 60 days prior to a general election or 30 days prior to a primary election to federal office._   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int last_index: Index of last result from previous page
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str description:
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum disbursement date
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_date: Maximum disbursement date
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :return: ElectioneeringPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'last_index', 'committee_id', 'per_page', 'min_amount', 'sort', 'max_amount', 'description', 'candidate_id', 'page', 'sort_nulls_last', 'sort_hide_null', 'min_date', 'sort_null_only', 'max_date', 'report_year']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `electioneering_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'last_index' in params:
            query_params.append(('last_index', params['last_index']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501
        if 'report_year' in params:
            query_params.append(('report_year', params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_totals_by_candidate_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_totals_by_candidate_get  # noqa: E501

         Total electioneering communications spent on candidates by cycle or candidate election year   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_totals_by_candidate_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ECTotalsByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.electioneering_totals_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.electioneering_totals_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def electioneering_totals_by_candidate_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_totals_by_candidate_get  # noqa: E501

         Total electioneering communications spent on candidates by cycle or candidate election year   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_totals_by_candidate_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ECTotalsByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'per_page', 'cycle', 'sort', 'candidate_id', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_totals_by_candidate_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `electioneering_totals_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/totals/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ECTotalsByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
