# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class FilingsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def candidate_candidate_id_filings_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_filings_get  # noqa: E501

         All official records and reports filed by or delivered to the FEC.  Note: because the filings data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_filings_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[str] request_type: Requests for additional information (RFAIs) sent to filers. The request type is based on the type of document filed:     - 1 Statement of Organization     - 2 Report of Receipts and Expenditures (Form 3 and 3X)     - 3 Second Notice - Reports     - 4 Request for Additional Information     - 5 Informational - Reports     - 6 Second Notice - Statement of Organization     - 7 Failure to File     - 8 From Public Disclosure     - 9 From Multi Candidate Status
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] file_number: Filing ID number
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param list[str] document_type:  The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice
        :param str committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param list[str] form_category:  The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] primary_general_indicator:  Primary, general or special election indicator.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: FilingsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.candidate_candidate_id_filings_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.candidate_candidate_id_filings_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501
            return data

    def candidate_candidate_id_filings_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_filings_get  # noqa: E501

         All official records and reports filed by or delivered to the FEC.  Note: because the filings data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_filings_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[str] request_type: Requests for additional information (RFAIs) sent to filers. The request type is based on the type of document filed:     - 1 Statement of Organization     - 2 Report of Receipts and Expenditures (Form 3 and 3X)     - 3 Second Notice - Reports     - 4 Request for Additional Information     - 5 Informational - Reports     - 6 Second Notice - Statement of Organization     - 7 Failure to File     - 8 From Public Disclosure     - 9 From Multi Candidate Status
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] file_number: Filing ID number
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param list[str] document_type:  The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice
        :param str committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param list[str] form_category:  The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] primary_general_indicator:  Primary, general or special election indicator.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: FilingsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'candidate_id', 'request_type', 'cycle', 'sort', 'file_number', 'beginning_image_number', 'form_type', 'document_type', 'committee_type', 'state', 'is_amended', 'sort_nulls_last', 'filer_type', 'form_category', 'sort_hide_null', 'amendment_indicator', 'report_type', 'report_year', 'min_receipt_date', 'most_recent', 'per_page', 'office', 'primary_general_indicator', 'district', 'page', 'max_receipt_date', 'party', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_filings_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_filings_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_filings_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in params:
            path_params['candidate_id'] = params['candidate_id']  # noqa: E501

        query_params = []
        if 'request_type' in params:
            query_params.append(('request_type', params['request_type']))  # noqa: E501
            collection_formats['request_type'] = 'multi'  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'file_number' in params:
            query_params.append(('file_number', params['file_number']))  # noqa: E501
            collection_formats['file_number'] = 'multi'  # noqa: E501
        if 'beginning_image_number' in params:
            query_params.append(('beginning_image_number', params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'form_type' in params:
            query_params.append(('form_type', params['form_type']))  # noqa: E501
            collection_formats['form_type'] = 'multi'  # noqa: E501
        if 'document_type' in params:
            query_params.append(('document_type', params['document_type']))  # noqa: E501
            collection_formats['document_type'] = 'multi'  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'is_amended' in params:
            query_params.append(('is_amended', params['is_amended']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'filer_type' in params:
            query_params.append(('filer_type', params['filer_type']))  # noqa: E501
        if 'form_category' in params:
            query_params.append(('form_category', params['form_category']))  # noqa: E501
            collection_formats['form_category'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'amendment_indicator' in params:
            query_params.append(('amendment_indicator', params['amendment_indicator']))  # noqa: E501
            collection_formats['amendment_indicator'] = 'multi'  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'report_year' in params:
            query_params.append(('report_year', params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501
        if 'min_receipt_date' in params:
            query_params.append(('min_receipt_date', params['min_receipt_date']))  # noqa: E501
        if 'most_recent' in params:
            query_params.append(('most_recent', params['most_recent']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'primary_general_indicator' in params:
            query_params.append(('primary_general_indicator', params['primary_general_indicator']))  # noqa: E501
            collection_formats['primary_general_indicator'] = 'multi'  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'max_receipt_date' in params:
            query_params.append(('max_receipt_date', params['max_receipt_date']))  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/filings/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilingsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_filings_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_filings_get  # noqa: E501

         All official records and reports filed by or delivered to the FEC.  Note: because the filings data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_filings_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param list[str] request_type: Requests for additional information (RFAIs) sent to filers. The request type is based on the type of document filed:     - 1 Statement of Organization     - 2 Report of Receipts and Expenditures (Form 3 and 3X)     - 3 Second Notice - Reports     - 4 Request for Additional Information     - 5 Informational - Reports     - 6 Second Notice - Statement of Organization     - 7 Failure to File     - 8 From Public Disclosure     - 9 From Multi Candidate Status
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] file_number: Filing ID number
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param list[str] document_type:  The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice
        :param str committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param list[str] form_category:  The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] primary_general_indicator:  Primary, general or special election indicator.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: FilingsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_filings_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_filings_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_filings_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_filings_get  # noqa: E501

         All official records and reports filed by or delivered to the FEC.  Note: because the filings data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_filings_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param list[str] request_type: Requests for additional information (RFAIs) sent to filers. The request type is based on the type of document filed:     - 1 Statement of Organization     - 2 Report of Receipts and Expenditures (Form 3 and 3X)     - 3 Second Notice - Reports     - 4 Request for Additional Information     - 5 Informational - Reports     - 6 Second Notice - Statement of Organization     - 7 Failure to File     - 8 From Public Disclosure     - 9 From Multi Candidate Status
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] file_number: Filing ID number
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param list[str] document_type:  The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice
        :param str committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param list[str] form_category:  The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] primary_general_indicator:  Primary, general or special election indicator.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: FilingsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'request_type', 'cycle', 'sort', 'file_number', 'beginning_image_number', 'form_type', 'document_type', 'committee_type', 'state', 'is_amended', 'sort_nulls_last', 'filer_type', 'form_category', 'sort_hide_null', 'amendment_indicator', 'report_type', 'report_year', 'min_receipt_date', 'most_recent', 'per_page', 'office', 'primary_general_indicator', 'district', 'page', 'max_receipt_date', 'party', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_filings_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_filings_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_filings_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'request_type' in params:
            query_params.append(('request_type', params['request_type']))  # noqa: E501
            collection_formats['request_type'] = 'multi'  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'file_number' in params:
            query_params.append(('file_number', params['file_number']))  # noqa: E501
            collection_formats['file_number'] = 'multi'  # noqa: E501
        if 'beginning_image_number' in params:
            query_params.append(('beginning_image_number', params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'form_type' in params:
            query_params.append(('form_type', params['form_type']))  # noqa: E501
            collection_formats['form_type'] = 'multi'  # noqa: E501
        if 'document_type' in params:
            query_params.append(('document_type', params['document_type']))  # noqa: E501
            collection_formats['document_type'] = 'multi'  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'is_amended' in params:
            query_params.append(('is_amended', params['is_amended']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'filer_type' in params:
            query_params.append(('filer_type', params['filer_type']))  # noqa: E501
        if 'form_category' in params:
            query_params.append(('form_category', params['form_category']))  # noqa: E501
            collection_formats['form_category'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'amendment_indicator' in params:
            query_params.append(('amendment_indicator', params['amendment_indicator']))  # noqa: E501
            collection_formats['amendment_indicator'] = 'multi'  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'report_year' in params:
            query_params.append(('report_year', params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501
        if 'min_receipt_date' in params:
            query_params.append(('min_receipt_date', params['min_receipt_date']))  # noqa: E501
        if 'most_recent' in params:
            query_params.append(('most_recent', params['most_recent']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'primary_general_indicator' in params:
            query_params.append(('primary_general_indicator', params['primary_general_indicator']))  # noqa: E501
            collection_formats['primary_general_indicator'] = 'multi'  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'max_receipt_date' in params:
            query_params.append(('max_receipt_date', params['max_receipt_date']))  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/filings/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilingsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filings_get(self, api_key, **kwargs):  # noqa: E501
        """filings_get  # noqa: E501

         All official records and reports filed by or delivered to the FEC.  Note: because the filings data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filings_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] request_type: Requests for additional information (RFAIs) sent to filers. The request type is based on the type of document filed:     - 1 Statement of Organization     - 2 Report of Receipts and Expenditures (Form 3 and 3X)     - 3 Second Notice - Reports     - 4 Request for Additional Information     - 5 Informational - Reports     - 6 Second Notice - Statement of Organization     - 7 Failure to File     - 8 From Public Disclosure     - 9 From Multi Candidate Status
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] file_number: Filing ID number
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param list[str] document_type:  The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice
        :param str committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param list[str] form_category:  The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] primary_general_indicator:  Primary, general or special election indicator.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: FilingsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filings_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.filings_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def filings_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """filings_get  # noqa: E501

         All official records and reports filed by or delivered to the FEC.  Note: because the filings data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filings_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] request_type: Requests for additional information (RFAIs) sent to filers. The request type is based on the type of document filed:     - 1 Statement of Organization     - 2 Report of Receipts and Expenditures (Form 3 and 3X)     - 3 Second Notice - Reports     - 4 Request for Additional Information     - 5 Informational - Reports     - 6 Second Notice - Statement of Organization     - 7 Failure to File     - 8 From Public Disclosure     - 9 From Multi Candidate Status
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] file_number: Filing ID number
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param list[str] document_type:  The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice
        :param str committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param list[str] form_category:  The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] office: Federal office candidate runs for: H, S or P
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] primary_general_indicator:  Primary, general or special election indicator.
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int page: For paginating through results, starting at page 1
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: FilingsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'request_type', 'cycle', 'sort', 'file_number', 'beginning_image_number', 'form_type', 'document_type', 'committee_type', 'state', 'is_amended', 'sort_nulls_last', 'filer_type', 'form_category', 'sort_hide_null', 'amendment_indicator', 'report_type', 'report_year', 'min_receipt_date', 'most_recent', 'committee_id', 'per_page', 'office', 'candidate_id', 'primary_general_indicator', 'district', 'page', 'max_receipt_date', 'party', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method filings_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `filings_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'request_type' in params:
            query_params.append(('request_type', params['request_type']))  # noqa: E501
            collection_formats['request_type'] = 'multi'  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'file_number' in params:
            query_params.append(('file_number', params['file_number']))  # noqa: E501
            collection_formats['file_number'] = 'multi'  # noqa: E501
        if 'beginning_image_number' in params:
            query_params.append(('beginning_image_number', params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'form_type' in params:
            query_params.append(('form_type', params['form_type']))  # noqa: E501
            collection_formats['form_type'] = 'multi'  # noqa: E501
        if 'document_type' in params:
            query_params.append(('document_type', params['document_type']))  # noqa: E501
            collection_formats['document_type'] = 'multi'  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'is_amended' in params:
            query_params.append(('is_amended', params['is_amended']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'filer_type' in params:
            query_params.append(('filer_type', params['filer_type']))  # noqa: E501
        if 'form_category' in params:
            query_params.append(('form_category', params['form_category']))  # noqa: E501
            collection_formats['form_category'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'amendment_indicator' in params:
            query_params.append(('amendment_indicator', params['amendment_indicator']))  # noqa: E501
            collection_formats['amendment_indicator'] = 'multi'  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'report_year' in params:
            query_params.append(('report_year', params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501
        if 'min_receipt_date' in params:
            query_params.append(('min_receipt_date', params['min_receipt_date']))  # noqa: E501
        if 'most_recent' in params:
            query_params.append(('most_recent', params['most_recent']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'primary_general_indicator' in params:
            query_params.append(('primary_general_indicator', params['primary_general_indicator']))  # noqa: E501
            collection_formats['primary_general_indicator'] = 'multi'  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'max_receipt_date' in params:
            query_params.append(('max_receipt_date', params['max_receipt_date']))  # noqa: E501
        if 'party' in params:
            query_params.append(('party', params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/filings/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilingsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def operations_log_get(self, api_key, **kwargs):  # noqa: E501
        """operations_log_get  # noqa: E501

         The Operations log contains details of each report loaded into the database. It is primarily used as status check to determine when all of the data processes, from initial entry through review are complete.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_log_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param date max_coverage_end_date:  Ending date of the reporting period before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param date min_coverage_end_date:  Ending date of the reporting period after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] candidate_committee_id:  A unique identifier of the registered filer.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] status_num:  Status of the transactional report.     -0- Transaction is entered            into the system.           But not verified.     -1- Transaction is verified.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_transaction_data_complete_date:  Select all filings processed completely after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_transaction_data_complete_date:  Select all filings processed completely before this date(MM/DD/YYYY or YYYY-MM-DD)
        :return: OperationsLogPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.operations_log_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.operations_log_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def operations_log_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """operations_log_get  # noqa: E501

         The Operations log contains details of each report loaded into the database. It is primarily used as status check to determine when all of the data processes, from initial entry through review are complete.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_log_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param date max_coverage_end_date:  Ending date of the reporting period before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] form_type: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param date min_coverage_end_date:  Ending date of the reporting period after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] candidate_committee_id:  A unique identifier of the registered filer.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param date min_receipt_date:  Selects all filings received after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] status_num:  Status of the transactional report.     -0- Transaction is entered            into the system.           But not verified.     -1- Transaction is verified.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_receipt_date:  Selects all filings received before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_transaction_data_complete_date:  Select all filings processed completely after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_transaction_data_complete_date:  Select all filings processed completely before this date(MM/DD/YYYY or YYYY-MM-DD)
        :return: OperationsLogPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'sort', 'beginning_image_number', 'max_coverage_end_date', 'form_type', 'min_coverage_end_date', 'sort_nulls_last', 'candidate_committee_id', 'sort_hide_null', 'amendment_indicator', 'report_type', 'report_year', 'min_receipt_date', 'per_page', 'status_num', 'page', 'sort_null_only', 'max_receipt_date', 'min_transaction_data_complete_date', 'max_transaction_data_complete_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method operations_log_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `operations_log_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'beginning_image_number' in params:
            query_params.append(('beginning_image_number', params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'max_coverage_end_date' in params:
            query_params.append(('max_coverage_end_date', params['max_coverage_end_date']))  # noqa: E501
        if 'form_type' in params:
            query_params.append(('form_type', params['form_type']))  # noqa: E501
            collection_formats['form_type'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'min_coverage_end_date' in params:
            query_params.append(('min_coverage_end_date', params['min_coverage_end_date']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'candidate_committee_id' in params:
            query_params.append(('candidate_committee_id', params['candidate_committee_id']))  # noqa: E501
            collection_formats['candidate_committee_id'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'amendment_indicator' in params:
            query_params.append(('amendment_indicator', params['amendment_indicator']))  # noqa: E501
            collection_formats['amendment_indicator'] = 'multi'  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'report_year' in params:
            query_params.append(('report_year', params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501
        if 'min_receipt_date' in params:
            query_params.append(('min_receipt_date', params['min_receipt_date']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'status_num' in params:
            query_params.append(('status_num', params['status_num']))  # noqa: E501
            collection_formats['status_num'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'max_receipt_date' in params:
            query_params.append(('max_receipt_date', params['max_receipt_date']))  # noqa: E501
        if 'min_transaction_data_complete_date' in params:
            query_params.append(('min_transaction_data_complete_date', params['min_transaction_data_complete_date']))  # noqa: E501
        if 'max_transaction_data_complete_date' in params:
            query_params.append(('max_transaction_data_complete_date', params['max_transaction_data_complete_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/operations-log/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationsLogPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
