# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class FinancialApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def committee_committee_id_reports_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_reports_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_reports_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :return: CommitteeReportsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_reports_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_reports_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_reports_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_reports_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_reports_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :return: CommitteeReportsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'min_cash_on_hand_end_period_amount', 'cycle', 'sort', 'year', 'beginning_image_number', 'max_debts_owed_expenditures', 'max_party_coordinated_expenditures', 'min_disbursements_amount', 'is_amended', 'sort_nulls_last', 'sort_hide_null', 'max_receipts_amount', 'report_type', 'min_debts_owed_amount', 'max_disbursements_amount', 'max_independent_expenditures', 'per_page', 'type', 'candidate_id', 'min_total_contributions', 'min_receipts_amount', 'page', 'min_party_coordinated_expenditures', 'max_cash_on_hand_end_period_amount', 'max_total_contributions', 'sort_null_only', 'min_independent_expenditures']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_reports_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_reports_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_reports_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'min_cash_on_hand_end_period_amount' in params:
            query_params.append(('min_cash_on_hand_end_period_amount', params['min_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'beginning_image_number' in params:
            query_params.append(('beginning_image_number', params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'max_debts_owed_expenditures' in params:
            query_params.append(('max_debts_owed_expenditures', params['max_debts_owed_expenditures']))  # noqa: E501
        if 'max_party_coordinated_expenditures' in params:
            query_params.append(('max_party_coordinated_expenditures', params['max_party_coordinated_expenditures']))  # noqa: E501
        if 'min_disbursements_amount' in params:
            query_params.append(('min_disbursements_amount', params['min_disbursements_amount']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'is_amended' in params:
            query_params.append(('is_amended', params['is_amended']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'max_receipts_amount' in params:
            query_params.append(('max_receipts_amount', params['max_receipts_amount']))  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'min_debts_owed_amount' in params:
            query_params.append(('min_debts_owed_amount', params['min_debts_owed_amount']))  # noqa: E501
        if 'max_disbursements_amount' in params:
            query_params.append(('max_disbursements_amount', params['max_disbursements_amount']))  # noqa: E501
        if 'max_independent_expenditures' in params:
            query_params.append(('max_independent_expenditures', params['max_independent_expenditures']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
        if 'min_total_contributions' in params:
            query_params.append(('min_total_contributions', params['min_total_contributions']))  # noqa: E501
        if 'min_receipts_amount' in params:
            query_params.append(('min_receipts_amount', params['min_receipts_amount']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'min_party_coordinated_expenditures' in params:
            query_params.append(('min_party_coordinated_expenditures', params['min_party_coordinated_expenditures']))  # noqa: E501
        if 'max_cash_on_hand_end_period_amount' in params:
            query_params.append(('max_cash_on_hand_end_period_amount', params['max_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'max_total_contributions' in params:
            query_params.append(('max_total_contributions', params['max_total_contributions']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'min_independent_expenditures' in params:
            query_params.append(('min_independent_expenditures', params['min_independent_expenditures']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/reports/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeReportsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_totals_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_totals_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_totals_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.committee_committee_id_totals_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
        else:
            (data) = self.committee_committee_id_totals_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501
            return data

    def committee_committee_id_totals_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_totals_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_totals_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'designation', 'cycle', 'sort', 'type', 'sort_nulls_last', 'page', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_totals_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `committee_committee_id_totals_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if ('committee_id' not in params or
                params['committee_id'] is None):
            raise ValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_totals_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in params:
            path_params['committee_id'] = params['committee_id']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'designation' in params:
            query_params.append(('designation', params['designation']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/totals/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elections_get(self, cycle, office, api_key, **kwargs):  # noqa: E501
        """elections_get  # noqa: E501

         Look at the top-level financial information for all candidates running for the same office.  Choose a 2-year cycle, and `house`, `senate` or `presidential`.  If you are looking for a Senate seat, you will need to select the state using a two-letter abbreviation.  House races require state and a two-digit district number.  Since this endpoint reflects financial information, it will only have candidates once they file financial reporting forms. Query the `/candidates` endpoint to see an up to date list of all the candidates that filed to run for a particular seat.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_get(cycle, office, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str state: US state or territory where a candidate runs for office
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.elections_get_with_http_info(cycle, office, api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.elections_get_with_http_info(cycle, office, api_key, **kwargs)  # noqa: E501
            return data

    def elections_get_with_http_info(self, cycle, office, api_key, **kwargs):  # noqa: E501
        """elections_get  # noqa: E501

         Look at the top-level financial information for all candidates running for the same office.  Choose a 2-year cycle, and `house`, `senate` or `presidential`.  If you are looking for a Senate seat, you will need to select the state using a two-letter abbreviation.  House races require state and a two-digit district number.  Since this endpoint reflects financial information, it will only have candidates once they file financial reporting forms. Query the `/candidates` endpoint to see an up to date list of all the candidates that filed to run for a particular seat.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_get_with_http_info(cycle, office, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str state: US state or territory where a candidate runs for office
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cycle', 'office', 'api_key', 'per_page', 'sort', 'state', 'district', 'election_full', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method elections_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `elections_get`')  # noqa: E501
        # verify the required parameter 'office' is set
        if ('office' not in params or
                params['office'] is None):
            raise ValueError('Missing the required parameter `office` when calling `elections_get`')  # noqa: E501
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `elections_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/elections/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectionPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elections_search_get(self, api_key, **kwargs):  # noqa: E501
        """elections_search_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_search_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] office:
        :param list[str] state: US state or territory where a candidate runs for office
        :param list[int] zip: Zip code
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectionsListPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.elections_search_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.elections_search_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def elections_search_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """elections_search_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_search_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] office:
        :param list[str] state: US state or territory where a candidate runs for office
        :param list[int] zip: Zip code
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ElectionsListPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'per_page', 'sort', 'office', 'state', 'zip', 'district', 'sort_nulls_last', 'page', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method elections_search_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `elections_search_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'zip' in params:
            query_params.append(('zip', params['zip']))  # noqa: E501
            collection_formats['zip'] = 'multi'  # noqa: E501
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/elections/search/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectionsListPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elections_summary_get(self, api_key, cycle, office, **kwargs):  # noqa: E501
        """elections_summary_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_summary_get(api_key, cycle, office, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str state: US state or territory where a candidate runs for office
        :return: ElectionSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.elections_summary_get_with_http_info(api_key, cycle, office, **kwargs)  # noqa: E501
        else:
            (data) = self.elections_summary_get_with_http_info(api_key, cycle, office, **kwargs)  # noqa: E501
            return data

    def elections_summary_get_with_http_info(self, api_key, cycle, office, **kwargs):  # noqa: E501
        """elections_summary_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_summary_get_with_http_info(api_key, cycle, office, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str state: US state or territory where a candidate runs for office
        :return: ElectionSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'office', 'district', 'election_full', 'state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method elections_summary_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `elections_summary_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `elections_summary_get`')  # noqa: E501
        # verify the required parameter 'office' is set
        if ('office' not in params or
                params['office'] is None):
            raise ValueError('Missing the required parameter `office` when calling `elections_summary_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'district' in params:
            query_params.append(('district', params['district']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
        if 'office' in params:
            query_params.append(('office', params['office']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/elections/summary/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectionSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reports_committee_type_get(self, api_key, committee_type, **kwargs):  # noqa: E501
        """reports_committee_type_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reports_committee_type_get(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param date min_receipt_date:  Selects all items received by FEC after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param date max_receipt_date:  Selects all items received by FEC before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :return: CommitteeReportsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reports_committee_type_get_with_http_info(api_key, committee_type, **kwargs)  # noqa: E501
        else:
            (data) = self.reports_committee_type_get_with_http_info(api_key, committee_type, **kwargs)  # noqa: E501
            return data

    def reports_committee_type_get_with_http_info(self, api_key, committee_type, **kwargs):  # noqa: E501
        """reports_committee_type_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reports_committee_type_get_with_http_info(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param date min_receipt_date:  Selects all items received by FEC after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param date max_receipt_date:  Selects all items received by FEC before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :return: CommitteeReportsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_type', 'sort', 'beginning_image_number', 'max_debts_owed_expenditures', 'max_party_coordinated_expenditures', 'min_disbursements_amount', 'is_amended', 'max_receipts_amount', 'min_debts_owed_amount', 'min_receipt_date', 'max_disbursements_amount', 'max_independent_expenditures', 'committee_id', 'type', 'candidate_id', 'min_total_contributions', 'page', 'min_party_coordinated_expenditures', 'sort_null_only', 'min_independent_expenditures', 'min_cash_on_hand_end_period_amount', 'cycle', 'year', 'sort_nulls_last', 'filer_type', 'sort_hide_null', 'amendment_indicator', 'report_type', 'most_recent', 'per_page', 'min_receipts_amount', 'max_cash_on_hand_end_period_amount', 'max_receipt_date', 'max_total_contributions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method reports_committee_type_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `reports_committee_type_get`')  # noqa: E501
        # verify the required parameter 'committee_type' is set
        if ('committee_type' not in params or
                params['committee_type'] is None):
            raise ValueError('Missing the required parameter `committee_type` when calling `reports_committee_type_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_type' in params:
            path_params['committee_type'] = params['committee_type']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'beginning_image_number' in params:
            query_params.append(('beginning_image_number', params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'max_debts_owed_expenditures' in params:
            query_params.append(('max_debts_owed_expenditures', params['max_debts_owed_expenditures']))  # noqa: E501
        if 'max_party_coordinated_expenditures' in params:
            query_params.append(('max_party_coordinated_expenditures', params['max_party_coordinated_expenditures']))  # noqa: E501
        if 'min_disbursements_amount' in params:
            query_params.append(('min_disbursements_amount', params['min_disbursements_amount']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'is_amended' in params:
            query_params.append(('is_amended', params['is_amended']))  # noqa: E501
        if 'max_receipts_amount' in params:
            query_params.append(('max_receipts_amount', params['max_receipts_amount']))  # noqa: E501
        if 'min_debts_owed_amount' in params:
            query_params.append(('min_debts_owed_amount', params['min_debts_owed_amount']))  # noqa: E501
        if 'min_receipt_date' in params:
            query_params.append(('min_receipt_date', params['min_receipt_date']))  # noqa: E501
        if 'max_disbursements_amount' in params:
            query_params.append(('max_disbursements_amount', params['max_disbursements_amount']))  # noqa: E501
        if 'max_independent_expenditures' in params:
            query_params.append(('max_independent_expenditures', params['max_independent_expenditures']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
        if 'min_total_contributions' in params:
            query_params.append(('min_total_contributions', params['min_total_contributions']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'min_party_coordinated_expenditures' in params:
            query_params.append(('min_party_coordinated_expenditures', params['min_party_coordinated_expenditures']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'min_independent_expenditures' in params:
            query_params.append(('min_independent_expenditures', params['min_independent_expenditures']))  # noqa: E501
        if 'min_cash_on_hand_end_period_amount' in params:
            query_params.append(('min_cash_on_hand_end_period_amount', params['min_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'filer_type' in params:
            query_params.append(('filer_type', params['filer_type']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'amendment_indicator' in params:
            query_params.append(('amendment_indicator', params['amendment_indicator']))  # noqa: E501
            collection_formats['amendment_indicator'] = 'multi'  # noqa: E501
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'most_recent' in params:
            query_params.append(('most_recent', params['most_recent']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_receipts_amount' in params:
            query_params.append(('min_receipts_amount', params['min_receipts_amount']))  # noqa: E501
        if 'max_cash_on_hand_end_period_amount' in params:
            query_params.append(('max_cash_on_hand_end_period_amount', params['max_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'max_receipt_date' in params:
            query_params.append(('max_receipt_date', params['max_receipt_date']))  # noqa: E501
        if 'max_total_contributions' in params:
            query_params.append(('max_total_contributions', params['max_total_contributions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{committee_type}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeReportsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def totals_by_entity_get(self, api_key, cycle, **kwargs):  # noqa: E501
        """totals_by_entity_get  # noqa: E501

         Provides cumulative receipt totals by entity type, over a two year cycle. Totals are adjusted to avoid double counting.  This is [the sql](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V41__large_aggregates.sql) that creates these calculations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_by_entity_get(api_key, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: EntityReceiptDisbursementTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.totals_by_entity_get_with_http_info(api_key, cycle, **kwargs)  # noqa: E501
        else:
            (data) = self.totals_by_entity_get_with_http_info(api_key, cycle, **kwargs)  # noqa: E501
            return data

    def totals_by_entity_get_with_http_info(self, api_key, cycle, **kwargs):  # noqa: E501
        """totals_by_entity_get  # noqa: E501

         Provides cumulative receipt totals by entity type, over a two year cycle. Totals are adjusted to avoid double counting.  This is [the sql](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V41__large_aggregates.sql) that creates these calculations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_by_entity_get_with_http_info(api_key, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param int page: For paginating through results, starting at page 1
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: EntityReceiptDisbursementTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'page', 'per_page', 'sort', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method totals_by_entity_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `totals_by_entity_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `totals_by_entity_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/totals/by_entity/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityReceiptDisbursementTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def totals_committee_type_get(self, api_key, committee_type, **kwargs):  # noqa: E501
        """totals_committee_type_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_committee_type_get(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str committee_designation_full: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param str committee_type_full: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.totals_committee_type_get_with_http_info(api_key, committee_type, **kwargs)  # noqa: E501
        else:
            (data) = self.totals_committee_type_get_with_http_info(api_key, committee_type, **kwargs)  # noqa: E501
            return data

    def totals_committee_type_get_with_http_info(self, api_key, committee_type, **kwargs):  # noqa: E501
        """totals_committee_type_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_committee_type_get_with_http_info(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str committee_designation_full: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param str committee_type_full: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_type', 'committee_id', 'cycle', 'per_page', 'sort', 'sort_nulls_last', 'committee_designation_full', 'page', 'sort_hide_null', 'committee_type_full', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method totals_committee_type_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `totals_committee_type_get`')  # noqa: E501
        # verify the required parameter 'committee_type' is set
        if ('committee_type' not in params or
                params['committee_type'] is None):
            raise ValueError('Missing the required parameter `committee_type` when calling `totals_committee_type_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_type' in params:
            path_params['committee_type'] = params['committee_type']  # noqa: E501

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'committee_designation_full' in params:
            query_params.append(('committee_designation_full', params['committee_designation_full']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'committee_type_full' in params:
            query_params.append(('committee_type_full', params['committee_type_full']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/totals/{committee_type}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
