# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class LegalApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def legal_search_get(self, api_key, **kwargs):  # noqa: E501
        """legal_search_get  # noqa: E501

         Search legal documents by type, or across all document types using keywords, parameter values and ranges.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.legal_search_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] case_dispositions: Filter cases by dispositions
        :param list[int] ao_requestor_type: Code of the advisory opinion requestor type.
        :param str af_report_year: Admin fine report year
        :param list[str] ao_name: Force advisory opinion name
        :param date case_min_open_date: Filter cases by earliest date opened
        :param list[str] ao_entity_name: Search by name of commenter or representative
        :param str q: Text to search legal documents for.
        :param str case_respondents: Filter cases by respondents
        :param list[str] ao_statutory_citation: Search for statutory citations
        :param date ao_max_issue_date: Latest issue date of advisory opinion
        :param date af_max_rtb_date: Filter cases by latest Reason to Believe date
        :param int case_election_cycles: Filter cases by election cycles
        :param list[str] case_document_category: Filter cases by category of associated documents
        :param str type: Document type to refine search by
        :param date case_max_open_date: Filter cases by latest date opened
        :param list[str] af_name: Admin fine committee name
        :param date ao_min_issue_date: Earliest issue date of advisory opinion
        :param int af_fd_fine_amount: Filter cases by Final Determination fine amount
        :param int af_rtb_fine_amount: Filter cases by Reason to Believe fine amount
        :param date af_max_fd_date: Filter cases by latest Final Determination date
        :param list[str] ao_category: Category of the document
        :param list[str] ao_regulatory_citation: Search for regulatory citations
        :param date ao_min_request_date: Earliest request date of advisory opinion
        :param date af_min_rtb_date: Filter cases by earliest Reason to Believe date
        :param date case_max_close_date: Filter cases by latest date closed
        :param bool ao_citation_require_all: Require all citations to be in document (default behavior is any)
        :param date case_min_close_date: Filter cases by earliest date closed
        :param date ao_max_request_date: Latest request date of advisory opinion
        :param int from_hit: Get results starting from this index.
        :param str af_committee_id: Admin fine committee ID
        :param str ao_requestor: The requestor of the advisory opinion
        :param str ao_status: Status of AO (pending, withdrawn, or final)
        :param bool ao_is_pending: AO is pending
        :param list[str] case_no: Enforcement matter case number
        :param date af_min_fd_date: Filter cases by earliest Final Determination date
        :param list[str] ao_no: Force advisory opinion number
        :param int hits_returned: Number of results to return (max 10).
        :return: InlineResponseDefault1
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.legal_search_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.legal_search_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def legal_search_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """legal_search_get  # noqa: E501

         Search legal documents by type, or across all document types using keywords, parameter values and ranges.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.legal_search_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] case_dispositions: Filter cases by dispositions
        :param list[int] ao_requestor_type: Code of the advisory opinion requestor type.
        :param str af_report_year: Admin fine report year
        :param list[str] ao_name: Force advisory opinion name
        :param date case_min_open_date: Filter cases by earliest date opened
        :param list[str] ao_entity_name: Search by name of commenter or representative
        :param str q: Text to search legal documents for.
        :param str case_respondents: Filter cases by respondents
        :param list[str] ao_statutory_citation: Search for statutory citations
        :param date ao_max_issue_date: Latest issue date of advisory opinion
        :param date af_max_rtb_date: Filter cases by latest Reason to Believe date
        :param int case_election_cycles: Filter cases by election cycles
        :param list[str] case_document_category: Filter cases by category of associated documents
        :param str type: Document type to refine search by
        :param date case_max_open_date: Filter cases by latest date opened
        :param list[str] af_name: Admin fine committee name
        :param date ao_min_issue_date: Earliest issue date of advisory opinion
        :param int af_fd_fine_amount: Filter cases by Final Determination fine amount
        :param int af_rtb_fine_amount: Filter cases by Reason to Believe fine amount
        :param date af_max_fd_date: Filter cases by latest Final Determination date
        :param list[str] ao_category: Category of the document
        :param list[str] ao_regulatory_citation: Search for regulatory citations
        :param date ao_min_request_date: Earliest request date of advisory opinion
        :param date af_min_rtb_date: Filter cases by earliest Reason to Believe date
        :param date case_max_close_date: Filter cases by latest date closed
        :param bool ao_citation_require_all: Require all citations to be in document (default behavior is any)
        :param date case_min_close_date: Filter cases by earliest date closed
        :param date ao_max_request_date: Latest request date of advisory opinion
        :param int from_hit: Get results starting from this index.
        :param str af_committee_id: Admin fine committee ID
        :param str ao_requestor: The requestor of the advisory opinion
        :param str ao_status: Status of AO (pending, withdrawn, or final)
        :param bool ao_is_pending: AO is pending
        :param list[str] case_no: Enforcement matter case number
        :param date af_min_fd_date: Filter cases by earliest Final Determination date
        :param list[str] ao_no: Force advisory opinion number
        :param int hits_returned: Number of results to return (max 10).
        :return: InlineResponseDefault1
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'case_dispositions', 'ao_requestor_type', 'af_report_year', 'ao_name', 'case_min_open_date', 'ao_entity_name', 'q', 'case_respondents', 'ao_statutory_citation', 'ao_max_issue_date', 'af_max_rtb_date', 'case_election_cycles', 'case_document_category', 'type', 'case_max_open_date', 'af_name', 'ao_min_issue_date', 'af_fd_fine_amount', 'af_rtb_fine_amount', 'af_max_fd_date', 'ao_category', 'ao_regulatory_citation', 'ao_min_request_date', 'af_min_rtb_date', 'case_max_close_date', 'ao_citation_require_all', 'case_min_close_date', 'ao_max_request_date', 'from_hit', 'af_committee_id', 'ao_requestor', 'ao_status', 'ao_is_pending', 'case_no', 'af_min_fd_date', 'ao_no', 'hits_returned']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method legal_search_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `legal_search_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'case_dispositions' in params:
            query_params.append(('case_dispositions', params['case_dispositions']))  # noqa: E501
            collection_formats['case_dispositions'] = 'multi'  # noqa: E501
        if 'ao_requestor_type' in params:
            query_params.append(('ao_requestor_type', params['ao_requestor_type']))  # noqa: E501
            collection_formats['ao_requestor_type'] = 'multi'  # noqa: E501
        if 'af_report_year' in params:
            query_params.append(('af_report_year', params['af_report_year']))  # noqa: E501
        if 'ao_name' in params:
            query_params.append(('ao_name', params['ao_name']))  # noqa: E501
            collection_formats['ao_name'] = 'multi'  # noqa: E501
        if 'case_min_open_date' in params:
            query_params.append(('case_min_open_date', params['case_min_open_date']))  # noqa: E501
        if 'ao_entity_name' in params:
            query_params.append(('ao_entity_name', params['ao_entity_name']))  # noqa: E501
            collection_formats['ao_entity_name'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'case_respondents' in params:
            query_params.append(('case_respondents', params['case_respondents']))  # noqa: E501
        if 'ao_statutory_citation' in params:
            query_params.append(('ao_statutory_citation', params['ao_statutory_citation']))  # noqa: E501
            collection_formats['ao_statutory_citation'] = 'multi'  # noqa: E501
        if 'ao_max_issue_date' in params:
            query_params.append(('ao_max_issue_date', params['ao_max_issue_date']))  # noqa: E501
        if 'af_max_rtb_date' in params:
            query_params.append(('af_max_rtb_date', params['af_max_rtb_date']))  # noqa: E501
        if 'case_election_cycles' in params:
            query_params.append(('case_election_cycles', params['case_election_cycles']))  # noqa: E501
        if 'case_document_category' in params:
            query_params.append(('case_document_category', params['case_document_category']))  # noqa: E501
            collection_formats['case_document_category'] = 'multi'  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'case_max_open_date' in params:
            query_params.append(('case_max_open_date', params['case_max_open_date']))  # noqa: E501
        if 'af_name' in params:
            query_params.append(('af_name', params['af_name']))  # noqa: E501
            collection_formats['af_name'] = 'multi'  # noqa: E501
        if 'ao_min_issue_date' in params:
            query_params.append(('ao_min_issue_date', params['ao_min_issue_date']))  # noqa: E501
        if 'af_fd_fine_amount' in params:
            query_params.append(('af_fd_fine_amount', params['af_fd_fine_amount']))  # noqa: E501
        if 'af_rtb_fine_amount' in params:
            query_params.append(('af_rtb_fine_amount', params['af_rtb_fine_amount']))  # noqa: E501
        if 'af_max_fd_date' in params:
            query_params.append(('af_max_fd_date', params['af_max_fd_date']))  # noqa: E501
        if 'ao_category' in params:
            query_params.append(('ao_category', params['ao_category']))  # noqa: E501
            collection_formats['ao_category'] = 'multi'  # noqa: E501
        if 'ao_regulatory_citation' in params:
            query_params.append(('ao_regulatory_citation', params['ao_regulatory_citation']))  # noqa: E501
            collection_formats['ao_regulatory_citation'] = 'multi'  # noqa: E501
        if 'ao_min_request_date' in params:
            query_params.append(('ao_min_request_date', params['ao_min_request_date']))  # noqa: E501
        if 'af_min_rtb_date' in params:
            query_params.append(('af_min_rtb_date', params['af_min_rtb_date']))  # noqa: E501
        if 'case_max_close_date' in params:
            query_params.append(('case_max_close_date', params['case_max_close_date']))  # noqa: E501
        if 'ao_citation_require_all' in params:
            query_params.append(('ao_citation_require_all', params['ao_citation_require_all']))  # noqa: E501
        if 'case_min_close_date' in params:
            query_params.append(('case_min_close_date', params['case_min_close_date']))  # noqa: E501
        if 'ao_max_request_date' in params:
            query_params.append(('ao_max_request_date', params['ao_max_request_date']))  # noqa: E501
        if 'from_hit' in params:
            query_params.append(('from_hit', params['from_hit']))  # noqa: E501
        if 'af_committee_id' in params:
            query_params.append(('af_committee_id', params['af_committee_id']))  # noqa: E501
        if 'ao_requestor' in params:
            query_params.append(('ao_requestor', params['ao_requestor']))  # noqa: E501
        if 'ao_status' in params:
            query_params.append(('ao_status', params['ao_status']))  # noqa: E501
        if 'ao_is_pending' in params:
            query_params.append(('ao_is_pending', params['ao_is_pending']))  # noqa: E501
        if 'case_no' in params:
            query_params.append(('case_no', params['case_no']))  # noqa: E501
            collection_formats['case_no'] = 'multi'  # noqa: E501
        if 'af_min_fd_date' in params:
            query_params.append(('af_min_fd_date', params['af_min_fd_date']))  # noqa: E501
        if 'ao_no' in params:
            query_params.append(('ao_no', params['ao_no']))  # noqa: E501
            collection_formats['ao_no'] = 'multi'  # noqa: E501
        if 'hits_returned' in params:
            query_params.append(('hits_returned', params['hits_returned']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/legal/search/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponseDefault1',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
