# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient


class ReceiptsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def schedules_schedule_a_by_employer_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_employer_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s employer name. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_employer_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] employer: Employer of contributor as reported on the committee's filing
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByEmployerPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_employer_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_employer_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_employer_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_employer_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s employer name. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_employer_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] employer: Employer of contributor as reported on the committee's filing
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByEmployerPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'employer', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_employer_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_employer_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'employer' in params:
            query_params.append(('employer', params['employer']))  # noqa: E501
            collection_formats['employer'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_employer/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByEmployerPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_occupation_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_occupation_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s occupation. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_occupation_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] occupation: Occupation of contributor as reported on the committee's filing
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByOccupationPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_occupation_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_occupation_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_occupation_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_occupation_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s occupation. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_occupation_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] occupation: Occupation of contributor as reported on the committee's filing
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByOccupationPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'occupation', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_occupation_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_occupation_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'occupation' in params:
            query_params.append(('occupation', params['occupation']))  # noqa: E501
            collection_formats['occupation'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_occupation/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByOccupationPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_size_by_candidate_get(self, cycle, candidate_id, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_size_by_candidate_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by size of contribution and candidate. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_size_by_candidate_get(cycle, candidate_id, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleABySizeCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_size_by_candidate_get_with_http_info(cycle, candidate_id, api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_size_by_candidate_get_with_http_info(cycle, candidate_id, api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_size_by_candidate_get_with_http_info(self, cycle, candidate_id, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_size_by_candidate_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by size of contribution and candidate. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_size_by_candidate_get_with_http_info(cycle, candidate_id, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleABySizeCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cycle', 'candidate_id', 'api_key', 'per_page', 'sort', 'election_full', 'sort_nulls_last', 'page', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_size_by_candidate_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `schedules_schedule_a_by_size_by_candidate_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `schedules_schedule_a_by_size_by_candidate_get`')  # noqa: E501
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_size_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_size/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleABySizeCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_size_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_size_get  # noqa: E501

         This endpoint provides individual contributions received by a committee, aggregated by size:  ```  - $200 and under  - $200.01 - $499.99  - $500 - $999.99  - $1000 - $1999.99  - $2000 + ```  The $200.00 and under category includes contributions of $200 or less combined with unitemized individual contributions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_size_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[int] size:  The total all contributions in the following ranges: ```   -0    $200 and under   -200  $200.01 - $499.99   -500  $500 - $999.99   -1000 $1000 - $1999.99   -2000 $2000 + ``` Unitemized contributions are included in the `0` category.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleABySizePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_size_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_size_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_size_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_size_get  # noqa: E501

         This endpoint provides individual contributions received by a committee, aggregated by size:  ```  - $200 and under  - $200.01 - $499.99  - $500 - $999.99  - $1000 - $1999.99  - $2000 + ```  The $200.00 and under category includes contributions of $200 or less combined with unitemized individual contributions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_size_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[int] size:  The total all contributions in the following ranges: ```   -0    $200 and under   -200  $200.01 - $499.99   -500  $500 - $999.99   -1000 $1000 - $1999.99   -2000 $2000 + ``` Unitemized contributions are included in the `0` category.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleABySizePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'size', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_size_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_size_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
            collection_formats['size'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_size/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleABySizePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_state_by_candidate_get(self, cycle, candidate_id, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_by_candidate_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by contributor’s state and candidate. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_by_candidate_get(cycle, candidate_id, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStateCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_state_by_candidate_get_with_http_info(cycle, candidate_id, api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_state_by_candidate_get_with_http_info(cycle, candidate_id, api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_state_by_candidate_get_with_http_info(self, cycle, candidate_id, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_by_candidate_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by contributor’s state and candidate. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_by_candidate_get_with_http_info(cycle, candidate_id, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStateCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cycle', 'candidate_id', 'api_key', 'per_page', 'sort', 'election_full', 'sort_nulls_last', 'page', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_state_by_candidate_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `schedules_schedule_a_by_state_by_candidate_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `schedules_schedule_a_by_state_by_candidate_get`')  # noqa: E501
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_state_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_state/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByStateCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_state_by_candidate_totals_get(self, cycle, candidate_id, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_by_candidate_totals_get  # noqa: E501

         Itemized individual contributions aggregated by contributor’s state, candidate, committee type and cycle. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_by_candidate_totals_get(cycle, candidate_id, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStateCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_state_by_candidate_totals_get_with_http_info(cycle, candidate_id, api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_state_by_candidate_totals_get_with_http_info(cycle, candidate_id, api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_state_by_candidate_totals_get_with_http_info(self, cycle, candidate_id, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_by_candidate_totals_get  # noqa: E501

         Itemized individual contributions aggregated by contributor’s state, candidate, committee type and cycle. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_by_candidate_totals_get_with_http_info(cycle, candidate_id, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStateCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cycle', 'candidate_id', 'api_key', 'per_page', 'sort', 'election_full', 'sort_nulls_last', 'page', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_state_by_candidate_totals_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cycle' is set
        if ('cycle' not in params or
                params['cycle'] is None):
            raise ValueError('Missing the required parameter `cycle` when calling `schedules_schedule_a_by_state_by_candidate_totals_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if ('candidate_id' not in params or
                params['candidate_id'] is None):
            raise ValueError('Missing the required parameter `candidate_id` when calling `schedules_schedule_a_by_state_by_candidate_totals_get`')  # noqa: E501
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_state_by_candidate_totals_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'candidate_id' in params:
            query_params.append(('candidate_id', params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'election_full' in params:
            query_params.append(('election_full', params['election_full']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_state/by_candidate/totals/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByStateCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_state_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s state. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: State of contributor
        :param int page: For paginating through results, starting at page 1
        :param bool hide_null: Exclude values with missing state
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_state_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_state_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_state_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s state. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: State of contributor
        :param int page: For paginating through results, starting at page 1
        :param bool hide_null: Exclude values with missing state
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'state', 'page', 'hide_null', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_state_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_state_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'hide_null' in params:
            query_params.append(('hide_null', params['hide_null']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_state/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByStatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_state_totals_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_totals_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by contributor’s state, committee type and cycle. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_totals_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: US state or territory
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account         - all All Committee Types         - all_candidates All Candidate Committee Types (H, S, P)         - all_pacs All PAC Committee Types (N, O, Q, V, W)
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStateRecipientTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_state_totals_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_state_totals_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_state_totals_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_state_totals_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by contributor’s state, committee type and cycle. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_state_totals_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: US state or territory
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account         - all All Committee Types         - all_candidates All Candidate Committee Types (H, S, P)         - all_pacs All PAC Committee Types (N, O, Q, V, W)
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByStateRecipientTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'cycle', 'per_page', 'sort', 'state', 'committee_type', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_state_totals_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_state_totals_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'committee_type' in params:
            query_params.append(('committee_type', params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_state/totals/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByStateRecipientTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_by_zip_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_zip_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s ZIP code. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) section of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_zip_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: State of contributor
        :param list[str] zip: Zip code of contributor
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByZipPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_by_zip_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_by_zip_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_by_zip_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_by_zip_get  # noqa: E501

         This endpoint provides itemized individual contributions received by a committee, aggregated by the contributor’s ZIP code. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/ about-receipts-data/) section of our “about the data” page. Unitemized individual contributions are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_by_zip_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: State of contributor
        :param list[str] zip: Zip code of contributor
        :param int page: For paginating through results, starting at page 1
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :return: ScheduleAByZipPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'committee_id', 'per_page', 'cycle', 'sort', 'state', 'zip', 'page', 'sort_nulls_last', 'sort_hide_null', 'sort_null_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_by_zip_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_by_zip_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'cycle' in params:
            query_params.append(('cycle', params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'zip' in params:
            query_params.append(('zip', params['zip']))  # noqa: E501
            collection_formats['zip'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/by_zip/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAByZipPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_efile_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_efile_get  # noqa: E501

         Efiling endpoints provide real-time campaign finance data received from electronic filers. Efiling endpoints only contain the most recent four months of data and don't contain the processed and coded data that you can find on other endpoints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_efile_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str min_image_number:
        :param list[str] contributor_city: City of contributor
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] contributor_name: Name of contributor
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param str max_image_number:
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] contributor_occupation: Occupation of contributor, filers need to make an effort to gather this information
        :param list[str] contributor_state: State of contributor
        :param list[str] contributor_employer: Employer of contributor, filers need to make an effort to gather this information
        :return: ScheduleAEfilePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_efile_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_efile_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_efile_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_efile_get  # noqa: E501

         Efiling endpoints provide real-time campaign finance data received from electronic filers. Efiling endpoints only contain the most recent four months of data and don't contain the processed and coded data that you can find on other endpoints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_efile_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str max_amount: Filter for all amounts less than a value.
        :param str min_image_number:
        :param list[str] contributor_city: City of contributor
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] contributor_name: Name of contributor
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param str max_image_number:
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] contributor_occupation: Occupation of contributor, filers need to make an effort to gather this information
        :param list[str] contributor_state: State of contributor
        :param list[str] contributor_employer: Employer of contributor, filers need to make an effort to gather this information
        :return: ScheduleAEfilePage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'sort', 'max_amount', 'min_image_number', 'contributor_city', 'sort_nulls_last', 'sort_hide_null', 'min_date', 'line_number', 'max_date', 'contributor_name', 'committee_id', 'per_page', 'min_amount', 'max_image_number', 'image_number', 'page', 'sort_null_only', 'contributor_occupation', 'contributor_state', 'contributor_employer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_efile_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_efile_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'min_image_number' in params:
            query_params.append(('min_image_number', params['min_image_number']))  # noqa: E501
        if 'contributor_city' in params:
            query_params.append(('contributor_city', params['contributor_city']))  # noqa: E501
            collection_formats['contributor_city'] = 'multi'  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'sort_nulls_last' in params:
            query_params.append(('sort_nulls_last', params['sort_nulls_last']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'line_number' in params:
            query_params.append(('line_number', params['line_number']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501
        if 'contributor_name' in params:
            query_params.append(('contributor_name', params['contributor_name']))  # noqa: E501
            collection_formats['contributor_name'] = 'multi'  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'max_image_number' in params:
            query_params.append(('max_image_number', params['max_image_number']))  # noqa: E501
        if 'image_number' in params:
            query_params.append(('image_number', params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'contributor_occupation' in params:
            query_params.append(('contributor_occupation', params['contributor_occupation']))  # noqa: E501
            collection_formats['contributor_occupation'] = 'multi'  # noqa: E501
        if 'contributor_state' in params:
            query_params.append(('contributor_state', params['contributor_state']))  # noqa: E501
            collection_formats['contributor_state'] = 'multi'  # noqa: E501
        if 'contributor_employer' in params:
            query_params.append(('contributor_employer', params['contributor_employer']))  # noqa: E501
            collection_formats['contributor_employer'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/efile/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAEfilePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_get  # noqa: E501

         This description is for both ​`/schedules​/schedule_a​/` and ​ `/schedules​/schedule_a​/{sub_id}​/`.  This endpoint provides itemized receipts. Schedule A records describe itemized receipts, including contributions from individuals. If you are interested in contributions from an individual, use the `/schedules/schedule_a/` endpoint. For a more complete description of all Schedule A records see the [receipts section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/methodology/) of our “about the data” page.  ​The `/schedules​/schedule_a​/` endpoint is not paginated by page number. This endpoint uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset. To request the next page, you should append the values found in the `last_indexes` object from pagination to the URL of your last request as additional parameters. For example, when sorting by `contribution_receipt_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 2152643,     per_page: 20,     count: 43052850,     last_indexes: {         last_index: \"230880619\",         last_contribution_receipt_date: \"2014-01-01\"     } } ```  To fetch the next page of sorted results, append `last_index=230880619` and `last_contribution_receipt_date=2014-01-01` to the URL. We strongly advise paging through these results using sort indices. The default sort is ascending by `contribution_receipt_date`. If you do not page using sort indices, some transactions may be unintentionally filtered out.  Calls to ​`/schedules​/schedule_a​/` may return many records. For large result sets, the record counts found in the pagination object are approximate; you will need to page through the records until no records are returned.  ​The `/schedules​/schedule_a​/{sub_id}​/` endpoint returns a single transaction, but it does include a pagination object class. Please ignore the information in that object class.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int last_index: Index of last result from previous page
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str min_image_number:
        :param date last_contribution_receipt_date: When sorting by `contribution_receipt_date`, this is populated with the         `contribution_receipt_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param date min_load_date: Minimum load date
        :param list[str] contributor_type: Filters individual or committee contributions based on line number
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] contributor_state: State of contributor
        :param list[str] contributor_occupation: Occupation of contributor, filers need to make an effort to gather this information
        :param str max_image_number:
        :param list[str] contributor_employer: Employer of contributor, filers need to make an effort to gather this information
        :param list[str] contributor_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param list[str] recipient_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool is_individual: Restrict to non-earmarked individual contributions where memo code is true. Filtering individuals is useful to make sure contributions are not double reported and in creating breakdowns of the amount of money coming from individuals.
        :param str max_amount: Filter for all amounts less than a value.
        :param list[str] contributor_city: City of contributor
        :param float last_contributor_aggregate_ytd: When sorting by `contributor_aggregate_ytd`, this is populated with the         `contributor_aggregate_ytd` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] contributor_name: Name of contributor
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] contributor_zip: Zip code of contributor
        :param list[str] recipient_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param date max_load_date: Maximum load date
        :param float last_contribution_receipt_amount: When sorting by `contribution_receipt_amount`, this is populated with the         `contribution_receipt_amount` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] recipient_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :return: ScheduleAPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_get_with_http_info(api_key, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_get_with_http_info(api_key, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_a_get  # noqa: E501

         This description is for both ​`/schedules​/schedule_a​/` and ​ `/schedules​/schedule_a​/{sub_id}​/`.  This endpoint provides itemized receipts. Schedule A records describe itemized receipts, including contributions from individuals. If you are interested in contributions from an individual, use the `/schedules/schedule_a/` endpoint. For a more complete description of all Schedule A records see the [receipts section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/methodology/) of our “about the data” page.  ​The `/schedules​/schedule_a​/` endpoint is not paginated by page number. This endpoint uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset. To request the next page, you should append the values found in the `last_indexes` object from pagination to the URL of your last request as additional parameters. For example, when sorting by `contribution_receipt_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 2152643,     per_page: 20,     count: 43052850,     last_indexes: {         last_index: \"230880619\",         last_contribution_receipt_date: \"2014-01-01\"     } } ```  To fetch the next page of sorted results, append `last_index=230880619` and `last_contribution_receipt_date=2014-01-01` to the URL. We strongly advise paging through these results using sort indices. The default sort is ascending by `contribution_receipt_date`. If you do not page using sort indices, some transactions may be unintentionally filtered out.  Calls to ​`/schedules​/schedule_a​/` may return many records. For large result sets, the record counts found in the pagination object are approximate; you will need to page through the records until no records are returned.  ​The `/schedules​/schedule_a​/{sub_id}​/` endpoint returns a single transaction, but it does include a pagination object class. Please ignore the information in that object class.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int last_index: Index of last result from previous page
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str min_image_number:
        :param date last_contribution_receipt_date: When sorting by `contribution_receipt_date`, this is populated with the         `contribution_receipt_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param date min_load_date: Minimum load date
        :param list[str] contributor_type: Filters individual or committee contributions based on line number
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] contributor_state: State of contributor
        :param list[str] contributor_occupation: Occupation of contributor, filers need to make an effort to gather this information
        :param str max_image_number:
        :param list[str] contributor_employer: Employer of contributor, filers need to make an effort to gather this information
        :param list[str] contributor_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param list[str] recipient_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool is_individual: Restrict to non-earmarked individual contributions where memo code is true. Filtering individuals is useful to make sure contributions are not double reported and in creating breakdowns of the amount of money coming from individuals.
        :param str max_amount: Filter for all amounts less than a value.
        :param list[str] contributor_city: City of contributor
        :param float last_contributor_aggregate_ytd: When sorting by `contributor_aggregate_ytd`, this is populated with the         `contributor_aggregate_ytd` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] contributor_name: Name of contributor
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] contributor_zip: Zip code of contributor
        :param list[str] recipient_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param date max_load_date: Maximum load date
        :param float last_contribution_receipt_amount: When sorting by `contribution_receipt_amount`, this is populated with the         `contribution_receipt_amount` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] recipient_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :return: ScheduleAPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'last_index', 'sort', 'min_image_number', 'last_contribution_receipt_date', 'committee_id', 'min_load_date', 'contributor_type', 'sort_null_only', 'contributor_state', 'contributor_occupation', 'max_image_number', 'contributor_employer', 'contributor_id', 'recipient_committee_type', 'is_individual', 'max_amount', 'contributor_city', 'last_contributor_aggregate_ytd', 'sort_hide_null', 'min_date', 'line_number', 'max_date', 'contributor_name', 'two_year_transaction_period', 'per_page', 'min_amount', 'contributor_zip', 'recipient_committee_org_type', 'max_load_date', 'last_contribution_receipt_amount', 'image_number', 'recipient_committee_designation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'last_index' in params:
            query_params.append(('last_index', params['last_index']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'min_image_number' in params:
            query_params.append(('min_image_number', params['min_image_number']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'last_contribution_receipt_date' in params:
            query_params.append(('last_contribution_receipt_date', params['last_contribution_receipt_date']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'min_load_date' in params:
            query_params.append(('min_load_date', params['min_load_date']))  # noqa: E501
        if 'contributor_type' in params:
            query_params.append(('contributor_type', params['contributor_type']))  # noqa: E501
            collection_formats['contributor_type'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'contributor_state' in params:
            query_params.append(('contributor_state', params['contributor_state']))  # noqa: E501
            collection_formats['contributor_state'] = 'multi'  # noqa: E501
        if 'contributor_occupation' in params:
            query_params.append(('contributor_occupation', params['contributor_occupation']))  # noqa: E501
            collection_formats['contributor_occupation'] = 'multi'  # noqa: E501
        if 'max_image_number' in params:
            query_params.append(('max_image_number', params['max_image_number']))  # noqa: E501
        if 'contributor_employer' in params:
            query_params.append(('contributor_employer', params['contributor_employer']))  # noqa: E501
            collection_formats['contributor_employer'] = 'multi'  # noqa: E501
        if 'contributor_id' in params:
            query_params.append(('contributor_id', params['contributor_id']))  # noqa: E501
            collection_formats['contributor_id'] = 'multi'  # noqa: E501
        if 'recipient_committee_type' in params:
            query_params.append(('recipient_committee_type', params['recipient_committee_type']))  # noqa: E501
            collection_formats['recipient_committee_type'] = 'multi'  # noqa: E501
        if 'is_individual' in params:
            query_params.append(('is_individual', params['is_individual']))  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'contributor_city' in params:
            query_params.append(('contributor_city', params['contributor_city']))  # noqa: E501
            collection_formats['contributor_city'] = 'multi'  # noqa: E501
        if 'last_contributor_aggregate_ytd' in params:
            query_params.append(('last_contributor_aggregate_ytd', params['last_contributor_aggregate_ytd']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'line_number' in params:
            query_params.append(('line_number', params['line_number']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501
        if 'contributor_name' in params:
            query_params.append(('contributor_name', params['contributor_name']))  # noqa: E501
            collection_formats['contributor_name'] = 'multi'  # noqa: E501
        if 'two_year_transaction_period' in params:
            query_params.append(('two_year_transaction_period', params['two_year_transaction_period']))  # noqa: E501
            collection_formats['two_year_transaction_period'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'contributor_zip' in params:
            query_params.append(('contributor_zip', params['contributor_zip']))  # noqa: E501
            collection_formats['contributor_zip'] = 'multi'  # noqa: E501
        if 'recipient_committee_org_type' in params:
            query_params.append(('recipient_committee_org_type', params['recipient_committee_org_type']))  # noqa: E501
            collection_formats['recipient_committee_org_type'] = 'multi'  # noqa: E501
        if 'max_load_date' in params:
            query_params.append(('max_load_date', params['max_load_date']))  # noqa: E501
        if 'last_contribution_receipt_amount' in params:
            query_params.append(('last_contribution_receipt_amount', params['last_contribution_receipt_amount']))  # noqa: E501
        if 'image_number' in params:
            query_params.append(('image_number', params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'recipient_committee_designation' in params:
            query_params.append(('recipient_committee_designation', params['recipient_committee_designation']))  # noqa: E501
            collection_formats['recipient_committee_designation'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_a_sub_id_get(self, api_key, sub_id, **kwargs):  # noqa: E501
        """schedules_schedule_a_sub_id_get  # noqa: E501

         This description is for both ​`/schedules​/schedule_a​/` and ​ `/schedules​/schedule_a​/{sub_id}​/`.  This endpoint provides itemized receipts. Schedule A records describe itemized receipts, including contributions from individuals. If you are interested in contributions from an individual, use the `/schedules/schedule_a/` endpoint. For a more complete description of all Schedule A records see the [receipts section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/methodology/) of our “about the data” page.  ​The `/schedules​/schedule_a​/` endpoint is not paginated by page number. This endpoint uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset. To request the next page, you should append the values found in the `last_indexes` object from pagination to the URL of your last request as additional parameters. For example, when sorting by `contribution_receipt_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 2152643,     per_page: 20,     count: 43052850,     last_indexes: {         last_index: \"230880619\",         last_contribution_receipt_date: \"2014-01-01\"     } } ```  To fetch the next page of sorted results, append `last_index=230880619` and `last_contribution_receipt_date=2014-01-01` to the URL. We strongly advise paging through these results using sort indices. The default sort is ascending by `contribution_receipt_date`. If you do not page using sort indices, some transactions may be unintentionally filtered out.  Calls to ​`/schedules​/schedule_a​/` may return many records. For large result sets, the record counts found in the pagination object are approximate; you will need to page through the records until no records are returned.  ​The `/schedules​/schedule_a​/{sub_id}​/` endpoint returns a single transaction, but it does include a pagination object class. Please ignore the information in that object class.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_sub_id_get(api_key, sub_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sub_id: (required)
        :param int last_index: Index of last result from previous page
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str min_image_number:
        :param date last_contribution_receipt_date: When sorting by `contribution_receipt_date`, this is populated with the         `contribution_receipt_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param date min_load_date: Minimum load date
        :param list[str] contributor_type: Filters individual or committee contributions based on line number
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] contributor_state: State of contributor
        :param list[str] contributor_occupation: Occupation of contributor, filers need to make an effort to gather this information
        :param str max_image_number:
        :param list[str] contributor_employer: Employer of contributor, filers need to make an effort to gather this information
        :param list[str] contributor_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param list[str] recipient_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool is_individual: Restrict to non-earmarked individual contributions where memo code is true. Filtering individuals is useful to make sure contributions are not double reported and in creating breakdowns of the amount of money coming from individuals.
        :param str max_amount: Filter for all amounts less than a value.
        :param list[str] contributor_city: City of contributor
        :param float last_contributor_aggregate_ytd: When sorting by `contributor_aggregate_ytd`, this is populated with the         `contributor_aggregate_ytd` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] contributor_name: Name of contributor
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] contributor_zip: Zip code of contributor
        :param list[str] recipient_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param date max_load_date: Maximum load date
        :param float last_contribution_receipt_amount: When sorting by `contribution_receipt_amount`, this is populated with the         `contribution_receipt_amount` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] recipient_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :return: ScheduleAPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedules_schedule_a_sub_id_get_with_http_info(api_key, sub_id, **kwargs)  # noqa: E501
        else:
            (data) = self.schedules_schedule_a_sub_id_get_with_http_info(api_key, sub_id, **kwargs)  # noqa: E501
            return data

    def schedules_schedule_a_sub_id_get_with_http_info(self, api_key, sub_id, **kwargs):  # noqa: E501
        """schedules_schedule_a_sub_id_get  # noqa: E501

         This description is for both ​`/schedules​/schedule_a​/` and ​ `/schedules​/schedule_a​/{sub_id}​/`.  This endpoint provides itemized receipts. Schedule A records describe itemized receipts, including contributions from individuals. If you are interested in contributions from an individual, use the `/schedules/schedule_a/` endpoint. For a more complete description of all Schedule A records see the [receipts section] (https://www.fec.gov/campaign-finance-data/ about-campaign-finance-data/about-receipts-data/) of our “about the data” page. If you are interested in our “is_individual” methodology see the [methodology section] (https://www.fec.gov/campaign-finance-data/about-campaign-finance-data/methodology/) of our “about the data” page.  ​The `/schedules​/schedule_a​/` endpoint is not paginated by page number. This endpoint uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset. To request the next page, you should append the values found in the `last_indexes` object from pagination to the URL of your last request as additional parameters. For example, when sorting by `contribution_receipt_date`, you might receive a page of results with the following pagination information:  ``` pagination: {     pages: 2152643,     per_page: 20,     count: 43052850,     last_indexes: {         last_index: \"230880619\",         last_contribution_receipt_date: \"2014-01-01\"     } } ```  To fetch the next page of sorted results, append `last_index=230880619` and `last_contribution_receipt_date=2014-01-01` to the URL. We strongly advise paging through these results using sort indices. The default sort is ascending by `contribution_receipt_date`. If you do not page using sort indices, some transactions may be unintentionally filtered out.  Calls to ​`/schedules​/schedule_a​/` may return many records. For large result sets, the record counts found in the pagination object are approximate; you will need to page through the records until no records are returned.  ​The `/schedules​/schedule_a​/{sub_id}​/` endpoint returns a single transaction, but it does include a pagination object class. Please ignore the information in that object class.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_a_sub_id_get_with_http_info(api_key, sub_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sub_id: (required)
        :param int last_index: Index of last result from previous page
        :param str sort: Provide a field to sort by. Use - for descending order.
        :param str min_image_number:
        :param date last_contribution_receipt_date: When sorting by `contribution_receipt_date`, this is populated with the         `contribution_receipt_date` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param date min_load_date: Minimum load date
        :param list[str] contributor_type: Filters individual or committee contributions based on line number
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] contributor_state: State of contributor
        :param list[str] contributor_occupation: Occupation of contributor, filers need to make an effort to gather this information
        :param str max_image_number:
        :param list[str] contributor_employer: Employer of contributor, filers need to make an effort to gather this information
        :param list[str] contributor_id: The FEC identifier should be represented here if the contributor is registered with the FEC.
        :param list[str] recipient_committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool is_individual: Restrict to non-earmarked individual contributions where memo code is true. Filtering individuals is useful to make sure contributions are not double reported and in creating breakdowns of the amount of money coming from individuals.
        :param str max_amount: Filter for all amounts less than a value.
        :param list[str] contributor_city: City of contributor
        :param float last_contributor_aggregate_ytd: When sorting by `contributor_aggregate_ytd`, this is populated with the         `contributor_aggregate_ytd` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_date: Minimum date
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param date max_date: Maximum date
        :param list[str] contributor_name: Name of contributor
        :param list[int] two_year_transaction_period:  This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str min_amount: Filter for all amounts greater than a value.
        :param list[str] contributor_zip: Zip code of contributor
        :param list[str] recipient_committee_org_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param date max_load_date: Maximum load date
        :param float last_contribution_receipt_amount: When sorting by `contribution_receipt_amount`, this is populated with the         `contribution_receipt_amount` of the last result. However, you will need to pass the index         of that last result to `last_index` to get the next page.
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] recipient_committee_designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :return: ScheduleAPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key', 'sub_id', 'last_index', 'sort', 'min_image_number', 'last_contribution_receipt_date', 'committee_id', 'min_load_date', 'contributor_type', 'sort_null_only', 'contributor_state', 'contributor_occupation', 'max_image_number', 'contributor_employer', 'contributor_id', 'recipient_committee_type', 'is_individual', 'max_amount', 'contributor_city', 'last_contributor_aggregate_ytd', 'sort_hide_null', 'min_date', 'line_number', 'max_date', 'contributor_name', 'two_year_transaction_period', 'per_page', 'min_amount', 'contributor_zip', 'recipient_committee_org_type', 'max_load_date', 'last_contribution_receipt_amount', 'image_number', 'recipient_committee_designation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_a_sub_id_get' % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'api_key' is set
        if ('api_key' not in params or
                params['api_key'] is None):
            raise ValueError('Missing the required parameter `api_key` when calling `schedules_schedule_a_sub_id_get`')  # noqa: E501
        # verify the required parameter 'sub_id' is set
        if ('sub_id' not in params or
                params['sub_id'] is None):
            raise ValueError('Missing the required parameter `sub_id` when calling `schedules_schedule_a_sub_id_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sub_id' in params:
            path_params['sub_id'] = params['sub_id']  # noqa: E501

        query_params = []
        if 'last_index' in params:
            query_params.append(('last_index', params['last_index']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'min_image_number' in params:
            query_params.append(('min_image_number', params['min_image_number']))  # noqa: E501
        if 'api_key' in params:
            query_params.append(('api_key', params['api_key']))  # noqa: E501
        if 'last_contribution_receipt_date' in params:
            query_params.append(('last_contribution_receipt_date', params['last_contribution_receipt_date']))  # noqa: E501
        if 'committee_id' in params:
            query_params.append(('committee_id', params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'min_load_date' in params:
            query_params.append(('min_load_date', params['min_load_date']))  # noqa: E501
        if 'contributor_type' in params:
            query_params.append(('contributor_type', params['contributor_type']))  # noqa: E501
            collection_formats['contributor_type'] = 'multi'  # noqa: E501
        if 'sort_null_only' in params:
            query_params.append(('sort_null_only', params['sort_null_only']))  # noqa: E501
        if 'contributor_state' in params:
            query_params.append(('contributor_state', params['contributor_state']))  # noqa: E501
            collection_formats['contributor_state'] = 'multi'  # noqa: E501
        if 'contributor_occupation' in params:
            query_params.append(('contributor_occupation', params['contributor_occupation']))  # noqa: E501
            collection_formats['contributor_occupation'] = 'multi'  # noqa: E501
        if 'max_image_number' in params:
            query_params.append(('max_image_number', params['max_image_number']))  # noqa: E501
        if 'contributor_employer' in params:
            query_params.append(('contributor_employer', params['contributor_employer']))  # noqa: E501
            collection_formats['contributor_employer'] = 'multi'  # noqa: E501
        if 'contributor_id' in params:
            query_params.append(('contributor_id', params['contributor_id']))  # noqa: E501
            collection_formats['contributor_id'] = 'multi'  # noqa: E501
        if 'recipient_committee_type' in params:
            query_params.append(('recipient_committee_type', params['recipient_committee_type']))  # noqa: E501
            collection_formats['recipient_committee_type'] = 'multi'  # noqa: E501
        if 'is_individual' in params:
            query_params.append(('is_individual', params['is_individual']))  # noqa: E501
        if 'max_amount' in params:
            query_params.append(('max_amount', params['max_amount']))  # noqa: E501
        if 'contributor_city' in params:
            query_params.append(('contributor_city', params['contributor_city']))  # noqa: E501
            collection_formats['contributor_city'] = 'multi'  # noqa: E501
        if 'last_contributor_aggregate_ytd' in params:
            query_params.append(('last_contributor_aggregate_ytd', params['last_contributor_aggregate_ytd']))  # noqa: E501
        if 'sort_hide_null' in params:
            query_params.append(('sort_hide_null', params['sort_hide_null']))  # noqa: E501
        if 'min_date' in params:
            query_params.append(('min_date', params['min_date']))  # noqa: E501
        if 'line_number' in params:
            query_params.append(('line_number', params['line_number']))  # noqa: E501
        if 'max_date' in params:
            query_params.append(('max_date', params['max_date']))  # noqa: E501
        if 'contributor_name' in params:
            query_params.append(('contributor_name', params['contributor_name']))  # noqa: E501
            collection_formats['contributor_name'] = 'multi'  # noqa: E501
        if 'two_year_transaction_period' in params:
            query_params.append(('two_year_transaction_period', params['two_year_transaction_period']))  # noqa: E501
            collection_formats['two_year_transaction_period'] = 'multi'  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'min_amount' in params:
            query_params.append(('min_amount', params['min_amount']))  # noqa: E501
        if 'contributor_zip' in params:
            query_params.append(('contributor_zip', params['contributor_zip']))  # noqa: E501
            collection_formats['contributor_zip'] = 'multi'  # noqa: E501
        if 'recipient_committee_org_type' in params:
            query_params.append(('recipient_committee_org_type', params['recipient_committee_org_type']))  # noqa: E501
            collection_formats['recipient_committee_org_type'] = 'multi'  # noqa: E501
        if 'max_load_date' in params:
            query_params.append(('max_load_date', params['max_load_date']))  # noqa: E501
        if 'last_contribution_receipt_amount' in params:
            query_params.append(('last_contribution_receipt_amount', params['last_contribution_receipt_amount']))  # noqa: E501
        if 'image_number' in params:
            query_params.append(('image_number', params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'recipient_committee_designation' in params:
            query_params.append(('recipient_committee_designation', params['recipient_committee_designation']))  # noqa: E501
            collection_formats['recipient_committee_designation'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_a/{sub_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleAPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
