# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class BaseF3PFiling(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amended_by': 'int',
        'amendment': 'str',
        'amendment_chain': 'list[int]',
        'beginning_image_number': 'str',
        'cash_on_hand_beginning_period': 'float',
        'cash_on_hand_end_period': 'float',
        'city': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'coverage_end_date': 'date',
        'coverage_start_date': 'date',
        'csv_url': 'str',
        'debts_owed_by_committee': 'float',
        'debts_owed_to_committee': 'float',
        'document_description': 'str',
        'election_date': 'date',
        'election_state': 'str',
        'expenditure_subject_to_limits': 'float',
        'fec_file_id': 'str',
        'fec_url': 'str',
        'file_number': 'int',
        'general_election': 'str',
        'is_amended': 'bool',
        'most_recent': 'bool',
        'most_recent_filing': 'int',
        'net_contributions_cycle_to_date': 'float',
        'net_operating_expenditures_cycle_to_date': 'float',
        'pdf_url': 'str',
        'prefix': 'str',
        'primary_election': 'str',
        'receipt_date': 'date',
        'report': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'rpt_pgi': 'str',
        'sign_date': 'date',
        'state': 'str',
        'street_1': 'str',
        'street_2': 'str',
        'subtotal_summary_period': 'str',
        'suffix': 'str',
        'summary_lines': 'str',
        'treasurer_first_name': 'str',
        'treasurer_last_name': 'str',
        'treasurer_middle_name': 'str',
        'treasurer_name': 'str',
        'zip': 'str'
    }

    attribute_map = {
        'amended_by': 'amended_by',
        'amendment': 'amendment',
        'amendment_chain': 'amendment_chain',
        'beginning_image_number': 'beginning_image_number',
        'cash_on_hand_beginning_period': 'cash_on_hand_beginning_period',
        'cash_on_hand_end_period': 'cash_on_hand_end_period',
        'city': 'city',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'csv_url': 'csv_url',
        'debts_owed_by_committee': 'debts_owed_by_committee',
        'debts_owed_to_committee': 'debts_owed_to_committee',
        'document_description': 'document_description',
        'election_date': 'election_date',
        'election_state': 'election_state',
        'expenditure_subject_to_limits': 'expenditure_subject_to_limits',
        'fec_file_id': 'fec_file_id',
        'fec_url': 'fec_url',
        'file_number': 'file_number',
        'general_election': 'general_election',
        'is_amended': 'is_amended',
        'most_recent': 'most_recent',
        'most_recent_filing': 'most_recent_filing',
        'net_contributions_cycle_to_date': 'net_contributions_cycle_to_date',
        'net_operating_expenditures_cycle_to_date': 'net_operating_expenditures_cycle_to_date',
        'pdf_url': 'pdf_url',
        'prefix': 'prefix',
        'primary_election': 'primary_election',
        'receipt_date': 'receipt_date',
        'report': 'report',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'rpt_pgi': 'rpt_pgi',
        'sign_date': 'sign_date',
        'state': 'state',
        'street_1': 'street_1',
        'street_2': 'street_2',
        'subtotal_summary_period': 'subtotal_summary_period',
        'suffix': 'suffix',
        'summary_lines': 'summary_lines',
        'treasurer_first_name': 'treasurer_first_name',
        'treasurer_last_name': 'treasurer_last_name',
        'treasurer_middle_name': 'treasurer_middle_name',
        'treasurer_name': 'treasurer_name',
        'zip': 'zip'
    }

    def __init__(self, amended_by=None, amendment=None, amendment_chain=None, beginning_image_number=None, cash_on_hand_beginning_period=None, cash_on_hand_end_period=None, city=None, committee_id=None, committee_name=None, coverage_end_date=None, coverage_start_date=None, csv_url=None, debts_owed_by_committee=None, debts_owed_to_committee=None, document_description=None, election_date=None, election_state=None, expenditure_subject_to_limits=None, fec_file_id=None, fec_url=None, file_number=None, general_election=None, is_amended=None, most_recent=None, most_recent_filing=None, net_contributions_cycle_to_date=None, net_operating_expenditures_cycle_to_date=None, pdf_url=None, prefix=None, primary_election=None, receipt_date=None, report=None, report_type=None, report_year=None, rpt_pgi=None, sign_date=None, state=None, street_1=None, street_2=None, subtotal_summary_period=None, suffix=None, summary_lines=None, treasurer_first_name=None, treasurer_last_name=None, treasurer_middle_name=None, treasurer_name=None, zip=None, local_vars_configuration=None):  # noqa: E501
        """BaseF3PFiling - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amended_by = None
        self._amendment = None
        self._amendment_chain = None
        self._beginning_image_number = None
        self._cash_on_hand_beginning_period = None
        self._cash_on_hand_end_period = None
        self._city = None
        self._committee_id = None
        self._committee_name = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._csv_url = None
        self._debts_owed_by_committee = None
        self._debts_owed_to_committee = None
        self._document_description = None
        self._election_date = None
        self._election_state = None
        self._expenditure_subject_to_limits = None
        self._fec_file_id = None
        self._fec_url = None
        self._file_number = None
        self._general_election = None
        self._is_amended = None
        self._most_recent = None
        self._most_recent_filing = None
        self._net_contributions_cycle_to_date = None
        self._net_operating_expenditures_cycle_to_date = None
        self._pdf_url = None
        self._prefix = None
        self._primary_election = None
        self._receipt_date = None
        self._report = None
        self._report_type = None
        self._report_year = None
        self._rpt_pgi = None
        self._sign_date = None
        self._state = None
        self._street_1 = None
        self._street_2 = None
        self._subtotal_summary_period = None
        self._suffix = None
        self._summary_lines = None
        self._treasurer_first_name = None
        self._treasurer_last_name = None
        self._treasurer_middle_name = None
        self._treasurer_name = None
        self._zip = None
        self.discriminator = None

        if amended_by is not None:
            self.amended_by = amended_by
        self.amendment = amendment
        if amendment_chain is not None:
            self.amendment_chain = amendment_chain
        if beginning_image_number is not None:
            self.beginning_image_number = beginning_image_number
        self.cash_on_hand_beginning_period = cash_on_hand_beginning_period
        self.cash_on_hand_end_period = cash_on_hand_end_period
        self.city = city
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        if csv_url is not None:
            self.csv_url = csv_url
        self.debts_owed_by_committee = debts_owed_by_committee
        self.debts_owed_to_committee = debts_owed_to_committee
        if document_description is not None:
            self.document_description = document_description
        self.election_date = election_date
        self.election_state = election_state
        self.expenditure_subject_to_limits = expenditure_subject_to_limits
        if fec_file_id is not None:
            self.fec_file_id = fec_file_id
        if fec_url is not None:
            self.fec_url = fec_url
        if file_number is not None:
            self.file_number = file_number
        self.general_election = general_election
        if is_amended is not None:
            self.is_amended = is_amended
        if most_recent is not None:
            self.most_recent = most_recent
        if most_recent_filing is not None:
            self.most_recent_filing = most_recent_filing
        self.net_contributions_cycle_to_date = net_contributions_cycle_to_date
        self.net_operating_expenditures_cycle_to_date = net_operating_expenditures_cycle_to_date
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.prefix = prefix
        self.primary_election = primary_election
        self.receipt_date = receipt_date
        self.report = report
        self.report_type = report_type
        if report_year is not None:
            self.report_year = report_year
        self.rpt_pgi = rpt_pgi
        self.sign_date = sign_date
        self.state = state
        self.street_1 = street_1
        self.street_2 = street_2
        self.subtotal_summary_period = subtotal_summary_period
        self.suffix = suffix
        if summary_lines is not None:
            self.summary_lines = summary_lines
        self.treasurer_first_name = treasurer_first_name
        self.treasurer_last_name = treasurer_last_name
        self.treasurer_middle_name = treasurer_middle_name
        if treasurer_name is not None:
            self.treasurer_name = treasurer_name
        self.zip = zip

    @property
    def amended_by(self):
        """Gets the amended_by of this BaseF3PFiling.  # noqa: E501


        :return: The amended_by of this BaseF3PFiling.  # noqa: E501
        :rtype: int
        """
        return self._amended_by

    @amended_by.setter
    def amended_by(self, amended_by):
        """Sets the amended_by of this BaseF3PFiling.


        :param amended_by: The amended_by of this BaseF3PFiling.  # noqa: E501
        :type: int
        """

        self._amended_by = amended_by

    @property
    def amendment(self):
        """Gets the amendment of this BaseF3PFiling.  # noqa: E501


        :return: The amendment of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._amendment

    @amendment.setter
    def amendment(self, amendment):
        """Sets the amendment of this BaseF3PFiling.


        :param amendment: The amendment of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._amendment = amendment

    @property
    def amendment_chain(self):
        """Gets the amendment_chain of this BaseF3PFiling.  # noqa: E501


        :return: The amendment_chain of this BaseF3PFiling.  # noqa: E501
        :rtype: list[int]
        """
        return self._amendment_chain

    @amendment_chain.setter
    def amendment_chain(self, amendment_chain):
        """Sets the amendment_chain of this BaseF3PFiling.


        :param amendment_chain: The amendment_chain of this BaseF3PFiling.  # noqa: E501
        :type: list[int]
        """

        self._amendment_chain = amendment_chain

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this BaseF3PFiling.  # noqa: E501


        :return: The beginning_image_number of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this BaseF3PFiling.


        :param beginning_image_number: The beginning_image_number of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def cash_on_hand_beginning_period(self):
        """Gets the cash_on_hand_beginning_period of this BaseF3PFiling.  # noqa: E501


        :return: The cash_on_hand_beginning_period of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_beginning_period

    @cash_on_hand_beginning_period.setter
    def cash_on_hand_beginning_period(self, cash_on_hand_beginning_period):
        """Sets the cash_on_hand_beginning_period of this BaseF3PFiling.


        :param cash_on_hand_beginning_period: The cash_on_hand_beginning_period of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_beginning_period = cash_on_hand_beginning_period

    @property
    def cash_on_hand_end_period(self):
        """Gets the cash_on_hand_end_period of this BaseF3PFiling.  # noqa: E501


        :return: The cash_on_hand_end_period of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_end_period

    @cash_on_hand_end_period.setter
    def cash_on_hand_end_period(self, cash_on_hand_end_period):
        """Sets the cash_on_hand_end_period of this BaseF3PFiling.


        :param cash_on_hand_end_period: The cash_on_hand_end_period of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_end_period = cash_on_hand_end_period

    @property
    def city(self):
        """Gets the city of this BaseF3PFiling.  # noqa: E501


        :return: The city of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this BaseF3PFiling.


        :param city: The city of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def committee_id(self):
        """Gets the committee_id of this BaseF3PFiling.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this BaseF3PFiling.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this BaseF3PFiling.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this BaseF3PFiling.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this BaseF3PFiling.  # noqa: E501


        :return: The coverage_end_date of this BaseF3PFiling.  # noqa: E501
        :rtype: date
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this BaseF3PFiling.


        :param coverage_end_date: The coverage_end_date of this BaseF3PFiling.  # noqa: E501
        :type: date
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this BaseF3PFiling.  # noqa: E501


        :return: The coverage_start_date of this BaseF3PFiling.  # noqa: E501
        :rtype: date
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this BaseF3PFiling.


        :param coverage_start_date: The coverage_start_date of this BaseF3PFiling.  # noqa: E501
        :type: date
        """

        self._coverage_start_date = coverage_start_date

    @property
    def csv_url(self):
        """Gets the csv_url of this BaseF3PFiling.  # noqa: E501


        :return: The csv_url of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._csv_url

    @csv_url.setter
    def csv_url(self, csv_url):
        """Sets the csv_url of this BaseF3PFiling.


        :param csv_url: The csv_url of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._csv_url = csv_url

    @property
    def debts_owed_by_committee(self):
        """Gets the debts_owed_by_committee of this BaseF3PFiling.  # noqa: E501


        :return: The debts_owed_by_committee of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_by_committee

    @debts_owed_by_committee.setter
    def debts_owed_by_committee(self, debts_owed_by_committee):
        """Sets the debts_owed_by_committee of this BaseF3PFiling.


        :param debts_owed_by_committee: The debts_owed_by_committee of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._debts_owed_by_committee = debts_owed_by_committee

    @property
    def debts_owed_to_committee(self):
        """Gets the debts_owed_to_committee of this BaseF3PFiling.  # noqa: E501


        :return: The debts_owed_to_committee of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_to_committee

    @debts_owed_to_committee.setter
    def debts_owed_to_committee(self, debts_owed_to_committee):
        """Sets the debts_owed_to_committee of this BaseF3PFiling.


        :param debts_owed_to_committee: The debts_owed_to_committee of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._debts_owed_to_committee = debts_owed_to_committee

    @property
    def document_description(self):
        """Gets the document_description of this BaseF3PFiling.  # noqa: E501


        :return: The document_description of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._document_description

    @document_description.setter
    def document_description(self, document_description):
        """Sets the document_description of this BaseF3PFiling.


        :param document_description: The document_description of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._document_description = document_description

    @property
    def election_date(self):
        """Gets the election_date of this BaseF3PFiling.  # noqa: E501


        :return: The election_date of this BaseF3PFiling.  # noqa: E501
        :rtype: date
        """
        return self._election_date

    @election_date.setter
    def election_date(self, election_date):
        """Sets the election_date of this BaseF3PFiling.


        :param election_date: The election_date of this BaseF3PFiling.  # noqa: E501
        :type: date
        """

        self._election_date = election_date

    @property
    def election_state(self):
        """Gets the election_state of this BaseF3PFiling.  # noqa: E501


        :return: The election_state of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._election_state

    @election_state.setter
    def election_state(self, election_state):
        """Sets the election_state of this BaseF3PFiling.


        :param election_state: The election_state of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._election_state = election_state

    @property
    def expenditure_subject_to_limits(self):
        """Gets the expenditure_subject_to_limits of this BaseF3PFiling.  # noqa: E501


        :return: The expenditure_subject_to_limits of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._expenditure_subject_to_limits

    @expenditure_subject_to_limits.setter
    def expenditure_subject_to_limits(self, expenditure_subject_to_limits):
        """Sets the expenditure_subject_to_limits of this BaseF3PFiling.


        :param expenditure_subject_to_limits: The expenditure_subject_to_limits of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._expenditure_subject_to_limits = expenditure_subject_to_limits

    @property
    def fec_file_id(self):
        """Gets the fec_file_id of this BaseF3PFiling.  # noqa: E501


        :return: The fec_file_id of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._fec_file_id

    @fec_file_id.setter
    def fec_file_id(self, fec_file_id):
        """Sets the fec_file_id of this BaseF3PFiling.


        :param fec_file_id: The fec_file_id of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._fec_file_id = fec_file_id

    @property
    def fec_url(self):
        """Gets the fec_url of this BaseF3PFiling.  # noqa: E501


        :return: The fec_url of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._fec_url

    @fec_url.setter
    def fec_url(self, fec_url):
        """Sets the fec_url of this BaseF3PFiling.


        :param fec_url: The fec_url of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._fec_url = fec_url

    @property
    def file_number(self):
        """Gets the file_number of this BaseF3PFiling.  # noqa: E501


        :return: The file_number of this BaseF3PFiling.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this BaseF3PFiling.


        :param file_number: The file_number of this BaseF3PFiling.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def general_election(self):
        """Gets the general_election of this BaseF3PFiling.  # noqa: E501


        :return: The general_election of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._general_election

    @general_election.setter
    def general_election(self, general_election):
        """Sets the general_election of this BaseF3PFiling.


        :param general_election: The general_election of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._general_election = general_election

    @property
    def is_amended(self):
        """Gets the is_amended of this BaseF3PFiling.  # noqa: E501


        :return: The is_amended of this BaseF3PFiling.  # noqa: E501
        :rtype: bool
        """
        return self._is_amended

    @is_amended.setter
    def is_amended(self, is_amended):
        """Sets the is_amended of this BaseF3PFiling.


        :param is_amended: The is_amended of this BaseF3PFiling.  # noqa: E501
        :type: bool
        """

        self._is_amended = is_amended

    @property
    def most_recent(self):
        """Gets the most_recent of this BaseF3PFiling.  # noqa: E501


        :return: The most_recent of this BaseF3PFiling.  # noqa: E501
        :rtype: bool
        """
        return self._most_recent

    @most_recent.setter
    def most_recent(self, most_recent):
        """Sets the most_recent of this BaseF3PFiling.


        :param most_recent: The most_recent of this BaseF3PFiling.  # noqa: E501
        :type: bool
        """

        self._most_recent = most_recent

    @property
    def most_recent_filing(self):
        """Gets the most_recent_filing of this BaseF3PFiling.  # noqa: E501


        :return: The most_recent_filing of this BaseF3PFiling.  # noqa: E501
        :rtype: int
        """
        return self._most_recent_filing

    @most_recent_filing.setter
    def most_recent_filing(self, most_recent_filing):
        """Sets the most_recent_filing of this BaseF3PFiling.


        :param most_recent_filing: The most_recent_filing of this BaseF3PFiling.  # noqa: E501
        :type: int
        """

        self._most_recent_filing = most_recent_filing

    @property
    def net_contributions_cycle_to_date(self):
        """Gets the net_contributions_cycle_to_date of this BaseF3PFiling.  # noqa: E501


        :return: The net_contributions_cycle_to_date of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._net_contributions_cycle_to_date

    @net_contributions_cycle_to_date.setter
    def net_contributions_cycle_to_date(self, net_contributions_cycle_to_date):
        """Sets the net_contributions_cycle_to_date of this BaseF3PFiling.


        :param net_contributions_cycle_to_date: The net_contributions_cycle_to_date of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._net_contributions_cycle_to_date = net_contributions_cycle_to_date

    @property
    def net_operating_expenditures_cycle_to_date(self):
        """Gets the net_operating_expenditures_cycle_to_date of this BaseF3PFiling.  # noqa: E501


        :return: The net_operating_expenditures_cycle_to_date of this BaseF3PFiling.  # noqa: E501
        :rtype: float
        """
        return self._net_operating_expenditures_cycle_to_date

    @net_operating_expenditures_cycle_to_date.setter
    def net_operating_expenditures_cycle_to_date(self, net_operating_expenditures_cycle_to_date):
        """Sets the net_operating_expenditures_cycle_to_date of this BaseF3PFiling.


        :param net_operating_expenditures_cycle_to_date: The net_operating_expenditures_cycle_to_date of this BaseF3PFiling.  # noqa: E501
        :type: float
        """

        self._net_operating_expenditures_cycle_to_date = net_operating_expenditures_cycle_to_date

    @property
    def pdf_url(self):
        """Gets the pdf_url of this BaseF3PFiling.  # noqa: E501


        :return: The pdf_url of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this BaseF3PFiling.


        :param pdf_url: The pdf_url of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def prefix(self):
        """Gets the prefix of this BaseF3PFiling.  # noqa: E501


        :return: The prefix of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this BaseF3PFiling.


        :param prefix: The prefix of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._prefix = prefix

    @property
    def primary_election(self):
        """Gets the primary_election of this BaseF3PFiling.  # noqa: E501


        :return: The primary_election of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._primary_election

    @primary_election.setter
    def primary_election(self, primary_election):
        """Sets the primary_election of this BaseF3PFiling.


        :param primary_election: The primary_election of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._primary_election = primary_election

    @property
    def receipt_date(self):
        """Gets the receipt_date of this BaseF3PFiling.  # noqa: E501


        :return: The receipt_date of this BaseF3PFiling.  # noqa: E501
        :rtype: date
        """
        return self._receipt_date

    @receipt_date.setter
    def receipt_date(self, receipt_date):
        """Sets the receipt_date of this BaseF3PFiling.


        :param receipt_date: The receipt_date of this BaseF3PFiling.  # noqa: E501
        :type: date
        """

        self._receipt_date = receipt_date

    @property
    def report(self):
        """Gets the report of this BaseF3PFiling.  # noqa: E501


        :return: The report of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._report

    @report.setter
    def report(self, report):
        """Sets the report of this BaseF3PFiling.


        :param report: The report of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._report = report

    @property
    def report_type(self):
        """Gets the report_type of this BaseF3PFiling.  # noqa: E501


        :return: The report_type of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this BaseF3PFiling.


        :param report_type: The report_type of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this BaseF3PFiling.  # noqa: E501


        :return: The report_year of this BaseF3PFiling.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this BaseF3PFiling.


        :param report_year: The report_year of this BaseF3PFiling.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def rpt_pgi(self):
        """Gets the rpt_pgi of this BaseF3PFiling.  # noqa: E501

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :return: The rpt_pgi of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._rpt_pgi

    @rpt_pgi.setter
    def rpt_pgi(self, rpt_pgi):
        """Sets the rpt_pgi of this BaseF3PFiling.

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :param rpt_pgi: The rpt_pgi of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._rpt_pgi = rpt_pgi

    @property
    def sign_date(self):
        """Gets the sign_date of this BaseF3PFiling.  # noqa: E501


        :return: The sign_date of this BaseF3PFiling.  # noqa: E501
        :rtype: date
        """
        return self._sign_date

    @sign_date.setter
    def sign_date(self, sign_date):
        """Sets the sign_date of this BaseF3PFiling.


        :param sign_date: The sign_date of this BaseF3PFiling.  # noqa: E501
        :type: date
        """

        self._sign_date = sign_date

    @property
    def state(self):
        """Gets the state of this BaseF3PFiling.  # noqa: E501


        :return: The state of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this BaseF3PFiling.


        :param state: The state of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def street_1(self):
        """Gets the street_1 of this BaseF3PFiling.  # noqa: E501


        :return: The street_1 of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._street_1

    @street_1.setter
    def street_1(self, street_1):
        """Sets the street_1 of this BaseF3PFiling.


        :param street_1: The street_1 of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._street_1 = street_1

    @property
    def street_2(self):
        """Gets the street_2 of this BaseF3PFiling.  # noqa: E501


        :return: The street_2 of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._street_2

    @street_2.setter
    def street_2(self, street_2):
        """Sets the street_2 of this BaseF3PFiling.


        :param street_2: The street_2 of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._street_2 = street_2

    @property
    def subtotal_summary_period(self):
        """Gets the subtotal_summary_period of this BaseF3PFiling.  # noqa: E501


        :return: The subtotal_summary_period of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._subtotal_summary_period

    @subtotal_summary_period.setter
    def subtotal_summary_period(self, subtotal_summary_period):
        """Sets the subtotal_summary_period of this BaseF3PFiling.


        :param subtotal_summary_period: The subtotal_summary_period of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._subtotal_summary_period = subtotal_summary_period

    @property
    def suffix(self):
        """Gets the suffix of this BaseF3PFiling.  # noqa: E501


        :return: The suffix of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._suffix

    @suffix.setter
    def suffix(self, suffix):
        """Sets the suffix of this BaseF3PFiling.


        :param suffix: The suffix of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._suffix = suffix

    @property
    def summary_lines(self):
        """Gets the summary_lines of this BaseF3PFiling.  # noqa: E501


        :return: The summary_lines of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._summary_lines

    @summary_lines.setter
    def summary_lines(self, summary_lines):
        """Sets the summary_lines of this BaseF3PFiling.


        :param summary_lines: The summary_lines of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._summary_lines = summary_lines

    @property
    def treasurer_first_name(self):
        """Gets the treasurer_first_name of this BaseF3PFiling.  # noqa: E501


        :return: The treasurer_first_name of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_first_name

    @treasurer_first_name.setter
    def treasurer_first_name(self, treasurer_first_name):
        """Sets the treasurer_first_name of this BaseF3PFiling.


        :param treasurer_first_name: The treasurer_first_name of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._treasurer_first_name = treasurer_first_name

    @property
    def treasurer_last_name(self):
        """Gets the treasurer_last_name of this BaseF3PFiling.  # noqa: E501


        :return: The treasurer_last_name of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_last_name

    @treasurer_last_name.setter
    def treasurer_last_name(self, treasurer_last_name):
        """Sets the treasurer_last_name of this BaseF3PFiling.


        :param treasurer_last_name: The treasurer_last_name of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._treasurer_last_name = treasurer_last_name

    @property
    def treasurer_middle_name(self):
        """Gets the treasurer_middle_name of this BaseF3PFiling.  # noqa: E501


        :return: The treasurer_middle_name of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_middle_name

    @treasurer_middle_name.setter
    def treasurer_middle_name(self, treasurer_middle_name):
        """Sets the treasurer_middle_name of this BaseF3PFiling.


        :param treasurer_middle_name: The treasurer_middle_name of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._treasurer_middle_name = treasurer_middle_name

    @property
    def treasurer_name(self):
        """Gets the treasurer_name of this BaseF3PFiling.  # noqa: E501


        :return: The treasurer_name of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name

    @treasurer_name.setter
    def treasurer_name(self, treasurer_name):
        """Sets the treasurer_name of this BaseF3PFiling.


        :param treasurer_name: The treasurer_name of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._treasurer_name = treasurer_name

    @property
    def zip(self):
        """Gets the zip of this BaseF3PFiling.  # noqa: E501


        :return: The zip of this BaseF3PFiling.  # noqa: E501
        :rtype: str
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """Sets the zip of this BaseF3PFiling.


        :param zip: The zip of this BaseF3PFiling.  # noqa: E501
        :type: str
        """

        self._zip = zip

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BaseF3PFiling):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BaseF3PFiling):
            return True

        return self.to_dict() != other.to_dict()
