# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CandidateCommitteeTotalsPresidential(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'candidate_contribution': 'float',
        'candidate_election_year': 'int',
        'candidate_id': 'str',
        'contribution_refunds': 'float',
        'contributions': 'float',
        'coverage_end_date': 'datetime',
        'coverage_start_date': 'datetime',
        'cycle': 'int',
        'disbursements': 'float',
        'election_full': 'bool',
        'exempt_legal_accounting_disbursement': 'float',
        'federal_funds': 'float',
        'fundraising_disbursements': 'float',
        'individual_contributions': 'float',
        'individual_itemized_contributions': 'float',
        'individual_unitemized_contributions': 'float',
        'last_beginning_image_number': 'str',
        'last_cash_on_hand_end_period': 'float',
        'last_debts_owed_by_committee': 'float',
        'last_debts_owed_to_committee': 'float',
        'last_report_type_full': 'str',
        'last_report_year': 'int',
        'loan_repayments_made': 'float',
        'loans_received': 'float',
        'loans_received_from_candidate': 'float',
        'net_contributions': 'float',
        'net_operating_expenditures': 'float',
        'offsets_to_fundraising_expenditures': 'float',
        'offsets_to_legal_accounting': 'float',
        'offsets_to_operating_expenditures': 'float',
        'operating_expenditures': 'float',
        'other_disbursements': 'float',
        'other_loans_received': 'float',
        'other_political_committee_contributions': 'float',
        'other_receipts': 'float',
        'political_party_committee_contributions': 'float',
        'receipts': 'float',
        'refunded_individual_contributions': 'float',
        'refunded_other_political_committee_contributions': 'float',
        'refunded_political_party_committee_contributions': 'float',
        'repayments_loans_made_by_candidate': 'float',
        'repayments_other_loans': 'float',
        'total_offsets_to_operating_expenditures': 'float',
        'transaction_coverage_date': 'datetime',
        'transfers_from_affiliated_committee': 'float',
        'transfers_to_other_authorized_committee': 'float'
    }

    attribute_map = {
        'candidate_contribution': 'candidate_contribution',
        'candidate_election_year': 'candidate_election_year',
        'candidate_id': 'candidate_id',
        'contribution_refunds': 'contribution_refunds',
        'contributions': 'contributions',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'cycle': 'cycle',
        'disbursements': 'disbursements',
        'election_full': 'election_full',
        'exempt_legal_accounting_disbursement': 'exempt_legal_accounting_disbursement',
        'federal_funds': 'federal_funds',
        'fundraising_disbursements': 'fundraising_disbursements',
        'individual_contributions': 'individual_contributions',
        'individual_itemized_contributions': 'individual_itemized_contributions',
        'individual_unitemized_contributions': 'individual_unitemized_contributions',
        'last_beginning_image_number': 'last_beginning_image_number',
        'last_cash_on_hand_end_period': 'last_cash_on_hand_end_period',
        'last_debts_owed_by_committee': 'last_debts_owed_by_committee',
        'last_debts_owed_to_committee': 'last_debts_owed_to_committee',
        'last_report_type_full': 'last_report_type_full',
        'last_report_year': 'last_report_year',
        'loan_repayments_made': 'loan_repayments_made',
        'loans_received': 'loans_received',
        'loans_received_from_candidate': 'loans_received_from_candidate',
        'net_contributions': 'net_contributions',
        'net_operating_expenditures': 'net_operating_expenditures',
        'offsets_to_fundraising_expenditures': 'offsets_to_fundraising_expenditures',
        'offsets_to_legal_accounting': 'offsets_to_legal_accounting',
        'offsets_to_operating_expenditures': 'offsets_to_operating_expenditures',
        'operating_expenditures': 'operating_expenditures',
        'other_disbursements': 'other_disbursements',
        'other_loans_received': 'other_loans_received',
        'other_political_committee_contributions': 'other_political_committee_contributions',
        'other_receipts': 'other_receipts',
        'political_party_committee_contributions': 'political_party_committee_contributions',
        'receipts': 'receipts',
        'refunded_individual_contributions': 'refunded_individual_contributions',
        'refunded_other_political_committee_contributions': 'refunded_other_political_committee_contributions',
        'refunded_political_party_committee_contributions': 'refunded_political_party_committee_contributions',
        'repayments_loans_made_by_candidate': 'repayments_loans_made_by_candidate',
        'repayments_other_loans': 'repayments_other_loans',
        'total_offsets_to_operating_expenditures': 'total_offsets_to_operating_expenditures',
        'transaction_coverage_date': 'transaction_coverage_date',
        'transfers_from_affiliated_committee': 'transfers_from_affiliated_committee',
        'transfers_to_other_authorized_committee': 'transfers_to_other_authorized_committee'
    }

    def __init__(self, candidate_contribution=None, candidate_election_year=None, candidate_id=None, contribution_refunds=None, contributions=None, coverage_end_date=None, coverage_start_date=None, cycle=None, disbursements=None, election_full=None, exempt_legal_accounting_disbursement=None, federal_funds=None, fundraising_disbursements=None, individual_contributions=None, individual_itemized_contributions=None, individual_unitemized_contributions=None, last_beginning_image_number=None, last_cash_on_hand_end_period=None, last_debts_owed_by_committee=None, last_debts_owed_to_committee=None, last_report_type_full=None, last_report_year=None, loan_repayments_made=None, loans_received=None, loans_received_from_candidate=None, net_contributions=None, net_operating_expenditures=None, offsets_to_fundraising_expenditures=None, offsets_to_legal_accounting=None, offsets_to_operating_expenditures=None, operating_expenditures=None, other_disbursements=None, other_loans_received=None, other_political_committee_contributions=None, other_receipts=None, political_party_committee_contributions=None, receipts=None, refunded_individual_contributions=None, refunded_other_political_committee_contributions=None, refunded_political_party_committee_contributions=None, repayments_loans_made_by_candidate=None, repayments_other_loans=None, total_offsets_to_operating_expenditures=None, transaction_coverage_date=None, transfers_from_affiliated_committee=None, transfers_to_other_authorized_committee=None, local_vars_configuration=None):  # noqa: E501
        """CandidateCommitteeTotalsPresidential - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._candidate_contribution = None
        self._candidate_election_year = None
        self._candidate_id = None
        self._contribution_refunds = None
        self._contributions = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._cycle = None
        self._disbursements = None
        self._election_full = None
        self._exempt_legal_accounting_disbursement = None
        self._federal_funds = None
        self._fundraising_disbursements = None
        self._individual_contributions = None
        self._individual_itemized_contributions = None
        self._individual_unitemized_contributions = None
        self._last_beginning_image_number = None
        self._last_cash_on_hand_end_period = None
        self._last_debts_owed_by_committee = None
        self._last_debts_owed_to_committee = None
        self._last_report_type_full = None
        self._last_report_year = None
        self._loan_repayments_made = None
        self._loans_received = None
        self._loans_received_from_candidate = None
        self._net_contributions = None
        self._net_operating_expenditures = None
        self._offsets_to_fundraising_expenditures = None
        self._offsets_to_legal_accounting = None
        self._offsets_to_operating_expenditures = None
        self._operating_expenditures = None
        self._other_disbursements = None
        self._other_loans_received = None
        self._other_political_committee_contributions = None
        self._other_receipts = None
        self._political_party_committee_contributions = None
        self._receipts = None
        self._refunded_individual_contributions = None
        self._refunded_other_political_committee_contributions = None
        self._refunded_political_party_committee_contributions = None
        self._repayments_loans_made_by_candidate = None
        self._repayments_other_loans = None
        self._total_offsets_to_operating_expenditures = None
        self._transaction_coverage_date = None
        self._transfers_from_affiliated_committee = None
        self._transfers_to_other_authorized_committee = None
        self.discriminator = None

        self.candidate_contribution = candidate_contribution
        self.candidate_election_year = candidate_election_year
        self.candidate_id = candidate_id
        self.contribution_refunds = contribution_refunds
        self.contributions = contributions
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        self.cycle = cycle
        self.disbursements = disbursements
        self.election_full = election_full
        self.exempt_legal_accounting_disbursement = exempt_legal_accounting_disbursement
        self.federal_funds = federal_funds
        self.fundraising_disbursements = fundraising_disbursements
        self.individual_contributions = individual_contributions
        self.individual_itemized_contributions = individual_itemized_contributions
        self.individual_unitemized_contributions = individual_unitemized_contributions
        if last_beginning_image_number is not None:
            self.last_beginning_image_number = last_beginning_image_number
        if last_cash_on_hand_end_period is not None:
            self.last_cash_on_hand_end_period = last_cash_on_hand_end_period
        self.last_debts_owed_by_committee = last_debts_owed_by_committee
        self.last_debts_owed_to_committee = last_debts_owed_to_committee
        self.last_report_type_full = last_report_type_full
        self.last_report_year = last_report_year
        self.loan_repayments_made = loan_repayments_made
        self.loans_received = loans_received
        self.loans_received_from_candidate = loans_received_from_candidate
        self.net_contributions = net_contributions
        self.net_operating_expenditures = net_operating_expenditures
        self.offsets_to_fundraising_expenditures = offsets_to_fundraising_expenditures
        self.offsets_to_legal_accounting = offsets_to_legal_accounting
        self.offsets_to_operating_expenditures = offsets_to_operating_expenditures
        self.operating_expenditures = operating_expenditures
        self.other_disbursements = other_disbursements
        self.other_loans_received = other_loans_received
        self.other_political_committee_contributions = other_political_committee_contributions
        self.other_receipts = other_receipts
        self.political_party_committee_contributions = political_party_committee_contributions
        self.receipts = receipts
        self.refunded_individual_contributions = refunded_individual_contributions
        self.refunded_other_political_committee_contributions = refunded_other_political_committee_contributions
        self.refunded_political_party_committee_contributions = refunded_political_party_committee_contributions
        self.repayments_loans_made_by_candidate = repayments_loans_made_by_candidate
        self.repayments_other_loans = repayments_other_loans
        self.total_offsets_to_operating_expenditures = total_offsets_to_operating_expenditures
        self.transaction_coverage_date = transaction_coverage_date
        self.transfers_from_affiliated_committee = transfers_from_affiliated_committee
        self.transfers_to_other_authorized_committee = transfers_to_other_authorized_committee

    @property
    def candidate_contribution(self):
        """Gets the candidate_contribution of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The candidate_contribution of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._candidate_contribution

    @candidate_contribution.setter
    def candidate_contribution(self, candidate_contribution):
        """Sets the candidate_contribution of this CandidateCommitteeTotalsPresidential.


        :param candidate_contribution: The candidate_contribution of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._candidate_contribution = candidate_contribution

    @property
    def candidate_election_year(self):
        """Gets the candidate_election_year of this CandidateCommitteeTotalsPresidential.  # noqa: E501

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The candidate_election_year of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: int
        """
        return self._candidate_election_year

    @candidate_election_year.setter
    def candidate_election_year(self, candidate_election_year):
        """Sets the candidate_election_year of this CandidateCommitteeTotalsPresidential.

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param candidate_election_year: The candidate_election_year of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and candidate_election_year is None:  # noqa: E501
            raise ValueError('Invalid value for `candidate_election_year`, must not be `None`')  # noqa: E501

        self._candidate_election_year = candidate_election_year

    @property
    def candidate_id(self):
        """Gets the candidate_id of this CandidateCommitteeTotalsPresidential.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this CandidateCommitteeTotalsPresidential.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and candidate_id is None:  # noqa: E501
            raise ValueError('Invalid value for `candidate_id`, must not be `None`')  # noqa: E501

        self._candidate_id = candidate_id

    @property
    def contribution_refunds(self):
        """Gets the contribution_refunds of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The contribution_refunds of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._contribution_refunds

    @contribution_refunds.setter
    def contribution_refunds(self, contribution_refunds):
        """Sets the contribution_refunds of this CandidateCommitteeTotalsPresidential.


        :param contribution_refunds: The contribution_refunds of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._contribution_refunds = contribution_refunds

    @property
    def contributions(self):
        """Gets the contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501

        Contribution  # noqa: E501

        :return: The contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._contributions

    @contributions.setter
    def contributions(self, contributions):
        """Sets the contributions of this CandidateCommitteeTotalsPresidential.

        Contribution  # noqa: E501

        :param contributions: The contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._contributions = contributions

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The coverage_end_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this CandidateCommitteeTotalsPresidential.


        :param coverage_end_date: The coverage_end_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: datetime
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The coverage_start_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this CandidateCommitteeTotalsPresidential.


        :param coverage_start_date: The coverage_start_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: datetime
        """

        self._coverage_start_date = coverage_start_date

    @property
    def cycle(self):
        """Gets the cycle of this CandidateCommitteeTotalsPresidential.  # noqa: E501

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CandidateCommitteeTotalsPresidential.

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and cycle is None:  # noqa: E501
            raise ValueError('Invalid value for `cycle`, must not be `None`')  # noqa: E501

        self._cycle = cycle

    @property
    def disbursements(self):
        """Gets the disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501

        Disbursements  # noqa: E501

        :return: The disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._disbursements

    @disbursements.setter
    def disbursements(self, disbursements):
        """Sets the disbursements of this CandidateCommitteeTotalsPresidential.

        Disbursements  # noqa: E501

        :param disbursements: The disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._disbursements = disbursements

    @property
    def election_full(self):
        """Gets the election_full of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The election_full of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: bool
        """
        return self._election_full

    @election_full.setter
    def election_full(self, election_full):
        """Sets the election_full of this CandidateCommitteeTotalsPresidential.


        :param election_full: The election_full of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and election_full is None:  # noqa: E501
            raise ValueError('Invalid value for `election_full`, must not be `None`')  # noqa: E501

        self._election_full = election_full

    @property
    def exempt_legal_accounting_disbursement(self):
        """Gets the exempt_legal_accounting_disbursement of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The exempt_legal_accounting_disbursement of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._exempt_legal_accounting_disbursement

    @exempt_legal_accounting_disbursement.setter
    def exempt_legal_accounting_disbursement(self, exempt_legal_accounting_disbursement):
        """Sets the exempt_legal_accounting_disbursement of this CandidateCommitteeTotalsPresidential.


        :param exempt_legal_accounting_disbursement: The exempt_legal_accounting_disbursement of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._exempt_legal_accounting_disbursement = exempt_legal_accounting_disbursement

    @property
    def federal_funds(self):
        """Gets the federal_funds of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The federal_funds of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._federal_funds

    @federal_funds.setter
    def federal_funds(self, federal_funds):
        """Sets the federal_funds of this CandidateCommitteeTotalsPresidential.


        :param federal_funds: The federal_funds of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._federal_funds = federal_funds

    @property
    def fundraising_disbursements(self):
        """Gets the fundraising_disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The fundraising_disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._fundraising_disbursements

    @fundraising_disbursements.setter
    def fundraising_disbursements(self, fundraising_disbursements):
        """Sets the fundraising_disbursements of this CandidateCommitteeTotalsPresidential.


        :param fundraising_disbursements: The fundraising_disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._fundraising_disbursements = fundraising_disbursements

    @property
    def individual_contributions(self):
        """Gets the individual_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The individual_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._individual_contributions

    @individual_contributions.setter
    def individual_contributions(self, individual_contributions):
        """Sets the individual_contributions of this CandidateCommitteeTotalsPresidential.


        :param individual_contributions: The individual_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._individual_contributions = individual_contributions

    @property
    def individual_itemized_contributions(self):
        """Gets the individual_itemized_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less.  # noqa: E501

        :return: The individual_itemized_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._individual_itemized_contributions

    @individual_itemized_contributions.setter
    def individual_itemized_contributions(self, individual_itemized_contributions):
        """Sets the individual_itemized_contributions of this CandidateCommitteeTotalsPresidential.

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less.  # noqa: E501

        :param individual_itemized_contributions: The individual_itemized_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._individual_itemized_contributions = individual_itemized_contributions

    @property
    def individual_unitemized_contributions(self):
        """Gets the individual_unitemized_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total.  # noqa: E501

        :return: The individual_unitemized_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._individual_unitemized_contributions

    @individual_unitemized_contributions.setter
    def individual_unitemized_contributions(self, individual_unitemized_contributions):
        """Sets the individual_unitemized_contributions of this CandidateCommitteeTotalsPresidential.

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total.  # noqa: E501

        :param individual_unitemized_contributions: The individual_unitemized_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._individual_unitemized_contributions = individual_unitemized_contributions

    @property
    def last_beginning_image_number(self):
        """Gets the last_beginning_image_number of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The last_beginning_image_number of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: str
        """
        return self._last_beginning_image_number

    @last_beginning_image_number.setter
    def last_beginning_image_number(self, last_beginning_image_number):
        """Sets the last_beginning_image_number of this CandidateCommitteeTotalsPresidential.


        :param last_beginning_image_number: The last_beginning_image_number of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: str
        """

        self._last_beginning_image_number = last_beginning_image_number

    @property
    def last_cash_on_hand_end_period(self):
        """Gets the last_cash_on_hand_end_period of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The last_cash_on_hand_end_period of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._last_cash_on_hand_end_period

    @last_cash_on_hand_end_period.setter
    def last_cash_on_hand_end_period(self, last_cash_on_hand_end_period):
        """Sets the last_cash_on_hand_end_period of this CandidateCommitteeTotalsPresidential.


        :param last_cash_on_hand_end_period: The last_cash_on_hand_end_period of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._last_cash_on_hand_end_period = last_cash_on_hand_end_period

    @property
    def last_debts_owed_by_committee(self):
        """Gets the last_debts_owed_by_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The last_debts_owed_by_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._last_debts_owed_by_committee

    @last_debts_owed_by_committee.setter
    def last_debts_owed_by_committee(self, last_debts_owed_by_committee):
        """Sets the last_debts_owed_by_committee of this CandidateCommitteeTotalsPresidential.


        :param last_debts_owed_by_committee: The last_debts_owed_by_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._last_debts_owed_by_committee = last_debts_owed_by_committee

    @property
    def last_debts_owed_to_committee(self):
        """Gets the last_debts_owed_to_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The last_debts_owed_to_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._last_debts_owed_to_committee

    @last_debts_owed_to_committee.setter
    def last_debts_owed_to_committee(self, last_debts_owed_to_committee):
        """Sets the last_debts_owed_to_committee of this CandidateCommitteeTotalsPresidential.


        :param last_debts_owed_to_committee: The last_debts_owed_to_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._last_debts_owed_to_committee = last_debts_owed_to_committee

    @property
    def last_report_type_full(self):
        """Gets the last_report_type_full of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The last_report_type_full of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: str
        """
        return self._last_report_type_full

    @last_report_type_full.setter
    def last_report_type_full(self, last_report_type_full):
        """Sets the last_report_type_full of this CandidateCommitteeTotalsPresidential.


        :param last_report_type_full: The last_report_type_full of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: str
        """

        self._last_report_type_full = last_report_type_full

    @property
    def last_report_year(self):
        """Gets the last_report_year of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The last_report_year of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: int
        """
        return self._last_report_year

    @last_report_year.setter
    def last_report_year(self, last_report_year):
        """Sets the last_report_year of this CandidateCommitteeTotalsPresidential.


        :param last_report_year: The last_report_year of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: int
        """

        self._last_report_year = last_report_year

    @property
    def loan_repayments_made(self):
        """Gets the loan_repayments_made of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The loan_repayments_made of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_made

    @loan_repayments_made.setter
    def loan_repayments_made(self, loan_repayments_made):
        """Sets the loan_repayments_made of this CandidateCommitteeTotalsPresidential.


        :param loan_repayments_made: The loan_repayments_made of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._loan_repayments_made = loan_repayments_made

    @property
    def loans_received(self):
        """Gets the loans_received of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The loans_received of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._loans_received

    @loans_received.setter
    def loans_received(self, loans_received):
        """Sets the loans_received of this CandidateCommitteeTotalsPresidential.


        :param loans_received: The loans_received of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._loans_received = loans_received

    @property
    def loans_received_from_candidate(self):
        """Gets the loans_received_from_candidate of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The loans_received_from_candidate of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._loans_received_from_candidate

    @loans_received_from_candidate.setter
    def loans_received_from_candidate(self, loans_received_from_candidate):
        """Sets the loans_received_from_candidate of this CandidateCommitteeTotalsPresidential.


        :param loans_received_from_candidate: The loans_received_from_candidate of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._loans_received_from_candidate = loans_received_from_candidate

    @property
    def net_contributions(self):
        """Gets the net_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The net_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._net_contributions

    @net_contributions.setter
    def net_contributions(self, net_contributions):
        """Sets the net_contributions of this CandidateCommitteeTotalsPresidential.


        :param net_contributions: The net_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._net_contributions = net_contributions

    @property
    def net_operating_expenditures(self):
        """Gets the net_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The net_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._net_operating_expenditures

    @net_operating_expenditures.setter
    def net_operating_expenditures(self, net_operating_expenditures):
        """Sets the net_operating_expenditures of this CandidateCommitteeTotalsPresidential.


        :param net_operating_expenditures: The net_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._net_operating_expenditures = net_operating_expenditures

    @property
    def offsets_to_fundraising_expenditures(self):
        """Gets the offsets_to_fundraising_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The offsets_to_fundraising_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_fundraising_expenditures

    @offsets_to_fundraising_expenditures.setter
    def offsets_to_fundraising_expenditures(self, offsets_to_fundraising_expenditures):
        """Sets the offsets_to_fundraising_expenditures of this CandidateCommitteeTotalsPresidential.


        :param offsets_to_fundraising_expenditures: The offsets_to_fundraising_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._offsets_to_fundraising_expenditures = offsets_to_fundraising_expenditures

    @property
    def offsets_to_legal_accounting(self):
        """Gets the offsets_to_legal_accounting of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The offsets_to_legal_accounting of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_legal_accounting

    @offsets_to_legal_accounting.setter
    def offsets_to_legal_accounting(self, offsets_to_legal_accounting):
        """Sets the offsets_to_legal_accounting of this CandidateCommitteeTotalsPresidential.


        :param offsets_to_legal_accounting: The offsets_to_legal_accounting of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._offsets_to_legal_accounting = offsets_to_legal_accounting

    @property
    def offsets_to_operating_expenditures(self):
        """Gets the offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_operating_expenditures

    @offsets_to_operating_expenditures.setter
    def offsets_to_operating_expenditures(self, offsets_to_operating_expenditures):
        """Sets the offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.


        :param offsets_to_operating_expenditures: The offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._offsets_to_operating_expenditures = offsets_to_operating_expenditures

    @property
    def operating_expenditures(self):
        """Gets the operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._operating_expenditures

    @operating_expenditures.setter
    def operating_expenditures(self, operating_expenditures):
        """Sets the operating_expenditures of this CandidateCommitteeTotalsPresidential.


        :param operating_expenditures: The operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._operating_expenditures = operating_expenditures

    @property
    def other_disbursements(self):
        """Gets the other_disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The other_disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._other_disbursements

    @other_disbursements.setter
    def other_disbursements(self, other_disbursements):
        """Sets the other_disbursements of this CandidateCommitteeTotalsPresidential.


        :param other_disbursements: The other_disbursements of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._other_disbursements = other_disbursements

    @property
    def other_loans_received(self):
        """Gets the other_loans_received of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The other_loans_received of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._other_loans_received

    @other_loans_received.setter
    def other_loans_received(self, other_loans_received):
        """Sets the other_loans_received of this CandidateCommitteeTotalsPresidential.


        :param other_loans_received: The other_loans_received of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._other_loans_received = other_loans_received

    @property
    def other_political_committee_contributions(self):
        """Gets the other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._other_political_committee_contributions

    @other_political_committee_contributions.setter
    def other_political_committee_contributions(self, other_political_committee_contributions):
        """Sets the other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.


        :param other_political_committee_contributions: The other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._other_political_committee_contributions = other_political_committee_contributions

    @property
    def other_receipts(self):
        """Gets the other_receipts of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The other_receipts of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._other_receipts

    @other_receipts.setter
    def other_receipts(self, other_receipts):
        """Sets the other_receipts of this CandidateCommitteeTotalsPresidential.


        :param other_receipts: The other_receipts of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._other_receipts = other_receipts

    @property
    def political_party_committee_contributions(self):
        """Gets the political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._political_party_committee_contributions

    @political_party_committee_contributions.setter
    def political_party_committee_contributions(self, political_party_committee_contributions):
        """Sets the political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.


        :param political_party_committee_contributions: The political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._political_party_committee_contributions = political_party_committee_contributions

    @property
    def receipts(self):
        """Gets the receipts of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The receipts of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._receipts

    @receipts.setter
    def receipts(self, receipts):
        """Sets the receipts of this CandidateCommitteeTotalsPresidential.


        :param receipts: The receipts of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._receipts = receipts

    @property
    def refunded_individual_contributions(self):
        """Gets the refunded_individual_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The refunded_individual_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._refunded_individual_contributions

    @refunded_individual_contributions.setter
    def refunded_individual_contributions(self, refunded_individual_contributions):
        """Sets the refunded_individual_contributions of this CandidateCommitteeTotalsPresidential.


        :param refunded_individual_contributions: The refunded_individual_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._refunded_individual_contributions = refunded_individual_contributions

    @property
    def refunded_other_political_committee_contributions(self):
        """Gets the refunded_other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The refunded_other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._refunded_other_political_committee_contributions

    @refunded_other_political_committee_contributions.setter
    def refunded_other_political_committee_contributions(self, refunded_other_political_committee_contributions):
        """Sets the refunded_other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.


        :param refunded_other_political_committee_contributions: The refunded_other_political_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._refunded_other_political_committee_contributions = refunded_other_political_committee_contributions

    @property
    def refunded_political_party_committee_contributions(self):
        """Gets the refunded_political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The refunded_political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._refunded_political_party_committee_contributions

    @refunded_political_party_committee_contributions.setter
    def refunded_political_party_committee_contributions(self, refunded_political_party_committee_contributions):
        """Sets the refunded_political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.


        :param refunded_political_party_committee_contributions: The refunded_political_party_committee_contributions of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._refunded_political_party_committee_contributions = refunded_political_party_committee_contributions

    @property
    def repayments_loans_made_by_candidate(self):
        """Gets the repayments_loans_made_by_candidate of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The repayments_loans_made_by_candidate of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._repayments_loans_made_by_candidate

    @repayments_loans_made_by_candidate.setter
    def repayments_loans_made_by_candidate(self, repayments_loans_made_by_candidate):
        """Sets the repayments_loans_made_by_candidate of this CandidateCommitteeTotalsPresidential.


        :param repayments_loans_made_by_candidate: The repayments_loans_made_by_candidate of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._repayments_loans_made_by_candidate = repayments_loans_made_by_candidate

    @property
    def repayments_other_loans(self):
        """Gets the repayments_other_loans of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The repayments_other_loans of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._repayments_other_loans

    @repayments_other_loans.setter
    def repayments_other_loans(self, repayments_other_loans):
        """Sets the repayments_other_loans of this CandidateCommitteeTotalsPresidential.


        :param repayments_other_loans: The repayments_other_loans of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._repayments_other_loans = repayments_other_loans

    @property
    def total_offsets_to_operating_expenditures(self):
        """Gets the total_offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The total_offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._total_offsets_to_operating_expenditures

    @total_offsets_to_operating_expenditures.setter
    def total_offsets_to_operating_expenditures(self, total_offsets_to_operating_expenditures):
        """Sets the total_offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.


        :param total_offsets_to_operating_expenditures: The total_offsets_to_operating_expenditures of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._total_offsets_to_operating_expenditures = total_offsets_to_operating_expenditures

    @property
    def transaction_coverage_date(self):
        """Gets the transaction_coverage_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The transaction_coverage_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: datetime
        """
        return self._transaction_coverage_date

    @transaction_coverage_date.setter
    def transaction_coverage_date(self, transaction_coverage_date):
        """Sets the transaction_coverage_date of this CandidateCommitteeTotalsPresidential.


        :param transaction_coverage_date: The transaction_coverage_date of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: datetime
        """

        self._transaction_coverage_date = transaction_coverage_date

    @property
    def transfers_from_affiliated_committee(self):
        """Gets the transfers_from_affiliated_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The transfers_from_affiliated_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_affiliated_committee

    @transfers_from_affiliated_committee.setter
    def transfers_from_affiliated_committee(self, transfers_from_affiliated_committee):
        """Sets the transfers_from_affiliated_committee of this CandidateCommitteeTotalsPresidential.


        :param transfers_from_affiliated_committee: The transfers_from_affiliated_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._transfers_from_affiliated_committee = transfers_from_affiliated_committee

    @property
    def transfers_to_other_authorized_committee(self):
        """Gets the transfers_to_other_authorized_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501


        :return: The transfers_to_other_authorized_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :rtype: float
        """
        return self._transfers_to_other_authorized_committee

    @transfers_to_other_authorized_committee.setter
    def transfers_to_other_authorized_committee(self, transfers_to_other_authorized_committee):
        """Sets the transfers_to_other_authorized_committee of this CandidateCommitteeTotalsPresidential.


        :param transfers_to_other_authorized_committee: The transfers_to_other_authorized_committee of this CandidateCommitteeTotalsPresidential.  # noqa: E501
        :type: float
        """

        self._transfers_to_other_authorized_committee = transfers_to_other_authorized_committee

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CandidateCommitteeTotalsPresidential):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CandidateCommitteeTotalsPresidential):
            return True

        return self.to_dict() != other.to_dict()
