# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CandidateHistoryTotal(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'active_through': 'int',
        'address_city': 'str',
        'address_state': 'str',
        'address_street_1': 'str',
        'address_street_2': 'str',
        'address_zip': 'str',
        'candidate_election_year': 'int',
        'candidate_id': 'str',
        'candidate_inactive': 'bool',
        'candidate_status': 'str',
        'cash_on_hand_end_period': 'float',
        'coverage_end_date': 'date',
        'coverage_start_date': 'date',
        'cycle': 'int',
        'cycles': 'list[int]',
        'debts_owed_by_committee': 'float',
        'disbursements': 'float',
        'district': 'str',
        'district_number': 'int',
        'election_districts': 'list[str]',
        'election_year': 'int',
        'election_years': 'list[int]',
        'fec_cycles_in_election': 'list[int]',
        'federal_funds_flag': 'bool',
        'first_file_date': 'date',
        'flags': 'str',
        'has_raised_funds': 'bool',
        'incumbent_challenge': 'str',
        'incumbent_challenge_full': 'str',
        'is_election': 'bool',
        'last_f2_date': 'date',
        'last_file_date': 'date',
        'load_date': 'datetime',
        'name': 'str',
        'office': 'str',
        'office_full': 'str',
        'party': 'str',
        'party_full': 'str',
        'receipts': 'float',
        'rounded_election_years': 'list[int]',
        'state': 'str',
        'two_year_period': 'int'
    }

    attribute_map = {
        'active_through': 'active_through',
        'address_city': 'address_city',
        'address_state': 'address_state',
        'address_street_1': 'address_street_1',
        'address_street_2': 'address_street_2',
        'address_zip': 'address_zip',
        'candidate_election_year': 'candidate_election_year',
        'candidate_id': 'candidate_id',
        'candidate_inactive': 'candidate_inactive',
        'candidate_status': 'candidate_status',
        'cash_on_hand_end_period': 'cash_on_hand_end_period',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'cycle': 'cycle',
        'cycles': 'cycles',
        'debts_owed_by_committee': 'debts_owed_by_committee',
        'disbursements': 'disbursements',
        'district': 'district',
        'district_number': 'district_number',
        'election_districts': 'election_districts',
        'election_year': 'election_year',
        'election_years': 'election_years',
        'fec_cycles_in_election': 'fec_cycles_in_election',
        'federal_funds_flag': 'federal_funds_flag',
        'first_file_date': 'first_file_date',
        'flags': 'flags',
        'has_raised_funds': 'has_raised_funds',
        'incumbent_challenge': 'incumbent_challenge',
        'incumbent_challenge_full': 'incumbent_challenge_full',
        'is_election': 'is_election',
        'last_f2_date': 'last_f2_date',
        'last_file_date': 'last_file_date',
        'load_date': 'load_date',
        'name': 'name',
        'office': 'office',
        'office_full': 'office_full',
        'party': 'party',
        'party_full': 'party_full',
        'receipts': 'receipts',
        'rounded_election_years': 'rounded_election_years',
        'state': 'state',
        'two_year_period': 'two_year_period'
    }

    def __init__(self, active_through=None, address_city=None, address_state=None, address_street_1=None, address_street_2=None, address_zip=None, candidate_election_year=None, candidate_id=None, candidate_inactive=None, candidate_status=None, cash_on_hand_end_period=None, coverage_end_date=None, coverage_start_date=None, cycle=None, cycles=None, debts_owed_by_committee=None, disbursements=None, district=None, district_number=None, election_districts=None, election_year=None, election_years=None, fec_cycles_in_election=None, federal_funds_flag=None, first_file_date=None, flags=None, has_raised_funds=None, incumbent_challenge=None, incumbent_challenge_full=None, is_election=None, last_f2_date=None, last_file_date=None, load_date=None, name=None, office=None, office_full=None, party=None, party_full=None, receipts=None, rounded_election_years=None, state=None, two_year_period=None, local_vars_configuration=None):  # noqa: E501
        """CandidateHistoryTotal - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._active_through = None
        self._address_city = None
        self._address_state = None
        self._address_street_1 = None
        self._address_street_2 = None
        self._address_zip = None
        self._candidate_election_year = None
        self._candidate_id = None
        self._candidate_inactive = None
        self._candidate_status = None
        self._cash_on_hand_end_period = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._cycle = None
        self._cycles = None
        self._debts_owed_by_committee = None
        self._disbursements = None
        self._district = None
        self._district_number = None
        self._election_districts = None
        self._election_year = None
        self._election_years = None
        self._fec_cycles_in_election = None
        self._federal_funds_flag = None
        self._first_file_date = None
        self._flags = None
        self._has_raised_funds = None
        self._incumbent_challenge = None
        self._incumbent_challenge_full = None
        self._is_election = None
        self._last_f2_date = None
        self._last_file_date = None
        self._load_date = None
        self._name = None
        self._office = None
        self._office_full = None
        self._party = None
        self._party_full = None
        self._receipts = None
        self._rounded_election_years = None
        self._state = None
        self._two_year_period = None
        self.discriminator = None

        self.active_through = active_through
        self.address_city = address_city
        self.address_state = address_state
        self.address_street_1 = address_street_1
        self.address_street_2 = address_street_2
        self.address_zip = address_zip
        self.candidate_election_year = candidate_election_year
        self.candidate_id = candidate_id
        self.candidate_inactive = candidate_inactive
        self.candidate_status = candidate_status
        self.cash_on_hand_end_period = cash_on_hand_end_period
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        self.cycle = cycle
        self.cycles = cycles
        self.debts_owed_by_committee = debts_owed_by_committee
        self.disbursements = disbursements
        self.district = district
        self.district_number = district_number
        self.election_districts = election_districts
        if election_year is not None:
            self.election_year = election_year
        self.election_years = election_years
        self.fec_cycles_in_election = fec_cycles_in_election
        self.federal_funds_flag = federal_funds_flag
        self.first_file_date = first_file_date
        self.flags = flags
        self.has_raised_funds = has_raised_funds
        self.incumbent_challenge = incumbent_challenge
        self.incumbent_challenge_full = incumbent_challenge_full
        self.is_election = is_election
        self.last_f2_date = last_f2_date
        self.last_file_date = last_file_date
        self.load_date = load_date
        self.name = name
        self.office = office
        self.office_full = office_full
        self.party = party
        self.party_full = party_full
        self.receipts = receipts
        self.rounded_election_years = rounded_election_years
        self.state = state
        self.two_year_period = two_year_period

    @property
    def active_through(self):
        """Gets the active_through of this CandidateHistoryTotal.  # noqa: E501

        Last year a candidate was active. This field is specific to the candidate_id so if the same person runs for another office, there may be a different record for them.  # noqa: E501

        :return: The active_through of this CandidateHistoryTotal.  # noqa: E501
        :rtype: int
        """
        return self._active_through

    @active_through.setter
    def active_through(self, active_through):
        """Sets the active_through of this CandidateHistoryTotal.

        Last year a candidate was active. This field is specific to the candidate_id so if the same person runs for another office, there may be a different record for them.  # noqa: E501

        :param active_through: The active_through of this CandidateHistoryTotal.  # noqa: E501
        :type: int
        """

        self._active_through = active_through

    @property
    def address_city(self):
        """Gets the address_city of this CandidateHistoryTotal.  # noqa: E501

        City of candidate's address, as reported on their Form 2.  # noqa: E501

        :return: The address_city of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._address_city

    @address_city.setter
    def address_city(self, address_city):
        """Sets the address_city of this CandidateHistoryTotal.

        City of candidate's address, as reported on their Form 2.  # noqa: E501

        :param address_city: The address_city of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                address_city is not None and len(address_city) > 100):
            raise ValueError('Invalid value for `address_city`, length must be less than or equal to `100`')  # noqa: E501

        self._address_city = address_city

    @property
    def address_state(self):
        """Gets the address_state of this CandidateHistoryTotal.  # noqa: E501

        State of candidate's address, as reported on their Form 2.  # noqa: E501

        :return: The address_state of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._address_state

    @address_state.setter
    def address_state(self, address_state):
        """Sets the address_state of this CandidateHistoryTotal.

        State of candidate's address, as reported on their Form 2.  # noqa: E501

        :param address_state: The address_state of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                address_state is not None and len(address_state) > 2):
            raise ValueError('Invalid value for `address_state`, length must be less than or equal to `2`')  # noqa: E501

        self._address_state = address_state

    @property
    def address_street_1(self):
        """Gets the address_street_1 of this CandidateHistoryTotal.  # noqa: E501

        Street of candidate's address, as reported on their Form 2.  # noqa: E501

        :return: The address_street_1 of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._address_street_1

    @address_street_1.setter
    def address_street_1(self, address_street_1):
        """Sets the address_street_1 of this CandidateHistoryTotal.

        Street of candidate's address, as reported on their Form 2.  # noqa: E501

        :param address_street_1: The address_street_1 of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                address_street_1 is not None and len(address_street_1) > 200):
            raise ValueError('Invalid value for `address_street_1`, length must be less than or equal to `200`')  # noqa: E501

        self._address_street_1 = address_street_1

    @property
    def address_street_2(self):
        """Gets the address_street_2 of this CandidateHistoryTotal.  # noqa: E501

        Additional street information of candidate's address, as reported on their Form 2.  # noqa: E501

        :return: The address_street_2 of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._address_street_2

    @address_street_2.setter
    def address_street_2(self, address_street_2):
        """Sets the address_street_2 of this CandidateHistoryTotal.

        Additional street information of candidate's address, as reported on their Form 2.  # noqa: E501

        :param address_street_2: The address_street_2 of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                address_street_2 is not None and len(address_street_2) > 200):
            raise ValueError('Invalid value for `address_street_2`, length must be less than or equal to `200`')  # noqa: E501

        self._address_street_2 = address_street_2

    @property
    def address_zip(self):
        """Gets the address_zip of this CandidateHistoryTotal.  # noqa: E501

        Zip code of candidate's address, as reported on their Form 2.  # noqa: E501

        :return: The address_zip of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._address_zip

    @address_zip.setter
    def address_zip(self, address_zip):
        """Sets the address_zip of this CandidateHistoryTotal.

        Zip code of candidate's address, as reported on their Form 2.  # noqa: E501

        :param address_zip: The address_zip of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                address_zip is not None and len(address_zip) > 10):
            raise ValueError('Invalid value for `address_zip`, length must be less than or equal to `10`')  # noqa: E501

        self._address_zip = address_zip

    @property
    def candidate_election_year(self):
        """Gets the candidate_election_year of this CandidateHistoryTotal.  # noqa: E501

        The last year of the cycle for this election.  # noqa: E501

        :return: The candidate_election_year of this CandidateHistoryTotal.  # noqa: E501
        :rtype: int
        """
        return self._candidate_election_year

    @candidate_election_year.setter
    def candidate_election_year(self, candidate_election_year):
        """Sets the candidate_election_year of this CandidateHistoryTotal.

        The last year of the cycle for this election.  # noqa: E501

        :param candidate_election_year: The candidate_election_year of this CandidateHistoryTotal.  # noqa: E501
        :type: int
        """

        self._candidate_election_year = candidate_election_year

    @property
    def candidate_id(self):
        """Gets the candidate_id of this CandidateHistoryTotal.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this CandidateHistoryTotal.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and candidate_id is None:  # noqa: E501
            raise ValueError('Invalid value for `candidate_id`, must not be `None`')  # noqa: E501

        self._candidate_id = candidate_id

    @property
    def candidate_inactive(self):
        """Gets the candidate_inactive of this CandidateHistoryTotal.  # noqa: E501

         True indicates that a candidate is inactive.   # noqa: E501

        :return: The candidate_inactive of this CandidateHistoryTotal.  # noqa: E501
        :rtype: bool
        """
        return self._candidate_inactive

    @candidate_inactive.setter
    def candidate_inactive(self, candidate_inactive):
        """Sets the candidate_inactive of this CandidateHistoryTotal.

         True indicates that a candidate is inactive.   # noqa: E501

        :param candidate_inactive: The candidate_inactive of this CandidateHistoryTotal.  # noqa: E501
        :type: bool
        """

        self._candidate_inactive = candidate_inactive

    @property
    def candidate_status(self):
        """Gets the candidate_status of this CandidateHistoryTotal.  # noqa: E501

        One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate   # noqa: E501

        :return: The candidate_status of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._candidate_status

    @candidate_status.setter
    def candidate_status(self, candidate_status):
        """Sets the candidate_status of this CandidateHistoryTotal.

        One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate   # noqa: E501

        :param candidate_status: The candidate_status of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                candidate_status is not None and len(candidate_status) > 1):
            raise ValueError('Invalid value for `candidate_status`, length must be less than or equal to `1`')  # noqa: E501

        self._candidate_status = candidate_status

    @property
    def cash_on_hand_end_period(self):
        """Gets the cash_on_hand_end_period of this CandidateHistoryTotal.  # noqa: E501


        :return: The cash_on_hand_end_period of this CandidateHistoryTotal.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_end_period

    @cash_on_hand_end_period.setter
    def cash_on_hand_end_period(self, cash_on_hand_end_period):
        """Sets the cash_on_hand_end_period of this CandidateHistoryTotal.


        :param cash_on_hand_end_period: The cash_on_hand_end_period of this CandidateHistoryTotal.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_end_period = cash_on_hand_end_period

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this CandidateHistoryTotal.  # noqa: E501

        Ending date of the reporting period  # noqa: E501

        :return: The coverage_end_date of this CandidateHistoryTotal.  # noqa: E501
        :rtype: date
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this CandidateHistoryTotal.

        Ending date of the reporting period  # noqa: E501

        :param coverage_end_date: The coverage_end_date of this CandidateHistoryTotal.  # noqa: E501
        :type: date
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this CandidateHistoryTotal.  # noqa: E501

        Beginning date of the reporting period  # noqa: E501

        :return: The coverage_start_date of this CandidateHistoryTotal.  # noqa: E501
        :rtype: date
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this CandidateHistoryTotal.

        Beginning date of the reporting period  # noqa: E501

        :param coverage_start_date: The coverage_start_date of this CandidateHistoryTotal.  # noqa: E501
        :type: date
        """

        self._coverage_start_date = coverage_start_date

    @property
    def cycle(self):
        """Gets the cycle of this CandidateHistoryTotal.  # noqa: E501


        :return: The cycle of this CandidateHistoryTotal.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CandidateHistoryTotal.


        :param cycle: The cycle of this CandidateHistoryTotal.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and cycle is None:  # noqa: E501
            raise ValueError('Invalid value for `cycle`, must not be `None`')  # noqa: E501

        self._cycle = cycle

    @property
    def cycles(self):
        """Gets the cycles of this CandidateHistoryTotal.  # noqa: E501

         Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.   # noqa: E501

        :return: The cycles of this CandidateHistoryTotal.  # noqa: E501
        :rtype: list[int]
        """
        return self._cycles

    @cycles.setter
    def cycles(self, cycles):
        """Sets the cycles of this CandidateHistoryTotal.

         Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.   # noqa: E501

        :param cycles: The cycles of this CandidateHistoryTotal.  # noqa: E501
        :type: list[int]
        """

        self._cycles = cycles

    @property
    def debts_owed_by_committee(self):
        """Gets the debts_owed_by_committee of this CandidateHistoryTotal.  # noqa: E501


        :return: The debts_owed_by_committee of this CandidateHistoryTotal.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_by_committee

    @debts_owed_by_committee.setter
    def debts_owed_by_committee(self, debts_owed_by_committee):
        """Sets the debts_owed_by_committee of this CandidateHistoryTotal.


        :param debts_owed_by_committee: The debts_owed_by_committee of this CandidateHistoryTotal.  # noqa: E501
        :type: float
        """

        self._debts_owed_by_committee = debts_owed_by_committee

    @property
    def disbursements(self):
        """Gets the disbursements of this CandidateHistoryTotal.  # noqa: E501


        :return: The disbursements of this CandidateHistoryTotal.  # noqa: E501
        :rtype: float
        """
        return self._disbursements

    @disbursements.setter
    def disbursements(self, disbursements):
        """Sets the disbursements of this CandidateHistoryTotal.


        :param disbursements: The disbursements of this CandidateHistoryTotal.  # noqa: E501
        :type: float
        """

        self._disbursements = disbursements

    @property
    def district(self):
        """Gets the district of this CandidateHistoryTotal.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The district of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._district

    @district.setter
    def district(self, district):
        """Sets the district of this CandidateHistoryTotal.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param district: The district of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                district is not None and len(district) > 2):
            raise ValueError('Invalid value for `district`, length must be less than or equal to `2`')  # noqa: E501

        self._district = district

    @property
    def district_number(self):
        """Gets the district_number of this CandidateHistoryTotal.  # noqa: E501

        One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate   # noqa: E501

        :return: The district_number of this CandidateHistoryTotal.  # noqa: E501
        :rtype: int
        """
        return self._district_number

    @district_number.setter
    def district_number(self, district_number):
        """Sets the district_number of this CandidateHistoryTotal.

        One-letter code explaining if the candidate is:         - C present candidate         - F future candidate         - N not yet a candidate         - P prior candidate   # noqa: E501

        :param district_number: The district_number of this CandidateHistoryTotal.  # noqa: E501
        :type: int
        """

        self._district_number = district_number

    @property
    def election_districts(self):
        """Gets the election_districts of this CandidateHistoryTotal.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The election_districts of this CandidateHistoryTotal.  # noqa: E501
        :rtype: list[str]
        """
        return self._election_districts

    @election_districts.setter
    def election_districts(self, election_districts):
        """Sets the election_districts of this CandidateHistoryTotal.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param election_districts: The election_districts of this CandidateHistoryTotal.  # noqa: E501
        :type: list[str]
        """

        self._election_districts = election_districts

    @property
    def election_year(self):
        """Gets the election_year of this CandidateHistoryTotal.  # noqa: E501


        :return: The election_year of this CandidateHistoryTotal.  # noqa: E501
        :rtype: int
        """
        return self._election_year

    @election_year.setter
    def election_year(self, election_year):
        """Sets the election_year of this CandidateHistoryTotal.


        :param election_year: The election_year of this CandidateHistoryTotal.  # noqa: E501
        :type: int
        """

        self._election_year = election_year

    @property
    def election_years(self):
        """Gets the election_years of this CandidateHistoryTotal.  # noqa: E501

        Years in which a candidate ran for office.  # noqa: E501

        :return: The election_years of this CandidateHistoryTotal.  # noqa: E501
        :rtype: list[int]
        """
        return self._election_years

    @election_years.setter
    def election_years(self, election_years):
        """Sets the election_years of this CandidateHistoryTotal.

        Years in which a candidate ran for office.  # noqa: E501

        :param election_years: The election_years of this CandidateHistoryTotal.  # noqa: E501
        :type: list[int]
        """

        self._election_years = election_years

    @property
    def fec_cycles_in_election(self):
        """Gets the fec_cycles_in_election of this CandidateHistoryTotal.  # noqa: E501

        FEC cycles are included in candidate election years.  # noqa: E501

        :return: The fec_cycles_in_election of this CandidateHistoryTotal.  # noqa: E501
        :rtype: list[int]
        """
        return self._fec_cycles_in_election

    @fec_cycles_in_election.setter
    def fec_cycles_in_election(self, fec_cycles_in_election):
        """Sets the fec_cycles_in_election of this CandidateHistoryTotal.

        FEC cycles are included in candidate election years.  # noqa: E501

        :param fec_cycles_in_election: The fec_cycles_in_election of this CandidateHistoryTotal.  # noqa: E501
        :type: list[int]
        """

        self._fec_cycles_in_election = fec_cycles_in_election

    @property
    def federal_funds_flag(self):
        """Gets the federal_funds_flag of this CandidateHistoryTotal.  # noqa: E501

        A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.  # noqa: E501

        :return: The federal_funds_flag of this CandidateHistoryTotal.  # noqa: E501
        :rtype: bool
        """
        return self._federal_funds_flag

    @federal_funds_flag.setter
    def federal_funds_flag(self, federal_funds_flag):
        """Sets the federal_funds_flag of this CandidateHistoryTotal.

        A boolean the describes if a presidential candidate has accepted federal funds. The flag will be false for House and Senate candidates.  # noqa: E501

        :param federal_funds_flag: The federal_funds_flag of this CandidateHistoryTotal.  # noqa: E501
        :type: bool
        """

        self._federal_funds_flag = federal_funds_flag

    @property
    def first_file_date(self):
        """Gets the first_file_date of this CandidateHistoryTotal.  # noqa: E501

        The day the FEC received the candidate's first filing. This is a F2 candidate registration.  # noqa: E501

        :return: The first_file_date of this CandidateHistoryTotal.  # noqa: E501
        :rtype: date
        """
        return self._first_file_date

    @first_file_date.setter
    def first_file_date(self, first_file_date):
        """Sets the first_file_date of this CandidateHistoryTotal.

        The day the FEC received the candidate's first filing. This is a F2 candidate registration.  # noqa: E501

        :param first_file_date: The first_file_date of this CandidateHistoryTotal.  # noqa: E501
        :type: date
        """

        self._first_file_date = first_file_date

    @property
    def flags(self):
        """Gets the flags of this CandidateHistoryTotal.  # noqa: E501


        :return: The flags of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._flags

    @flags.setter
    def flags(self, flags):
        """Sets the flags of this CandidateHistoryTotal.


        :param flags: The flags of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """

        self._flags = flags

    @property
    def has_raised_funds(self):
        """Gets the has_raised_funds of this CandidateHistoryTotal.  # noqa: E501

        A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)  # noqa: E501

        :return: The has_raised_funds of this CandidateHistoryTotal.  # noqa: E501
        :rtype: bool
        """
        return self._has_raised_funds

    @has_raised_funds.setter
    def has_raised_funds(self, has_raised_funds):
        """Sets the has_raised_funds of this CandidateHistoryTotal.

        A boolean that describes if a candidate's committee has ever received any receipts for their campaign for this particular office. (Candidates have separate candidate IDs for each office.)  # noqa: E501

        :param has_raised_funds: The has_raised_funds of this CandidateHistoryTotal.  # noqa: E501
        :type: bool
        """

        self._has_raised_funds = has_raised_funds

    @property
    def incumbent_challenge(self):
        """Gets the incumbent_challenge of this CandidateHistoryTotal.  # noqa: E501

        One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.  # noqa: E501

        :return: The incumbent_challenge of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._incumbent_challenge

    @incumbent_challenge.setter
    def incumbent_challenge(self, incumbent_challenge):
        """Sets the incumbent_challenge of this CandidateHistoryTotal.

        One-letter code ('I', 'C', 'O') explaining if the candidate is an incumbent, a challenger, or if the seat is open.  # noqa: E501

        :param incumbent_challenge: The incumbent_challenge of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                incumbent_challenge is not None and len(incumbent_challenge) > 1):
            raise ValueError('Invalid value for `incumbent_challenge`, length must be less than or equal to `1`')  # noqa: E501

        self._incumbent_challenge = incumbent_challenge

    @property
    def incumbent_challenge_full(self):
        """Gets the incumbent_challenge_full of this CandidateHistoryTotal.  # noqa: E501

        Explains if the candidate is an incumbent, a challenger, or if the seat is open.  # noqa: E501

        :return: The incumbent_challenge_full of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._incumbent_challenge_full

    @incumbent_challenge_full.setter
    def incumbent_challenge_full(self, incumbent_challenge_full):
        """Sets the incumbent_challenge_full of this CandidateHistoryTotal.

        Explains if the candidate is an incumbent, a challenger, or if the seat is open.  # noqa: E501

        :param incumbent_challenge_full: The incumbent_challenge_full of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                incumbent_challenge_full is not None and len(incumbent_challenge_full) > 10):
            raise ValueError('Invalid value for `incumbent_challenge_full`, length must be less than or equal to `10`')  # noqa: E501

        self._incumbent_challenge_full = incumbent_challenge_full

    @property
    def is_election(self):
        """Gets the is_election of this CandidateHistoryTotal.  # noqa: E501


        :return: The is_election of this CandidateHistoryTotal.  # noqa: E501
        :rtype: bool
        """
        return self._is_election

    @is_election.setter
    def is_election(self, is_election):
        """Sets the is_election of this CandidateHistoryTotal.


        :param is_election: The is_election of this CandidateHistoryTotal.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_election is None:  # noqa: E501
            raise ValueError('Invalid value for `is_election`, must not be `None`')  # noqa: E501

        self._is_election = is_election

    @property
    def last_f2_date(self):
        """Gets the last_f2_date of this CandidateHistoryTotal.  # noqa: E501

        The day the FEC received the candidate's most recent Form 2  # noqa: E501

        :return: The last_f2_date of this CandidateHistoryTotal.  # noqa: E501
        :rtype: date
        """
        return self._last_f2_date

    @last_f2_date.setter
    def last_f2_date(self, last_f2_date):
        """Sets the last_f2_date of this CandidateHistoryTotal.

        The day the FEC received the candidate's most recent Form 2  # noqa: E501

        :param last_f2_date: The last_f2_date of this CandidateHistoryTotal.  # noqa: E501
        :type: date
        """

        self._last_f2_date = last_f2_date

    @property
    def last_file_date(self):
        """Gets the last_file_date of this CandidateHistoryTotal.  # noqa: E501

        The day the FEC received the candidate's most recent filing  # noqa: E501

        :return: The last_file_date of this CandidateHistoryTotal.  # noqa: E501
        :rtype: date
        """
        return self._last_file_date

    @last_file_date.setter
    def last_file_date(self, last_file_date):
        """Sets the last_file_date of this CandidateHistoryTotal.

        The day the FEC received the candidate's most recent filing  # noqa: E501

        :param last_file_date: The last_file_date of this CandidateHistoryTotal.  # noqa: E501
        :type: date
        """

        self._last_file_date = last_file_date

    @property
    def load_date(self):
        """Gets the load_date of this CandidateHistoryTotal.  # noqa: E501

        Date the information was loaded into the FEC systems. This can be affected by reseting systems and other factors, refer to receipt_date for the day that the FEC received the paper or electronic document. Keep in mind that paper filings take more time to process and there can be a lag between load_date and receipt_date. This field can be helpful to identify paper records that have been processed recently.  # noqa: E501

        :return: The load_date of this CandidateHistoryTotal.  # noqa: E501
        :rtype: datetime
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this CandidateHistoryTotal.

        Date the information was loaded into the FEC systems. This can be affected by reseting systems and other factors, refer to receipt_date for the day that the FEC received the paper or electronic document. Keep in mind that paper filings take more time to process and there can be a lag between load_date and receipt_date. This field can be helpful to identify paper records that have been processed recently.  # noqa: E501

        :param load_date: The load_date of this CandidateHistoryTotal.  # noqa: E501
        :type: datetime
        """

        self._load_date = load_date

    @property
    def name(self):
        """Gets the name of this CandidateHistoryTotal.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The name of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CandidateHistoryTotal.

        Name of candidate running for office  # noqa: E501

        :param name: The name of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError('Invalid value for `name`, length must be less than or equal to `100`')  # noqa: E501

        self._name = name

    @property
    def office(self):
        """Gets the office of this CandidateHistoryTotal.  # noqa: E501

        Federal office candidate runs for: H, S or P  # noqa: E501

        :return: The office of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._office

    @office.setter
    def office(self, office):
        """Sets the office of this CandidateHistoryTotal.

        Federal office candidate runs for: H, S or P  # noqa: E501

        :param office: The office of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                office is not None and len(office) > 1):
            raise ValueError('Invalid value for `office`, length must be less than or equal to `1`')  # noqa: E501

        self._office = office

    @property
    def office_full(self):
        """Gets the office_full of this CandidateHistoryTotal.  # noqa: E501

        Federal office candidate runs for: House, Senate or presidential  # noqa: E501

        :return: The office_full of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._office_full

    @office_full.setter
    def office_full(self, office_full):
        """Sets the office_full of this CandidateHistoryTotal.

        Federal office candidate runs for: House, Senate or presidential  # noqa: E501

        :param office_full: The office_full of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                office_full is not None and len(office_full) > 9):
            raise ValueError('Invalid value for `office_full`, length must be less than or equal to `9`')  # noqa: E501

        self._office_full = office_full

    @property
    def party(self):
        """Gets the party of this CandidateHistoryTotal.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The party of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._party

    @party.setter
    def party(self, party):
        """Sets the party of this CandidateHistoryTotal.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param party: The party of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party is not None and len(party) > 3):
            raise ValueError('Invalid value for `party`, length must be less than or equal to `3`')  # noqa: E501

        self._party = party

    @property
    def party_full(self):
        """Gets the party_full of this CandidateHistoryTotal.  # noqa: E501

        Party affiliated with a candidate or committee  # noqa: E501

        :return: The party_full of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._party_full

    @party_full.setter
    def party_full(self, party_full):
        """Sets the party_full of this CandidateHistoryTotal.

        Party affiliated with a candidate or committee  # noqa: E501

        :param party_full: The party_full of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party_full is not None and len(party_full) > 255):
            raise ValueError('Invalid value for `party_full`, length must be less than or equal to `255`')  # noqa: E501

        self._party_full = party_full

    @property
    def receipts(self):
        """Gets the receipts of this CandidateHistoryTotal.  # noqa: E501


        :return: The receipts of this CandidateHistoryTotal.  # noqa: E501
        :rtype: float
        """
        return self._receipts

    @receipts.setter
    def receipts(self, receipts):
        """Sets the receipts of this CandidateHistoryTotal.


        :param receipts: The receipts of this CandidateHistoryTotal.  # noqa: E501
        :type: float
        """

        self._receipts = receipts

    @property
    def rounded_election_years(self):
        """Gets the rounded_election_years of this CandidateHistoryTotal.  # noqa: E501

        Rounded election years in which a candidate ran for office  # noqa: E501

        :return: The rounded_election_years of this CandidateHistoryTotal.  # noqa: E501
        :rtype: list[int]
        """
        return self._rounded_election_years

    @rounded_election_years.setter
    def rounded_election_years(self, rounded_election_years):
        """Sets the rounded_election_years of this CandidateHistoryTotal.

        Rounded election years in which a candidate ran for office  # noqa: E501

        :param rounded_election_years: The rounded_election_years of this CandidateHistoryTotal.  # noqa: E501
        :type: list[int]
        """

        self._rounded_election_years = rounded_election_years

    @property
    def state(self):
        """Gets the state of this CandidateHistoryTotal.  # noqa: E501

        US state or territory where a candidate runs for office  # noqa: E501

        :return: The state of this CandidateHistoryTotal.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CandidateHistoryTotal.

        US state or territory where a candidate runs for office  # noqa: E501

        :param state: The state of this CandidateHistoryTotal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                state is not None and len(state) > 2):
            raise ValueError('Invalid value for `state`, length must be less than or equal to `2`')  # noqa: E501

        self._state = state

    @property
    def two_year_period(self):
        """Gets the two_year_period of this CandidateHistoryTotal.  # noqa: E501

         Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.   # noqa: E501

        :return: The two_year_period of this CandidateHistoryTotal.  # noqa: E501
        :rtype: int
        """
        return self._two_year_period

    @two_year_period.setter
    def two_year_period(self, two_year_period):
        """Sets the two_year_period of this CandidateHistoryTotal.

         Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.   # noqa: E501

        :param two_year_period: The two_year_period of this CandidateHistoryTotal.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and two_year_period is None:  # noqa: E501
            raise ValueError('Invalid value for `two_year_period`, must not be `None`')  # noqa: E501

        self._two_year_period = two_year_period

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CandidateHistoryTotal):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CandidateHistoryTotal):
            return True

        return self.to_dict() != other.to_dict()
