# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class Committee(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'affiliated_committee_name': 'str',
        'candidate_ids': 'list[str]',
        'committee_id': 'str',
        'committee_type': 'str',
        'committee_type_full': 'str',
        'cycles': 'list[int]',
        'designation': 'str',
        'designation_full': 'str',
        'filing_frequency': 'str',
        'first_file_date': 'date',
        'last_f1_date': 'date',
        'last_file_date': 'date',
        'name': 'str',
        'organization_type': 'str',
        'organization_type_full': 'str',
        'party': 'str',
        'party_full': 'str',
        'state': 'str',
        'treasurer_name': 'str'
    }

    attribute_map = {
        'affiliated_committee_name': 'affiliated_committee_name',
        'candidate_ids': 'candidate_ids',
        'committee_id': 'committee_id',
        'committee_type': 'committee_type',
        'committee_type_full': 'committee_type_full',
        'cycles': 'cycles',
        'designation': 'designation',
        'designation_full': 'designation_full',
        'filing_frequency': 'filing_frequency',
        'first_file_date': 'first_file_date',
        'last_f1_date': 'last_f1_date',
        'last_file_date': 'last_file_date',
        'name': 'name',
        'organization_type': 'organization_type',
        'organization_type_full': 'organization_type_full',
        'party': 'party',
        'party_full': 'party_full',
        'state': 'state',
        'treasurer_name': 'treasurer_name'
    }

    def __init__(self, affiliated_committee_name=None, candidate_ids=None, committee_id=None, committee_type=None, committee_type_full=None, cycles=None, designation=None, designation_full=None, filing_frequency=None, first_file_date=None, last_f1_date=None, last_file_date=None, name=None, organization_type=None, organization_type_full=None, party=None, party_full=None, state=None, treasurer_name=None, local_vars_configuration=None):  # noqa: E501
        """Committee - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._affiliated_committee_name = None
        self._candidate_ids = None
        self._committee_id = None
        self._committee_type = None
        self._committee_type_full = None
        self._cycles = None
        self._designation = None
        self._designation_full = None
        self._filing_frequency = None
        self._first_file_date = None
        self._last_f1_date = None
        self._last_file_date = None
        self._name = None
        self._organization_type = None
        self._organization_type_full = None
        self._party = None
        self._party_full = None
        self._state = None
        self._treasurer_name = None
        self.discriminator = None

        self.affiliated_committee_name = affiliated_committee_name
        self.candidate_ids = candidate_ids
        self.committee_id = committee_id
        self.committee_type = committee_type
        self.committee_type_full = committee_type_full
        self.cycles = cycles
        self.designation = designation
        self.designation_full = designation_full
        self.filing_frequency = filing_frequency
        self.first_file_date = first_file_date
        self.last_f1_date = last_f1_date
        self.last_file_date = last_file_date
        self.name = name
        self.organization_type = organization_type
        self.organization_type_full = organization_type_full
        self.party = party
        self.party_full = party_full
        self.state = state
        self.treasurer_name = treasurer_name

    @property
    def affiliated_committee_name(self):
        """Gets the affiliated_committee_name of this Committee.  # noqa: E501

         Affiliated committee or connected organization   # noqa: E501

        :return: The affiliated_committee_name of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._affiliated_committee_name

    @affiliated_committee_name.setter
    def affiliated_committee_name(self, affiliated_committee_name):
        """Sets the affiliated_committee_name of this Committee.

         Affiliated committee or connected organization   # noqa: E501

        :param affiliated_committee_name: The affiliated_committee_name of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                affiliated_committee_name is not None and len(affiliated_committee_name) > 100):
            raise ValueError('Invalid value for `affiliated_committee_name`, length must be less than or equal to `100`')  # noqa: E501

        self._affiliated_committee_name = affiliated_committee_name

    @property
    def candidate_ids(self):
        """Gets the candidate_ids of this Committee.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_ids of this Committee.  # noqa: E501
        :rtype: list[str]
        """
        return self._candidate_ids

    @candidate_ids.setter
    def candidate_ids(self, candidate_ids):
        """Sets the candidate_ids of this Committee.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_ids: The candidate_ids of this Committee.  # noqa: E501
        :type: list[str]
        """

        self._candidate_ids = candidate_ids

    @property
    def committee_id(self):
        """Gets the committee_id of this Committee.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this Committee.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this Committee.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and committee_id is None:  # noqa: E501
            raise ValueError('Invalid value for `committee_id`, must not be `None`')  # noqa: E501

        self._committee_id = committee_id

    @property
    def committee_type(self):
        """Gets the committee_type of this Committee.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this Committee.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type: The committee_type of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                committee_type is not None and len(committee_type) > 1):
            raise ValueError('Invalid value for `committee_type`, length must be less than or equal to `1`')  # noqa: E501

        self._committee_type = committee_type

    @property
    def committee_type_full(self):
        """Gets the committee_type_full of this Committee.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type_full of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._committee_type_full

    @committee_type_full.setter
    def committee_type_full(self, committee_type_full):
        """Sets the committee_type_full of this Committee.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type_full: The committee_type_full of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                committee_type_full is not None and len(committee_type_full) > 50):
            raise ValueError('Invalid value for `committee_type_full`, length must be less than or equal to `50`')  # noqa: E501

        self._committee_type_full = committee_type_full

    @property
    def cycles(self):
        """Gets the cycles of this Committee.  # noqa: E501

         A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycles of this Committee.  # noqa: E501
        :rtype: list[int]
        """
        return self._cycles

    @cycles.setter
    def cycles(self, cycles):
        """Sets the cycles of this Committee.

         A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycles: The cycles of this Committee.  # noqa: E501
        :type: list[int]
        """

        self._cycles = cycles

    @property
    def designation(self):
        """Gets the designation of this Committee.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The designation of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._designation

    @designation.setter
    def designation(self, designation):
        """Sets the designation of this Committee.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param designation: The designation of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                designation is not None and len(designation) > 1):
            raise ValueError('Invalid value for `designation`, length must be less than or equal to `1`')  # noqa: E501

        self._designation = designation

    @property
    def designation_full(self):
        """Gets the designation_full of this Committee.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The designation_full of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._designation_full

    @designation_full.setter
    def designation_full(self, designation_full):
        """Sets the designation_full of this Committee.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param designation_full: The designation_full of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                designation_full is not None and len(designation_full) > 25):
            raise ValueError('Invalid value for `designation_full`, length must be less than or equal to `25`')  # noqa: E501

        self._designation_full = designation_full

    @property
    def filing_frequency(self):
        """Gets the filing_frequency of this Committee.  # noqa: E501

        The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived   # noqa: E501

        :return: The filing_frequency of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._filing_frequency

    @filing_frequency.setter
    def filing_frequency(self, filing_frequency):
        """Sets the filing_frequency of this Committee.

        The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived   # noqa: E501

        :param filing_frequency: The filing_frequency of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                filing_frequency is not None and len(filing_frequency) > 1):
            raise ValueError('Invalid value for `filing_frequency`, length must be less than or equal to `1`')  # noqa: E501

        self._filing_frequency = filing_frequency

    @property
    def first_file_date(self):
        """Gets the first_file_date of this Committee.  # noqa: E501

        The day the FEC received the committee's first filing. This is usually a Form 1 committee registration.  # noqa: E501

        :return: The first_file_date of this Committee.  # noqa: E501
        :rtype: date
        """
        return self._first_file_date

    @first_file_date.setter
    def first_file_date(self, first_file_date):
        """Sets the first_file_date of this Committee.

        The day the FEC received the committee's first filing. This is usually a Form 1 committee registration.  # noqa: E501

        :param first_file_date: The first_file_date of this Committee.  # noqa: E501
        :type: date
        """

        self._first_file_date = first_file_date

    @property
    def last_f1_date(self):
        """Gets the last_f1_date of this Committee.  # noqa: E501

        The day the FEC received the committee's most recent Form 1  # noqa: E501

        :return: The last_f1_date of this Committee.  # noqa: E501
        :rtype: date
        """
        return self._last_f1_date

    @last_f1_date.setter
    def last_f1_date(self, last_f1_date):
        """Sets the last_f1_date of this Committee.

        The day the FEC received the committee's most recent Form 1  # noqa: E501

        :param last_f1_date: The last_f1_date of this Committee.  # noqa: E501
        :type: date
        """

        self._last_f1_date = last_f1_date

    @property
    def last_file_date(self):
        """Gets the last_file_date of this Committee.  # noqa: E501

        The day the FEC received the committee's most recent filing  # noqa: E501

        :return: The last_file_date of this Committee.  # noqa: E501
        :rtype: date
        """
        return self._last_file_date

    @last_file_date.setter
    def last_file_date(self, last_file_date):
        """Sets the last_file_date of this Committee.

        The day the FEC received the committee's most recent filing  # noqa: E501

        :param last_file_date: The last_file_date of this Committee.  # noqa: E501
        :type: date
        """

        self._last_file_date = last_file_date

    @property
    def name(self):
        """Gets the name of this Committee.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The name of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Committee.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param name: The name of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError('Invalid value for `name`, length must be less than or equal to `100`')  # noqa: E501

        self._name = name

    @property
    def organization_type(self):
        """Gets the organization_type of this Committee.  # noqa: E501

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :return: The organization_type of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._organization_type

    @organization_type.setter
    def organization_type(self, organization_type):
        """Sets the organization_type of this Committee.

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :param organization_type: The organization_type of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                organization_type is not None and len(organization_type) > 1):
            raise ValueError('Invalid value for `organization_type`, length must be less than or equal to `1`')  # noqa: E501

        self._organization_type = organization_type

    @property
    def organization_type_full(self):
        """Gets the organization_type_full of this Committee.  # noqa: E501

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :return: The organization_type_full of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._organization_type_full

    @organization_type_full.setter
    def organization_type_full(self, organization_type_full):
        """Sets the organization_type_full of this Committee.

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :param organization_type_full: The organization_type_full of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                organization_type_full is not None and len(organization_type_full) > 100):
            raise ValueError('Invalid value for `organization_type_full`, length must be less than or equal to `100`')  # noqa: E501

        self._organization_type_full = organization_type_full

    @property
    def party(self):
        """Gets the party of this Committee.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The party of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._party

    @party.setter
    def party(self, party):
        """Sets the party of this Committee.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param party: The party of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party is not None and len(party) > 3):
            raise ValueError('Invalid value for `party`, length must be less than or equal to `3`')  # noqa: E501

        self._party = party

    @property
    def party_full(self):
        """Gets the party_full of this Committee.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The party_full of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._party_full

    @party_full.setter
    def party_full(self, party_full):
        """Sets the party_full of this Committee.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param party_full: The party_full of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party_full is not None and len(party_full) > 50):
            raise ValueError('Invalid value for `party_full`, length must be less than or equal to `50`')  # noqa: E501

        self._party_full = party_full

    @property
    def state(self):
        """Gets the state of this Committee.  # noqa: E501

         State of the committee's address as filed on the Form 1   # noqa: E501

        :return: The state of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Committee.

         State of the committee's address as filed on the Form 1   # noqa: E501

        :param state: The state of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                state is not None and len(state) > 2):
            raise ValueError('Invalid value for `state`, length must be less than or equal to `2`')  # noqa: E501

        self._state = state

    @property
    def treasurer_name(self):
        """Gets the treasurer_name of this Committee.  # noqa: E501

        Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.  # noqa: E501

        :return: The treasurer_name of this Committee.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name

    @treasurer_name.setter
    def treasurer_name(self, treasurer_name):
        """Sets the treasurer_name of this Committee.

        Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.  # noqa: E501

        :param treasurer_name: The treasurer_name of this Committee.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name is not None and len(treasurer_name) > 100):
            raise ValueError('Invalid value for `treasurer_name`, length must be less than or equal to `100`')  # noqa: E501

        self._treasurer_name = treasurer_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Committee):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Committee):
            return True

        return self.to_dict() != other.to_dict()
