# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CommitteeDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'affiliated_committee_name': 'str',
        'candidate_ids': 'list[str]',
        'city': 'str',
        'committee_id': 'str',
        'committee_type': 'str',
        'committee_type_full': 'str',
        'custodian_city': 'str',
        'custodian_name_1': 'str',
        'custodian_name_2': 'str',
        'custodian_name_full': 'str',
        'custodian_name_middle': 'str',
        'custodian_name_prefix': 'str',
        'custodian_name_suffix': 'str',
        'custodian_name_title': 'str',
        'custodian_phone': 'str',
        'custodian_state': 'str',
        'custodian_street_1': 'str',
        'custodian_street_2': 'str',
        'custodian_zip': 'str',
        'cycles': 'list[int]',
        'designation': 'str',
        'designation_full': 'str',
        'email': 'str',
        'fax': 'str',
        'filing_frequency': 'str',
        'first_file_date': 'date',
        'form_type': 'str',
        'last_file_date': 'date',
        'leadership_pac': 'str',
        'lobbyist_registrant_pac': 'str',
        'name': 'str',
        'organization_type': 'str',
        'organization_type_full': 'str',
        'party': 'str',
        'party_full': 'str',
        'party_type': 'str',
        'party_type_full': 'str',
        'state': 'str',
        'state_full': 'str',
        'street_1': 'str',
        'street_2': 'str',
        'treasurer_city': 'str',
        'treasurer_name': 'str',
        'treasurer_name_1': 'str',
        'treasurer_name_2': 'str',
        'treasurer_name_middle': 'str',
        'treasurer_name_prefix': 'str',
        'treasurer_name_suffix': 'str',
        'treasurer_name_title': 'str',
        'treasurer_phone': 'str',
        'treasurer_state': 'str',
        'treasurer_street_1': 'str',
        'treasurer_street_2': 'str',
        'treasurer_zip': 'str',
        'website': 'str',
        'zip': 'str'
    }

    attribute_map = {
        'affiliated_committee_name': 'affiliated_committee_name',
        'candidate_ids': 'candidate_ids',
        'city': 'city',
        'committee_id': 'committee_id',
        'committee_type': 'committee_type',
        'committee_type_full': 'committee_type_full',
        'custodian_city': 'custodian_city',
        'custodian_name_1': 'custodian_name_1',
        'custodian_name_2': 'custodian_name_2',
        'custodian_name_full': 'custodian_name_full',
        'custodian_name_middle': 'custodian_name_middle',
        'custodian_name_prefix': 'custodian_name_prefix',
        'custodian_name_suffix': 'custodian_name_suffix',
        'custodian_name_title': 'custodian_name_title',
        'custodian_phone': 'custodian_phone',
        'custodian_state': 'custodian_state',
        'custodian_street_1': 'custodian_street_1',
        'custodian_street_2': 'custodian_street_2',
        'custodian_zip': 'custodian_zip',
        'cycles': 'cycles',
        'designation': 'designation',
        'designation_full': 'designation_full',
        'email': 'email',
        'fax': 'fax',
        'filing_frequency': 'filing_frequency',
        'first_file_date': 'first_file_date',
        'form_type': 'form_type',
        'last_file_date': 'last_file_date',
        'leadership_pac': 'leadership_pac',
        'lobbyist_registrant_pac': 'lobbyist_registrant_pac',
        'name': 'name',
        'organization_type': 'organization_type',
        'organization_type_full': 'organization_type_full',
        'party': 'party',
        'party_full': 'party_full',
        'party_type': 'party_type',
        'party_type_full': 'party_type_full',
        'state': 'state',
        'state_full': 'state_full',
        'street_1': 'street_1',
        'street_2': 'street_2',
        'treasurer_city': 'treasurer_city',
        'treasurer_name': 'treasurer_name',
        'treasurer_name_1': 'treasurer_name_1',
        'treasurer_name_2': 'treasurer_name_2',
        'treasurer_name_middle': 'treasurer_name_middle',
        'treasurer_name_prefix': 'treasurer_name_prefix',
        'treasurer_name_suffix': 'treasurer_name_suffix',
        'treasurer_name_title': 'treasurer_name_title',
        'treasurer_phone': 'treasurer_phone',
        'treasurer_state': 'treasurer_state',
        'treasurer_street_1': 'treasurer_street_1',
        'treasurer_street_2': 'treasurer_street_2',
        'treasurer_zip': 'treasurer_zip',
        'website': 'website',
        'zip': 'zip'
    }

    def __init__(self, affiliated_committee_name=None, candidate_ids=None, city=None, committee_id=None, committee_type=None, committee_type_full=None, custodian_city=None, custodian_name_1=None, custodian_name_2=None, custodian_name_full=None, custodian_name_middle=None, custodian_name_prefix=None, custodian_name_suffix=None, custodian_name_title=None, custodian_phone=None, custodian_state=None, custodian_street_1=None, custodian_street_2=None, custodian_zip=None, cycles=None, designation=None, designation_full=None, email=None, fax=None, filing_frequency=None, first_file_date=None, form_type=None, last_file_date=None, leadership_pac=None, lobbyist_registrant_pac=None, name=None, organization_type=None, organization_type_full=None, party=None, party_full=None, party_type=None, party_type_full=None, state=None, state_full=None, street_1=None, street_2=None, treasurer_city=None, treasurer_name=None, treasurer_name_1=None, treasurer_name_2=None, treasurer_name_middle=None, treasurer_name_prefix=None, treasurer_name_suffix=None, treasurer_name_title=None, treasurer_phone=None, treasurer_state=None, treasurer_street_1=None, treasurer_street_2=None, treasurer_zip=None, website=None, zip=None, local_vars_configuration=None):  # noqa: E501
        """CommitteeDetail - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._affiliated_committee_name = None
        self._candidate_ids = None
        self._city = None
        self._committee_id = None
        self._committee_type = None
        self._committee_type_full = None
        self._custodian_city = None
        self._custodian_name_1 = None
        self._custodian_name_2 = None
        self._custodian_name_full = None
        self._custodian_name_middle = None
        self._custodian_name_prefix = None
        self._custodian_name_suffix = None
        self._custodian_name_title = None
        self._custodian_phone = None
        self._custodian_state = None
        self._custodian_street_1 = None
        self._custodian_street_2 = None
        self._custodian_zip = None
        self._cycles = None
        self._designation = None
        self._designation_full = None
        self._email = None
        self._fax = None
        self._filing_frequency = None
        self._first_file_date = None
        self._form_type = None
        self._last_file_date = None
        self._leadership_pac = None
        self._lobbyist_registrant_pac = None
        self._name = None
        self._organization_type = None
        self._organization_type_full = None
        self._party = None
        self._party_full = None
        self._party_type = None
        self._party_type_full = None
        self._state = None
        self._state_full = None
        self._street_1 = None
        self._street_2 = None
        self._treasurer_city = None
        self._treasurer_name = None
        self._treasurer_name_1 = None
        self._treasurer_name_2 = None
        self._treasurer_name_middle = None
        self._treasurer_name_prefix = None
        self._treasurer_name_suffix = None
        self._treasurer_name_title = None
        self._treasurer_phone = None
        self._treasurer_state = None
        self._treasurer_street_1 = None
        self._treasurer_street_2 = None
        self._treasurer_zip = None
        self._website = None
        self._zip = None
        self.discriminator = None

        self.affiliated_committee_name = affiliated_committee_name
        self.candidate_ids = candidate_ids
        self.city = city
        self.committee_id = committee_id
        self.committee_type = committee_type
        self.committee_type_full = committee_type_full
        self.custodian_city = custodian_city
        self.custodian_name_1 = custodian_name_1
        self.custodian_name_2 = custodian_name_2
        self.custodian_name_full = custodian_name_full
        self.custodian_name_middle = custodian_name_middle
        self.custodian_name_prefix = custodian_name_prefix
        self.custodian_name_suffix = custodian_name_suffix
        self.custodian_name_title = custodian_name_title
        self.custodian_phone = custodian_phone
        self.custodian_state = custodian_state
        self.custodian_street_1 = custodian_street_1
        self.custodian_street_2 = custodian_street_2
        self.custodian_zip = custodian_zip
        self.cycles = cycles
        self.designation = designation
        self.designation_full = designation_full
        self.email = email
        self.fax = fax
        self.filing_frequency = filing_frequency
        self.first_file_date = first_file_date
        self.form_type = form_type
        self.last_file_date = last_file_date
        self.leadership_pac = leadership_pac
        self.lobbyist_registrant_pac = lobbyist_registrant_pac
        self.name = name
        self.organization_type = organization_type
        self.organization_type_full = organization_type_full
        self.party = party
        self.party_full = party_full
        self.party_type = party_type
        self.party_type_full = party_type_full
        self.state = state
        self.state_full = state_full
        self.street_1 = street_1
        self.street_2 = street_2
        self.treasurer_city = treasurer_city
        self.treasurer_name = treasurer_name
        self.treasurer_name_1 = treasurer_name_1
        self.treasurer_name_2 = treasurer_name_2
        self.treasurer_name_middle = treasurer_name_middle
        self.treasurer_name_prefix = treasurer_name_prefix
        self.treasurer_name_suffix = treasurer_name_suffix
        self.treasurer_name_title = treasurer_name_title
        self.treasurer_phone = treasurer_phone
        self.treasurer_state = treasurer_state
        self.treasurer_street_1 = treasurer_street_1
        self.treasurer_street_2 = treasurer_street_2
        self.treasurer_zip = treasurer_zip
        self.website = website
        self.zip = zip

    @property
    def affiliated_committee_name(self):
        """Gets the affiliated_committee_name of this CommitteeDetail.  # noqa: E501

         Affiliated committee or connected organization   # noqa: E501

        :return: The affiliated_committee_name of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._affiliated_committee_name

    @affiliated_committee_name.setter
    def affiliated_committee_name(self, affiliated_committee_name):
        """Sets the affiliated_committee_name of this CommitteeDetail.

         Affiliated committee or connected organization   # noqa: E501

        :param affiliated_committee_name: The affiliated_committee_name of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                affiliated_committee_name is not None and len(affiliated_committee_name) > 100):
            raise ValueError('Invalid value for `affiliated_committee_name`, length must be less than or equal to `100`')  # noqa: E501

        self._affiliated_committee_name = affiliated_committee_name

    @property
    def candidate_ids(self):
        """Gets the candidate_ids of this CommitteeDetail.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_ids of this CommitteeDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._candidate_ids

    @candidate_ids.setter
    def candidate_ids(self, candidate_ids):
        """Sets the candidate_ids of this CommitteeDetail.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_ids: The candidate_ids of this CommitteeDetail.  # noqa: E501
        :type: list[str]
        """

        self._candidate_ids = candidate_ids

    @property
    def city(self):
        """Gets the city of this CommitteeDetail.  # noqa: E501

         City of committee as reported on the Form 1   # noqa: E501

        :return: The city of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this CommitteeDetail.

         City of committee as reported on the Form 1   # noqa: E501

        :param city: The city of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                city is not None and len(city) > 50):
            raise ValueError('Invalid value for `city`, length must be less than or equal to `50`')  # noqa: E501

        self._city = city

    @property
    def committee_id(self):
        """Gets the committee_id of this CommitteeDetail.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this CommitteeDetail.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and committee_id is None:  # noqa: E501
            raise ValueError('Invalid value for `committee_id`, must not be `None`')  # noqa: E501

        self._committee_id = committee_id

    @property
    def committee_type(self):
        """Gets the committee_type of this CommitteeDetail.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this CommitteeDetail.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type: The committee_type of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                committee_type is not None and len(committee_type) > 1):
            raise ValueError('Invalid value for `committee_type`, length must be less than or equal to `1`')  # noqa: E501

        self._committee_type = committee_type

    @property
    def committee_type_full(self):
        """Gets the committee_type_full of this CommitteeDetail.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._committee_type_full

    @committee_type_full.setter
    def committee_type_full(self, committee_type_full):
        """Sets the committee_type_full of this CommitteeDetail.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type_full: The committee_type_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                committee_type_full is not None and len(committee_type_full) > 50):
            raise ValueError('Invalid value for `committee_type_full`, length must be less than or equal to `50`')  # noqa: E501

        self._committee_type_full = committee_type_full

    @property
    def custodian_city(self):
        """Gets the custodian_city of this CommitteeDetail.  # noqa: E501

         City of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_city of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_city

    @custodian_city.setter
    def custodian_city(self, custodian_city):
        """Sets the custodian_city of this CommitteeDetail.

         City of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_city: The custodian_city of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_city is not None and len(custodian_city) > 50):
            raise ValueError('Invalid value for `custodian_city`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_city = custodian_city

    @property
    def custodian_name_1(self):
        """Gets the custodian_name_1 of this CommitteeDetail.  # noqa: E501

         Name 1 of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_1 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_1

    @custodian_name_1.setter
    def custodian_name_1(self, custodian_name_1):
        """Sets the custodian_name_1 of this CommitteeDetail.

         Name 1 of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_1: The custodian_name_1 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_1 is not None and len(custodian_name_1) > 50):
            raise ValueError('Invalid value for `custodian_name_1`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_name_1 = custodian_name_1

    @property
    def custodian_name_2(self):
        """Gets the custodian_name_2 of this CommitteeDetail.  # noqa: E501

         Name 2 of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_2 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_2

    @custodian_name_2.setter
    def custodian_name_2(self, custodian_name_2):
        """Sets the custodian_name_2 of this CommitteeDetail.

         Name 2 of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_2: The custodian_name_2 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_2 is not None and len(custodian_name_2) > 50):
            raise ValueError('Invalid value for `custodian_name_2`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_name_2 = custodian_name_2

    @property
    def custodian_name_full(self):
        """Gets the custodian_name_full of this CommitteeDetail.  # noqa: E501

         Full name of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_full

    @custodian_name_full.setter
    def custodian_name_full(self, custodian_name_full):
        """Sets the custodian_name_full of this CommitteeDetail.

         Full name of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_full: The custodian_name_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_full is not None and len(custodian_name_full) > 100):
            raise ValueError('Invalid value for `custodian_name_full`, length must be less than or equal to `100`')  # noqa: E501

        self._custodian_name_full = custodian_name_full

    @property
    def custodian_name_middle(self):
        """Gets the custodian_name_middle of this CommitteeDetail.  # noqa: E501

         Middle name of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_middle of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_middle

    @custodian_name_middle.setter
    def custodian_name_middle(self, custodian_name_middle):
        """Sets the custodian_name_middle of this CommitteeDetail.

         Middle name of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_middle: The custodian_name_middle of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_middle is not None and len(custodian_name_middle) > 50):
            raise ValueError('Invalid value for `custodian_name_middle`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_name_middle = custodian_name_middle

    @property
    def custodian_name_prefix(self):
        """Gets the custodian_name_prefix of this CommitteeDetail.  # noqa: E501

         Name prefix of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_prefix of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_prefix

    @custodian_name_prefix.setter
    def custodian_name_prefix(self, custodian_name_prefix):
        """Sets the custodian_name_prefix of this CommitteeDetail.

         Name prefix of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_prefix: The custodian_name_prefix of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_prefix is not None and len(custodian_name_prefix) > 50):
            raise ValueError('Invalid value for `custodian_name_prefix`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_name_prefix = custodian_name_prefix

    @property
    def custodian_name_suffix(self):
        """Gets the custodian_name_suffix of this CommitteeDetail.  # noqa: E501

         Suffix name of the committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_suffix of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_suffix

    @custodian_name_suffix.setter
    def custodian_name_suffix(self, custodian_name_suffix):
        """Sets the custodian_name_suffix of this CommitteeDetail.

         Suffix name of the committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_suffix: The custodian_name_suffix of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_suffix is not None and len(custodian_name_suffix) > 50):
            raise ValueError('Invalid value for `custodian_name_suffix`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_name_suffix = custodian_name_suffix

    @property
    def custodian_name_title(self):
        """Gets the custodian_name_title of this CommitteeDetail.  # noqa: E501

         Name title of the committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_name_title of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_name_title

    @custodian_name_title.setter
    def custodian_name_title(self, custodian_name_title):
        """Sets the custodian_name_title of this CommitteeDetail.

         Name title of the committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_name_title: The custodian_name_title of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_name_title is not None and len(custodian_name_title) > 50):
            raise ValueError('Invalid value for `custodian_name_title`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_name_title = custodian_name_title

    @property
    def custodian_phone(self):
        """Gets the custodian_phone of this CommitteeDetail.  # noqa: E501

         Phone number of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_phone of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_phone

    @custodian_phone.setter
    def custodian_phone(self, custodian_phone):
        """Sets the custodian_phone of this CommitteeDetail.

         Phone number of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_phone: The custodian_phone of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_phone is not None and len(custodian_phone) > 15):
            raise ValueError('Invalid value for `custodian_phone`, length must be less than or equal to `15`')  # noqa: E501

        self._custodian_phone = custodian_phone

    @property
    def custodian_state(self):
        """Gets the custodian_state of this CommitteeDetail.  # noqa: E501

         State of committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_state of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_state

    @custodian_state.setter
    def custodian_state(self, custodian_state):
        """Sets the custodian_state of this CommitteeDetail.

         State of committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_state: The custodian_state of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_state is not None and len(custodian_state) > 2):
            raise ValueError('Invalid value for `custodian_state`, length must be less than or equal to `2`')  # noqa: E501

        self._custodian_state = custodian_state

    @property
    def custodian_street_1(self):
        """Gets the custodian_street_1 of this CommitteeDetail.  # noqa: E501

         Street address of the committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_street_1 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_street_1

    @custodian_street_1.setter
    def custodian_street_1(self, custodian_street_1):
        """Sets the custodian_street_1 of this CommitteeDetail.

         Street address of the committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_street_1: The custodian_street_1 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_street_1 is not None and len(custodian_street_1) > 50):
            raise ValueError('Invalid value for `custodian_street_1`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_street_1 = custodian_street_1

    @property
    def custodian_street_2(self):
        """Gets the custodian_street_2 of this CommitteeDetail.  # noqa: E501

         Second line of the street address of the committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_street_2 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_street_2

    @custodian_street_2.setter
    def custodian_street_2(self, custodian_street_2):
        """Sets the custodian_street_2 of this CommitteeDetail.

         Second line of the street address of the committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_street_2: The custodian_street_2 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_street_2 is not None and len(custodian_street_2) > 50):
            raise ValueError('Invalid value for `custodian_street_2`, length must be less than or equal to `50`')  # noqa: E501

        self._custodian_street_2 = custodian_street_2

    @property
    def custodian_zip(self):
        """Gets the custodian_zip of this CommitteeDetail.  # noqa: E501

         Zip code of the committee custodian as reported on the Form 1   # noqa: E501

        :return: The custodian_zip of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._custodian_zip

    @custodian_zip.setter
    def custodian_zip(self, custodian_zip):
        """Sets the custodian_zip of this CommitteeDetail.

         Zip code of the committee custodian as reported on the Form 1   # noqa: E501

        :param custodian_zip: The custodian_zip of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                custodian_zip is not None and len(custodian_zip) > 9):
            raise ValueError('Invalid value for `custodian_zip`, length must be less than or equal to `9`')  # noqa: E501

        self._custodian_zip = custodian_zip

    @property
    def cycles(self):
        """Gets the cycles of this CommitteeDetail.  # noqa: E501

         A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycles of this CommitteeDetail.  # noqa: E501
        :rtype: list[int]
        """
        return self._cycles

    @cycles.setter
    def cycles(self, cycles):
        """Sets the cycles of this CommitteeDetail.

         A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycles: The cycles of this CommitteeDetail.  # noqa: E501
        :type: list[int]
        """

        self._cycles = cycles

    @property
    def designation(self):
        """Gets the designation of this CommitteeDetail.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The designation of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._designation

    @designation.setter
    def designation(self, designation):
        """Sets the designation of this CommitteeDetail.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param designation: The designation of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                designation is not None and len(designation) > 1):
            raise ValueError('Invalid value for `designation`, length must be less than or equal to `1`')  # noqa: E501

        self._designation = designation

    @property
    def designation_full(self):
        """Gets the designation_full of this CommitteeDetail.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The designation_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._designation_full

    @designation_full.setter
    def designation_full(self, designation_full):
        """Sets the designation_full of this CommitteeDetail.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param designation_full: The designation_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                designation_full is not None and len(designation_full) > 25):
            raise ValueError('Invalid value for `designation_full`, length must be less than or equal to `25`')  # noqa: E501

        self._designation_full = designation_full

    @property
    def email(self):
        """Gets the email of this CommitteeDetail.  # noqa: E501

         Email as reported on the Form 1   # noqa: E501

        :return: The email of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this CommitteeDetail.

         Email as reported on the Form 1   # noqa: E501

        :param email: The email of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 50):
            raise ValueError('Invalid value for `email`, length must be less than or equal to `50`')  # noqa: E501

        self._email = email

    @property
    def fax(self):
        """Gets the fax of this CommitteeDetail.  # noqa: E501

         Fax as reported on the Form 1   # noqa: E501

        :return: The fax of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._fax

    @fax.setter
    def fax(self, fax):
        """Sets the fax of this CommitteeDetail.

         Fax as reported on the Form 1   # noqa: E501

        :param fax: The fax of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                fax is not None and len(fax) > 10):
            raise ValueError('Invalid value for `fax`, length must be less than or equal to `10`')  # noqa: E501

        self._fax = fax

    @property
    def filing_frequency(self):
        """Gets the filing_frequency of this CommitteeDetail.  # noqa: E501

        The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived   # noqa: E501

        :return: The filing_frequency of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._filing_frequency

    @filing_frequency.setter
    def filing_frequency(self, filing_frequency):
        """Sets the filing_frequency of this CommitteeDetail.

        The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived   # noqa: E501

        :param filing_frequency: The filing_frequency of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                filing_frequency is not None and len(filing_frequency) > 1):
            raise ValueError('Invalid value for `filing_frequency`, length must be less than or equal to `1`')  # noqa: E501

        self._filing_frequency = filing_frequency

    @property
    def first_file_date(self):
        """Gets the first_file_date of this CommitteeDetail.  # noqa: E501

        The day the FEC received the committee's first filing. This is usually a Form 1 committee registration.  # noqa: E501

        :return: The first_file_date of this CommitteeDetail.  # noqa: E501
        :rtype: date
        """
        return self._first_file_date

    @first_file_date.setter
    def first_file_date(self, first_file_date):
        """Sets the first_file_date of this CommitteeDetail.

        The day the FEC received the committee's first filing. This is usually a Form 1 committee registration.  # noqa: E501

        :param first_file_date: The first_file_date of this CommitteeDetail.  # noqa: E501
        :type: date
        """

        self._first_file_date = first_file_date

    @property
    def form_type(self):
        """Gets the form_type of this CommitteeDetail.  # noqa: E501

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :return: The form_type of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._form_type

    @form_type.setter
    def form_type(self, form_type):
        """Sets the form_type of this CommitteeDetail.

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :param form_type: The form_type of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                form_type is not None and len(form_type) > 3):
            raise ValueError('Invalid value for `form_type`, length must be less than or equal to `3`')  # noqa: E501

        self._form_type = form_type

    @property
    def last_file_date(self):
        """Gets the last_file_date of this CommitteeDetail.  # noqa: E501

        The day the FEC received the committee's most recent filing  # noqa: E501

        :return: The last_file_date of this CommitteeDetail.  # noqa: E501
        :rtype: date
        """
        return self._last_file_date

    @last_file_date.setter
    def last_file_date(self, last_file_date):
        """Sets the last_file_date of this CommitteeDetail.

        The day the FEC received the committee's most recent filing  # noqa: E501

        :param last_file_date: The last_file_date of this CommitteeDetail.  # noqa: E501
        :type: date
        """

        self._last_file_date = last_file_date

    @property
    def leadership_pac(self):
        """Gets the leadership_pac of this CommitteeDetail.  # noqa: E501

         Indicates if the committee is a leadership PAC   # noqa: E501

        :return: The leadership_pac of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._leadership_pac

    @leadership_pac.setter
    def leadership_pac(self, leadership_pac):
        """Sets the leadership_pac of this CommitteeDetail.

         Indicates if the committee is a leadership PAC   # noqa: E501

        :param leadership_pac: The leadership_pac of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                leadership_pac is not None and len(leadership_pac) > 50):
            raise ValueError('Invalid value for `leadership_pac`, length must be less than or equal to `50`')  # noqa: E501

        self._leadership_pac = leadership_pac

    @property
    def lobbyist_registrant_pac(self):
        """Gets the lobbyist_registrant_pac of this CommitteeDetail.  # noqa: E501

         Indicates if the committee is a lobbyist registrant PAC   # noqa: E501

        :return: The lobbyist_registrant_pac of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._lobbyist_registrant_pac

    @lobbyist_registrant_pac.setter
    def lobbyist_registrant_pac(self, lobbyist_registrant_pac):
        """Sets the lobbyist_registrant_pac of this CommitteeDetail.

         Indicates if the committee is a lobbyist registrant PAC   # noqa: E501

        :param lobbyist_registrant_pac: The lobbyist_registrant_pac of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                lobbyist_registrant_pac is not None and len(lobbyist_registrant_pac) > 1):
            raise ValueError('Invalid value for `lobbyist_registrant_pac`, length must be less than or equal to `1`')  # noqa: E501

        self._lobbyist_registrant_pac = lobbyist_registrant_pac

    @property
    def name(self):
        """Gets the name of this CommitteeDetail.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The name of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CommitteeDetail.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param name: The name of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError('Invalid value for `name`, length must be less than or equal to `100`')  # noqa: E501

        self._name = name

    @property
    def organization_type(self):
        """Gets the organization_type of this CommitteeDetail.  # noqa: E501

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :return: The organization_type of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._organization_type

    @organization_type.setter
    def organization_type(self, organization_type):
        """Sets the organization_type of this CommitteeDetail.

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :param organization_type: The organization_type of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                organization_type is not None and len(organization_type) > 1):
            raise ValueError('Invalid value for `organization_type`, length must be less than or equal to `1`')  # noqa: E501

        self._organization_type = organization_type

    @property
    def organization_type_full(self):
        """Gets the organization_type_full of this CommitteeDetail.  # noqa: E501

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :return: The organization_type_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._organization_type_full

    @organization_type_full.setter
    def organization_type_full(self, organization_type_full):
        """Sets the organization_type_full of this CommitteeDetail.

        The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock   # noqa: E501

        :param organization_type_full: The organization_type_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                organization_type_full is not None and len(organization_type_full) > 100):
            raise ValueError('Invalid value for `organization_type_full`, length must be less than or equal to `100`')  # noqa: E501

        self._organization_type_full = organization_type_full

    @property
    def party(self):
        """Gets the party of this CommitteeDetail.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The party of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._party

    @party.setter
    def party(self, party):
        """Sets the party of this CommitteeDetail.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param party: The party of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party is not None and len(party) > 3):
            raise ValueError('Invalid value for `party`, length must be less than or equal to `3`')  # noqa: E501

        self._party = party

    @property
    def party_full(self):
        """Gets the party_full of this CommitteeDetail.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The party_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._party_full

    @party_full.setter
    def party_full(self, party_full):
        """Sets the party_full of this CommitteeDetail.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param party_full: The party_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party_full is not None and len(party_full) > 50):
            raise ValueError('Invalid value for `party_full`, length must be less than or equal to `50`')  # noqa: E501

        self._party_full = party_full

    @property
    def party_type(self):
        """Gets the party_type of this CommitteeDetail.  # noqa: E501

         Code for the type of party the committee is, only if applicable   # noqa: E501

        :return: The party_type of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._party_type

    @party_type.setter
    def party_type(self, party_type):
        """Sets the party_type of this CommitteeDetail.

         Code for the type of party the committee is, only if applicable   # noqa: E501

        :param party_type: The party_type of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party_type is not None and len(party_type) > 3):
            raise ValueError('Invalid value for `party_type`, length must be less than or equal to `3`')  # noqa: E501

        self._party_type = party_type

    @property
    def party_type_full(self):
        """Gets the party_type_full of this CommitteeDetail.  # noqa: E501

         Description of the type of party the committee is, only if applicable   # noqa: E501

        :return: The party_type_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._party_type_full

    @party_type_full.setter
    def party_type_full(self, party_type_full):
        """Sets the party_type_full of this CommitteeDetail.

         Description of the type of party the committee is, only if applicable   # noqa: E501

        :param party_type_full: The party_type_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                party_type_full is not None and len(party_type_full) > 15):
            raise ValueError('Invalid value for `party_type_full`, length must be less than or equal to `15`')  # noqa: E501

        self._party_type_full = party_type_full

    @property
    def state(self):
        """Gets the state of this CommitteeDetail.  # noqa: E501

         State of the committee's address as filed on the Form 1   # noqa: E501

        :return: The state of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CommitteeDetail.

         State of the committee's address as filed on the Form 1   # noqa: E501

        :param state: The state of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                state is not None and len(state) > 2):
            raise ValueError('Invalid value for `state`, length must be less than or equal to `2`')  # noqa: E501

        self._state = state

    @property
    def state_full(self):
        """Gets the state_full of this CommitteeDetail.  # noqa: E501

         State of committee as reported on the Form 1   # noqa: E501

        :return: The state_full of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._state_full

    @state_full.setter
    def state_full(self, state_full):
        """Sets the state_full of this CommitteeDetail.

         State of committee as reported on the Form 1   # noqa: E501

        :param state_full: The state_full of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                state_full is not None and len(state_full) > 50):
            raise ValueError('Invalid value for `state_full`, length must be less than or equal to `50`')  # noqa: E501

        self._state_full = state_full

    @property
    def street_1(self):
        """Gets the street_1 of this CommitteeDetail.  # noqa: E501

         Street address of committee as reported on the Form 1   # noqa: E501

        :return: The street_1 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._street_1

    @street_1.setter
    def street_1(self, street_1):
        """Sets the street_1 of this CommitteeDetail.

         Street address of committee as reported on the Form 1   # noqa: E501

        :param street_1: The street_1 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                street_1 is not None and len(street_1) > 50):
            raise ValueError('Invalid value for `street_1`, length must be less than or equal to `50`')  # noqa: E501

        self._street_1 = street_1

    @property
    def street_2(self):
        """Gets the street_2 of this CommitteeDetail.  # noqa: E501

         Second line of street address of committee as reported on the Form 1   # noqa: E501

        :return: The street_2 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._street_2

    @street_2.setter
    def street_2(self, street_2):
        """Sets the street_2 of this CommitteeDetail.

         Second line of street address of committee as reported on the Form 1   # noqa: E501

        :param street_2: The street_2 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                street_2 is not None and len(street_2) > 50):
            raise ValueError('Invalid value for `street_2`, length must be less than or equal to `50`')  # noqa: E501

        self._street_2 = street_2

    @property
    def treasurer_city(self):
        """Gets the treasurer_city of this CommitteeDetail.  # noqa: E501

         City of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_city of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_city

    @treasurer_city.setter
    def treasurer_city(self, treasurer_city):
        """Sets the treasurer_city of this CommitteeDetail.

         City of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_city: The treasurer_city of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_city is not None and len(treasurer_city) > 50):
            raise ValueError('Invalid value for `treasurer_city`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_city = treasurer_city

    @property
    def treasurer_name(self):
        """Gets the treasurer_name of this CommitteeDetail.  # noqa: E501

        Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.  # noqa: E501

        :return: The treasurer_name of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name

    @treasurer_name.setter
    def treasurer_name(self, treasurer_name):
        """Sets the treasurer_name of this CommitteeDetail.

        Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.  # noqa: E501

        :param treasurer_name: The treasurer_name of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name is not None and len(treasurer_name) > 100):
            raise ValueError('Invalid value for `treasurer_name`, length must be less than or equal to `100`')  # noqa: E501

        self._treasurer_name = treasurer_name

    @property
    def treasurer_name_1(self):
        """Gets the treasurer_name_1 of this CommitteeDetail.  # noqa: E501

         Name 1 of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_name_1 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name_1

    @treasurer_name_1.setter
    def treasurer_name_1(self, treasurer_name_1):
        """Sets the treasurer_name_1 of this CommitteeDetail.

         Name 1 of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_name_1: The treasurer_name_1 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name_1 is not None and len(treasurer_name_1) > 50):
            raise ValueError('Invalid value for `treasurer_name_1`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_name_1 = treasurer_name_1

    @property
    def treasurer_name_2(self):
        """Gets the treasurer_name_2 of this CommitteeDetail.  # noqa: E501

         Name 2 of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_name_2 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name_2

    @treasurer_name_2.setter
    def treasurer_name_2(self, treasurer_name_2):
        """Sets the treasurer_name_2 of this CommitteeDetail.

         Name 2 of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_name_2: The treasurer_name_2 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name_2 is not None and len(treasurer_name_2) > 50):
            raise ValueError('Invalid value for `treasurer_name_2`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_name_2 = treasurer_name_2

    @property
    def treasurer_name_middle(self):
        """Gets the treasurer_name_middle of this CommitteeDetail.  # noqa: E501

         Middle name of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_name_middle of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name_middle

    @treasurer_name_middle.setter
    def treasurer_name_middle(self, treasurer_name_middle):
        """Sets the treasurer_name_middle of this CommitteeDetail.

         Middle name of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_name_middle: The treasurer_name_middle of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name_middle is not None and len(treasurer_name_middle) > 50):
            raise ValueError('Invalid value for `treasurer_name_middle`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_name_middle = treasurer_name_middle

    @property
    def treasurer_name_prefix(self):
        """Gets the treasurer_name_prefix of this CommitteeDetail.  # noqa: E501

         Name Prefix of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_name_prefix of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name_prefix

    @treasurer_name_prefix.setter
    def treasurer_name_prefix(self, treasurer_name_prefix):
        """Sets the treasurer_name_prefix of this CommitteeDetail.

         Name Prefix of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_name_prefix: The treasurer_name_prefix of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name_prefix is not None and len(treasurer_name_prefix) > 50):
            raise ValueError('Invalid value for `treasurer_name_prefix`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_name_prefix = treasurer_name_prefix

    @property
    def treasurer_name_suffix(self):
        """Gets the treasurer_name_suffix of this CommitteeDetail.  # noqa: E501

         Name suffix of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_name_suffix of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name_suffix

    @treasurer_name_suffix.setter
    def treasurer_name_suffix(self, treasurer_name_suffix):
        """Sets the treasurer_name_suffix of this CommitteeDetail.

         Name suffix of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_name_suffix: The treasurer_name_suffix of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name_suffix is not None and len(treasurer_name_suffix) > 50):
            raise ValueError('Invalid value for `treasurer_name_suffix`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_name_suffix = treasurer_name_suffix

    @property
    def treasurer_name_title(self):
        """Gets the treasurer_name_title of this CommitteeDetail.  # noqa: E501

         Name title of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_name_title of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name_title

    @treasurer_name_title.setter
    def treasurer_name_title(self, treasurer_name_title):
        """Sets the treasurer_name_title of this CommitteeDetail.

         Name title of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_name_title: The treasurer_name_title of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_name_title is not None and len(treasurer_name_title) > 50):
            raise ValueError('Invalid value for `treasurer_name_title`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_name_title = treasurer_name_title

    @property
    def treasurer_phone(self):
        """Gets the treasurer_phone of this CommitteeDetail.  # noqa: E501

         Phone of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_phone of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_phone

    @treasurer_phone.setter
    def treasurer_phone(self, treasurer_phone):
        """Sets the treasurer_phone of this CommitteeDetail.

         Phone of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_phone: The treasurer_phone of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_phone is not None and len(treasurer_phone) > 15):
            raise ValueError('Invalid value for `treasurer_phone`, length must be less than or equal to `15`')  # noqa: E501

        self._treasurer_phone = treasurer_phone

    @property
    def treasurer_state(self):
        """Gets the treasurer_state of this CommitteeDetail.  # noqa: E501

         State of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_state of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_state

    @treasurer_state.setter
    def treasurer_state(self, treasurer_state):
        """Sets the treasurer_state of this CommitteeDetail.

         State of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_state: The treasurer_state of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_state is not None and len(treasurer_state) > 50):
            raise ValueError('Invalid value for `treasurer_state`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_state = treasurer_state

    @property
    def treasurer_street_1(self):
        """Gets the treasurer_street_1 of this CommitteeDetail.  # noqa: E501

         Street of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_street_1 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_street_1

    @treasurer_street_1.setter
    def treasurer_street_1(self, treasurer_street_1):
        """Sets the treasurer_street_1 of this CommitteeDetail.

         Street of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_street_1: The treasurer_street_1 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_street_1 is not None and len(treasurer_street_1) > 50):
            raise ValueError('Invalid value for `treasurer_street_1`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_street_1 = treasurer_street_1

    @property
    def treasurer_street_2(self):
        """Gets the treasurer_street_2 of this CommitteeDetail.  # noqa: E501

         Second line of the street of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_street_2 of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_street_2

    @treasurer_street_2.setter
    def treasurer_street_2(self, treasurer_street_2):
        """Sets the treasurer_street_2 of this CommitteeDetail.

         Second line of the street of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_street_2: The treasurer_street_2 of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_street_2 is not None and len(treasurer_street_2) > 50):
            raise ValueError('Invalid value for `treasurer_street_2`, length must be less than or equal to `50`')  # noqa: E501

        self._treasurer_street_2 = treasurer_street_2

    @property
    def treasurer_zip(self):
        """Gets the treasurer_zip of this CommitteeDetail.  # noqa: E501

         Zip code of committee treasurer as reported on the Form 1   # noqa: E501

        :return: The treasurer_zip of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_zip

    @treasurer_zip.setter
    def treasurer_zip(self, treasurer_zip):
        """Sets the treasurer_zip of this CommitteeDetail.

         Zip code of committee treasurer as reported on the Form 1   # noqa: E501

        :param treasurer_zip: The treasurer_zip of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                treasurer_zip is not None and len(treasurer_zip) > 9):
            raise ValueError('Invalid value for `treasurer_zip`, length must be less than or equal to `9`')  # noqa: E501

        self._treasurer_zip = treasurer_zip

    @property
    def website(self):
        """Gets the website of this CommitteeDetail.  # noqa: E501

         Website url as reported on the Form 1   # noqa: E501

        :return: The website of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._website

    @website.setter
    def website(self, website):
        """Sets the website of this CommitteeDetail.

         Website url as reported on the Form 1   # noqa: E501

        :param website: The website of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                website is not None and len(website) > 50):
            raise ValueError('Invalid value for `website`, length must be less than or equal to `50`')  # noqa: E501

        self._website = website

    @property
    def zip(self):
        """Gets the zip of this CommitteeDetail.  # noqa: E501

         Zip code of committee as reported on the Form 1   # noqa: E501

        :return: The zip of this CommitteeDetail.  # noqa: E501
        :rtype: str
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """Sets the zip of this CommitteeDetail.

         Zip code of committee as reported on the Form 1   # noqa: E501

        :param zip: The zip of this CommitteeDetail.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                zip is not None and len(zip) > 9):
            raise ValueError('Invalid value for `zip`, length must be less than or equal to `9`')  # noqa: E501

        self._zip = zip

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommitteeDetail):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommitteeDetail):
            return True

        return self.to_dict() != other.to_dict()
