# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CommitteeReportsHouseSenate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'aggregate_amount_personal_contributions_general': 'float',
        'aggregate_contributions_personal_funds_primary': 'float',
        'all_other_loans_period': 'float',
        'all_other_loans_ytd': 'float',
        'amendment_chain': 'list[float]',
        'amendment_indicator': 'str',
        'amendment_indicator_full': 'str',
        'beginning_image_number': 'str',
        'candidate_contribution_period': 'float',
        'candidate_contribution_ytd': 'float',
        'cash_on_hand_beginning_period': 'float',
        'cash_on_hand_end_period': 'float',
        'committee_id': 'str',
        'committee_name': 'str',
        'committee_type': 'str',
        'coverage_end_date': 'datetime',
        'coverage_start_date': 'datetime',
        'csv_url': 'str',
        'cycle': 'int',
        'debts_owed_by_committee': 'float',
        'debts_owed_to_committee': 'float',
        'document_description': 'str',
        'end_image_number': 'str',
        'fec_file_id': 'str',
        'fec_url': 'str',
        'file_number': 'int',
        'gross_receipt_authorized_committee_general': 'float',
        'gross_receipt_authorized_committee_primary': 'float',
        'gross_receipt_minus_personal_contribution_general': 'float',
        'gross_receipt_minus_personal_contributions_primary': 'float',
        'html_url': 'str',
        'individual_itemized_contributions_period': 'float',
        'individual_itemized_contributions_ytd': 'float',
        'individual_unitemized_contributions_period': 'float',
        'individual_unitemized_contributions_ytd': 'float',
        'is_amended': 'bool',
        'loan_repayments_candidate_loans_period': 'float',
        'loan_repayments_candidate_loans_ytd': 'float',
        'loan_repayments_other_loans_period': 'float',
        'loan_repayments_other_loans_ytd': 'float',
        'loans_made_by_candidate_period': 'float',
        'loans_made_by_candidate_ytd': 'float',
        'means_filed': 'str',
        'most_recent': 'bool',
        'most_recent_file_number': 'float',
        'net_contributions_period': 'float',
        'net_contributions_ytd': 'float',
        'net_operating_expenditures_period': 'float',
        'net_operating_expenditures_ytd': 'float',
        'offsets_to_operating_expenditures_period': 'float',
        'offsets_to_operating_expenditures_ytd': 'float',
        'operating_expenditures_period': 'float',
        'operating_expenditures_ytd': 'float',
        'other_disbursements_period': 'float',
        'other_disbursements_ytd': 'float',
        'other_political_committee_contributions_period': 'float',
        'other_political_committee_contributions_ytd': 'float',
        'other_receipts_period': 'float',
        'other_receipts_ytd': 'float',
        'pdf_url': 'str',
        'political_party_committee_contributions_period': 'float',
        'political_party_committee_contributions_ytd': 'float',
        'previous_file_number': 'float',
        'receipt_date': 'date',
        'refunded_individual_contributions_period': 'float',
        'refunded_individual_contributions_ytd': 'float',
        'refunded_other_political_committee_contributions_period': 'float',
        'refunded_other_political_committee_contributions_ytd': 'float',
        'refunded_political_party_committee_contributions_period': 'float',
        'refunded_political_party_committee_contributions_ytd': 'float',
        'refunds_total_contributions_col_total_ytd': 'float',
        'report_form': 'str',
        'report_type': 'str',
        'report_type_full': 'str',
        'report_year': 'int',
        'subtotal_period': 'float',
        'total_contribution_refunds_col_total_period': 'float',
        'total_contribution_refunds_period': 'float',
        'total_contribution_refunds_ytd': 'float',
        'total_contributions_column_total_period': 'float',
        'total_contributions_period': 'float',
        'total_contributions_ytd': 'float',
        'total_disbursements_period': 'float',
        'total_disbursements_ytd': 'float',
        'total_individual_contributions_period': 'float',
        'total_individual_contributions_ytd': 'float',
        'total_loan_repayments_made_period': 'float',
        'total_loan_repayments_made_ytd': 'float',
        'total_loans_received_period': 'float',
        'total_loans_received_ytd': 'float',
        'total_offsets_to_operating_expenditures_period': 'float',
        'total_offsets_to_operating_expenditures_ytd': 'float',
        'total_operating_expenditures_period': 'float',
        'total_operating_expenditures_ytd': 'float',
        'total_receipts_period': 'float',
        'total_receipts_ytd': 'float',
        'transfers_from_other_authorized_committee_period': 'float',
        'transfers_from_other_authorized_committee_ytd': 'float',
        'transfers_to_other_authorized_committee_period': 'float',
        'transfers_to_other_authorized_committee_ytd': 'float'
    }

    attribute_map = {
        'aggregate_amount_personal_contributions_general': 'aggregate_amount_personal_contributions_general',
        'aggregate_contributions_personal_funds_primary': 'aggregate_contributions_personal_funds_primary',
        'all_other_loans_period': 'all_other_loans_period',
        'all_other_loans_ytd': 'all_other_loans_ytd',
        'amendment_chain': 'amendment_chain',
        'amendment_indicator': 'amendment_indicator',
        'amendment_indicator_full': 'amendment_indicator_full',
        'beginning_image_number': 'beginning_image_number',
        'candidate_contribution_period': 'candidate_contribution_period',
        'candidate_contribution_ytd': 'candidate_contribution_ytd',
        'cash_on_hand_beginning_period': 'cash_on_hand_beginning_period',
        'cash_on_hand_end_period': 'cash_on_hand_end_period',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'committee_type': 'committee_type',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'csv_url': 'csv_url',
        'cycle': 'cycle',
        'debts_owed_by_committee': 'debts_owed_by_committee',
        'debts_owed_to_committee': 'debts_owed_to_committee',
        'document_description': 'document_description',
        'end_image_number': 'end_image_number',
        'fec_file_id': 'fec_file_id',
        'fec_url': 'fec_url',
        'file_number': 'file_number',
        'gross_receipt_authorized_committee_general': 'gross_receipt_authorized_committee_general',
        'gross_receipt_authorized_committee_primary': 'gross_receipt_authorized_committee_primary',
        'gross_receipt_minus_personal_contribution_general': 'gross_receipt_minus_personal_contribution_general',
        'gross_receipt_minus_personal_contributions_primary': 'gross_receipt_minus_personal_contributions_primary',
        'html_url': 'html_url',
        'individual_itemized_contributions_period': 'individual_itemized_contributions_period',
        'individual_itemized_contributions_ytd': 'individual_itemized_contributions_ytd',
        'individual_unitemized_contributions_period': 'individual_unitemized_contributions_period',
        'individual_unitemized_contributions_ytd': 'individual_unitemized_contributions_ytd',
        'is_amended': 'is_amended',
        'loan_repayments_candidate_loans_period': 'loan_repayments_candidate_loans_period',
        'loan_repayments_candidate_loans_ytd': 'loan_repayments_candidate_loans_ytd',
        'loan_repayments_other_loans_period': 'loan_repayments_other_loans_period',
        'loan_repayments_other_loans_ytd': 'loan_repayments_other_loans_ytd',
        'loans_made_by_candidate_period': 'loans_made_by_candidate_period',
        'loans_made_by_candidate_ytd': 'loans_made_by_candidate_ytd',
        'means_filed': 'means_filed',
        'most_recent': 'most_recent',
        'most_recent_file_number': 'most_recent_file_number',
        'net_contributions_period': 'net_contributions_period',
        'net_contributions_ytd': 'net_contributions_ytd',
        'net_operating_expenditures_period': 'net_operating_expenditures_period',
        'net_operating_expenditures_ytd': 'net_operating_expenditures_ytd',
        'offsets_to_operating_expenditures_period': 'offsets_to_operating_expenditures_period',
        'offsets_to_operating_expenditures_ytd': 'offsets_to_operating_expenditures_ytd',
        'operating_expenditures_period': 'operating_expenditures_period',
        'operating_expenditures_ytd': 'operating_expenditures_ytd',
        'other_disbursements_period': 'other_disbursements_period',
        'other_disbursements_ytd': 'other_disbursements_ytd',
        'other_political_committee_contributions_period': 'other_political_committee_contributions_period',
        'other_political_committee_contributions_ytd': 'other_political_committee_contributions_ytd',
        'other_receipts_period': 'other_receipts_period',
        'other_receipts_ytd': 'other_receipts_ytd',
        'pdf_url': 'pdf_url',
        'political_party_committee_contributions_period': 'political_party_committee_contributions_period',
        'political_party_committee_contributions_ytd': 'political_party_committee_contributions_ytd',
        'previous_file_number': 'previous_file_number',
        'receipt_date': 'receipt_date',
        'refunded_individual_contributions_period': 'refunded_individual_contributions_period',
        'refunded_individual_contributions_ytd': 'refunded_individual_contributions_ytd',
        'refunded_other_political_committee_contributions_period': 'refunded_other_political_committee_contributions_period',
        'refunded_other_political_committee_contributions_ytd': 'refunded_other_political_committee_contributions_ytd',
        'refunded_political_party_committee_contributions_period': 'refunded_political_party_committee_contributions_period',
        'refunded_political_party_committee_contributions_ytd': 'refunded_political_party_committee_contributions_ytd',
        'refunds_total_contributions_col_total_ytd': 'refunds_total_contributions_col_total_ytd',
        'report_form': 'report_form',
        'report_type': 'report_type',
        'report_type_full': 'report_type_full',
        'report_year': 'report_year',
        'subtotal_period': 'subtotal_period',
        'total_contribution_refunds_col_total_period': 'total_contribution_refunds_col_total_period',
        'total_contribution_refunds_period': 'total_contribution_refunds_period',
        'total_contribution_refunds_ytd': 'total_contribution_refunds_ytd',
        'total_contributions_column_total_period': 'total_contributions_column_total_period',
        'total_contributions_period': 'total_contributions_period',
        'total_contributions_ytd': 'total_contributions_ytd',
        'total_disbursements_period': 'total_disbursements_period',
        'total_disbursements_ytd': 'total_disbursements_ytd',
        'total_individual_contributions_period': 'total_individual_contributions_period',
        'total_individual_contributions_ytd': 'total_individual_contributions_ytd',
        'total_loan_repayments_made_period': 'total_loan_repayments_made_period',
        'total_loan_repayments_made_ytd': 'total_loan_repayments_made_ytd',
        'total_loans_received_period': 'total_loans_received_period',
        'total_loans_received_ytd': 'total_loans_received_ytd',
        'total_offsets_to_operating_expenditures_period': 'total_offsets_to_operating_expenditures_period',
        'total_offsets_to_operating_expenditures_ytd': 'total_offsets_to_operating_expenditures_ytd',
        'total_operating_expenditures_period': 'total_operating_expenditures_period',
        'total_operating_expenditures_ytd': 'total_operating_expenditures_ytd',
        'total_receipts_period': 'total_receipts_period',
        'total_receipts_ytd': 'total_receipts_ytd',
        'transfers_from_other_authorized_committee_period': 'transfers_from_other_authorized_committee_period',
        'transfers_from_other_authorized_committee_ytd': 'transfers_from_other_authorized_committee_ytd',
        'transfers_to_other_authorized_committee_period': 'transfers_to_other_authorized_committee_period',
        'transfers_to_other_authorized_committee_ytd': 'transfers_to_other_authorized_committee_ytd'
    }

    def __init__(self, aggregate_amount_personal_contributions_general=None, aggregate_contributions_personal_funds_primary=None, all_other_loans_period=None, all_other_loans_ytd=None, amendment_chain=None, amendment_indicator=None, amendment_indicator_full=None, beginning_image_number=None, candidate_contribution_period=None, candidate_contribution_ytd=None, cash_on_hand_beginning_period=None, cash_on_hand_end_period=None, committee_id=None, committee_name=None, committee_type=None, coverage_end_date=None, coverage_start_date=None, csv_url=None, cycle=None, debts_owed_by_committee=None, debts_owed_to_committee=None, document_description=None, end_image_number=None, fec_file_id=None, fec_url=None, file_number=None, gross_receipt_authorized_committee_general=None, gross_receipt_authorized_committee_primary=None, gross_receipt_minus_personal_contribution_general=None, gross_receipt_minus_personal_contributions_primary=None, html_url=None, individual_itemized_contributions_period=None, individual_itemized_contributions_ytd=None, individual_unitemized_contributions_period=None, individual_unitemized_contributions_ytd=None, is_amended=None, loan_repayments_candidate_loans_period=None, loan_repayments_candidate_loans_ytd=None, loan_repayments_other_loans_period=None, loan_repayments_other_loans_ytd=None, loans_made_by_candidate_period=None, loans_made_by_candidate_ytd=None, means_filed=None, most_recent=None, most_recent_file_number=None, net_contributions_period=None, net_contributions_ytd=None, net_operating_expenditures_period=None, net_operating_expenditures_ytd=None, offsets_to_operating_expenditures_period=None, offsets_to_operating_expenditures_ytd=None, operating_expenditures_period=None, operating_expenditures_ytd=None, other_disbursements_period=None, other_disbursements_ytd=None, other_political_committee_contributions_period=None, other_political_committee_contributions_ytd=None, other_receipts_period=None, other_receipts_ytd=None, pdf_url=None, political_party_committee_contributions_period=None, political_party_committee_contributions_ytd=None, previous_file_number=None, receipt_date=None, refunded_individual_contributions_period=None, refunded_individual_contributions_ytd=None, refunded_other_political_committee_contributions_period=None, refunded_other_political_committee_contributions_ytd=None, refunded_political_party_committee_contributions_period=None, refunded_political_party_committee_contributions_ytd=None, refunds_total_contributions_col_total_ytd=None, report_form=None, report_type=None, report_type_full=None, report_year=None, subtotal_period=None, total_contribution_refunds_col_total_period=None, total_contribution_refunds_period=None, total_contribution_refunds_ytd=None, total_contributions_column_total_period=None, total_contributions_period=None, total_contributions_ytd=None, total_disbursements_period=None, total_disbursements_ytd=None, total_individual_contributions_period=None, total_individual_contributions_ytd=None, total_loan_repayments_made_period=None, total_loan_repayments_made_ytd=None, total_loans_received_period=None, total_loans_received_ytd=None, total_offsets_to_operating_expenditures_period=None, total_offsets_to_operating_expenditures_ytd=None, total_operating_expenditures_period=None, total_operating_expenditures_ytd=None, total_receipts_period=None, total_receipts_ytd=None, transfers_from_other_authorized_committee_period=None, transfers_from_other_authorized_committee_ytd=None, transfers_to_other_authorized_committee_period=None, transfers_to_other_authorized_committee_ytd=None, local_vars_configuration=None):  # noqa: E501
        """CommitteeReportsHouseSenate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._aggregate_amount_personal_contributions_general = None
        self._aggregate_contributions_personal_funds_primary = None
        self._all_other_loans_period = None
        self._all_other_loans_ytd = None
        self._amendment_chain = None
        self._amendment_indicator = None
        self._amendment_indicator_full = None
        self._beginning_image_number = None
        self._candidate_contribution_period = None
        self._candidate_contribution_ytd = None
        self._cash_on_hand_beginning_period = None
        self._cash_on_hand_end_period = None
        self._committee_id = None
        self._committee_name = None
        self._committee_type = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._csv_url = None
        self._cycle = None
        self._debts_owed_by_committee = None
        self._debts_owed_to_committee = None
        self._document_description = None
        self._end_image_number = None
        self._fec_file_id = None
        self._fec_url = None
        self._file_number = None
        self._gross_receipt_authorized_committee_general = None
        self._gross_receipt_authorized_committee_primary = None
        self._gross_receipt_minus_personal_contribution_general = None
        self._gross_receipt_minus_personal_contributions_primary = None
        self._html_url = None
        self._individual_itemized_contributions_period = None
        self._individual_itemized_contributions_ytd = None
        self._individual_unitemized_contributions_period = None
        self._individual_unitemized_contributions_ytd = None
        self._is_amended = None
        self._loan_repayments_candidate_loans_period = None
        self._loan_repayments_candidate_loans_ytd = None
        self._loan_repayments_other_loans_period = None
        self._loan_repayments_other_loans_ytd = None
        self._loans_made_by_candidate_period = None
        self._loans_made_by_candidate_ytd = None
        self._means_filed = None
        self._most_recent = None
        self._most_recent_file_number = None
        self._net_contributions_period = None
        self._net_contributions_ytd = None
        self._net_operating_expenditures_period = None
        self._net_operating_expenditures_ytd = None
        self._offsets_to_operating_expenditures_period = None
        self._offsets_to_operating_expenditures_ytd = None
        self._operating_expenditures_period = None
        self._operating_expenditures_ytd = None
        self._other_disbursements_period = None
        self._other_disbursements_ytd = None
        self._other_political_committee_contributions_period = None
        self._other_political_committee_contributions_ytd = None
        self._other_receipts_period = None
        self._other_receipts_ytd = None
        self._pdf_url = None
        self._political_party_committee_contributions_period = None
        self._political_party_committee_contributions_ytd = None
        self._previous_file_number = None
        self._receipt_date = None
        self._refunded_individual_contributions_period = None
        self._refunded_individual_contributions_ytd = None
        self._refunded_other_political_committee_contributions_period = None
        self._refunded_other_political_committee_contributions_ytd = None
        self._refunded_political_party_committee_contributions_period = None
        self._refunded_political_party_committee_contributions_ytd = None
        self._refunds_total_contributions_col_total_ytd = None
        self._report_form = None
        self._report_type = None
        self._report_type_full = None
        self._report_year = None
        self._subtotal_period = None
        self._total_contribution_refunds_col_total_period = None
        self._total_contribution_refunds_period = None
        self._total_contribution_refunds_ytd = None
        self._total_contributions_column_total_period = None
        self._total_contributions_period = None
        self._total_contributions_ytd = None
        self._total_disbursements_period = None
        self._total_disbursements_ytd = None
        self._total_individual_contributions_period = None
        self._total_individual_contributions_ytd = None
        self._total_loan_repayments_made_period = None
        self._total_loan_repayments_made_ytd = None
        self._total_loans_received_period = None
        self._total_loans_received_ytd = None
        self._total_offsets_to_operating_expenditures_period = None
        self._total_offsets_to_operating_expenditures_ytd = None
        self._total_operating_expenditures_period = None
        self._total_operating_expenditures_ytd = None
        self._total_receipts_period = None
        self._total_receipts_ytd = None
        self._transfers_from_other_authorized_committee_period = None
        self._transfers_from_other_authorized_committee_ytd = None
        self._transfers_to_other_authorized_committee_period = None
        self._transfers_to_other_authorized_committee_ytd = None
        self.discriminator = None

        self.aggregate_amount_personal_contributions_general = aggregate_amount_personal_contributions_general
        self.aggregate_contributions_personal_funds_primary = aggregate_contributions_personal_funds_primary
        self.all_other_loans_period = all_other_loans_period
        self.all_other_loans_ytd = all_other_loans_ytd
        self.amendment_chain = amendment_chain
        self.amendment_indicator = amendment_indicator
        self.amendment_indicator_full = amendment_indicator_full
        if beginning_image_number is not None:
            self.beginning_image_number = beginning_image_number
        self.candidate_contribution_period = candidate_contribution_period
        self.candidate_contribution_ytd = candidate_contribution_ytd
        self.cash_on_hand_beginning_period = cash_on_hand_beginning_period
        self.cash_on_hand_end_period = cash_on_hand_end_period
        self.committee_id = committee_id
        self.committee_name = committee_name
        if committee_type is not None:
            self.committee_type = committee_type
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        if csv_url is not None:
            self.csv_url = csv_url
        self.cycle = cycle
        self.debts_owed_by_committee = debts_owed_by_committee
        self.debts_owed_to_committee = debts_owed_to_committee
        if document_description is not None:
            self.document_description = document_description
        if end_image_number is not None:
            self.end_image_number = end_image_number
        if fec_file_id is not None:
            self.fec_file_id = fec_file_id
        if fec_url is not None:
            self.fec_url = fec_url
        self.file_number = file_number
        self.gross_receipt_authorized_committee_general = gross_receipt_authorized_committee_general
        self.gross_receipt_authorized_committee_primary = gross_receipt_authorized_committee_primary
        self.gross_receipt_minus_personal_contribution_general = gross_receipt_minus_personal_contribution_general
        self.gross_receipt_minus_personal_contributions_primary = gross_receipt_minus_personal_contributions_primary
        self.html_url = html_url
        self.individual_itemized_contributions_period = individual_itemized_contributions_period
        self.individual_itemized_contributions_ytd = individual_itemized_contributions_ytd
        self.individual_unitemized_contributions_period = individual_unitemized_contributions_period
        self.individual_unitemized_contributions_ytd = individual_unitemized_contributions_ytd
        self.is_amended = is_amended
        self.loan_repayments_candidate_loans_period = loan_repayments_candidate_loans_period
        self.loan_repayments_candidate_loans_ytd = loan_repayments_candidate_loans_ytd
        self.loan_repayments_other_loans_period = loan_repayments_other_loans_period
        self.loan_repayments_other_loans_ytd = loan_repayments_other_loans_ytd
        self.loans_made_by_candidate_period = loans_made_by_candidate_period
        self.loans_made_by_candidate_ytd = loans_made_by_candidate_ytd
        self.means_filed = means_filed
        self.most_recent = most_recent
        self.most_recent_file_number = most_recent_file_number
        self.net_contributions_period = net_contributions_period
        self.net_contributions_ytd = net_contributions_ytd
        self.net_operating_expenditures_period = net_operating_expenditures_period
        self.net_operating_expenditures_ytd = net_operating_expenditures_ytd
        self.offsets_to_operating_expenditures_period = offsets_to_operating_expenditures_period
        self.offsets_to_operating_expenditures_ytd = offsets_to_operating_expenditures_ytd
        self.operating_expenditures_period = operating_expenditures_period
        self.operating_expenditures_ytd = operating_expenditures_ytd
        self.other_disbursements_period = other_disbursements_period
        self.other_disbursements_ytd = other_disbursements_ytd
        self.other_political_committee_contributions_period = other_political_committee_contributions_period
        self.other_political_committee_contributions_ytd = other_political_committee_contributions_ytd
        self.other_receipts_period = other_receipts_period
        self.other_receipts_ytd = other_receipts_ytd
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.political_party_committee_contributions_period = political_party_committee_contributions_period
        self.political_party_committee_contributions_ytd = political_party_committee_contributions_ytd
        self.previous_file_number = previous_file_number
        self.receipt_date = receipt_date
        self.refunded_individual_contributions_period = refunded_individual_contributions_period
        self.refunded_individual_contributions_ytd = refunded_individual_contributions_ytd
        self.refunded_other_political_committee_contributions_period = refunded_other_political_committee_contributions_period
        self.refunded_other_political_committee_contributions_ytd = refunded_other_political_committee_contributions_ytd
        self.refunded_political_party_committee_contributions_period = refunded_political_party_committee_contributions_period
        self.refunded_political_party_committee_contributions_ytd = refunded_political_party_committee_contributions_ytd
        self.refunds_total_contributions_col_total_ytd = refunds_total_contributions_col_total_ytd
        if report_form is not None:
            self.report_form = report_form
        self.report_type = report_type
        self.report_type_full = report_type_full
        self.report_year = report_year
        self.subtotal_period = subtotal_period
        self.total_contribution_refunds_col_total_period = total_contribution_refunds_col_total_period
        self.total_contribution_refunds_period = total_contribution_refunds_period
        self.total_contribution_refunds_ytd = total_contribution_refunds_ytd
        self.total_contributions_column_total_period = total_contributions_column_total_period
        self.total_contributions_period = total_contributions_period
        self.total_contributions_ytd = total_contributions_ytd
        self.total_disbursements_period = total_disbursements_period
        self.total_disbursements_ytd = total_disbursements_ytd
        self.total_individual_contributions_period = total_individual_contributions_period
        self.total_individual_contributions_ytd = total_individual_contributions_ytd
        self.total_loan_repayments_made_period = total_loan_repayments_made_period
        self.total_loan_repayments_made_ytd = total_loan_repayments_made_ytd
        self.total_loans_received_period = total_loans_received_period
        self.total_loans_received_ytd = total_loans_received_ytd
        self.total_offsets_to_operating_expenditures_period = total_offsets_to_operating_expenditures_period
        self.total_offsets_to_operating_expenditures_ytd = total_offsets_to_operating_expenditures_ytd
        self.total_operating_expenditures_period = total_operating_expenditures_period
        self.total_operating_expenditures_ytd = total_operating_expenditures_ytd
        self.total_receipts_period = total_receipts_period
        self.total_receipts_ytd = total_receipts_ytd
        self.transfers_from_other_authorized_committee_period = transfers_from_other_authorized_committee_period
        self.transfers_from_other_authorized_committee_ytd = transfers_from_other_authorized_committee_ytd
        self.transfers_to_other_authorized_committee_period = transfers_to_other_authorized_committee_period
        self.transfers_to_other_authorized_committee_ytd = transfers_to_other_authorized_committee_ytd

    @property
    def aggregate_amount_personal_contributions_general(self):
        """Gets the aggregate_amount_personal_contributions_general of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The aggregate_amount_personal_contributions_general of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._aggregate_amount_personal_contributions_general

    @aggregate_amount_personal_contributions_general.setter
    def aggregate_amount_personal_contributions_general(self, aggregate_amount_personal_contributions_general):
        """Sets the aggregate_amount_personal_contributions_general of this CommitteeReportsHouseSenate.


        :param aggregate_amount_personal_contributions_general: The aggregate_amount_personal_contributions_general of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._aggregate_amount_personal_contributions_general = aggregate_amount_personal_contributions_general

    @property
    def aggregate_contributions_personal_funds_primary(self):
        """Gets the aggregate_contributions_personal_funds_primary of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The aggregate_contributions_personal_funds_primary of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._aggregate_contributions_personal_funds_primary

    @aggregate_contributions_personal_funds_primary.setter
    def aggregate_contributions_personal_funds_primary(self, aggregate_contributions_personal_funds_primary):
        """Sets the aggregate_contributions_personal_funds_primary of this CommitteeReportsHouseSenate.


        :param aggregate_contributions_personal_funds_primary: The aggregate_contributions_personal_funds_primary of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._aggregate_contributions_personal_funds_primary = aggregate_contributions_personal_funds_primary

    @property
    def all_other_loans_period(self):
        """Gets the all_other_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The all_other_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._all_other_loans_period

    @all_other_loans_period.setter
    def all_other_loans_period(self, all_other_loans_period):
        """Sets the all_other_loans_period of this CommitteeReportsHouseSenate.


        :param all_other_loans_period: The all_other_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._all_other_loans_period = all_other_loans_period

    @property
    def all_other_loans_ytd(self):
        """Gets the all_other_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The all_other_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._all_other_loans_ytd

    @all_other_loans_ytd.setter
    def all_other_loans_ytd(self, all_other_loans_ytd):
        """Sets the all_other_loans_ytd of this CommitteeReportsHouseSenate.


        :param all_other_loans_ytd: The all_other_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._all_other_loans_ytd = all_other_loans_ytd

    @property
    def amendment_chain(self):
        """Gets the amendment_chain of this CommitteeReportsHouseSenate.  # noqa: E501

         The first value in the chain is the original filing.  The ordering in the chain reflects the order the amendments were filed up to the amendment being viewed.   # noqa: E501

        :return: The amendment_chain of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: list[float]
        """
        return self._amendment_chain

    @amendment_chain.setter
    def amendment_chain(self, amendment_chain):
        """Sets the amendment_chain of this CommitteeReportsHouseSenate.

         The first value in the chain is the original filing.  The ordering in the chain reflects the order the amendments were filed up to the amendment being viewed.   # noqa: E501

        :param amendment_chain: The amendment_chain of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: list[float]
        """

        self._amendment_chain = amendment_chain

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The amendment_indicator of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this CommitteeReportsHouseSenate.


        :param amendment_indicator: The amendment_indicator of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def amendment_indicator_full(self):
        """Gets the amendment_indicator_full of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The amendment_indicator_full of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator_full

    @amendment_indicator_full.setter
    def amendment_indicator_full(self, amendment_indicator_full):
        """Sets the amendment_indicator_full of this CommitteeReportsHouseSenate.


        :param amendment_indicator_full: The amendment_indicator_full of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._amendment_indicator_full = amendment_indicator_full

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The beginning_image_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this CommitteeReportsHouseSenate.


        :param beginning_image_number: The beginning_image_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def candidate_contribution_period(self):
        """Gets the candidate_contribution_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The candidate_contribution_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._candidate_contribution_period

    @candidate_contribution_period.setter
    def candidate_contribution_period(self, candidate_contribution_period):
        """Sets the candidate_contribution_period of this CommitteeReportsHouseSenate.


        :param candidate_contribution_period: The candidate_contribution_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._candidate_contribution_period = candidate_contribution_period

    @property
    def candidate_contribution_ytd(self):
        """Gets the candidate_contribution_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The candidate_contribution_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._candidate_contribution_ytd

    @candidate_contribution_ytd.setter
    def candidate_contribution_ytd(self, candidate_contribution_ytd):
        """Sets the candidate_contribution_ytd of this CommitteeReportsHouseSenate.


        :param candidate_contribution_ytd: The candidate_contribution_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._candidate_contribution_ytd = candidate_contribution_ytd

    @property
    def cash_on_hand_beginning_period(self):
        """Gets the cash_on_hand_beginning_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Balance for the committee at the start of the two-year period  # noqa: E501

        :return: The cash_on_hand_beginning_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_beginning_period

    @cash_on_hand_beginning_period.setter
    def cash_on_hand_beginning_period(self, cash_on_hand_beginning_period):
        """Sets the cash_on_hand_beginning_period of this CommitteeReportsHouseSenate.

        Balance for the committee at the start of the two-year period  # noqa: E501

        :param cash_on_hand_beginning_period: The cash_on_hand_beginning_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_beginning_period = cash_on_hand_beginning_period

    @property
    def cash_on_hand_end_period(self):
        """Gets the cash_on_hand_end_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Ending cash balance on the most recent filing  # noqa: E501

        :return: The cash_on_hand_end_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_end_period

    @cash_on_hand_end_period.setter
    def cash_on_hand_end_period(self, cash_on_hand_end_period):
        """Sets the cash_on_hand_end_period of this CommitteeReportsHouseSenate.

        Ending cash balance on the most recent filing  # noqa: E501

        :param cash_on_hand_end_period: The cash_on_hand_end_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_end_period = cash_on_hand_end_period

    @property
    def committee_id(self):
        """Gets the committee_id of this CommitteeReportsHouseSenate.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this CommitteeReportsHouseSenate.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this CommitteeReportsHouseSenate.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this CommitteeReportsHouseSenate.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def committee_type(self):
        """Gets the committee_type of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The committee_type of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this CommitteeReportsHouseSenate.


        :param committee_type: The committee_type of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_type = committee_type

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this CommitteeReportsHouseSenate.  # noqa: E501

        Ending date of the reporting period  # noqa: E501

        :return: The coverage_end_date of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this CommitteeReportsHouseSenate.

        Ending date of the reporting period  # noqa: E501

        :param coverage_end_date: The coverage_end_date of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: datetime
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this CommitteeReportsHouseSenate.  # noqa: E501

        Beginning date of the reporting period  # noqa: E501

        :return: The coverage_start_date of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this CommitteeReportsHouseSenate.

        Beginning date of the reporting period  # noqa: E501

        :param coverage_start_date: The coverage_start_date of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: datetime
        """

        self._coverage_start_date = coverage_start_date

    @property
    def csv_url(self):
        """Gets the csv_url of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The csv_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._csv_url

    @csv_url.setter
    def csv_url(self, csv_url):
        """Sets the csv_url of this CommitteeReportsHouseSenate.


        :param csv_url: The csv_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._csv_url = csv_url

    @property
    def cycle(self):
        """Gets the cycle of this CommitteeReportsHouseSenate.  # noqa: E501

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CommitteeReportsHouseSenate.

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def debts_owed_by_committee(self):
        """Gets the debts_owed_by_committee of this CommitteeReportsHouseSenate.  # noqa: E501

        Debts owed by the committee  # noqa: E501

        :return: The debts_owed_by_committee of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_by_committee

    @debts_owed_by_committee.setter
    def debts_owed_by_committee(self, debts_owed_by_committee):
        """Sets the debts_owed_by_committee of this CommitteeReportsHouseSenate.

        Debts owed by the committee  # noqa: E501

        :param debts_owed_by_committee: The debts_owed_by_committee of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._debts_owed_by_committee = debts_owed_by_committee

    @property
    def debts_owed_to_committee(self):
        """Gets the debts_owed_to_committee of this CommitteeReportsHouseSenate.  # noqa: E501

        Debts owed to the committee  # noqa: E501

        :return: The debts_owed_to_committee of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_to_committee

    @debts_owed_to_committee.setter
    def debts_owed_to_committee(self, debts_owed_to_committee):
        """Sets the debts_owed_to_committee of this CommitteeReportsHouseSenate.

        Debts owed to the committee  # noqa: E501

        :param debts_owed_to_committee: The debts_owed_to_committee of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._debts_owed_to_committee = debts_owed_to_committee

    @property
    def document_description(self):
        """Gets the document_description of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The document_description of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._document_description

    @document_description.setter
    def document_description(self, document_description):
        """Sets the document_description of this CommitteeReportsHouseSenate.


        :param document_description: The document_description of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._document_description = document_description

    @property
    def end_image_number(self):
        """Gets the end_image_number of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The end_image_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._end_image_number

    @end_image_number.setter
    def end_image_number(self, end_image_number):
        """Sets the end_image_number of this CommitteeReportsHouseSenate.


        :param end_image_number: The end_image_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._end_image_number = end_image_number

    @property
    def fec_file_id(self):
        """Gets the fec_file_id of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The fec_file_id of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._fec_file_id

    @fec_file_id.setter
    def fec_file_id(self, fec_file_id):
        """Sets the fec_file_id of this CommitteeReportsHouseSenate.


        :param fec_file_id: The fec_file_id of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._fec_file_id = fec_file_id

    @property
    def fec_url(self):
        """Gets the fec_url of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The fec_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._fec_url

    @fec_url.setter
    def fec_url(self, fec_url):
        """Sets the fec_url of this CommitteeReportsHouseSenate.


        :param fec_url: The fec_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._fec_url = fec_url

    @property
    def file_number(self):
        """Gets the file_number of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The file_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this CommitteeReportsHouseSenate.


        :param file_number: The file_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def gross_receipt_authorized_committee_general(self):
        """Gets the gross_receipt_authorized_committee_general of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The gross_receipt_authorized_committee_general of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._gross_receipt_authorized_committee_general

    @gross_receipt_authorized_committee_general.setter
    def gross_receipt_authorized_committee_general(self, gross_receipt_authorized_committee_general):
        """Sets the gross_receipt_authorized_committee_general of this CommitteeReportsHouseSenate.


        :param gross_receipt_authorized_committee_general: The gross_receipt_authorized_committee_general of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._gross_receipt_authorized_committee_general = gross_receipt_authorized_committee_general

    @property
    def gross_receipt_authorized_committee_primary(self):
        """Gets the gross_receipt_authorized_committee_primary of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The gross_receipt_authorized_committee_primary of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._gross_receipt_authorized_committee_primary

    @gross_receipt_authorized_committee_primary.setter
    def gross_receipt_authorized_committee_primary(self, gross_receipt_authorized_committee_primary):
        """Sets the gross_receipt_authorized_committee_primary of this CommitteeReportsHouseSenate.


        :param gross_receipt_authorized_committee_primary: The gross_receipt_authorized_committee_primary of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._gross_receipt_authorized_committee_primary = gross_receipt_authorized_committee_primary

    @property
    def gross_receipt_minus_personal_contribution_general(self):
        """Gets the gross_receipt_minus_personal_contribution_general of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The gross_receipt_minus_personal_contribution_general of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._gross_receipt_minus_personal_contribution_general

    @gross_receipt_minus_personal_contribution_general.setter
    def gross_receipt_minus_personal_contribution_general(self, gross_receipt_minus_personal_contribution_general):
        """Sets the gross_receipt_minus_personal_contribution_general of this CommitteeReportsHouseSenate.


        :param gross_receipt_minus_personal_contribution_general: The gross_receipt_minus_personal_contribution_general of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._gross_receipt_minus_personal_contribution_general = gross_receipt_minus_personal_contribution_general

    @property
    def gross_receipt_minus_personal_contributions_primary(self):
        """Gets the gross_receipt_minus_personal_contributions_primary of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The gross_receipt_minus_personal_contributions_primary of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._gross_receipt_minus_personal_contributions_primary

    @gross_receipt_minus_personal_contributions_primary.setter
    def gross_receipt_minus_personal_contributions_primary(self, gross_receipt_minus_personal_contributions_primary):
        """Sets the gross_receipt_minus_personal_contributions_primary of this CommitteeReportsHouseSenate.


        :param gross_receipt_minus_personal_contributions_primary: The gross_receipt_minus_personal_contributions_primary of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._gross_receipt_minus_personal_contributions_primary = gross_receipt_minus_personal_contributions_primary

    @property
    def html_url(self):
        """Gets the html_url of this CommitteeReportsHouseSenate.  # noqa: E501

         HTML link to the filing.   # noqa: E501

        :return: The html_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """Sets the html_url of this CommitteeReportsHouseSenate.

         HTML link to the filing.   # noqa: E501

        :param html_url: The html_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._html_url = html_url

    @property
    def individual_itemized_contributions_period(self):
        """Gets the individual_itemized_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less. total for the reporting period  # noqa: E501

        :return: The individual_itemized_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_itemized_contributions_period

    @individual_itemized_contributions_period.setter
    def individual_itemized_contributions_period(self, individual_itemized_contributions_period):
        """Sets the individual_itemized_contributions_period of this CommitteeReportsHouseSenate.

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less. total for the reporting period  # noqa: E501

        :param individual_itemized_contributions_period: The individual_itemized_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_itemized_contributions_period = individual_itemized_contributions_period

    @property
    def individual_itemized_contributions_ytd(self):
        """Gets the individual_itemized_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less. total for the year to date  # noqa: E501

        :return: The individual_itemized_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_itemized_contributions_ytd

    @individual_itemized_contributions_ytd.setter
    def individual_itemized_contributions_ytd(self, individual_itemized_contributions_ytd):
        """Sets the individual_itemized_contributions_ytd of this CommitteeReportsHouseSenate.

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less. total for the year to date  # noqa: E501

        :param individual_itemized_contributions_ytd: The individual_itemized_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_itemized_contributions_ytd = individual_itemized_contributions_ytd

    @property
    def individual_unitemized_contributions_period(self):
        """Gets the individual_unitemized_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total. total for the reporting period  # noqa: E501

        :return: The individual_unitemized_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_unitemized_contributions_period

    @individual_unitemized_contributions_period.setter
    def individual_unitemized_contributions_period(self, individual_unitemized_contributions_period):
        """Sets the individual_unitemized_contributions_period of this CommitteeReportsHouseSenate.

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total. total for the reporting period  # noqa: E501

        :param individual_unitemized_contributions_period: The individual_unitemized_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_unitemized_contributions_period = individual_unitemized_contributions_period

    @property
    def individual_unitemized_contributions_ytd(self):
        """Gets the individual_unitemized_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total. total for the year to date  # noqa: E501

        :return: The individual_unitemized_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_unitemized_contributions_ytd

    @individual_unitemized_contributions_ytd.setter
    def individual_unitemized_contributions_ytd(self, individual_unitemized_contributions_ytd):
        """Sets the individual_unitemized_contributions_ytd of this CommitteeReportsHouseSenate.

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total. total for the year to date  # noqa: E501

        :param individual_unitemized_contributions_ytd: The individual_unitemized_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_unitemized_contributions_ytd = individual_unitemized_contributions_ytd

    @property
    def is_amended(self):
        """Gets the is_amended of this CommitteeReportsHouseSenate.  # noqa: E501

         False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.   # noqa: E501

        :return: The is_amended of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: bool
        """
        return self._is_amended

    @is_amended.setter
    def is_amended(self, is_amended):
        """Sets the is_amended of this CommitteeReportsHouseSenate.

         False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.   # noqa: E501

        :param is_amended: The is_amended of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: bool
        """

        self._is_amended = is_amended

    @property
    def loan_repayments_candidate_loans_period(self):
        """Gets the loan_repayments_candidate_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The loan_repayments_candidate_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_candidate_loans_period

    @loan_repayments_candidate_loans_period.setter
    def loan_repayments_candidate_loans_period(self, loan_repayments_candidate_loans_period):
        """Sets the loan_repayments_candidate_loans_period of this CommitteeReportsHouseSenate.


        :param loan_repayments_candidate_loans_period: The loan_repayments_candidate_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments_candidate_loans_period = loan_repayments_candidate_loans_period

    @property
    def loan_repayments_candidate_loans_ytd(self):
        """Gets the loan_repayments_candidate_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The loan_repayments_candidate_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_candidate_loans_ytd

    @loan_repayments_candidate_loans_ytd.setter
    def loan_repayments_candidate_loans_ytd(self, loan_repayments_candidate_loans_ytd):
        """Sets the loan_repayments_candidate_loans_ytd of this CommitteeReportsHouseSenate.


        :param loan_repayments_candidate_loans_ytd: The loan_repayments_candidate_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments_candidate_loans_ytd = loan_repayments_candidate_loans_ytd

    @property
    def loan_repayments_other_loans_period(self):
        """Gets the loan_repayments_other_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The loan_repayments_other_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_other_loans_period

    @loan_repayments_other_loans_period.setter
    def loan_repayments_other_loans_period(self, loan_repayments_other_loans_period):
        """Sets the loan_repayments_other_loans_period of this CommitteeReportsHouseSenate.


        :param loan_repayments_other_loans_period: The loan_repayments_other_loans_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments_other_loans_period = loan_repayments_other_loans_period

    @property
    def loan_repayments_other_loans_ytd(self):
        """Gets the loan_repayments_other_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The loan_repayments_other_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_other_loans_ytd

    @loan_repayments_other_loans_ytd.setter
    def loan_repayments_other_loans_ytd(self, loan_repayments_other_loans_ytd):
        """Sets the loan_repayments_other_loans_ytd of this CommitteeReportsHouseSenate.


        :param loan_repayments_other_loans_ytd: The loan_repayments_other_loans_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments_other_loans_ytd = loan_repayments_other_loans_ytd

    @property
    def loans_made_by_candidate_period(self):
        """Gets the loans_made_by_candidate_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The loans_made_by_candidate_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loans_made_by_candidate_period

    @loans_made_by_candidate_period.setter
    def loans_made_by_candidate_period(self, loans_made_by_candidate_period):
        """Sets the loans_made_by_candidate_period of this CommitteeReportsHouseSenate.


        :param loans_made_by_candidate_period: The loans_made_by_candidate_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loans_made_by_candidate_period = loans_made_by_candidate_period

    @property
    def loans_made_by_candidate_ytd(self):
        """Gets the loans_made_by_candidate_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The loans_made_by_candidate_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loans_made_by_candidate_ytd

    @loans_made_by_candidate_ytd.setter
    def loans_made_by_candidate_ytd(self, loans_made_by_candidate_ytd):
        """Sets the loans_made_by_candidate_ytd of this CommitteeReportsHouseSenate.


        :param loans_made_by_candidate_ytd: The loans_made_by_candidate_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loans_made_by_candidate_ytd = loans_made_by_candidate_ytd

    @property
    def means_filed(self):
        """Gets the means_filed of this CommitteeReportsHouseSenate.  # noqa: E501

        The method used to file with the FEC, either electronic or on paper.  # noqa: E501

        :return: The means_filed of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._means_filed

    @means_filed.setter
    def means_filed(self, means_filed):
        """Sets the means_filed of this CommitteeReportsHouseSenate.

        The method used to file with the FEC, either electronic or on paper.  # noqa: E501

        :param means_filed: The means_filed of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._means_filed = means_filed

    @property
    def most_recent(self):
        """Gets the most_recent of this CommitteeReportsHouseSenate.  # noqa: E501

         Report is either new or is the most-recently filed amendment   # noqa: E501

        :return: The most_recent of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: bool
        """
        return self._most_recent

    @most_recent.setter
    def most_recent(self, most_recent):
        """Sets the most_recent of this CommitteeReportsHouseSenate.

         Report is either new or is the most-recently filed amendment   # noqa: E501

        :param most_recent: The most_recent of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: bool
        """

        self._most_recent = most_recent

    @property
    def most_recent_file_number(self):
        """Gets the most_recent_file_number of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The most_recent_file_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._most_recent_file_number

    @most_recent_file_number.setter
    def most_recent_file_number(self, most_recent_file_number):
        """Sets the most_recent_file_number of this CommitteeReportsHouseSenate.


        :param most_recent_file_number: The most_recent_file_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._most_recent_file_number = most_recent_file_number

    @property
    def net_contributions_period(self):
        """Gets the net_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The net_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._net_contributions_period

    @net_contributions_period.setter
    def net_contributions_period(self, net_contributions_period):
        """Sets the net_contributions_period of this CommitteeReportsHouseSenate.


        :param net_contributions_period: The net_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._net_contributions_period = net_contributions_period

    @property
    def net_contributions_ytd(self):
        """Gets the net_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The net_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._net_contributions_ytd

    @net_contributions_ytd.setter
    def net_contributions_ytd(self, net_contributions_ytd):
        """Sets the net_contributions_ytd of this CommitteeReportsHouseSenate.


        :param net_contributions_ytd: The net_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._net_contributions_ytd = net_contributions_ytd

    @property
    def net_operating_expenditures_period(self):
        """Gets the net_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The net_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._net_operating_expenditures_period

    @net_operating_expenditures_period.setter
    def net_operating_expenditures_period(self, net_operating_expenditures_period):
        """Sets the net_operating_expenditures_period of this CommitteeReportsHouseSenate.


        :param net_operating_expenditures_period: The net_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._net_operating_expenditures_period = net_operating_expenditures_period

    @property
    def net_operating_expenditures_ytd(self):
        """Gets the net_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The net_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._net_operating_expenditures_ytd

    @net_operating_expenditures_ytd.setter
    def net_operating_expenditures_ytd(self, net_operating_expenditures_ytd):
        """Sets the net_operating_expenditures_ytd of this CommitteeReportsHouseSenate.


        :param net_operating_expenditures_ytd: The net_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._net_operating_expenditures_ytd = net_operating_expenditures_ytd

    @property
    def offsets_to_operating_expenditures_period(self):
        """Gets the offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Offsets to operating expenditures total for the reporting period  # noqa: E501

        :return: The offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_operating_expenditures_period

    @offsets_to_operating_expenditures_period.setter
    def offsets_to_operating_expenditures_period(self, offsets_to_operating_expenditures_period):
        """Sets the offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.

        Offsets to operating expenditures total for the reporting period  # noqa: E501

        :param offsets_to_operating_expenditures_period: The offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._offsets_to_operating_expenditures_period = offsets_to_operating_expenditures_period

    @property
    def offsets_to_operating_expenditures_ytd(self):
        """Gets the offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Offsets to operating expenditures total for the year to date  # noqa: E501

        :return: The offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_operating_expenditures_ytd

    @offsets_to_operating_expenditures_ytd.setter
    def offsets_to_operating_expenditures_ytd(self, offsets_to_operating_expenditures_ytd):
        """Sets the offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.

        Offsets to operating expenditures total for the year to date  # noqa: E501

        :param offsets_to_operating_expenditures_ytd: The offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._offsets_to_operating_expenditures_ytd = offsets_to_operating_expenditures_ytd

    @property
    def operating_expenditures_period(self):
        """Gets the operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._operating_expenditures_period

    @operating_expenditures_period.setter
    def operating_expenditures_period(self, operating_expenditures_period):
        """Sets the operating_expenditures_period of this CommitteeReportsHouseSenate.


        :param operating_expenditures_period: The operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._operating_expenditures_period = operating_expenditures_period

    @property
    def operating_expenditures_ytd(self):
        """Gets the operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._operating_expenditures_ytd

    @operating_expenditures_ytd.setter
    def operating_expenditures_ytd(self, operating_expenditures_ytd):
        """Sets the operating_expenditures_ytd of this CommitteeReportsHouseSenate.


        :param operating_expenditures_ytd: The operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._operating_expenditures_ytd = operating_expenditures_ytd

    @property
    def other_disbursements_period(self):
        """Gets the other_disbursements_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Other disbursements total for the reporting period  # noqa: E501

        :return: The other_disbursements_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_disbursements_period

    @other_disbursements_period.setter
    def other_disbursements_period(self, other_disbursements_period):
        """Sets the other_disbursements_period of this CommitteeReportsHouseSenate.

        Other disbursements total for the reporting period  # noqa: E501

        :param other_disbursements_period: The other_disbursements_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_disbursements_period = other_disbursements_period

    @property
    def other_disbursements_ytd(self):
        """Gets the other_disbursements_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Other disbursements total for the year to date  # noqa: E501

        :return: The other_disbursements_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_disbursements_ytd

    @other_disbursements_ytd.setter
    def other_disbursements_ytd(self, other_disbursements_ytd):
        """Sets the other_disbursements_ytd of this CommitteeReportsHouseSenate.

        Other disbursements total for the year to date  # noqa: E501

        :param other_disbursements_ytd: The other_disbursements_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_disbursements_ytd = other_disbursements_ytd

    @property
    def other_political_committee_contributions_period(self):
        """Gets the other_political_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Other committees contributions total for the reporting period  # noqa: E501

        :return: The other_political_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_political_committee_contributions_period

    @other_political_committee_contributions_period.setter
    def other_political_committee_contributions_period(self, other_political_committee_contributions_period):
        """Sets the other_political_committee_contributions_period of this CommitteeReportsHouseSenate.

        Other committees contributions total for the reporting period  # noqa: E501

        :param other_political_committee_contributions_period: The other_political_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_political_committee_contributions_period = other_political_committee_contributions_period

    @property
    def other_political_committee_contributions_ytd(self):
        """Gets the other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Other committees contributions total for the year to date  # noqa: E501

        :return: The other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_political_committee_contributions_ytd

    @other_political_committee_contributions_ytd.setter
    def other_political_committee_contributions_ytd(self, other_political_committee_contributions_ytd):
        """Sets the other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.

        Other committees contributions total for the year to date  # noqa: E501

        :param other_political_committee_contributions_ytd: The other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_political_committee_contributions_ytd = other_political_committee_contributions_ytd

    @property
    def other_receipts_period(self):
        """Gets the other_receipts_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The other_receipts_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_receipts_period

    @other_receipts_period.setter
    def other_receipts_period(self, other_receipts_period):
        """Sets the other_receipts_period of this CommitteeReportsHouseSenate.


        :param other_receipts_period: The other_receipts_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_receipts_period = other_receipts_period

    @property
    def other_receipts_ytd(self):
        """Gets the other_receipts_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The other_receipts_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_receipts_ytd

    @other_receipts_ytd.setter
    def other_receipts_ytd(self, other_receipts_ytd):
        """Sets the other_receipts_ytd of this CommitteeReportsHouseSenate.


        :param other_receipts_ytd: The other_receipts_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_receipts_ytd = other_receipts_ytd

    @property
    def pdf_url(self):
        """Gets the pdf_url of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The pdf_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this CommitteeReportsHouseSenate.


        :param pdf_url: The pdf_url of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def political_party_committee_contributions_period(self):
        """Gets the political_party_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Party committees contributions total for the reporting period  # noqa: E501

        :return: The political_party_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._political_party_committee_contributions_period

    @political_party_committee_contributions_period.setter
    def political_party_committee_contributions_period(self, political_party_committee_contributions_period):
        """Sets the political_party_committee_contributions_period of this CommitteeReportsHouseSenate.

        Party committees contributions total for the reporting period  # noqa: E501

        :param political_party_committee_contributions_period: The political_party_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._political_party_committee_contributions_period = political_party_committee_contributions_period

    @property
    def political_party_committee_contributions_ytd(self):
        """Gets the political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Party committees contributions total for the year to date  # noqa: E501

        :return: The political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._political_party_committee_contributions_ytd

    @political_party_committee_contributions_ytd.setter
    def political_party_committee_contributions_ytd(self, political_party_committee_contributions_ytd):
        """Sets the political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.

        Party committees contributions total for the year to date  # noqa: E501

        :param political_party_committee_contributions_ytd: The political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._political_party_committee_contributions_ytd = political_party_committee_contributions_ytd

    @property
    def previous_file_number(self):
        """Gets the previous_file_number of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The previous_file_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._previous_file_number

    @previous_file_number.setter
    def previous_file_number(self, previous_file_number):
        """Sets the previous_file_number of this CommitteeReportsHouseSenate.


        :param previous_file_number: The previous_file_number of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._previous_file_number = previous_file_number

    @property
    def receipt_date(self):
        """Gets the receipt_date of this CommitteeReportsHouseSenate.  # noqa: E501

        Date the FEC received the electronic or paper record  # noqa: E501

        :return: The receipt_date of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: date
        """
        return self._receipt_date

    @receipt_date.setter
    def receipt_date(self, receipt_date):
        """Sets the receipt_date of this CommitteeReportsHouseSenate.

        Date the FEC received the electronic or paper record  # noqa: E501

        :param receipt_date: The receipt_date of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: date
        """

        self._receipt_date = receipt_date

    @property
    def refunded_individual_contributions_period(self):
        """Gets the refunded_individual_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Individual refunds total for the reporting period  # noqa: E501

        :return: The refunded_individual_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_individual_contributions_period

    @refunded_individual_contributions_period.setter
    def refunded_individual_contributions_period(self, refunded_individual_contributions_period):
        """Sets the refunded_individual_contributions_period of this CommitteeReportsHouseSenate.

        Individual refunds total for the reporting period  # noqa: E501

        :param refunded_individual_contributions_period: The refunded_individual_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_individual_contributions_period = refunded_individual_contributions_period

    @property
    def refunded_individual_contributions_ytd(self):
        """Gets the refunded_individual_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Individual refunds total for the year to date  # noqa: E501

        :return: The refunded_individual_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_individual_contributions_ytd

    @refunded_individual_contributions_ytd.setter
    def refunded_individual_contributions_ytd(self, refunded_individual_contributions_ytd):
        """Sets the refunded_individual_contributions_ytd of this CommitteeReportsHouseSenate.

        Individual refunds total for the year to date  # noqa: E501

        :param refunded_individual_contributions_ytd: The refunded_individual_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_individual_contributions_ytd = refunded_individual_contributions_ytd

    @property
    def refunded_other_political_committee_contributions_period(self):
        """Gets the refunded_other_political_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Other committee refunds total for the reporting period  # noqa: E501

        :return: The refunded_other_political_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_other_political_committee_contributions_period

    @refunded_other_political_committee_contributions_period.setter
    def refunded_other_political_committee_contributions_period(self, refunded_other_political_committee_contributions_period):
        """Sets the refunded_other_political_committee_contributions_period of this CommitteeReportsHouseSenate.

        Other committee refunds total for the reporting period  # noqa: E501

        :param refunded_other_political_committee_contributions_period: The refunded_other_political_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_other_political_committee_contributions_period = refunded_other_political_committee_contributions_period

    @property
    def refunded_other_political_committee_contributions_ytd(self):
        """Gets the refunded_other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Other committee refunds total for the year to date  # noqa: E501

        :return: The refunded_other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_other_political_committee_contributions_ytd

    @refunded_other_political_committee_contributions_ytd.setter
    def refunded_other_political_committee_contributions_ytd(self, refunded_other_political_committee_contributions_ytd):
        """Sets the refunded_other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.

        Other committee refunds total for the year to date  # noqa: E501

        :param refunded_other_political_committee_contributions_ytd: The refunded_other_political_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_other_political_committee_contributions_ytd = refunded_other_political_committee_contributions_ytd

    @property
    def refunded_political_party_committee_contributions_period(self):
        """Gets the refunded_political_party_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Political party refunds total for the reporting period  # noqa: E501

        :return: The refunded_political_party_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_political_party_committee_contributions_period

    @refunded_political_party_committee_contributions_period.setter
    def refunded_political_party_committee_contributions_period(self, refunded_political_party_committee_contributions_period):
        """Sets the refunded_political_party_committee_contributions_period of this CommitteeReportsHouseSenate.

        Political party refunds total for the reporting period  # noqa: E501

        :param refunded_political_party_committee_contributions_period: The refunded_political_party_committee_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_political_party_committee_contributions_period = refunded_political_party_committee_contributions_period

    @property
    def refunded_political_party_committee_contributions_ytd(self):
        """Gets the refunded_political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Political party refunds total for the year to date  # noqa: E501

        :return: The refunded_political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_political_party_committee_contributions_ytd

    @refunded_political_party_committee_contributions_ytd.setter
    def refunded_political_party_committee_contributions_ytd(self, refunded_political_party_committee_contributions_ytd):
        """Sets the refunded_political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.

        Political party refunds total for the year to date  # noqa: E501

        :param refunded_political_party_committee_contributions_ytd: The refunded_political_party_committee_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_political_party_committee_contributions_ytd = refunded_political_party_committee_contributions_ytd

    @property
    def refunds_total_contributions_col_total_ytd(self):
        """Gets the refunds_total_contributions_col_total_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The refunds_total_contributions_col_total_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunds_total_contributions_col_total_ytd

    @refunds_total_contributions_col_total_ytd.setter
    def refunds_total_contributions_col_total_ytd(self, refunds_total_contributions_col_total_ytd):
        """Sets the refunds_total_contributions_col_total_ytd of this CommitteeReportsHouseSenate.


        :param refunds_total_contributions_col_total_ytd: The refunds_total_contributions_col_total_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunds_total_contributions_col_total_ytd = refunds_total_contributions_col_total_ytd

    @property
    def report_form(self):
        """Gets the report_form of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The report_form of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._report_form

    @report_form.setter
    def report_form(self, report_form):
        """Sets the report_form of this CommitteeReportsHouseSenate.


        :param report_form: The report_form of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._report_form = report_form

    @property
    def report_type(self):
        """Gets the report_type of this CommitteeReportsHouseSenate.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this CommitteeReportsHouseSenate.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_type_full(self):
        """Gets the report_type_full of this CommitteeReportsHouseSenate.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type_full of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._report_type_full

    @report_type_full.setter
    def report_type_full(self, report_type_full):
        """Sets the report_type_full of this CommitteeReportsHouseSenate.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type_full: The report_type_full of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: str
        """

        self._report_type_full = report_type_full

    @property
    def report_year(self):
        """Gets the report_year of this CommitteeReportsHouseSenate.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this CommitteeReportsHouseSenate.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def subtotal_period(self):
        """Gets the subtotal_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The subtotal_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._subtotal_period

    @subtotal_period.setter
    def subtotal_period(self, subtotal_period):
        """Sets the subtotal_period of this CommitteeReportsHouseSenate.


        :param subtotal_period: The subtotal_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._subtotal_period = subtotal_period

    @property
    def total_contribution_refunds_col_total_period(self):
        """Gets the total_contribution_refunds_col_total_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_contribution_refunds_col_total_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_contribution_refunds_col_total_period

    @total_contribution_refunds_col_total_period.setter
    def total_contribution_refunds_col_total_period(self, total_contribution_refunds_col_total_period):
        """Sets the total_contribution_refunds_col_total_period of this CommitteeReportsHouseSenate.


        :param total_contribution_refunds_col_total_period: The total_contribution_refunds_col_total_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_contribution_refunds_col_total_period = total_contribution_refunds_col_total_period

    @property
    def total_contribution_refunds_period(self):
        """Gets the total_contribution_refunds_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Total contribution refunds total for the reporting period  # noqa: E501

        :return: The total_contribution_refunds_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_contribution_refunds_period

    @total_contribution_refunds_period.setter
    def total_contribution_refunds_period(self, total_contribution_refunds_period):
        """Sets the total_contribution_refunds_period of this CommitteeReportsHouseSenate.

        Total contribution refunds total for the reporting period  # noqa: E501

        :param total_contribution_refunds_period: The total_contribution_refunds_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_contribution_refunds_period = total_contribution_refunds_period

    @property
    def total_contribution_refunds_ytd(self):
        """Gets the total_contribution_refunds_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Total contribution refunds total for the year to date  # noqa: E501

        :return: The total_contribution_refunds_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_contribution_refunds_ytd

    @total_contribution_refunds_ytd.setter
    def total_contribution_refunds_ytd(self, total_contribution_refunds_ytd):
        """Sets the total_contribution_refunds_ytd of this CommitteeReportsHouseSenate.

        Total contribution refunds total for the year to date  # noqa: E501

        :param total_contribution_refunds_ytd: The total_contribution_refunds_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_contribution_refunds_ytd = total_contribution_refunds_ytd

    @property
    def total_contributions_column_total_period(self):
        """Gets the total_contributions_column_total_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_contributions_column_total_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_contributions_column_total_period

    @total_contributions_column_total_period.setter
    def total_contributions_column_total_period(self, total_contributions_column_total_period):
        """Sets the total_contributions_column_total_period of this CommitteeReportsHouseSenate.


        :param total_contributions_column_total_period: The total_contributions_column_total_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_contributions_column_total_period = total_contributions_column_total_period

    @property
    def total_contributions_period(self):
        """Gets the total_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Contribution total for the reporting period  # noqa: E501

        :return: The total_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_contributions_period

    @total_contributions_period.setter
    def total_contributions_period(self, total_contributions_period):
        """Sets the total_contributions_period of this CommitteeReportsHouseSenate.

        Contribution total for the reporting period  # noqa: E501

        :param total_contributions_period: The total_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_contributions_period = total_contributions_period

    @property
    def total_contributions_ytd(self):
        """Gets the total_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Contribution total for the year to date  # noqa: E501

        :return: The total_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_contributions_ytd

    @total_contributions_ytd.setter
    def total_contributions_ytd(self, total_contributions_ytd):
        """Sets the total_contributions_ytd of this CommitteeReportsHouseSenate.

        Contribution total for the year to date  # noqa: E501

        :param total_contributions_ytd: The total_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_contributions_ytd = total_contributions_ytd

    @property
    def total_disbursements_period(self):
        """Gets the total_disbursements_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Disbursements total for the reporting period  # noqa: E501

        :return: The total_disbursements_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_disbursements_period

    @total_disbursements_period.setter
    def total_disbursements_period(self, total_disbursements_period):
        """Sets the total_disbursements_period of this CommitteeReportsHouseSenate.

        Disbursements total for the reporting period  # noqa: E501

        :param total_disbursements_period: The total_disbursements_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_disbursements_period = total_disbursements_period

    @property
    def total_disbursements_ytd(self):
        """Gets the total_disbursements_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Disbursements total for the year to date  # noqa: E501

        :return: The total_disbursements_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_disbursements_ytd

    @total_disbursements_ytd.setter
    def total_disbursements_ytd(self, total_disbursements_ytd):
        """Sets the total_disbursements_ytd of this CommitteeReportsHouseSenate.

        Disbursements total for the year to date  # noqa: E501

        :param total_disbursements_ytd: The total_disbursements_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_disbursements_ytd = total_disbursements_ytd

    @property
    def total_individual_contributions_period(self):
        """Gets the total_individual_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Individual contributions total for the reporting period  # noqa: E501

        :return: The total_individual_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_individual_contributions_period

    @total_individual_contributions_period.setter
    def total_individual_contributions_period(self, total_individual_contributions_period):
        """Sets the total_individual_contributions_period of this CommitteeReportsHouseSenate.

        Individual contributions total for the reporting period  # noqa: E501

        :param total_individual_contributions_period: The total_individual_contributions_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_individual_contributions_period = total_individual_contributions_period

    @property
    def total_individual_contributions_ytd(self):
        """Gets the total_individual_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Individual contributions total for the year to date  # noqa: E501

        :return: The total_individual_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_individual_contributions_ytd

    @total_individual_contributions_ytd.setter
    def total_individual_contributions_ytd(self, total_individual_contributions_ytd):
        """Sets the total_individual_contributions_ytd of this CommitteeReportsHouseSenate.

        Individual contributions total for the year to date  # noqa: E501

        :param total_individual_contributions_ytd: The total_individual_contributions_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_individual_contributions_ytd = total_individual_contributions_ytd

    @property
    def total_loan_repayments_made_period(self):
        """Gets the total_loan_repayments_made_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_loan_repayments_made_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_loan_repayments_made_period

    @total_loan_repayments_made_period.setter
    def total_loan_repayments_made_period(self, total_loan_repayments_made_period):
        """Sets the total_loan_repayments_made_period of this CommitteeReportsHouseSenate.


        :param total_loan_repayments_made_period: The total_loan_repayments_made_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_loan_repayments_made_period = total_loan_repayments_made_period

    @property
    def total_loan_repayments_made_ytd(self):
        """Gets the total_loan_repayments_made_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_loan_repayments_made_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_loan_repayments_made_ytd

    @total_loan_repayments_made_ytd.setter
    def total_loan_repayments_made_ytd(self, total_loan_repayments_made_ytd):
        """Sets the total_loan_repayments_made_ytd of this CommitteeReportsHouseSenate.


        :param total_loan_repayments_made_ytd: The total_loan_repayments_made_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_loan_repayments_made_ytd = total_loan_repayments_made_ytd

    @property
    def total_loans_received_period(self):
        """Gets the total_loans_received_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_loans_received_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_loans_received_period

    @total_loans_received_period.setter
    def total_loans_received_period(self, total_loans_received_period):
        """Sets the total_loans_received_period of this CommitteeReportsHouseSenate.


        :param total_loans_received_period: The total_loans_received_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_loans_received_period = total_loans_received_period

    @property
    def total_loans_received_ytd(self):
        """Gets the total_loans_received_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_loans_received_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_loans_received_ytd

    @total_loans_received_ytd.setter
    def total_loans_received_ytd(self, total_loans_received_ytd):
        """Sets the total_loans_received_ytd of this CommitteeReportsHouseSenate.


        :param total_loans_received_ytd: The total_loans_received_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_loans_received_ytd = total_loans_received_ytd

    @property
    def total_offsets_to_operating_expenditures_period(self):
        """Gets the total_offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_offsets_to_operating_expenditures_period

    @total_offsets_to_operating_expenditures_period.setter
    def total_offsets_to_operating_expenditures_period(self, total_offsets_to_operating_expenditures_period):
        """Sets the total_offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.


        :param total_offsets_to_operating_expenditures_period: The total_offsets_to_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_offsets_to_operating_expenditures_period = total_offsets_to_operating_expenditures_period

    @property
    def total_offsets_to_operating_expenditures_ytd(self):
        """Gets the total_offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_offsets_to_operating_expenditures_ytd

    @total_offsets_to_operating_expenditures_ytd.setter
    def total_offsets_to_operating_expenditures_ytd(self, total_offsets_to_operating_expenditures_ytd):
        """Sets the total_offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.


        :param total_offsets_to_operating_expenditures_ytd: The total_offsets_to_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_offsets_to_operating_expenditures_ytd = total_offsets_to_operating_expenditures_ytd

    @property
    def total_operating_expenditures_period(self):
        """Gets the total_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_operating_expenditures_period

    @total_operating_expenditures_period.setter
    def total_operating_expenditures_period(self, total_operating_expenditures_period):
        """Sets the total_operating_expenditures_period of this CommitteeReportsHouseSenate.


        :param total_operating_expenditures_period: The total_operating_expenditures_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_operating_expenditures_period = total_operating_expenditures_period

    @property
    def total_operating_expenditures_ytd(self):
        """Gets the total_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The total_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_operating_expenditures_ytd

    @total_operating_expenditures_ytd.setter
    def total_operating_expenditures_ytd(self, total_operating_expenditures_ytd):
        """Sets the total_operating_expenditures_ytd of this CommitteeReportsHouseSenate.


        :param total_operating_expenditures_ytd: The total_operating_expenditures_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_operating_expenditures_ytd = total_operating_expenditures_ytd

    @property
    def total_receipts_period(self):
        """Gets the total_receipts_period of this CommitteeReportsHouseSenate.  # noqa: E501

        Anything of value (money, goods, services or property) received by a political committee total for the reporting period  # noqa: E501

        :return: The total_receipts_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_receipts_period

    @total_receipts_period.setter
    def total_receipts_period(self, total_receipts_period):
        """Sets the total_receipts_period of this CommitteeReportsHouseSenate.

        Anything of value (money, goods, services or property) received by a political committee total for the reporting period  # noqa: E501

        :param total_receipts_period: The total_receipts_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_receipts_period = total_receipts_period

    @property
    def total_receipts_ytd(self):
        """Gets the total_receipts_ytd of this CommitteeReportsHouseSenate.  # noqa: E501

        Anything of value (money, goods, services or property) received by a political committee total for the year to date  # noqa: E501

        :return: The total_receipts_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._total_receipts_ytd

    @total_receipts_ytd.setter
    def total_receipts_ytd(self, total_receipts_ytd):
        """Sets the total_receipts_ytd of this CommitteeReportsHouseSenate.

        Anything of value (money, goods, services or property) received by a political committee total for the year to date  # noqa: E501

        :param total_receipts_ytd: The total_receipts_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._total_receipts_ytd = total_receipts_ytd

    @property
    def transfers_from_other_authorized_committee_period(self):
        """Gets the transfers_from_other_authorized_committee_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The transfers_from_other_authorized_committee_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_other_authorized_committee_period

    @transfers_from_other_authorized_committee_period.setter
    def transfers_from_other_authorized_committee_period(self, transfers_from_other_authorized_committee_period):
        """Sets the transfers_from_other_authorized_committee_period of this CommitteeReportsHouseSenate.


        :param transfers_from_other_authorized_committee_period: The transfers_from_other_authorized_committee_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._transfers_from_other_authorized_committee_period = transfers_from_other_authorized_committee_period

    @property
    def transfers_from_other_authorized_committee_ytd(self):
        """Gets the transfers_from_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The transfers_from_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_other_authorized_committee_ytd

    @transfers_from_other_authorized_committee_ytd.setter
    def transfers_from_other_authorized_committee_ytd(self, transfers_from_other_authorized_committee_ytd):
        """Sets the transfers_from_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.


        :param transfers_from_other_authorized_committee_ytd: The transfers_from_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._transfers_from_other_authorized_committee_ytd = transfers_from_other_authorized_committee_ytd

    @property
    def transfers_to_other_authorized_committee_period(self):
        """Gets the transfers_to_other_authorized_committee_period of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The transfers_to_other_authorized_committee_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._transfers_to_other_authorized_committee_period

    @transfers_to_other_authorized_committee_period.setter
    def transfers_to_other_authorized_committee_period(self, transfers_to_other_authorized_committee_period):
        """Sets the transfers_to_other_authorized_committee_period of this CommitteeReportsHouseSenate.


        :param transfers_to_other_authorized_committee_period: The transfers_to_other_authorized_committee_period of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._transfers_to_other_authorized_committee_period = transfers_to_other_authorized_committee_period

    @property
    def transfers_to_other_authorized_committee_ytd(self):
        """Gets the transfers_to_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.  # noqa: E501


        :return: The transfers_to_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._transfers_to_other_authorized_committee_ytd

    @transfers_to_other_authorized_committee_ytd.setter
    def transfers_to_other_authorized_committee_ytd(self, transfers_to_other_authorized_committee_ytd):
        """Sets the transfers_to_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.


        :param transfers_to_other_authorized_committee_ytd: The transfers_to_other_authorized_committee_ytd of this CommitteeReportsHouseSenate.  # noqa: E501
        :type: float
        """

        self._transfers_to_other_authorized_committee_ytd = transfers_to_other_authorized_committee_ytd

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommitteeReportsHouseSenate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommitteeReportsHouseSenate):
            return True

        return self.to_dict() != other.to_dict()
