# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CommitteeTotalsHouseSenate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'all_other_loans': 'float',
        'candidate_contribution': 'float',
        'cash_on_hand_beginning_period': 'float',
        'committee_designation': 'str',
        'committee_designation_full': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'committee_type': 'str',
        'committee_type_full': 'str',
        'contribution_refunds': 'float',
        'contributions': 'float',
        'coverage_end_date': 'datetime',
        'coverage_start_date': 'datetime',
        'cycle': 'int',
        'disbursements': 'float',
        'individual_contributions': 'float',
        'individual_itemized_contributions': 'float',
        'individual_unitemized_contributions': 'float',
        'last_beginning_image_number': 'str',
        'last_cash_on_hand_end_period': 'float',
        'last_debts_owed_by_committee': 'float',
        'last_debts_owed_to_committee': 'float',
        'last_report_type_full': 'str',
        'last_report_year': 'int',
        'loan_repayments': 'float',
        'loan_repayments_candidate_loans': 'float',
        'loan_repayments_other_loans': 'float',
        'loans': 'float',
        'loans_made_by_candidate': 'float',
        'net_contributions': 'float',
        'net_operating_expenditures': 'float',
        'offsets_to_operating_expenditures': 'float',
        'operating_expenditures': 'float',
        'other_disbursements': 'float',
        'other_political_committee_contributions': 'float',
        'other_receipts': 'float',
        'party_full': 'str',
        'pdf_url': 'str',
        'political_party_committee_contributions': 'float',
        'receipts': 'float',
        'refunded_individual_contributions': 'float',
        'refunded_other_political_committee_contributions': 'float',
        'refunded_political_party_committee_contributions': 'float',
        'report_form': 'str',
        'transaction_coverage_date': 'date',
        'transfers_from_other_authorized_committee': 'float',
        'transfers_to_other_authorized_committee': 'float'
    }

    attribute_map = {
        'all_other_loans': 'all_other_loans',
        'candidate_contribution': 'candidate_contribution',
        'cash_on_hand_beginning_period': 'cash_on_hand_beginning_period',
        'committee_designation': 'committee_designation',
        'committee_designation_full': 'committee_designation_full',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'committee_type': 'committee_type',
        'committee_type_full': 'committee_type_full',
        'contribution_refunds': 'contribution_refunds',
        'contributions': 'contributions',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'cycle': 'cycle',
        'disbursements': 'disbursements',
        'individual_contributions': 'individual_contributions',
        'individual_itemized_contributions': 'individual_itemized_contributions',
        'individual_unitemized_contributions': 'individual_unitemized_contributions',
        'last_beginning_image_number': 'last_beginning_image_number',
        'last_cash_on_hand_end_period': 'last_cash_on_hand_end_period',
        'last_debts_owed_by_committee': 'last_debts_owed_by_committee',
        'last_debts_owed_to_committee': 'last_debts_owed_to_committee',
        'last_report_type_full': 'last_report_type_full',
        'last_report_year': 'last_report_year',
        'loan_repayments': 'loan_repayments',
        'loan_repayments_candidate_loans': 'loan_repayments_candidate_loans',
        'loan_repayments_other_loans': 'loan_repayments_other_loans',
        'loans': 'loans',
        'loans_made_by_candidate': 'loans_made_by_candidate',
        'net_contributions': 'net_contributions',
        'net_operating_expenditures': 'net_operating_expenditures',
        'offsets_to_operating_expenditures': 'offsets_to_operating_expenditures',
        'operating_expenditures': 'operating_expenditures',
        'other_disbursements': 'other_disbursements',
        'other_political_committee_contributions': 'other_political_committee_contributions',
        'other_receipts': 'other_receipts',
        'party_full': 'party_full',
        'pdf_url': 'pdf_url',
        'political_party_committee_contributions': 'political_party_committee_contributions',
        'receipts': 'receipts',
        'refunded_individual_contributions': 'refunded_individual_contributions',
        'refunded_other_political_committee_contributions': 'refunded_other_political_committee_contributions',
        'refunded_political_party_committee_contributions': 'refunded_political_party_committee_contributions',
        'report_form': 'report_form',
        'transaction_coverage_date': 'transaction_coverage_date',
        'transfers_from_other_authorized_committee': 'transfers_from_other_authorized_committee',
        'transfers_to_other_authorized_committee': 'transfers_to_other_authorized_committee'
    }

    def __init__(self, all_other_loans=None, candidate_contribution=None, cash_on_hand_beginning_period=None, committee_designation=None, committee_designation_full=None, committee_id=None, committee_name=None, committee_type=None, committee_type_full=None, contribution_refunds=None, contributions=None, coverage_end_date=None, coverage_start_date=None, cycle=None, disbursements=None, individual_contributions=None, individual_itemized_contributions=None, individual_unitemized_contributions=None, last_beginning_image_number=None, last_cash_on_hand_end_period=None, last_debts_owed_by_committee=None, last_debts_owed_to_committee=None, last_report_type_full=None, last_report_year=None, loan_repayments=None, loan_repayments_candidate_loans=None, loan_repayments_other_loans=None, loans=None, loans_made_by_candidate=None, net_contributions=None, net_operating_expenditures=None, offsets_to_operating_expenditures=None, operating_expenditures=None, other_disbursements=None, other_political_committee_contributions=None, other_receipts=None, party_full=None, pdf_url=None, political_party_committee_contributions=None, receipts=None, refunded_individual_contributions=None, refunded_other_political_committee_contributions=None, refunded_political_party_committee_contributions=None, report_form=None, transaction_coverage_date=None, transfers_from_other_authorized_committee=None, transfers_to_other_authorized_committee=None, local_vars_configuration=None):  # noqa: E501
        """CommitteeTotalsHouseSenate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._all_other_loans = None
        self._candidate_contribution = None
        self._cash_on_hand_beginning_period = None
        self._committee_designation = None
        self._committee_designation_full = None
        self._committee_id = None
        self._committee_name = None
        self._committee_type = None
        self._committee_type_full = None
        self._contribution_refunds = None
        self._contributions = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._cycle = None
        self._disbursements = None
        self._individual_contributions = None
        self._individual_itemized_contributions = None
        self._individual_unitemized_contributions = None
        self._last_beginning_image_number = None
        self._last_cash_on_hand_end_period = None
        self._last_debts_owed_by_committee = None
        self._last_debts_owed_to_committee = None
        self._last_report_type_full = None
        self._last_report_year = None
        self._loan_repayments = None
        self._loan_repayments_candidate_loans = None
        self._loan_repayments_other_loans = None
        self._loans = None
        self._loans_made_by_candidate = None
        self._net_contributions = None
        self._net_operating_expenditures = None
        self._offsets_to_operating_expenditures = None
        self._operating_expenditures = None
        self._other_disbursements = None
        self._other_political_committee_contributions = None
        self._other_receipts = None
        self._party_full = None
        self._pdf_url = None
        self._political_party_committee_contributions = None
        self._receipts = None
        self._refunded_individual_contributions = None
        self._refunded_other_political_committee_contributions = None
        self._refunded_political_party_committee_contributions = None
        self._report_form = None
        self._transaction_coverage_date = None
        self._transfers_from_other_authorized_committee = None
        self._transfers_to_other_authorized_committee = None
        self.discriminator = None

        self.all_other_loans = all_other_loans
        self.candidate_contribution = candidate_contribution
        self.cash_on_hand_beginning_period = cash_on_hand_beginning_period
        self.committee_designation = committee_designation
        self.committee_designation_full = committee_designation_full
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.committee_type = committee_type
        self.committee_type_full = committee_type_full
        self.contribution_refunds = contribution_refunds
        self.contributions = contributions
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        self.cycle = cycle
        self.disbursements = disbursements
        self.individual_contributions = individual_contributions
        self.individual_itemized_contributions = individual_itemized_contributions
        self.individual_unitemized_contributions = individual_unitemized_contributions
        if last_beginning_image_number is not None:
            self.last_beginning_image_number = last_beginning_image_number
        if last_cash_on_hand_end_period is not None:
            self.last_cash_on_hand_end_period = last_cash_on_hand_end_period
        self.last_debts_owed_by_committee = last_debts_owed_by_committee
        self.last_debts_owed_to_committee = last_debts_owed_to_committee
        self.last_report_type_full = last_report_type_full
        self.last_report_year = last_report_year
        self.loan_repayments = loan_repayments
        self.loan_repayments_candidate_loans = loan_repayments_candidate_loans
        self.loan_repayments_other_loans = loan_repayments_other_loans
        self.loans = loans
        self.loans_made_by_candidate = loans_made_by_candidate
        self.net_contributions = net_contributions
        self.net_operating_expenditures = net_operating_expenditures
        self.offsets_to_operating_expenditures = offsets_to_operating_expenditures
        self.operating_expenditures = operating_expenditures
        self.other_disbursements = other_disbursements
        self.other_political_committee_contributions = other_political_committee_contributions
        self.other_receipts = other_receipts
        self.party_full = party_full
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.political_party_committee_contributions = political_party_committee_contributions
        self.receipts = receipts
        self.refunded_individual_contributions = refunded_individual_contributions
        self.refunded_other_political_committee_contributions = refunded_other_political_committee_contributions
        self.refunded_political_party_committee_contributions = refunded_political_party_committee_contributions
        if report_form is not None:
            self.report_form = report_form
        if transaction_coverage_date is not None:
            self.transaction_coverage_date = transaction_coverage_date
        self.transfers_from_other_authorized_committee = transfers_from_other_authorized_committee
        self.transfers_to_other_authorized_committee = transfers_to_other_authorized_committee

    @property
    def all_other_loans(self):
        """Gets the all_other_loans of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The all_other_loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._all_other_loans

    @all_other_loans.setter
    def all_other_loans(self, all_other_loans):
        """Sets the all_other_loans of this CommitteeTotalsHouseSenate.


        :param all_other_loans: The all_other_loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._all_other_loans = all_other_loans

    @property
    def candidate_contribution(self):
        """Gets the candidate_contribution of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The candidate_contribution of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._candidate_contribution

    @candidate_contribution.setter
    def candidate_contribution(self, candidate_contribution):
        """Sets the candidate_contribution of this CommitteeTotalsHouseSenate.


        :param candidate_contribution: The candidate_contribution of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._candidate_contribution = candidate_contribution

    @property
    def cash_on_hand_beginning_period(self):
        """Gets the cash_on_hand_beginning_period of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The cash_on_hand_beginning_period of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_beginning_period

    @cash_on_hand_beginning_period.setter
    def cash_on_hand_beginning_period(self, cash_on_hand_beginning_period):
        """Sets the cash_on_hand_beginning_period of this CommitteeTotalsHouseSenate.


        :param cash_on_hand_beginning_period: The cash_on_hand_beginning_period of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_beginning_period = cash_on_hand_beginning_period

    @property
    def committee_designation(self):
        """Gets the committee_designation of this CommitteeTotalsHouseSenate.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The committee_designation of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_designation

    @committee_designation.setter
    def committee_designation(self, committee_designation):
        """Sets the committee_designation of this CommitteeTotalsHouseSenate.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param committee_designation: The committee_designation of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_designation = committee_designation

    @property
    def committee_designation_full(self):
        """Gets the committee_designation_full of this CommitteeTotalsHouseSenate.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The committee_designation_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_designation_full

    @committee_designation_full.setter
    def committee_designation_full(self, committee_designation_full):
        """Sets the committee_designation_full of this CommitteeTotalsHouseSenate.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param committee_designation_full: The committee_designation_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_designation_full = committee_designation_full

    @property
    def committee_id(self):
        """Gets the committee_id of this CommitteeTotalsHouseSenate.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this CommitteeTotalsHouseSenate.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this CommitteeTotalsHouseSenate.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this CommitteeTotalsHouseSenate.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def committee_type(self):
        """Gets the committee_type of this CommitteeTotalsHouseSenate.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this CommitteeTotalsHouseSenate.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type: The committee_type of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_type = committee_type

    @property
    def committee_type_full(self):
        """Gets the committee_type_full of this CommitteeTotalsHouseSenate.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._committee_type_full

    @committee_type_full.setter
    def committee_type_full(self, committee_type_full):
        """Sets the committee_type_full of this CommitteeTotalsHouseSenate.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type_full: The committee_type_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._committee_type_full = committee_type_full

    @property
    def contribution_refunds(self):
        """Gets the contribution_refunds of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The contribution_refunds of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._contribution_refunds

    @contribution_refunds.setter
    def contribution_refunds(self, contribution_refunds):
        """Sets the contribution_refunds of this CommitteeTotalsHouseSenate.


        :param contribution_refunds: The contribution_refunds of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._contribution_refunds = contribution_refunds

    @property
    def contributions(self):
        """Gets the contributions of this CommitteeTotalsHouseSenate.  # noqa: E501

        Contribution  # noqa: E501

        :return: The contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._contributions

    @contributions.setter
    def contributions(self, contributions):
        """Sets the contributions of this CommitteeTotalsHouseSenate.

        Contribution  # noqa: E501

        :param contributions: The contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._contributions = contributions

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The coverage_end_date of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this CommitteeTotalsHouseSenate.


        :param coverage_end_date: The coverage_end_date of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: datetime
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The coverage_start_date of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this CommitteeTotalsHouseSenate.


        :param coverage_start_date: The coverage_start_date of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: datetime
        """

        self._coverage_start_date = coverage_start_date

    @property
    def cycle(self):
        """Gets the cycle of this CommitteeTotalsHouseSenate.  # noqa: E501

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CommitteeTotalsHouseSenate.

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and cycle is None:  # noqa: E501
            raise ValueError('Invalid value for `cycle`, must not be `None`')  # noqa: E501

        self._cycle = cycle

    @property
    def disbursements(self):
        """Gets the disbursements of this CommitteeTotalsHouseSenate.  # noqa: E501

        Disbursements  # noqa: E501

        :return: The disbursements of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._disbursements

    @disbursements.setter
    def disbursements(self, disbursements):
        """Sets the disbursements of this CommitteeTotalsHouseSenate.

        Disbursements  # noqa: E501

        :param disbursements: The disbursements of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._disbursements = disbursements

    @property
    def individual_contributions(self):
        """Gets the individual_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The individual_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_contributions

    @individual_contributions.setter
    def individual_contributions(self, individual_contributions):
        """Sets the individual_contributions of this CommitteeTotalsHouseSenate.


        :param individual_contributions: The individual_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_contributions = individual_contributions

    @property
    def individual_itemized_contributions(self):
        """Gets the individual_itemized_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less.  # noqa: E501

        :return: The individual_itemized_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_itemized_contributions

    @individual_itemized_contributions.setter
    def individual_itemized_contributions(self, individual_itemized_contributions):
        """Sets the individual_itemized_contributions of this CommitteeTotalsHouseSenate.

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less.  # noqa: E501

        :param individual_itemized_contributions: The individual_itemized_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_itemized_contributions = individual_itemized_contributions

    @property
    def individual_unitemized_contributions(self):
        """Gets the individual_unitemized_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total.  # noqa: E501

        :return: The individual_unitemized_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._individual_unitemized_contributions

    @individual_unitemized_contributions.setter
    def individual_unitemized_contributions(self, individual_unitemized_contributions):
        """Sets the individual_unitemized_contributions of this CommitteeTotalsHouseSenate.

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total.  # noqa: E501

        :param individual_unitemized_contributions: The individual_unitemized_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._individual_unitemized_contributions = individual_unitemized_contributions

    @property
    def last_beginning_image_number(self):
        """Gets the last_beginning_image_number of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The last_beginning_image_number of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._last_beginning_image_number

    @last_beginning_image_number.setter
    def last_beginning_image_number(self, last_beginning_image_number):
        """Sets the last_beginning_image_number of this CommitteeTotalsHouseSenate.


        :param last_beginning_image_number: The last_beginning_image_number of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._last_beginning_image_number = last_beginning_image_number

    @property
    def last_cash_on_hand_end_period(self):
        """Gets the last_cash_on_hand_end_period of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The last_cash_on_hand_end_period of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._last_cash_on_hand_end_period

    @last_cash_on_hand_end_period.setter
    def last_cash_on_hand_end_period(self, last_cash_on_hand_end_period):
        """Sets the last_cash_on_hand_end_period of this CommitteeTotalsHouseSenate.


        :param last_cash_on_hand_end_period: The last_cash_on_hand_end_period of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._last_cash_on_hand_end_period = last_cash_on_hand_end_period

    @property
    def last_debts_owed_by_committee(self):
        """Gets the last_debts_owed_by_committee of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The last_debts_owed_by_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._last_debts_owed_by_committee

    @last_debts_owed_by_committee.setter
    def last_debts_owed_by_committee(self, last_debts_owed_by_committee):
        """Sets the last_debts_owed_by_committee of this CommitteeTotalsHouseSenate.


        :param last_debts_owed_by_committee: The last_debts_owed_by_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._last_debts_owed_by_committee = last_debts_owed_by_committee

    @property
    def last_debts_owed_to_committee(self):
        """Gets the last_debts_owed_to_committee of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The last_debts_owed_to_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._last_debts_owed_to_committee

    @last_debts_owed_to_committee.setter
    def last_debts_owed_to_committee(self, last_debts_owed_to_committee):
        """Sets the last_debts_owed_to_committee of this CommitteeTotalsHouseSenate.


        :param last_debts_owed_to_committee: The last_debts_owed_to_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._last_debts_owed_to_committee = last_debts_owed_to_committee

    @property
    def last_report_type_full(self):
        """Gets the last_report_type_full of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The last_report_type_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._last_report_type_full

    @last_report_type_full.setter
    def last_report_type_full(self, last_report_type_full):
        """Sets the last_report_type_full of this CommitteeTotalsHouseSenate.


        :param last_report_type_full: The last_report_type_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._last_report_type_full = last_report_type_full

    @property
    def last_report_year(self):
        """Gets the last_report_year of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The last_report_year of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: int
        """
        return self._last_report_year

    @last_report_year.setter
    def last_report_year(self, last_report_year):
        """Sets the last_report_year of this CommitteeTotalsHouseSenate.


        :param last_report_year: The last_report_year of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: int
        """

        self._last_report_year = last_report_year

    @property
    def loan_repayments(self):
        """Gets the loan_repayments of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The loan_repayments of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments

    @loan_repayments.setter
    def loan_repayments(self, loan_repayments):
        """Sets the loan_repayments of this CommitteeTotalsHouseSenate.


        :param loan_repayments: The loan_repayments of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments = loan_repayments

    @property
    def loan_repayments_candidate_loans(self):
        """Gets the loan_repayments_candidate_loans of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The loan_repayments_candidate_loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_candidate_loans

    @loan_repayments_candidate_loans.setter
    def loan_repayments_candidate_loans(self, loan_repayments_candidate_loans):
        """Sets the loan_repayments_candidate_loans of this CommitteeTotalsHouseSenate.


        :param loan_repayments_candidate_loans: The loan_repayments_candidate_loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments_candidate_loans = loan_repayments_candidate_loans

    @property
    def loan_repayments_other_loans(self):
        """Gets the loan_repayments_other_loans of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The loan_repayments_other_loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_other_loans

    @loan_repayments_other_loans.setter
    def loan_repayments_other_loans(self, loan_repayments_other_loans):
        """Sets the loan_repayments_other_loans of this CommitteeTotalsHouseSenate.


        :param loan_repayments_other_loans: The loan_repayments_other_loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loan_repayments_other_loans = loan_repayments_other_loans

    @property
    def loans(self):
        """Gets the loans of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loans

    @loans.setter
    def loans(self, loans):
        """Sets the loans of this CommitteeTotalsHouseSenate.


        :param loans: The loans of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loans = loans

    @property
    def loans_made_by_candidate(self):
        """Gets the loans_made_by_candidate of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The loans_made_by_candidate of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._loans_made_by_candidate

    @loans_made_by_candidate.setter
    def loans_made_by_candidate(self, loans_made_by_candidate):
        """Sets the loans_made_by_candidate of this CommitteeTotalsHouseSenate.


        :param loans_made_by_candidate: The loans_made_by_candidate of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._loans_made_by_candidate = loans_made_by_candidate

    @property
    def net_contributions(self):
        """Gets the net_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The net_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._net_contributions

    @net_contributions.setter
    def net_contributions(self, net_contributions):
        """Sets the net_contributions of this CommitteeTotalsHouseSenate.


        :param net_contributions: The net_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._net_contributions = net_contributions

    @property
    def net_operating_expenditures(self):
        """Gets the net_operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The net_operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._net_operating_expenditures

    @net_operating_expenditures.setter
    def net_operating_expenditures(self, net_operating_expenditures):
        """Sets the net_operating_expenditures of this CommitteeTotalsHouseSenate.


        :param net_operating_expenditures: The net_operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._net_operating_expenditures = net_operating_expenditures

    @property
    def offsets_to_operating_expenditures(self):
        """Gets the offsets_to_operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The offsets_to_operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_operating_expenditures

    @offsets_to_operating_expenditures.setter
    def offsets_to_operating_expenditures(self, offsets_to_operating_expenditures):
        """Sets the offsets_to_operating_expenditures of this CommitteeTotalsHouseSenate.


        :param offsets_to_operating_expenditures: The offsets_to_operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._offsets_to_operating_expenditures = offsets_to_operating_expenditures

    @property
    def operating_expenditures(self):
        """Gets the operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._operating_expenditures

    @operating_expenditures.setter
    def operating_expenditures(self, operating_expenditures):
        """Sets the operating_expenditures of this CommitteeTotalsHouseSenate.


        :param operating_expenditures: The operating_expenditures of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._operating_expenditures = operating_expenditures

    @property
    def other_disbursements(self):
        """Gets the other_disbursements of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The other_disbursements of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_disbursements

    @other_disbursements.setter
    def other_disbursements(self, other_disbursements):
        """Sets the other_disbursements of this CommitteeTotalsHouseSenate.


        :param other_disbursements: The other_disbursements of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_disbursements = other_disbursements

    @property
    def other_political_committee_contributions(self):
        """Gets the other_political_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The other_political_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_political_committee_contributions

    @other_political_committee_contributions.setter
    def other_political_committee_contributions(self, other_political_committee_contributions):
        """Sets the other_political_committee_contributions of this CommitteeTotalsHouseSenate.


        :param other_political_committee_contributions: The other_political_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_political_committee_contributions = other_political_committee_contributions

    @property
    def other_receipts(self):
        """Gets the other_receipts of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The other_receipts of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._other_receipts

    @other_receipts.setter
    def other_receipts(self, other_receipts):
        """Sets the other_receipts of this CommitteeTotalsHouseSenate.


        :param other_receipts: The other_receipts of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._other_receipts = other_receipts

    @property
    def party_full(self):
        """Gets the party_full of this CommitteeTotalsHouseSenate.  # noqa: E501

        Party affiliated with a candidate or committee  # noqa: E501

        :return: The party_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._party_full

    @party_full.setter
    def party_full(self, party_full):
        """Sets the party_full of this CommitteeTotalsHouseSenate.

        Party affiliated with a candidate or committee  # noqa: E501

        :param party_full: The party_full of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._party_full = party_full

    @property
    def pdf_url(self):
        """Gets the pdf_url of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The pdf_url of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this CommitteeTotalsHouseSenate.


        :param pdf_url: The pdf_url of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def political_party_committee_contributions(self):
        """Gets the political_party_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The political_party_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._political_party_committee_contributions

    @political_party_committee_contributions.setter
    def political_party_committee_contributions(self, political_party_committee_contributions):
        """Sets the political_party_committee_contributions of this CommitteeTotalsHouseSenate.


        :param political_party_committee_contributions: The political_party_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._political_party_committee_contributions = political_party_committee_contributions

    @property
    def receipts(self):
        """Gets the receipts of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The receipts of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._receipts

    @receipts.setter
    def receipts(self, receipts):
        """Sets the receipts of this CommitteeTotalsHouseSenate.


        :param receipts: The receipts of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._receipts = receipts

    @property
    def refunded_individual_contributions(self):
        """Gets the refunded_individual_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The refunded_individual_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_individual_contributions

    @refunded_individual_contributions.setter
    def refunded_individual_contributions(self, refunded_individual_contributions):
        """Sets the refunded_individual_contributions of this CommitteeTotalsHouseSenate.


        :param refunded_individual_contributions: The refunded_individual_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_individual_contributions = refunded_individual_contributions

    @property
    def refunded_other_political_committee_contributions(self):
        """Gets the refunded_other_political_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The refunded_other_political_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_other_political_committee_contributions

    @refunded_other_political_committee_contributions.setter
    def refunded_other_political_committee_contributions(self, refunded_other_political_committee_contributions):
        """Sets the refunded_other_political_committee_contributions of this CommitteeTotalsHouseSenate.


        :param refunded_other_political_committee_contributions: The refunded_other_political_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_other_political_committee_contributions = refunded_other_political_committee_contributions

    @property
    def refunded_political_party_committee_contributions(self):
        """Gets the refunded_political_party_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The refunded_political_party_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._refunded_political_party_committee_contributions

    @refunded_political_party_committee_contributions.setter
    def refunded_political_party_committee_contributions(self, refunded_political_party_committee_contributions):
        """Sets the refunded_political_party_committee_contributions of this CommitteeTotalsHouseSenate.


        :param refunded_political_party_committee_contributions: The refunded_political_party_committee_contributions of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._refunded_political_party_committee_contributions = refunded_political_party_committee_contributions

    @property
    def report_form(self):
        """Gets the report_form of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The report_form of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: str
        """
        return self._report_form

    @report_form.setter
    def report_form(self, report_form):
        """Sets the report_form of this CommitteeTotalsHouseSenate.


        :param report_form: The report_form of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: str
        """

        self._report_form = report_form

    @property
    def transaction_coverage_date(self):
        """Gets the transaction_coverage_date of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The transaction_coverage_date of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: date
        """
        return self._transaction_coverage_date

    @transaction_coverage_date.setter
    def transaction_coverage_date(self, transaction_coverage_date):
        """Sets the transaction_coverage_date of this CommitteeTotalsHouseSenate.


        :param transaction_coverage_date: The transaction_coverage_date of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: date
        """

        self._transaction_coverage_date = transaction_coverage_date

    @property
    def transfers_from_other_authorized_committee(self):
        """Gets the transfers_from_other_authorized_committee of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The transfers_from_other_authorized_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_other_authorized_committee

    @transfers_from_other_authorized_committee.setter
    def transfers_from_other_authorized_committee(self, transfers_from_other_authorized_committee):
        """Sets the transfers_from_other_authorized_committee of this CommitteeTotalsHouseSenate.


        :param transfers_from_other_authorized_committee: The transfers_from_other_authorized_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._transfers_from_other_authorized_committee = transfers_from_other_authorized_committee

    @property
    def transfers_to_other_authorized_committee(self):
        """Gets the transfers_to_other_authorized_committee of this CommitteeTotalsHouseSenate.  # noqa: E501


        :return: The transfers_to_other_authorized_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :rtype: float
        """
        return self._transfers_to_other_authorized_committee

    @transfers_to_other_authorized_committee.setter
    def transfers_to_other_authorized_committee(self, transfers_to_other_authorized_committee):
        """Sets the transfers_to_other_authorized_committee of this CommitteeTotalsHouseSenate.


        :param transfers_to_other_authorized_committee: The transfers_to_other_authorized_committee of this CommitteeTotalsHouseSenate.  # noqa: E501
        :type: float
        """

        self._transfers_to_other_authorized_committee = transfers_to_other_authorized_committee

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommitteeTotalsHouseSenate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommitteeTotalsHouseSenate):
            return True

        return self.to_dict() != other.to_dict()
