# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CommitteeTotalsIEOnly(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'committee_id': 'str',
        'coverage_end_date': 'datetime',
        'coverage_start_date': 'datetime',
        'cycle': 'int',
        'last_beginning_image_number': 'str',
        'last_cash_on_hand_end_period': 'float',
        'pdf_url': 'str',
        'report_form': 'str',
        'total_independent_contributions': 'float',
        'total_independent_expenditures': 'float',
        'transaction_coverage_date': 'date'
    }

    attribute_map = {
        'committee_id': 'committee_id',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'cycle': 'cycle',
        'last_beginning_image_number': 'last_beginning_image_number',
        'last_cash_on_hand_end_period': 'last_cash_on_hand_end_period',
        'pdf_url': 'pdf_url',
        'report_form': 'report_form',
        'total_independent_contributions': 'total_independent_contributions',
        'total_independent_expenditures': 'total_independent_expenditures',
        'transaction_coverage_date': 'transaction_coverage_date'
    }

    def __init__(self, committee_id=None, coverage_end_date=None, coverage_start_date=None, cycle=None, last_beginning_image_number=None, last_cash_on_hand_end_period=None, pdf_url=None, report_form=None, total_independent_contributions=None, total_independent_expenditures=None, transaction_coverage_date=None, local_vars_configuration=None):  # noqa: E501
        """CommitteeTotalsIEOnly - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._committee_id = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._cycle = None
        self._last_beginning_image_number = None
        self._last_cash_on_hand_end_period = None
        self._pdf_url = None
        self._report_form = None
        self._total_independent_contributions = None
        self._total_independent_expenditures = None
        self._transaction_coverage_date = None
        self.discriminator = None

        self.committee_id = committee_id
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        self.cycle = cycle
        if last_beginning_image_number is not None:
            self.last_beginning_image_number = last_beginning_image_number
        if last_cash_on_hand_end_period is not None:
            self.last_cash_on_hand_end_period = last_cash_on_hand_end_period
        if pdf_url is not None:
            self.pdf_url = pdf_url
        if report_form is not None:
            self.report_form = report_form
        self.total_independent_contributions = total_independent_contributions
        self.total_independent_expenditures = total_independent_expenditures
        if transaction_coverage_date is not None:
            self.transaction_coverage_date = transaction_coverage_date

    @property
    def committee_id(self):
        """Gets the committee_id of this CommitteeTotalsIEOnly.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this CommitteeTotalsIEOnly.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this CommitteeTotalsIEOnly.  # noqa: E501

        Ending date of the reporting period  # noqa: E501

        :return: The coverage_end_date of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this CommitteeTotalsIEOnly.

        Ending date of the reporting period  # noqa: E501

        :param coverage_end_date: The coverage_end_date of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: datetime
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this CommitteeTotalsIEOnly.  # noqa: E501

        Beginning date of the reporting period  # noqa: E501

        :return: The coverage_start_date of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this CommitteeTotalsIEOnly.

        Beginning date of the reporting period  # noqa: E501

        :param coverage_start_date: The coverage_start_date of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: datetime
        """

        self._coverage_start_date = coverage_start_date

    @property
    def cycle(self):
        """Gets the cycle of this CommitteeTotalsIEOnly.  # noqa: E501

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CommitteeTotalsIEOnly.

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def last_beginning_image_number(self):
        """Gets the last_beginning_image_number of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The last_beginning_image_number of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: str
        """
        return self._last_beginning_image_number

    @last_beginning_image_number.setter
    def last_beginning_image_number(self, last_beginning_image_number):
        """Sets the last_beginning_image_number of this CommitteeTotalsIEOnly.


        :param last_beginning_image_number: The last_beginning_image_number of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: str
        """

        self._last_beginning_image_number = last_beginning_image_number

    @property
    def last_cash_on_hand_end_period(self):
        """Gets the last_cash_on_hand_end_period of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The last_cash_on_hand_end_period of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: float
        """
        return self._last_cash_on_hand_end_period

    @last_cash_on_hand_end_period.setter
    def last_cash_on_hand_end_period(self, last_cash_on_hand_end_period):
        """Sets the last_cash_on_hand_end_period of this CommitteeTotalsIEOnly.


        :param last_cash_on_hand_end_period: The last_cash_on_hand_end_period of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: float
        """

        self._last_cash_on_hand_end_period = last_cash_on_hand_end_period

    @property
    def pdf_url(self):
        """Gets the pdf_url of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The pdf_url of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this CommitteeTotalsIEOnly.


        :param pdf_url: The pdf_url of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def report_form(self):
        """Gets the report_form of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The report_form of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: str
        """
        return self._report_form

    @report_form.setter
    def report_form(self, report_form):
        """Sets the report_form of this CommitteeTotalsIEOnly.


        :param report_form: The report_form of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: str
        """

        self._report_form = report_form

    @property
    def total_independent_contributions(self):
        """Gets the total_independent_contributions of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The total_independent_contributions of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: float
        """
        return self._total_independent_contributions

    @total_independent_contributions.setter
    def total_independent_contributions(self, total_independent_contributions):
        """Sets the total_independent_contributions of this CommitteeTotalsIEOnly.


        :param total_independent_contributions: The total_independent_contributions of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: float
        """

        self._total_independent_contributions = total_independent_contributions

    @property
    def total_independent_expenditures(self):
        """Gets the total_independent_expenditures of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The total_independent_expenditures of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: float
        """
        return self._total_independent_expenditures

    @total_independent_expenditures.setter
    def total_independent_expenditures(self, total_independent_expenditures):
        """Sets the total_independent_expenditures of this CommitteeTotalsIEOnly.


        :param total_independent_expenditures: The total_independent_expenditures of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: float
        """

        self._total_independent_expenditures = total_independent_expenditures

    @property
    def transaction_coverage_date(self):
        """Gets the transaction_coverage_date of this CommitteeTotalsIEOnly.  # noqa: E501


        :return: The transaction_coverage_date of this CommitteeTotalsIEOnly.  # noqa: E501
        :rtype: date
        """
        return self._transaction_coverage_date

    @transaction_coverage_date.setter
    def transaction_coverage_date(self, transaction_coverage_date):
        """Sets the transaction_coverage_date of this CommitteeTotalsIEOnly.


        :param transaction_coverage_date: The transaction_coverage_date of this CommitteeTotalsIEOnly.  # noqa: E501
        :type: date
        """

        self._transaction_coverage_date = transaction_coverage_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommitteeTotalsIEOnly):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommitteeTotalsIEOnly):
            return True

        return self.to_dict() != other.to_dict()
