# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CommitteeTotalsPacParty(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'all_loans_received': 'float',
        'allocated_federal_election_levin_share': 'float',
        'cash_on_hand_beginning_period': 'float',
        'committee_designation': 'str',
        'committee_designation_full': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'committee_type': 'str',
        'committee_type_full': 'str',
        'contribution_refunds': 'float',
        'contributions': 'float',
        'convention_exp': 'float',
        'coordinated_expenditures_by_party_committee': 'float',
        'coverage_end_date': 'datetime',
        'coverage_start_date': 'datetime',
        'cycle': 'int',
        'disbursements': 'float',
        'exp_prior_years_subject_limits': 'float',
        'exp_subject_limits': 'float',
        'fed_candidate_committee_contributions': 'float',
        'fed_candidate_contribution_refunds': 'float',
        'fed_disbursements': 'float',
        'fed_election_activity': 'float',
        'fed_operating_expenditures': 'float',
        'fed_receipts': 'float',
        'federal_funds': 'float',
        'independent_expenditures': 'float',
        'individual_contributions': 'float',
        'individual_itemized_contributions': 'float',
        'individual_unitemized_contributions': 'float',
        'itemized_convention_exp': 'float',
        'itemized_other_disb': 'float',
        'itemized_other_income': 'float',
        'itemized_other_refunds': 'float',
        'itemized_refunds_relating_convention_exp': 'float',
        'last_beginning_image_number': 'str',
        'last_cash_on_hand_end_period': 'float',
        'last_debts_owed_by_committee': 'float',
        'last_debts_owed_to_committee': 'float',
        'last_report_type_full': 'str',
        'last_report_year': 'int',
        'loan_repayments_made': 'float',
        'loan_repayments_received': 'float',
        'loans_and_loan_repayments_made': 'float',
        'loans_and_loan_repayments_received': 'float',
        'loans_made': 'float',
        'net_contributions': 'float',
        'net_operating_expenditures': 'float',
        'non_allocated_fed_election_activity': 'float',
        'offsets_to_operating_expenditures': 'float',
        'operating_expenditures': 'float',
        'other_disbursements': 'float',
        'other_fed_operating_expenditures': 'float',
        'other_fed_receipts': 'float',
        'other_political_committee_contributions': 'float',
        'other_refunds': 'float',
        'party_full': 'str',
        'pdf_url': 'str',
        'political_party_committee_contributions': 'float',
        'receipts': 'float',
        'refunded_individual_contributions': 'float',
        'refunded_other_political_committee_contributions': 'float',
        'refunded_political_party_committee_contributions': 'float',
        'refunds_relating_convention_exp': 'float',
        'report_form': 'str',
        'shared_fed_activity': 'float',
        'shared_fed_activity_nonfed': 'float',
        'shared_fed_operating_expenditures': 'float',
        'shared_nonfed_operating_expenditures': 'float',
        'total_exp_subject_limits': 'float',
        'total_transfers': 'float',
        'transaction_coverage_date': 'date',
        'transfers_from_affiliated_party': 'float',
        'transfers_from_nonfed_account': 'float',
        'transfers_from_nonfed_levin': 'float',
        'transfers_to_affiliated_committee': 'float',
        'unitemized_convention_exp': 'float',
        'unitemized_other_disb': 'float',
        'unitemized_other_income': 'float',
        'unitemized_other_refunds': 'float',
        'unitemized_refunds_relating_convention_exp': 'float'
    }

    attribute_map = {
        'all_loans_received': 'all_loans_received',
        'allocated_federal_election_levin_share': 'allocated_federal_election_levin_share',
        'cash_on_hand_beginning_period': 'cash_on_hand_beginning_period',
        'committee_designation': 'committee_designation',
        'committee_designation_full': 'committee_designation_full',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'committee_type': 'committee_type',
        'committee_type_full': 'committee_type_full',
        'contribution_refunds': 'contribution_refunds',
        'contributions': 'contributions',
        'convention_exp': 'convention_exp',
        'coordinated_expenditures_by_party_committee': 'coordinated_expenditures_by_party_committee',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'cycle': 'cycle',
        'disbursements': 'disbursements',
        'exp_prior_years_subject_limits': 'exp_prior_years_subject_limits',
        'exp_subject_limits': 'exp_subject_limits',
        'fed_candidate_committee_contributions': 'fed_candidate_committee_contributions',
        'fed_candidate_contribution_refunds': 'fed_candidate_contribution_refunds',
        'fed_disbursements': 'fed_disbursements',
        'fed_election_activity': 'fed_election_activity',
        'fed_operating_expenditures': 'fed_operating_expenditures',
        'fed_receipts': 'fed_receipts',
        'federal_funds': 'federal_funds',
        'independent_expenditures': 'independent_expenditures',
        'individual_contributions': 'individual_contributions',
        'individual_itemized_contributions': 'individual_itemized_contributions',
        'individual_unitemized_contributions': 'individual_unitemized_contributions',
        'itemized_convention_exp': 'itemized_convention_exp',
        'itemized_other_disb': 'itemized_other_disb',
        'itemized_other_income': 'itemized_other_income',
        'itemized_other_refunds': 'itemized_other_refunds',
        'itemized_refunds_relating_convention_exp': 'itemized_refunds_relating_convention_exp',
        'last_beginning_image_number': 'last_beginning_image_number',
        'last_cash_on_hand_end_period': 'last_cash_on_hand_end_period',
        'last_debts_owed_by_committee': 'last_debts_owed_by_committee',
        'last_debts_owed_to_committee': 'last_debts_owed_to_committee',
        'last_report_type_full': 'last_report_type_full',
        'last_report_year': 'last_report_year',
        'loan_repayments_made': 'loan_repayments_made',
        'loan_repayments_received': 'loan_repayments_received',
        'loans_and_loan_repayments_made': 'loans_and_loan_repayments_made',
        'loans_and_loan_repayments_received': 'loans_and_loan_repayments_received',
        'loans_made': 'loans_made',
        'net_contributions': 'net_contributions',
        'net_operating_expenditures': 'net_operating_expenditures',
        'non_allocated_fed_election_activity': 'non_allocated_fed_election_activity',
        'offsets_to_operating_expenditures': 'offsets_to_operating_expenditures',
        'operating_expenditures': 'operating_expenditures',
        'other_disbursements': 'other_disbursements',
        'other_fed_operating_expenditures': 'other_fed_operating_expenditures',
        'other_fed_receipts': 'other_fed_receipts',
        'other_political_committee_contributions': 'other_political_committee_contributions',
        'other_refunds': 'other_refunds',
        'party_full': 'party_full',
        'pdf_url': 'pdf_url',
        'political_party_committee_contributions': 'political_party_committee_contributions',
        'receipts': 'receipts',
        'refunded_individual_contributions': 'refunded_individual_contributions',
        'refunded_other_political_committee_contributions': 'refunded_other_political_committee_contributions',
        'refunded_political_party_committee_contributions': 'refunded_political_party_committee_contributions',
        'refunds_relating_convention_exp': 'refunds_relating_convention_exp',
        'report_form': 'report_form',
        'shared_fed_activity': 'shared_fed_activity',
        'shared_fed_activity_nonfed': 'shared_fed_activity_nonfed',
        'shared_fed_operating_expenditures': 'shared_fed_operating_expenditures',
        'shared_nonfed_operating_expenditures': 'shared_nonfed_operating_expenditures',
        'total_exp_subject_limits': 'total_exp_subject_limits',
        'total_transfers': 'total_transfers',
        'transaction_coverage_date': 'transaction_coverage_date',
        'transfers_from_affiliated_party': 'transfers_from_affiliated_party',
        'transfers_from_nonfed_account': 'transfers_from_nonfed_account',
        'transfers_from_nonfed_levin': 'transfers_from_nonfed_levin',
        'transfers_to_affiliated_committee': 'transfers_to_affiliated_committee',
        'unitemized_convention_exp': 'unitemized_convention_exp',
        'unitemized_other_disb': 'unitemized_other_disb',
        'unitemized_other_income': 'unitemized_other_income',
        'unitemized_other_refunds': 'unitemized_other_refunds',
        'unitemized_refunds_relating_convention_exp': 'unitemized_refunds_relating_convention_exp'
    }

    def __init__(self, all_loans_received=None, allocated_federal_election_levin_share=None, cash_on_hand_beginning_period=None, committee_designation=None, committee_designation_full=None, committee_id=None, committee_name=None, committee_type=None, committee_type_full=None, contribution_refunds=None, contributions=None, convention_exp=None, coordinated_expenditures_by_party_committee=None, coverage_end_date=None, coverage_start_date=None, cycle=None, disbursements=None, exp_prior_years_subject_limits=None, exp_subject_limits=None, fed_candidate_committee_contributions=None, fed_candidate_contribution_refunds=None, fed_disbursements=None, fed_election_activity=None, fed_operating_expenditures=None, fed_receipts=None, federal_funds=None, independent_expenditures=None, individual_contributions=None, individual_itemized_contributions=None, individual_unitemized_contributions=None, itemized_convention_exp=None, itemized_other_disb=None, itemized_other_income=None, itemized_other_refunds=None, itemized_refunds_relating_convention_exp=None, last_beginning_image_number=None, last_cash_on_hand_end_period=None, last_debts_owed_by_committee=None, last_debts_owed_to_committee=None, last_report_type_full=None, last_report_year=None, loan_repayments_made=None, loan_repayments_received=None, loans_and_loan_repayments_made=None, loans_and_loan_repayments_received=None, loans_made=None, net_contributions=None, net_operating_expenditures=None, non_allocated_fed_election_activity=None, offsets_to_operating_expenditures=None, operating_expenditures=None, other_disbursements=None, other_fed_operating_expenditures=None, other_fed_receipts=None, other_political_committee_contributions=None, other_refunds=None, party_full=None, pdf_url=None, political_party_committee_contributions=None, receipts=None, refunded_individual_contributions=None, refunded_other_political_committee_contributions=None, refunded_political_party_committee_contributions=None, refunds_relating_convention_exp=None, report_form=None, shared_fed_activity=None, shared_fed_activity_nonfed=None, shared_fed_operating_expenditures=None, shared_nonfed_operating_expenditures=None, total_exp_subject_limits=None, total_transfers=None, transaction_coverage_date=None, transfers_from_affiliated_party=None, transfers_from_nonfed_account=None, transfers_from_nonfed_levin=None, transfers_to_affiliated_committee=None, unitemized_convention_exp=None, unitemized_other_disb=None, unitemized_other_income=None, unitemized_other_refunds=None, unitemized_refunds_relating_convention_exp=None, local_vars_configuration=None):  # noqa: E501
        """CommitteeTotalsPacParty - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._all_loans_received = None
        self._allocated_federal_election_levin_share = None
        self._cash_on_hand_beginning_period = None
        self._committee_designation = None
        self._committee_designation_full = None
        self._committee_id = None
        self._committee_name = None
        self._committee_type = None
        self._committee_type_full = None
        self._contribution_refunds = None
        self._contributions = None
        self._convention_exp = None
        self._coordinated_expenditures_by_party_committee = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._cycle = None
        self._disbursements = None
        self._exp_prior_years_subject_limits = None
        self._exp_subject_limits = None
        self._fed_candidate_committee_contributions = None
        self._fed_candidate_contribution_refunds = None
        self._fed_disbursements = None
        self._fed_election_activity = None
        self._fed_operating_expenditures = None
        self._fed_receipts = None
        self._federal_funds = None
        self._independent_expenditures = None
        self._individual_contributions = None
        self._individual_itemized_contributions = None
        self._individual_unitemized_contributions = None
        self._itemized_convention_exp = None
        self._itemized_other_disb = None
        self._itemized_other_income = None
        self._itemized_other_refunds = None
        self._itemized_refunds_relating_convention_exp = None
        self._last_beginning_image_number = None
        self._last_cash_on_hand_end_period = None
        self._last_debts_owed_by_committee = None
        self._last_debts_owed_to_committee = None
        self._last_report_type_full = None
        self._last_report_year = None
        self._loan_repayments_made = None
        self._loan_repayments_received = None
        self._loans_and_loan_repayments_made = None
        self._loans_and_loan_repayments_received = None
        self._loans_made = None
        self._net_contributions = None
        self._net_operating_expenditures = None
        self._non_allocated_fed_election_activity = None
        self._offsets_to_operating_expenditures = None
        self._operating_expenditures = None
        self._other_disbursements = None
        self._other_fed_operating_expenditures = None
        self._other_fed_receipts = None
        self._other_political_committee_contributions = None
        self._other_refunds = None
        self._party_full = None
        self._pdf_url = None
        self._political_party_committee_contributions = None
        self._receipts = None
        self._refunded_individual_contributions = None
        self._refunded_other_political_committee_contributions = None
        self._refunded_political_party_committee_contributions = None
        self._refunds_relating_convention_exp = None
        self._report_form = None
        self._shared_fed_activity = None
        self._shared_fed_activity_nonfed = None
        self._shared_fed_operating_expenditures = None
        self._shared_nonfed_operating_expenditures = None
        self._total_exp_subject_limits = None
        self._total_transfers = None
        self._transaction_coverage_date = None
        self._transfers_from_affiliated_party = None
        self._transfers_from_nonfed_account = None
        self._transfers_from_nonfed_levin = None
        self._transfers_to_affiliated_committee = None
        self._unitemized_convention_exp = None
        self._unitemized_other_disb = None
        self._unitemized_other_income = None
        self._unitemized_other_refunds = None
        self._unitemized_refunds_relating_convention_exp = None
        self.discriminator = None

        self.all_loans_received = all_loans_received
        self.allocated_federal_election_levin_share = allocated_federal_election_levin_share
        self.cash_on_hand_beginning_period = cash_on_hand_beginning_period
        self.committee_designation = committee_designation
        self.committee_designation_full = committee_designation_full
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.committee_type = committee_type
        self.committee_type_full = committee_type_full
        self.contribution_refunds = contribution_refunds
        self.contributions = contributions
        self.convention_exp = convention_exp
        self.coordinated_expenditures_by_party_committee = coordinated_expenditures_by_party_committee
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        if cycle is not None:
            self.cycle = cycle
        self.disbursements = disbursements
        self.exp_prior_years_subject_limits = exp_prior_years_subject_limits
        self.exp_subject_limits = exp_subject_limits
        self.fed_candidate_committee_contributions = fed_candidate_committee_contributions
        self.fed_candidate_contribution_refunds = fed_candidate_contribution_refunds
        self.fed_disbursements = fed_disbursements
        self.fed_election_activity = fed_election_activity
        self.fed_operating_expenditures = fed_operating_expenditures
        self.fed_receipts = fed_receipts
        self.federal_funds = federal_funds
        self.independent_expenditures = independent_expenditures
        self.individual_contributions = individual_contributions
        self.individual_itemized_contributions = individual_itemized_contributions
        self.individual_unitemized_contributions = individual_unitemized_contributions
        self.itemized_convention_exp = itemized_convention_exp
        self.itemized_other_disb = itemized_other_disb
        self.itemized_other_income = itemized_other_income
        self.itemized_other_refunds = itemized_other_refunds
        self.itemized_refunds_relating_convention_exp = itemized_refunds_relating_convention_exp
        if last_beginning_image_number is not None:
            self.last_beginning_image_number = last_beginning_image_number
        if last_cash_on_hand_end_period is not None:
            self.last_cash_on_hand_end_period = last_cash_on_hand_end_period
        self.last_debts_owed_by_committee = last_debts_owed_by_committee
        self.last_debts_owed_to_committee = last_debts_owed_to_committee
        self.last_report_type_full = last_report_type_full
        self.last_report_year = last_report_year
        self.loan_repayments_made = loan_repayments_made
        self.loan_repayments_received = loan_repayments_received
        self.loans_and_loan_repayments_made = loans_and_loan_repayments_made
        self.loans_and_loan_repayments_received = loans_and_loan_repayments_received
        self.loans_made = loans_made
        self.net_contributions = net_contributions
        self.net_operating_expenditures = net_operating_expenditures
        self.non_allocated_fed_election_activity = non_allocated_fed_election_activity
        self.offsets_to_operating_expenditures = offsets_to_operating_expenditures
        self.operating_expenditures = operating_expenditures
        self.other_disbursements = other_disbursements
        self.other_fed_operating_expenditures = other_fed_operating_expenditures
        self.other_fed_receipts = other_fed_receipts
        self.other_political_committee_contributions = other_political_committee_contributions
        self.other_refunds = other_refunds
        self.party_full = party_full
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.political_party_committee_contributions = political_party_committee_contributions
        self.receipts = receipts
        self.refunded_individual_contributions = refunded_individual_contributions
        self.refunded_other_political_committee_contributions = refunded_other_political_committee_contributions
        self.refunded_political_party_committee_contributions = refunded_political_party_committee_contributions
        self.refunds_relating_convention_exp = refunds_relating_convention_exp
        if report_form is not None:
            self.report_form = report_form
        self.shared_fed_activity = shared_fed_activity
        self.shared_fed_activity_nonfed = shared_fed_activity_nonfed
        self.shared_fed_operating_expenditures = shared_fed_operating_expenditures
        self.shared_nonfed_operating_expenditures = shared_nonfed_operating_expenditures
        self.total_exp_subject_limits = total_exp_subject_limits
        self.total_transfers = total_transfers
        if transaction_coverage_date is not None:
            self.transaction_coverage_date = transaction_coverage_date
        self.transfers_from_affiliated_party = transfers_from_affiliated_party
        self.transfers_from_nonfed_account = transfers_from_nonfed_account
        self.transfers_from_nonfed_levin = transfers_from_nonfed_levin
        self.transfers_to_affiliated_committee = transfers_to_affiliated_committee
        self.unitemized_convention_exp = unitemized_convention_exp
        self.unitemized_other_disb = unitemized_other_disb
        self.unitemized_other_income = unitemized_other_income
        self.unitemized_other_refunds = unitemized_other_refunds
        self.unitemized_refunds_relating_convention_exp = unitemized_refunds_relating_convention_exp

    @property
    def all_loans_received(self):
        """Gets the all_loans_received of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The all_loans_received of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._all_loans_received

    @all_loans_received.setter
    def all_loans_received(self, all_loans_received):
        """Sets the all_loans_received of this CommitteeTotalsPacParty.


        :param all_loans_received: The all_loans_received of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._all_loans_received = all_loans_received

    @property
    def allocated_federal_election_levin_share(self):
        """Gets the allocated_federal_election_levin_share of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The allocated_federal_election_levin_share of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._allocated_federal_election_levin_share

    @allocated_federal_election_levin_share.setter
    def allocated_federal_election_levin_share(self, allocated_federal_election_levin_share):
        """Sets the allocated_federal_election_levin_share of this CommitteeTotalsPacParty.


        :param allocated_federal_election_levin_share: The allocated_federal_election_levin_share of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._allocated_federal_election_levin_share = allocated_federal_election_levin_share

    @property
    def cash_on_hand_beginning_period(self):
        """Gets the cash_on_hand_beginning_period of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The cash_on_hand_beginning_period of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_beginning_period

    @cash_on_hand_beginning_period.setter
    def cash_on_hand_beginning_period(self, cash_on_hand_beginning_period):
        """Sets the cash_on_hand_beginning_period of this CommitteeTotalsPacParty.


        :param cash_on_hand_beginning_period: The cash_on_hand_beginning_period of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_beginning_period = cash_on_hand_beginning_period

    @property
    def committee_designation(self):
        """Gets the committee_designation of this CommitteeTotalsPacParty.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The committee_designation of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._committee_designation

    @committee_designation.setter
    def committee_designation(self, committee_designation):
        """Sets the committee_designation of this CommitteeTotalsPacParty.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param committee_designation: The committee_designation of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._committee_designation = committee_designation

    @property
    def committee_designation_full(self):
        """Gets the committee_designation_full of this CommitteeTotalsPacParty.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The committee_designation_full of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._committee_designation_full

    @committee_designation_full.setter
    def committee_designation_full(self, committee_designation_full):
        """Sets the committee_designation_full of this CommitteeTotalsPacParty.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param committee_designation_full: The committee_designation_full of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._committee_designation_full = committee_designation_full

    @property
    def committee_id(self):
        """Gets the committee_id of this CommitteeTotalsPacParty.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this CommitteeTotalsPacParty.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this CommitteeTotalsPacParty.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this CommitteeTotalsPacParty.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def committee_type(self):
        """Gets the committee_type of this CommitteeTotalsPacParty.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this CommitteeTotalsPacParty.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type: The committee_type of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._committee_type = committee_type

    @property
    def committee_type_full(self):
        """Gets the committee_type_full of this CommitteeTotalsPacParty.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type_full of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._committee_type_full

    @committee_type_full.setter
    def committee_type_full(self, committee_type_full):
        """Sets the committee_type_full of this CommitteeTotalsPacParty.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type_full: The committee_type_full of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._committee_type_full = committee_type_full

    @property
    def contribution_refunds(self):
        """Gets the contribution_refunds of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The contribution_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._contribution_refunds

    @contribution_refunds.setter
    def contribution_refunds(self, contribution_refunds):
        """Sets the contribution_refunds of this CommitteeTotalsPacParty.


        :param contribution_refunds: The contribution_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._contribution_refunds = contribution_refunds

    @property
    def contributions(self):
        """Gets the contributions of this CommitteeTotalsPacParty.  # noqa: E501

        Contribution  # noqa: E501

        :return: The contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._contributions

    @contributions.setter
    def contributions(self, contributions):
        """Sets the contributions of this CommitteeTotalsPacParty.

        Contribution  # noqa: E501

        :param contributions: The contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._contributions = contributions

    @property
    def convention_exp(self):
        """Gets the convention_exp of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._convention_exp

    @convention_exp.setter
    def convention_exp(self, convention_exp):
        """Sets the convention_exp of this CommitteeTotalsPacParty.


        :param convention_exp: The convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._convention_exp = convention_exp

    @property
    def coordinated_expenditures_by_party_committee(self):
        """Gets the coordinated_expenditures_by_party_committee of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The coordinated_expenditures_by_party_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._coordinated_expenditures_by_party_committee

    @coordinated_expenditures_by_party_committee.setter
    def coordinated_expenditures_by_party_committee(self, coordinated_expenditures_by_party_committee):
        """Sets the coordinated_expenditures_by_party_committee of this CommitteeTotalsPacParty.


        :param coordinated_expenditures_by_party_committee: The coordinated_expenditures_by_party_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._coordinated_expenditures_by_party_committee = coordinated_expenditures_by_party_committee

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The coverage_end_date of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this CommitteeTotalsPacParty.


        :param coverage_end_date: The coverage_end_date of this CommitteeTotalsPacParty.  # noqa: E501
        :type: datetime
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The coverage_start_date of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this CommitteeTotalsPacParty.


        :param coverage_start_date: The coverage_start_date of this CommitteeTotalsPacParty.  # noqa: E501
        :type: datetime
        """

        self._coverage_start_date = coverage_start_date

    @property
    def cycle(self):
        """Gets the cycle of this CommitteeTotalsPacParty.  # noqa: E501

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CommitteeTotalsPacParty.

         Filter records to only those that are applicable to a given two-year period. This cycle follows the traditional House election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this CommitteeTotalsPacParty.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def disbursements(self):
        """Gets the disbursements of this CommitteeTotalsPacParty.  # noqa: E501

        Disbursements  # noqa: E501

        :return: The disbursements of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._disbursements

    @disbursements.setter
    def disbursements(self, disbursements):
        """Sets the disbursements of this CommitteeTotalsPacParty.

        Disbursements  # noqa: E501

        :param disbursements: The disbursements of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._disbursements = disbursements

    @property
    def exp_prior_years_subject_limits(self):
        """Gets the exp_prior_years_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The exp_prior_years_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._exp_prior_years_subject_limits

    @exp_prior_years_subject_limits.setter
    def exp_prior_years_subject_limits(self, exp_prior_years_subject_limits):
        """Sets the exp_prior_years_subject_limits of this CommitteeTotalsPacParty.


        :param exp_prior_years_subject_limits: The exp_prior_years_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._exp_prior_years_subject_limits = exp_prior_years_subject_limits

    @property
    def exp_subject_limits(self):
        """Gets the exp_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The exp_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._exp_subject_limits

    @exp_subject_limits.setter
    def exp_subject_limits(self, exp_subject_limits):
        """Sets the exp_subject_limits of this CommitteeTotalsPacParty.


        :param exp_subject_limits: The exp_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._exp_subject_limits = exp_subject_limits

    @property
    def fed_candidate_committee_contributions(self):
        """Gets the fed_candidate_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The fed_candidate_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._fed_candidate_committee_contributions

    @fed_candidate_committee_contributions.setter
    def fed_candidate_committee_contributions(self, fed_candidate_committee_contributions):
        """Sets the fed_candidate_committee_contributions of this CommitteeTotalsPacParty.


        :param fed_candidate_committee_contributions: The fed_candidate_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._fed_candidate_committee_contributions = fed_candidate_committee_contributions

    @property
    def fed_candidate_contribution_refunds(self):
        """Gets the fed_candidate_contribution_refunds of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The fed_candidate_contribution_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._fed_candidate_contribution_refunds

    @fed_candidate_contribution_refunds.setter
    def fed_candidate_contribution_refunds(self, fed_candidate_contribution_refunds):
        """Sets the fed_candidate_contribution_refunds of this CommitteeTotalsPacParty.


        :param fed_candidate_contribution_refunds: The fed_candidate_contribution_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._fed_candidate_contribution_refunds = fed_candidate_contribution_refunds

    @property
    def fed_disbursements(self):
        """Gets the fed_disbursements of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The fed_disbursements of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._fed_disbursements

    @fed_disbursements.setter
    def fed_disbursements(self, fed_disbursements):
        """Sets the fed_disbursements of this CommitteeTotalsPacParty.


        :param fed_disbursements: The fed_disbursements of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._fed_disbursements = fed_disbursements

    @property
    def fed_election_activity(self):
        """Gets the fed_election_activity of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The fed_election_activity of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._fed_election_activity

    @fed_election_activity.setter
    def fed_election_activity(self, fed_election_activity):
        """Sets the fed_election_activity of this CommitteeTotalsPacParty.


        :param fed_election_activity: The fed_election_activity of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._fed_election_activity = fed_election_activity

    @property
    def fed_operating_expenditures(self):
        """Gets the fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._fed_operating_expenditures

    @fed_operating_expenditures.setter
    def fed_operating_expenditures(self, fed_operating_expenditures):
        """Sets the fed_operating_expenditures of this CommitteeTotalsPacParty.


        :param fed_operating_expenditures: The fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._fed_operating_expenditures = fed_operating_expenditures

    @property
    def fed_receipts(self):
        """Gets the fed_receipts of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The fed_receipts of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._fed_receipts

    @fed_receipts.setter
    def fed_receipts(self, fed_receipts):
        """Sets the fed_receipts of this CommitteeTotalsPacParty.


        :param fed_receipts: The fed_receipts of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._fed_receipts = fed_receipts

    @property
    def federal_funds(self):
        """Gets the federal_funds of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The federal_funds of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._federal_funds

    @federal_funds.setter
    def federal_funds(self, federal_funds):
        """Sets the federal_funds of this CommitteeTotalsPacParty.


        :param federal_funds: The federal_funds of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._federal_funds = federal_funds

    @property
    def independent_expenditures(self):
        """Gets the independent_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The independent_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._independent_expenditures

    @independent_expenditures.setter
    def independent_expenditures(self, independent_expenditures):
        """Sets the independent_expenditures of this CommitteeTotalsPacParty.


        :param independent_expenditures: The independent_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._independent_expenditures = independent_expenditures

    @property
    def individual_contributions(self):
        """Gets the individual_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The individual_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._individual_contributions

    @individual_contributions.setter
    def individual_contributions(self, individual_contributions):
        """Sets the individual_contributions of this CommitteeTotalsPacParty.


        :param individual_contributions: The individual_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._individual_contributions = individual_contributions

    @property
    def individual_itemized_contributions(self):
        """Gets the individual_itemized_contributions of this CommitteeTotalsPacParty.  # noqa: E501

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less.  # noqa: E501

        :return: The individual_itemized_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._individual_itemized_contributions

    @individual_itemized_contributions.setter
    def individual_itemized_contributions(self, individual_itemized_contributions):
        """Sets the individual_itemized_contributions of this CommitteeTotalsPacParty.

        Individual itemized contributions are from individuals whose aggregate contributions total over $200 per individual per year. Be aware, some filers choose to itemize donations $200 or less.  # noqa: E501

        :param individual_itemized_contributions: The individual_itemized_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._individual_itemized_contributions = individual_itemized_contributions

    @property
    def individual_unitemized_contributions(self):
        """Gets the individual_unitemized_contributions of this CommitteeTotalsPacParty.  # noqa: E501

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total.  # noqa: E501

        :return: The individual_unitemized_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._individual_unitemized_contributions

    @individual_unitemized_contributions.setter
    def individual_unitemized_contributions(self, individual_unitemized_contributions):
        """Sets the individual_unitemized_contributions of this CommitteeTotalsPacParty.

        Unitemized contributions are made individuals whose aggregate contributions total $200 or less per individual per year. Be aware, some filers choose to itemize donations $200 or less and in that case those donations will appear in the itemized total.  # noqa: E501

        :param individual_unitemized_contributions: The individual_unitemized_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._individual_unitemized_contributions = individual_unitemized_contributions

    @property
    def itemized_convention_exp(self):
        """Gets the itemized_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The itemized_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._itemized_convention_exp

    @itemized_convention_exp.setter
    def itemized_convention_exp(self, itemized_convention_exp):
        """Sets the itemized_convention_exp of this CommitteeTotalsPacParty.


        :param itemized_convention_exp: The itemized_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._itemized_convention_exp = itemized_convention_exp

    @property
    def itemized_other_disb(self):
        """Gets the itemized_other_disb of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The itemized_other_disb of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._itemized_other_disb

    @itemized_other_disb.setter
    def itemized_other_disb(self, itemized_other_disb):
        """Sets the itemized_other_disb of this CommitteeTotalsPacParty.


        :param itemized_other_disb: The itemized_other_disb of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._itemized_other_disb = itemized_other_disb

    @property
    def itemized_other_income(self):
        """Gets the itemized_other_income of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The itemized_other_income of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._itemized_other_income

    @itemized_other_income.setter
    def itemized_other_income(self, itemized_other_income):
        """Sets the itemized_other_income of this CommitteeTotalsPacParty.


        :param itemized_other_income: The itemized_other_income of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._itemized_other_income = itemized_other_income

    @property
    def itemized_other_refunds(self):
        """Gets the itemized_other_refunds of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The itemized_other_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._itemized_other_refunds

    @itemized_other_refunds.setter
    def itemized_other_refunds(self, itemized_other_refunds):
        """Sets the itemized_other_refunds of this CommitteeTotalsPacParty.


        :param itemized_other_refunds: The itemized_other_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._itemized_other_refunds = itemized_other_refunds

    @property
    def itemized_refunds_relating_convention_exp(self):
        """Gets the itemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The itemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._itemized_refunds_relating_convention_exp

    @itemized_refunds_relating_convention_exp.setter
    def itemized_refunds_relating_convention_exp(self, itemized_refunds_relating_convention_exp):
        """Sets the itemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.


        :param itemized_refunds_relating_convention_exp: The itemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._itemized_refunds_relating_convention_exp = itemized_refunds_relating_convention_exp

    @property
    def last_beginning_image_number(self):
        """Gets the last_beginning_image_number of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The last_beginning_image_number of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._last_beginning_image_number

    @last_beginning_image_number.setter
    def last_beginning_image_number(self, last_beginning_image_number):
        """Sets the last_beginning_image_number of this CommitteeTotalsPacParty.


        :param last_beginning_image_number: The last_beginning_image_number of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._last_beginning_image_number = last_beginning_image_number

    @property
    def last_cash_on_hand_end_period(self):
        """Gets the last_cash_on_hand_end_period of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The last_cash_on_hand_end_period of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._last_cash_on_hand_end_period

    @last_cash_on_hand_end_period.setter
    def last_cash_on_hand_end_period(self, last_cash_on_hand_end_period):
        """Sets the last_cash_on_hand_end_period of this CommitteeTotalsPacParty.


        :param last_cash_on_hand_end_period: The last_cash_on_hand_end_period of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._last_cash_on_hand_end_period = last_cash_on_hand_end_period

    @property
    def last_debts_owed_by_committee(self):
        """Gets the last_debts_owed_by_committee of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The last_debts_owed_by_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._last_debts_owed_by_committee

    @last_debts_owed_by_committee.setter
    def last_debts_owed_by_committee(self, last_debts_owed_by_committee):
        """Sets the last_debts_owed_by_committee of this CommitteeTotalsPacParty.


        :param last_debts_owed_by_committee: The last_debts_owed_by_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._last_debts_owed_by_committee = last_debts_owed_by_committee

    @property
    def last_debts_owed_to_committee(self):
        """Gets the last_debts_owed_to_committee of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The last_debts_owed_to_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._last_debts_owed_to_committee

    @last_debts_owed_to_committee.setter
    def last_debts_owed_to_committee(self, last_debts_owed_to_committee):
        """Sets the last_debts_owed_to_committee of this CommitteeTotalsPacParty.


        :param last_debts_owed_to_committee: The last_debts_owed_to_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._last_debts_owed_to_committee = last_debts_owed_to_committee

    @property
    def last_report_type_full(self):
        """Gets the last_report_type_full of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The last_report_type_full of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._last_report_type_full

    @last_report_type_full.setter
    def last_report_type_full(self, last_report_type_full):
        """Sets the last_report_type_full of this CommitteeTotalsPacParty.


        :param last_report_type_full: The last_report_type_full of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._last_report_type_full = last_report_type_full

    @property
    def last_report_year(self):
        """Gets the last_report_year of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The last_report_year of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: int
        """
        return self._last_report_year

    @last_report_year.setter
    def last_report_year(self, last_report_year):
        """Sets the last_report_year of this CommitteeTotalsPacParty.


        :param last_report_year: The last_report_year of this CommitteeTotalsPacParty.  # noqa: E501
        :type: int
        """

        self._last_report_year = last_report_year

    @property
    def loan_repayments_made(self):
        """Gets the loan_repayments_made of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The loan_repayments_made of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_made

    @loan_repayments_made.setter
    def loan_repayments_made(self, loan_repayments_made):
        """Sets the loan_repayments_made of this CommitteeTotalsPacParty.


        :param loan_repayments_made: The loan_repayments_made of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._loan_repayments_made = loan_repayments_made

    @property
    def loan_repayments_received(self):
        """Gets the loan_repayments_received of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The loan_repayments_received of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._loan_repayments_received

    @loan_repayments_received.setter
    def loan_repayments_received(self, loan_repayments_received):
        """Sets the loan_repayments_received of this CommitteeTotalsPacParty.


        :param loan_repayments_received: The loan_repayments_received of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._loan_repayments_received = loan_repayments_received

    @property
    def loans_and_loan_repayments_made(self):
        """Gets the loans_and_loan_repayments_made of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The loans_and_loan_repayments_made of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._loans_and_loan_repayments_made

    @loans_and_loan_repayments_made.setter
    def loans_and_loan_repayments_made(self, loans_and_loan_repayments_made):
        """Sets the loans_and_loan_repayments_made of this CommitteeTotalsPacParty.


        :param loans_and_loan_repayments_made: The loans_and_loan_repayments_made of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._loans_and_loan_repayments_made = loans_and_loan_repayments_made

    @property
    def loans_and_loan_repayments_received(self):
        """Gets the loans_and_loan_repayments_received of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The loans_and_loan_repayments_received of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._loans_and_loan_repayments_received

    @loans_and_loan_repayments_received.setter
    def loans_and_loan_repayments_received(self, loans_and_loan_repayments_received):
        """Sets the loans_and_loan_repayments_received of this CommitteeTotalsPacParty.


        :param loans_and_loan_repayments_received: The loans_and_loan_repayments_received of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._loans_and_loan_repayments_received = loans_and_loan_repayments_received

    @property
    def loans_made(self):
        """Gets the loans_made of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The loans_made of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._loans_made

    @loans_made.setter
    def loans_made(self, loans_made):
        """Sets the loans_made of this CommitteeTotalsPacParty.


        :param loans_made: The loans_made of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._loans_made = loans_made

    @property
    def net_contributions(self):
        """Gets the net_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The net_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._net_contributions

    @net_contributions.setter
    def net_contributions(self, net_contributions):
        """Sets the net_contributions of this CommitteeTotalsPacParty.


        :param net_contributions: The net_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._net_contributions = net_contributions

    @property
    def net_operating_expenditures(self):
        """Gets the net_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The net_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._net_operating_expenditures

    @net_operating_expenditures.setter
    def net_operating_expenditures(self, net_operating_expenditures):
        """Sets the net_operating_expenditures of this CommitteeTotalsPacParty.


        :param net_operating_expenditures: The net_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._net_operating_expenditures = net_operating_expenditures

    @property
    def non_allocated_fed_election_activity(self):
        """Gets the non_allocated_fed_election_activity of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The non_allocated_fed_election_activity of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._non_allocated_fed_election_activity

    @non_allocated_fed_election_activity.setter
    def non_allocated_fed_election_activity(self, non_allocated_fed_election_activity):
        """Sets the non_allocated_fed_election_activity of this CommitteeTotalsPacParty.


        :param non_allocated_fed_election_activity: The non_allocated_fed_election_activity of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._non_allocated_fed_election_activity = non_allocated_fed_election_activity

    @property
    def offsets_to_operating_expenditures(self):
        """Gets the offsets_to_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The offsets_to_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_operating_expenditures

    @offsets_to_operating_expenditures.setter
    def offsets_to_operating_expenditures(self, offsets_to_operating_expenditures):
        """Sets the offsets_to_operating_expenditures of this CommitteeTotalsPacParty.


        :param offsets_to_operating_expenditures: The offsets_to_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._offsets_to_operating_expenditures = offsets_to_operating_expenditures

    @property
    def operating_expenditures(self):
        """Gets the operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._operating_expenditures

    @operating_expenditures.setter
    def operating_expenditures(self, operating_expenditures):
        """Sets the operating_expenditures of this CommitteeTotalsPacParty.


        :param operating_expenditures: The operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._operating_expenditures = operating_expenditures

    @property
    def other_disbursements(self):
        """Gets the other_disbursements of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The other_disbursements of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._other_disbursements

    @other_disbursements.setter
    def other_disbursements(self, other_disbursements):
        """Sets the other_disbursements of this CommitteeTotalsPacParty.


        :param other_disbursements: The other_disbursements of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._other_disbursements = other_disbursements

    @property
    def other_fed_operating_expenditures(self):
        """Gets the other_fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The other_fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._other_fed_operating_expenditures

    @other_fed_operating_expenditures.setter
    def other_fed_operating_expenditures(self, other_fed_operating_expenditures):
        """Sets the other_fed_operating_expenditures of this CommitteeTotalsPacParty.


        :param other_fed_operating_expenditures: The other_fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._other_fed_operating_expenditures = other_fed_operating_expenditures

    @property
    def other_fed_receipts(self):
        """Gets the other_fed_receipts of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The other_fed_receipts of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._other_fed_receipts

    @other_fed_receipts.setter
    def other_fed_receipts(self, other_fed_receipts):
        """Sets the other_fed_receipts of this CommitteeTotalsPacParty.


        :param other_fed_receipts: The other_fed_receipts of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._other_fed_receipts = other_fed_receipts

    @property
    def other_political_committee_contributions(self):
        """Gets the other_political_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The other_political_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._other_political_committee_contributions

    @other_political_committee_contributions.setter
    def other_political_committee_contributions(self, other_political_committee_contributions):
        """Sets the other_political_committee_contributions of this CommitteeTotalsPacParty.


        :param other_political_committee_contributions: The other_political_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._other_political_committee_contributions = other_political_committee_contributions

    @property
    def other_refunds(self):
        """Gets the other_refunds of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The other_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._other_refunds

    @other_refunds.setter
    def other_refunds(self, other_refunds):
        """Sets the other_refunds of this CommitteeTotalsPacParty.


        :param other_refunds: The other_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._other_refunds = other_refunds

    @property
    def party_full(self):
        """Gets the party_full of this CommitteeTotalsPacParty.  # noqa: E501

        Party affiliated with a candidate or committee  # noqa: E501

        :return: The party_full of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._party_full

    @party_full.setter
    def party_full(self, party_full):
        """Sets the party_full of this CommitteeTotalsPacParty.

        Party affiliated with a candidate or committee  # noqa: E501

        :param party_full: The party_full of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._party_full = party_full

    @property
    def pdf_url(self):
        """Gets the pdf_url of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The pdf_url of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this CommitteeTotalsPacParty.


        :param pdf_url: The pdf_url of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def political_party_committee_contributions(self):
        """Gets the political_party_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The political_party_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._political_party_committee_contributions

    @political_party_committee_contributions.setter
    def political_party_committee_contributions(self, political_party_committee_contributions):
        """Sets the political_party_committee_contributions of this CommitteeTotalsPacParty.


        :param political_party_committee_contributions: The political_party_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._political_party_committee_contributions = political_party_committee_contributions

    @property
    def receipts(self):
        """Gets the receipts of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The receipts of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._receipts

    @receipts.setter
    def receipts(self, receipts):
        """Sets the receipts of this CommitteeTotalsPacParty.


        :param receipts: The receipts of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._receipts = receipts

    @property
    def refunded_individual_contributions(self):
        """Gets the refunded_individual_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The refunded_individual_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._refunded_individual_contributions

    @refunded_individual_contributions.setter
    def refunded_individual_contributions(self, refunded_individual_contributions):
        """Sets the refunded_individual_contributions of this CommitteeTotalsPacParty.


        :param refunded_individual_contributions: The refunded_individual_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._refunded_individual_contributions = refunded_individual_contributions

    @property
    def refunded_other_political_committee_contributions(self):
        """Gets the refunded_other_political_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The refunded_other_political_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._refunded_other_political_committee_contributions

    @refunded_other_political_committee_contributions.setter
    def refunded_other_political_committee_contributions(self, refunded_other_political_committee_contributions):
        """Sets the refunded_other_political_committee_contributions of this CommitteeTotalsPacParty.


        :param refunded_other_political_committee_contributions: The refunded_other_political_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._refunded_other_political_committee_contributions = refunded_other_political_committee_contributions

    @property
    def refunded_political_party_committee_contributions(self):
        """Gets the refunded_political_party_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The refunded_political_party_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._refunded_political_party_committee_contributions

    @refunded_political_party_committee_contributions.setter
    def refunded_political_party_committee_contributions(self, refunded_political_party_committee_contributions):
        """Sets the refunded_political_party_committee_contributions of this CommitteeTotalsPacParty.


        :param refunded_political_party_committee_contributions: The refunded_political_party_committee_contributions of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._refunded_political_party_committee_contributions = refunded_political_party_committee_contributions

    @property
    def refunds_relating_convention_exp(self):
        """Gets the refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._refunds_relating_convention_exp

    @refunds_relating_convention_exp.setter
    def refunds_relating_convention_exp(self, refunds_relating_convention_exp):
        """Sets the refunds_relating_convention_exp of this CommitteeTotalsPacParty.


        :param refunds_relating_convention_exp: The refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._refunds_relating_convention_exp = refunds_relating_convention_exp

    @property
    def report_form(self):
        """Gets the report_form of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The report_form of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: str
        """
        return self._report_form

    @report_form.setter
    def report_form(self, report_form):
        """Sets the report_form of this CommitteeTotalsPacParty.


        :param report_form: The report_form of this CommitteeTotalsPacParty.  # noqa: E501
        :type: str
        """

        self._report_form = report_form

    @property
    def shared_fed_activity(self):
        """Gets the shared_fed_activity of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The shared_fed_activity of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._shared_fed_activity

    @shared_fed_activity.setter
    def shared_fed_activity(self, shared_fed_activity):
        """Sets the shared_fed_activity of this CommitteeTotalsPacParty.


        :param shared_fed_activity: The shared_fed_activity of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._shared_fed_activity = shared_fed_activity

    @property
    def shared_fed_activity_nonfed(self):
        """Gets the shared_fed_activity_nonfed of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The shared_fed_activity_nonfed of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._shared_fed_activity_nonfed

    @shared_fed_activity_nonfed.setter
    def shared_fed_activity_nonfed(self, shared_fed_activity_nonfed):
        """Sets the shared_fed_activity_nonfed of this CommitteeTotalsPacParty.


        :param shared_fed_activity_nonfed: The shared_fed_activity_nonfed of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._shared_fed_activity_nonfed = shared_fed_activity_nonfed

    @property
    def shared_fed_operating_expenditures(self):
        """Gets the shared_fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The shared_fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._shared_fed_operating_expenditures

    @shared_fed_operating_expenditures.setter
    def shared_fed_operating_expenditures(self, shared_fed_operating_expenditures):
        """Sets the shared_fed_operating_expenditures of this CommitteeTotalsPacParty.


        :param shared_fed_operating_expenditures: The shared_fed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._shared_fed_operating_expenditures = shared_fed_operating_expenditures

    @property
    def shared_nonfed_operating_expenditures(self):
        """Gets the shared_nonfed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The shared_nonfed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._shared_nonfed_operating_expenditures

    @shared_nonfed_operating_expenditures.setter
    def shared_nonfed_operating_expenditures(self, shared_nonfed_operating_expenditures):
        """Sets the shared_nonfed_operating_expenditures of this CommitteeTotalsPacParty.


        :param shared_nonfed_operating_expenditures: The shared_nonfed_operating_expenditures of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._shared_nonfed_operating_expenditures = shared_nonfed_operating_expenditures

    @property
    def total_exp_subject_limits(self):
        """Gets the total_exp_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The total_exp_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._total_exp_subject_limits

    @total_exp_subject_limits.setter
    def total_exp_subject_limits(self, total_exp_subject_limits):
        """Sets the total_exp_subject_limits of this CommitteeTotalsPacParty.


        :param total_exp_subject_limits: The total_exp_subject_limits of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._total_exp_subject_limits = total_exp_subject_limits

    @property
    def total_transfers(self):
        """Gets the total_transfers of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The total_transfers of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._total_transfers

    @total_transfers.setter
    def total_transfers(self, total_transfers):
        """Sets the total_transfers of this CommitteeTotalsPacParty.


        :param total_transfers: The total_transfers of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._total_transfers = total_transfers

    @property
    def transaction_coverage_date(self):
        """Gets the transaction_coverage_date of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The transaction_coverage_date of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: date
        """
        return self._transaction_coverage_date

    @transaction_coverage_date.setter
    def transaction_coverage_date(self, transaction_coverage_date):
        """Sets the transaction_coverage_date of this CommitteeTotalsPacParty.


        :param transaction_coverage_date: The transaction_coverage_date of this CommitteeTotalsPacParty.  # noqa: E501
        :type: date
        """

        self._transaction_coverage_date = transaction_coverage_date

    @property
    def transfers_from_affiliated_party(self):
        """Gets the transfers_from_affiliated_party of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The transfers_from_affiliated_party of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_affiliated_party

    @transfers_from_affiliated_party.setter
    def transfers_from_affiliated_party(self, transfers_from_affiliated_party):
        """Sets the transfers_from_affiliated_party of this CommitteeTotalsPacParty.


        :param transfers_from_affiliated_party: The transfers_from_affiliated_party of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._transfers_from_affiliated_party = transfers_from_affiliated_party

    @property
    def transfers_from_nonfed_account(self):
        """Gets the transfers_from_nonfed_account of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The transfers_from_nonfed_account of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_nonfed_account

    @transfers_from_nonfed_account.setter
    def transfers_from_nonfed_account(self, transfers_from_nonfed_account):
        """Sets the transfers_from_nonfed_account of this CommitteeTotalsPacParty.


        :param transfers_from_nonfed_account: The transfers_from_nonfed_account of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._transfers_from_nonfed_account = transfers_from_nonfed_account

    @property
    def transfers_from_nonfed_levin(self):
        """Gets the transfers_from_nonfed_levin of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The transfers_from_nonfed_levin of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_nonfed_levin

    @transfers_from_nonfed_levin.setter
    def transfers_from_nonfed_levin(self, transfers_from_nonfed_levin):
        """Sets the transfers_from_nonfed_levin of this CommitteeTotalsPacParty.


        :param transfers_from_nonfed_levin: The transfers_from_nonfed_levin of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._transfers_from_nonfed_levin = transfers_from_nonfed_levin

    @property
    def transfers_to_affiliated_committee(self):
        """Gets the transfers_to_affiliated_committee of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The transfers_to_affiliated_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._transfers_to_affiliated_committee

    @transfers_to_affiliated_committee.setter
    def transfers_to_affiliated_committee(self, transfers_to_affiliated_committee):
        """Sets the transfers_to_affiliated_committee of this CommitteeTotalsPacParty.


        :param transfers_to_affiliated_committee: The transfers_to_affiliated_committee of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._transfers_to_affiliated_committee = transfers_to_affiliated_committee

    @property
    def unitemized_convention_exp(self):
        """Gets the unitemized_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The unitemized_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._unitemized_convention_exp

    @unitemized_convention_exp.setter
    def unitemized_convention_exp(self, unitemized_convention_exp):
        """Sets the unitemized_convention_exp of this CommitteeTotalsPacParty.


        :param unitemized_convention_exp: The unitemized_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._unitemized_convention_exp = unitemized_convention_exp

    @property
    def unitemized_other_disb(self):
        """Gets the unitemized_other_disb of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The unitemized_other_disb of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._unitemized_other_disb

    @unitemized_other_disb.setter
    def unitemized_other_disb(self, unitemized_other_disb):
        """Sets the unitemized_other_disb of this CommitteeTotalsPacParty.


        :param unitemized_other_disb: The unitemized_other_disb of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._unitemized_other_disb = unitemized_other_disb

    @property
    def unitemized_other_income(self):
        """Gets the unitemized_other_income of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The unitemized_other_income of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._unitemized_other_income

    @unitemized_other_income.setter
    def unitemized_other_income(self, unitemized_other_income):
        """Sets the unitemized_other_income of this CommitteeTotalsPacParty.


        :param unitemized_other_income: The unitemized_other_income of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._unitemized_other_income = unitemized_other_income

    @property
    def unitemized_other_refunds(self):
        """Gets the unitemized_other_refunds of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The unitemized_other_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._unitemized_other_refunds

    @unitemized_other_refunds.setter
    def unitemized_other_refunds(self, unitemized_other_refunds):
        """Sets the unitemized_other_refunds of this CommitteeTotalsPacParty.


        :param unitemized_other_refunds: The unitemized_other_refunds of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._unitemized_other_refunds = unitemized_other_refunds

    @property
    def unitemized_refunds_relating_convention_exp(self):
        """Gets the unitemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501


        :return: The unitemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :rtype: float
        """
        return self._unitemized_refunds_relating_convention_exp

    @unitemized_refunds_relating_convention_exp.setter
    def unitemized_refunds_relating_convention_exp(self, unitemized_refunds_relating_convention_exp):
        """Sets the unitemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.


        :param unitemized_refunds_relating_convention_exp: The unitemized_refunds_relating_convention_exp of this CommitteeTotalsPacParty.  # noqa: E501
        :type: float
        """

        self._unitemized_refunds_relating_convention_exp = unitemized_refunds_relating_convention_exp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommitteeTotalsPacParty):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommitteeTotalsPacParty):
            return True

        return self.to_dict() != other.to_dict()
