# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class CommunicationCost(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_code': 'str',
        'action_code_full': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_full': 'str',
        'candidate_office_state': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'communication_class': 'str',
        'communication_type': 'str',
        'communication_type_full': 'str',
        'cycle': 'int',
        'file_number': 'int',
        'form_type_code': 'str',
        'image_number': 'str',
        'original_sub_id': 'int',
        'pdf_url': 'str',
        'primary_general_indicator': 'str',
        'primary_general_indicator_description': 'str',
        'purpose': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'state_full': 'str',
        'sub_id': 'int',
        'support_oppose_indicator': 'str',
        'tran_id': 'str',
        'transaction_amount': 'float',
        'transaction_date': 'date',
        'transaction_type': 'str'
    }

    attribute_map = {
        'action_code': 'action_code',
        'action_code_full': 'action_code_full',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_full': 'candidate_office_full',
        'candidate_office_state': 'candidate_office_state',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'communication_class': 'communication_class',
        'communication_type': 'communication_type',
        'communication_type_full': 'communication_type_full',
        'cycle': 'cycle',
        'file_number': 'file_number',
        'form_type_code': 'form_type_code',
        'image_number': 'image_number',
        'original_sub_id': 'original_sub_id',
        'pdf_url': 'pdf_url',
        'primary_general_indicator': 'primary_general_indicator',
        'primary_general_indicator_description': 'primary_general_indicator_description',
        'purpose': 'purpose',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'state_full': 'state_full',
        'sub_id': 'sub_id',
        'support_oppose_indicator': 'support_oppose_indicator',
        'tran_id': 'tran_id',
        'transaction_amount': 'transaction_amount',
        'transaction_date': 'transaction_date',
        'transaction_type': 'transaction_type'
    }

    def __init__(self, action_code=None, action_code_full=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_district=None, candidate_office_full=None, candidate_office_state=None, committee_id=None, committee_name=None, communication_class=None, communication_type=None, communication_type_full=None, cycle=None, file_number=None, form_type_code=None, image_number=None, original_sub_id=None, pdf_url=None, primary_general_indicator=None, primary_general_indicator_description=None, purpose=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, state_full=None, sub_id=None, support_oppose_indicator=None, tran_id=None, transaction_amount=None, transaction_date=None, transaction_type=None, local_vars_configuration=None):  # noqa: E501
        """CommunicationCost - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_code = None
        self._action_code_full = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_full = None
        self._candidate_office_state = None
        self._committee_id = None
        self._committee_name = None
        self._communication_class = None
        self._communication_type = None
        self._communication_type_full = None
        self._cycle = None
        self._file_number = None
        self._form_type_code = None
        self._image_number = None
        self._original_sub_id = None
        self._pdf_url = None
        self._primary_general_indicator = None
        self._primary_general_indicator_description = None
        self._purpose = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._state_full = None
        self._sub_id = None
        self._support_oppose_indicator = None
        self._tran_id = None
        self._transaction_amount = None
        self._transaction_date = None
        self._transaction_type = None
        self.discriminator = None

        self.action_code = action_code
        self.action_code_full = action_code_full
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_full = candidate_office_full
        self.candidate_office_state = candidate_office_state
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.communication_class = communication_class
        self.communication_type = communication_type
        self.communication_type_full = communication_type_full
        self.cycle = cycle
        self.file_number = file_number
        self.form_type_code = form_type_code
        self.image_number = image_number
        self.original_sub_id = original_sub_id
        self.pdf_url = pdf_url
        self.primary_general_indicator = primary_general_indicator
        self.primary_general_indicator_description = primary_general_indicator_description
        self.purpose = purpose
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        self.state_full = state_full
        if sub_id is not None:
            self.sub_id = sub_id
        self.support_oppose_indicator = support_oppose_indicator
        self.tran_id = tran_id
        self.transaction_amount = transaction_amount
        self.transaction_date = transaction_date
        self.transaction_type = transaction_type

    @property
    def action_code(self):
        """Gets the action_code of this CommunicationCost.  # noqa: E501


        :return: The action_code of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._action_code

    @action_code.setter
    def action_code(self, action_code):
        """Sets the action_code of this CommunicationCost.


        :param action_code: The action_code of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._action_code = action_code

    @property
    def action_code_full(self):
        """Gets the action_code_full of this CommunicationCost.  # noqa: E501


        :return: The action_code_full of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._action_code_full

    @action_code_full.setter
    def action_code_full(self, action_code_full):
        """Sets the action_code_full of this CommunicationCost.


        :param action_code_full: The action_code_full of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._action_code_full = action_code_full

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this CommunicationCost.  # noqa: E501


        :return: The candidate_first_name of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this CommunicationCost.


        :param candidate_first_name: The candidate_first_name of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this CommunicationCost.  # noqa: E501


        :return: The candidate_id of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this CommunicationCost.


        :param candidate_id: The candidate_id of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this CommunicationCost.  # noqa: E501


        :return: The candidate_last_name of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this CommunicationCost.


        :param candidate_last_name: The candidate_last_name of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this CommunicationCost.  # noqa: E501


        :return: The candidate_middle_name of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this CommunicationCost.


        :param candidate_middle_name: The candidate_middle_name of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this CommunicationCost.  # noqa: E501


        :return: The candidate_name of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this CommunicationCost.


        :param candidate_name: The candidate_name of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this CommunicationCost.  # noqa: E501


        :return: The candidate_office of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this CommunicationCost.


        :param candidate_office: The candidate_office of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this CommunicationCost.  # noqa: E501


        :return: The candidate_office_district of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this CommunicationCost.


        :param candidate_office_district: The candidate_office_district of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_full(self):
        """Gets the candidate_office_full of this CommunicationCost.  # noqa: E501


        :return: The candidate_office_full of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_full

    @candidate_office_full.setter
    def candidate_office_full(self, candidate_office_full):
        """Sets the candidate_office_full of this CommunicationCost.


        :param candidate_office_full: The candidate_office_full of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_office_full = candidate_office_full

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this CommunicationCost.  # noqa: E501


        :return: The candidate_office_state of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this CommunicationCost.


        :param candidate_office_state: The candidate_office_state of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def committee_id(self):
        """Gets the committee_id of this CommunicationCost.  # noqa: E501


        :return: The committee_id of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this CommunicationCost.


        :param committee_id: The committee_id of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this CommunicationCost.  # noqa: E501


        :return: The committee_name of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this CommunicationCost.


        :param committee_name: The committee_name of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def communication_class(self):
        """Gets the communication_class of this CommunicationCost.  # noqa: E501


        :return: The communication_class of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._communication_class

    @communication_class.setter
    def communication_class(self, communication_class):
        """Sets the communication_class of this CommunicationCost.


        :param communication_class: The communication_class of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._communication_class = communication_class

    @property
    def communication_type(self):
        """Gets the communication_type of this CommunicationCost.  # noqa: E501


        :return: The communication_type of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._communication_type

    @communication_type.setter
    def communication_type(self, communication_type):
        """Sets the communication_type of this CommunicationCost.


        :param communication_type: The communication_type of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._communication_type = communication_type

    @property
    def communication_type_full(self):
        """Gets the communication_type_full of this CommunicationCost.  # noqa: E501


        :return: The communication_type_full of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._communication_type_full

    @communication_type_full.setter
    def communication_type_full(self, communication_type_full):
        """Sets the communication_type_full of this CommunicationCost.


        :param communication_type_full: The communication_type_full of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._communication_type_full = communication_type_full

    @property
    def cycle(self):
        """Gets the cycle of this CommunicationCost.  # noqa: E501


        :return: The cycle of this CommunicationCost.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this CommunicationCost.


        :param cycle: The cycle of this CommunicationCost.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def file_number(self):
        """Gets the file_number of this CommunicationCost.  # noqa: E501


        :return: The file_number of this CommunicationCost.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this CommunicationCost.


        :param file_number: The file_number of this CommunicationCost.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def form_type_code(self):
        """Gets the form_type_code of this CommunicationCost.  # noqa: E501


        :return: The form_type_code of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._form_type_code

    @form_type_code.setter
    def form_type_code(self, form_type_code):
        """Sets the form_type_code of this CommunicationCost.


        :param form_type_code: The form_type_code of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._form_type_code = form_type_code

    @property
    def image_number(self):
        """Gets the image_number of this CommunicationCost.  # noqa: E501


        :return: The image_number of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this CommunicationCost.


        :param image_number: The image_number of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this CommunicationCost.  # noqa: E501


        :return: The original_sub_id of this CommunicationCost.  # noqa: E501
        :rtype: int
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this CommunicationCost.


        :param original_sub_id: The original_sub_id of this CommunicationCost.  # noqa: E501
        :type: int
        """

        self._original_sub_id = original_sub_id

    @property
    def pdf_url(self):
        """Gets the pdf_url of this CommunicationCost.  # noqa: E501


        :return: The pdf_url of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this CommunicationCost.


        :param pdf_url: The pdf_url of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def primary_general_indicator(self):
        """Gets the primary_general_indicator of this CommunicationCost.  # noqa: E501


        :return: The primary_general_indicator of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._primary_general_indicator

    @primary_general_indicator.setter
    def primary_general_indicator(self, primary_general_indicator):
        """Sets the primary_general_indicator of this CommunicationCost.


        :param primary_general_indicator: The primary_general_indicator of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._primary_general_indicator = primary_general_indicator

    @property
    def primary_general_indicator_description(self):
        """Gets the primary_general_indicator_description of this CommunicationCost.  # noqa: E501


        :return: The primary_general_indicator_description of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._primary_general_indicator_description

    @primary_general_indicator_description.setter
    def primary_general_indicator_description(self, primary_general_indicator_description):
        """Sets the primary_general_indicator_description of this CommunicationCost.


        :param primary_general_indicator_description: The primary_general_indicator_description of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._primary_general_indicator_description = primary_general_indicator_description

    @property
    def purpose(self):
        """Gets the purpose of this CommunicationCost.  # noqa: E501


        :return: The purpose of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """Sets the purpose of this CommunicationCost.


        :param purpose: The purpose of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._purpose = purpose

    @property
    def report_type(self):
        """Gets the report_type of this CommunicationCost.  # noqa: E501


        :return: The report_type of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this CommunicationCost.


        :param report_type: The report_type of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this CommunicationCost.  # noqa: E501


        :return: The report_year of this CommunicationCost.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this CommunicationCost.


        :param report_year: The report_year of this CommunicationCost.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this CommunicationCost.  # noqa: E501


        :return: The schedule_type of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this CommunicationCost.


        :param schedule_type: The schedule_type of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this CommunicationCost.  # noqa: E501


        :return: The schedule_type_full of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this CommunicationCost.


        :param schedule_type_full: The schedule_type_full of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def state_full(self):
        """Gets the state_full of this CommunicationCost.  # noqa: E501


        :return: The state_full of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._state_full

    @state_full.setter
    def state_full(self, state_full):
        """Sets the state_full of this CommunicationCost.


        :param state_full: The state_full of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._state_full = state_full

    @property
    def sub_id(self):
        """Gets the sub_id of this CommunicationCost.  # noqa: E501


        :return: The sub_id of this CommunicationCost.  # noqa: E501
        :rtype: int
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this CommunicationCost.


        :param sub_id: The sub_id of this CommunicationCost.  # noqa: E501
        :type: int
        """

        self._sub_id = sub_id

    @property
    def support_oppose_indicator(self):
        """Gets the support_oppose_indicator of this CommunicationCost.  # noqa: E501


        :return: The support_oppose_indicator of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._support_oppose_indicator

    @support_oppose_indicator.setter
    def support_oppose_indicator(self, support_oppose_indicator):
        """Sets the support_oppose_indicator of this CommunicationCost.


        :param support_oppose_indicator: The support_oppose_indicator of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._support_oppose_indicator = support_oppose_indicator

    @property
    def tran_id(self):
        """Gets the tran_id of this CommunicationCost.  # noqa: E501


        :return: The tran_id of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._tran_id

    @tran_id.setter
    def tran_id(self, tran_id):
        """Sets the tran_id of this CommunicationCost.


        :param tran_id: The tran_id of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._tran_id = tran_id

    @property
    def transaction_amount(self):
        """Gets the transaction_amount of this CommunicationCost.  # noqa: E501


        :return: The transaction_amount of this CommunicationCost.  # noqa: E501
        :rtype: float
        """
        return self._transaction_amount

    @transaction_amount.setter
    def transaction_amount(self, transaction_amount):
        """Sets the transaction_amount of this CommunicationCost.


        :param transaction_amount: The transaction_amount of this CommunicationCost.  # noqa: E501
        :type: float
        """

        self._transaction_amount = transaction_amount

    @property
    def transaction_date(self):
        """Gets the transaction_date of this CommunicationCost.  # noqa: E501


        :return: The transaction_date of this CommunicationCost.  # noqa: E501
        :rtype: date
        """
        return self._transaction_date

    @transaction_date.setter
    def transaction_date(self, transaction_date):
        """Sets the transaction_date of this CommunicationCost.


        :param transaction_date: The transaction_date of this CommunicationCost.  # noqa: E501
        :type: date
        """

        self._transaction_date = transaction_date

    @property
    def transaction_type(self):
        """Gets the transaction_type of this CommunicationCost.  # noqa: E501


        :return: The transaction_type of this CommunicationCost.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this CommunicationCost.


        :param transaction_type: The transaction_type of this CommunicationCost.  # noqa: E501
        :type: str
        """

        self._transaction_type = transaction_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommunicationCost):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommunicationCost):
            return True

        return self.to_dict() != other.to_dict()
