# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class EFilings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amended_by': 'int',
        'amendment_chain': 'list[int]',
        'amendment_number': 'int',
        'amends_file': 'int',
        'beginning_image_number': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'coverage_end_date': 'date',
        'coverage_start_date': 'date',
        'csv_url': 'str',
        'document_description': 'str',
        'ending_image_number': 'str',
        'fec_file_id': 'str',
        'fec_url': 'str',
        'file_number': 'int',
        'filed_date': 'date',
        'form_type': 'str',
        'html_url': 'str',
        'is_amended': 'bool',
        'load_timestamp': 'datetime',
        'most_recent': 'bool',
        'most_recent_filing': 'int',
        'pdf_url': 'str',
        'receipt_date': 'datetime'
    }

    attribute_map = {
        'amended_by': 'amended_by',
        'amendment_chain': 'amendment_chain',
        'amendment_number': 'amendment_number',
        'amends_file': 'amends_file',
        'beginning_image_number': 'beginning_image_number',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'csv_url': 'csv_url',
        'document_description': 'document_description',
        'ending_image_number': 'ending_image_number',
        'fec_file_id': 'fec_file_id',
        'fec_url': 'fec_url',
        'file_number': 'file_number',
        'filed_date': 'filed_date',
        'form_type': 'form_type',
        'html_url': 'html_url',
        'is_amended': 'is_amended',
        'load_timestamp': 'load_timestamp',
        'most_recent': 'most_recent',
        'most_recent_filing': 'most_recent_filing',
        'pdf_url': 'pdf_url',
        'receipt_date': 'receipt_date'
    }

    def __init__(self, amended_by=None, amendment_chain=None, amendment_number=None, amends_file=None, beginning_image_number=None, committee_id=None, committee_name=None, coverage_end_date=None, coverage_start_date=None, csv_url=None, document_description=None, ending_image_number=None, fec_file_id=None, fec_url=None, file_number=None, filed_date=None, form_type=None, html_url=None, is_amended=None, load_timestamp=None, most_recent=None, most_recent_filing=None, pdf_url=None, receipt_date=None, local_vars_configuration=None):  # noqa: E501
        """EFilings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amended_by = None
        self._amendment_chain = None
        self._amendment_number = None
        self._amends_file = None
        self._beginning_image_number = None
        self._committee_id = None
        self._committee_name = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._csv_url = None
        self._document_description = None
        self._ending_image_number = None
        self._fec_file_id = None
        self._fec_url = None
        self._file_number = None
        self._filed_date = None
        self._form_type = None
        self._html_url = None
        self._is_amended = None
        self._load_timestamp = None
        self._most_recent = None
        self._most_recent_filing = None
        self._pdf_url = None
        self._receipt_date = None
        self.discriminator = None

        if amended_by is not None:
            self.amended_by = amended_by
        if amendment_chain is not None:
            self.amendment_chain = amendment_chain
        self.amendment_number = amendment_number
        self.amends_file = amends_file
        if beginning_image_number is not None:
            self.beginning_image_number = beginning_image_number
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        if csv_url is not None:
            self.csv_url = csv_url
        if document_description is not None:
            self.document_description = document_description
        if ending_image_number is not None:
            self.ending_image_number = ending_image_number
        if fec_file_id is not None:
            self.fec_file_id = fec_file_id
        if fec_url is not None:
            self.fec_url = fec_url
        if file_number is not None:
            self.file_number = file_number
        self.filed_date = filed_date
        self.form_type = form_type
        if html_url is not None:
            self.html_url = html_url
        if is_amended is not None:
            self.is_amended = is_amended
        self.load_timestamp = load_timestamp
        if most_recent is not None:
            self.most_recent = most_recent
        if most_recent_filing is not None:
            self.most_recent_filing = most_recent_filing
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.receipt_date = receipt_date

    @property
    def amended_by(self):
        """Gets the amended_by of this EFilings.  # noqa: E501


        :return: The amended_by of this EFilings.  # noqa: E501
        :rtype: int
        """
        return self._amended_by

    @amended_by.setter
    def amended_by(self, amended_by):
        """Sets the amended_by of this EFilings.


        :param amended_by: The amended_by of this EFilings.  # noqa: E501
        :type: int
        """

        self._amended_by = amended_by

    @property
    def amendment_chain(self):
        """Gets the amendment_chain of this EFilings.  # noqa: E501


        :return: The amendment_chain of this EFilings.  # noqa: E501
        :rtype: list[int]
        """
        return self._amendment_chain

    @amendment_chain.setter
    def amendment_chain(self, amendment_chain):
        """Sets the amendment_chain of this EFilings.


        :param amendment_chain: The amendment_chain of this EFilings.  # noqa: E501
        :type: list[int]
        """

        self._amendment_chain = amendment_chain

    @property
    def amendment_number(self):
        """Gets the amendment_number of this EFilings.  # noqa: E501

         Number of times the report has been amended.   # noqa: E501

        :return: The amendment_number of this EFilings.  # noqa: E501
        :rtype: int
        """
        return self._amendment_number

    @amendment_number.setter
    def amendment_number(self, amendment_number):
        """Sets the amendment_number of this EFilings.

         Number of times the report has been amended.   # noqa: E501

        :param amendment_number: The amendment_number of this EFilings.  # noqa: E501
        :type: int
        """

        self._amendment_number = amendment_number

    @property
    def amends_file(self):
        """Gets the amends_file of this EFilings.  # noqa: E501

         For amendments, this file_number is the file_number of the previous report that is being amended. See amended_by for the most recent version of the report.   # noqa: E501

        :return: The amends_file of this EFilings.  # noqa: E501
        :rtype: int
        """
        return self._amends_file

    @amends_file.setter
    def amends_file(self, amends_file):
        """Sets the amends_file of this EFilings.

         For amendments, this file_number is the file_number of the previous report that is being amended. See amended_by for the most recent version of the report.   # noqa: E501

        :param amends_file: The amends_file of this EFilings.  # noqa: E501
        :type: int
        """

        self._amends_file = amends_file

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this EFilings.  # noqa: E501


        :return: The beginning_image_number of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this EFilings.


        :param beginning_image_number: The beginning_image_number of this EFilings.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def committee_id(self):
        """Gets the committee_id of this EFilings.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this EFilings.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this EFilings.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this EFilings.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this EFilings.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this EFilings.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this EFilings.  # noqa: E501

        Ending date of the reporting period  # noqa: E501

        :return: The coverage_end_date of this EFilings.  # noqa: E501
        :rtype: date
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this EFilings.

        Ending date of the reporting period  # noqa: E501

        :param coverage_end_date: The coverage_end_date of this EFilings.  # noqa: E501
        :type: date
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this EFilings.  # noqa: E501

        Beginning date of the reporting period  # noqa: E501

        :return: The coverage_start_date of this EFilings.  # noqa: E501
        :rtype: date
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this EFilings.

        Beginning date of the reporting period  # noqa: E501

        :param coverage_start_date: The coverage_start_date of this EFilings.  # noqa: E501
        :type: date
        """

        self._coverage_start_date = coverage_start_date

    @property
    def csv_url(self):
        """Gets the csv_url of this EFilings.  # noqa: E501


        :return: The csv_url of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._csv_url

    @csv_url.setter
    def csv_url(self, csv_url):
        """Sets the csv_url of this EFilings.


        :param csv_url: The csv_url of this EFilings.  # noqa: E501
        :type: str
        """

        self._csv_url = csv_url

    @property
    def document_description(self):
        """Gets the document_description of this EFilings.  # noqa: E501


        :return: The document_description of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._document_description

    @document_description.setter
    def document_description(self, document_description):
        """Sets the document_description of this EFilings.


        :param document_description: The document_description of this EFilings.  # noqa: E501
        :type: str
        """

        self._document_description = document_description

    @property
    def ending_image_number(self):
        """Gets the ending_image_number of this EFilings.  # noqa: E501


        :return: The ending_image_number of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._ending_image_number

    @ending_image_number.setter
    def ending_image_number(self, ending_image_number):
        """Sets the ending_image_number of this EFilings.


        :param ending_image_number: The ending_image_number of this EFilings.  # noqa: E501
        :type: str
        """

        self._ending_image_number = ending_image_number

    @property
    def fec_file_id(self):
        """Gets the fec_file_id of this EFilings.  # noqa: E501


        :return: The fec_file_id of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._fec_file_id

    @fec_file_id.setter
    def fec_file_id(self, fec_file_id):
        """Sets the fec_file_id of this EFilings.


        :param fec_file_id: The fec_file_id of this EFilings.  # noqa: E501
        :type: str
        """

        self._fec_file_id = fec_file_id

    @property
    def fec_url(self):
        """Gets the fec_url of this EFilings.  # noqa: E501


        :return: The fec_url of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._fec_url

    @fec_url.setter
    def fec_url(self, fec_url):
        """Sets the fec_url of this EFilings.


        :param fec_url: The fec_url of this EFilings.  # noqa: E501
        :type: str
        """

        self._fec_url = fec_url

    @property
    def file_number(self):
        """Gets the file_number of this EFilings.  # noqa: E501

        Filing ID number  # noqa: E501

        :return: The file_number of this EFilings.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this EFilings.

        Filing ID number  # noqa: E501

        :param file_number: The file_number of this EFilings.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filed_date(self):
        """Gets the filed_date of this EFilings.  # noqa: E501

        Timestamp of electronic or paper record that FEC received  # noqa: E501

        :return: The filed_date of this EFilings.  # noqa: E501
        :rtype: date
        """
        return self._filed_date

    @filed_date.setter
    def filed_date(self, filed_date):
        """Sets the filed_date of this EFilings.

        Timestamp of electronic or paper record that FEC received  # noqa: E501

        :param filed_date: The filed_date of this EFilings.  # noqa: E501
        :type: date
        """

        self._filed_date = filed_date

    @property
    def form_type(self):
        """Gets the form_type of this EFilings.  # noqa: E501

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :return: The form_type of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._form_type

    @form_type.setter
    def form_type(self, form_type):
        """Sets the form_type of this EFilings.

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :param form_type: The form_type of this EFilings.  # noqa: E501
        :type: str
        """

        self._form_type = form_type

    @property
    def html_url(self):
        """Gets the html_url of this EFilings.  # noqa: E501


        :return: The html_url of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """Sets the html_url of this EFilings.


        :param html_url: The html_url of this EFilings.  # noqa: E501
        :type: str
        """

        self._html_url = html_url

    @property
    def is_amended(self):
        """Gets the is_amended of this EFilings.  # noqa: E501


        :return: The is_amended of this EFilings.  # noqa: E501
        :rtype: bool
        """
        return self._is_amended

    @is_amended.setter
    def is_amended(self, is_amended):
        """Sets the is_amended of this EFilings.


        :param is_amended: The is_amended of this EFilings.  # noqa: E501
        :type: bool
        """

        self._is_amended = is_amended

    @property
    def load_timestamp(self):
        """Gets the load_timestamp of this EFilings.  # noqa: E501

        Date the information was loaded into the FEC systems. This can be affected by reseting systems and other factors, refer to receipt_date for the day that the FEC received the paper or electronic document. Keep in mind that paper filings take more time to process and there can be a lag between load_date and receipt_date. This field can be helpful to identify paper records that have been processed recently.  # noqa: E501

        :return: The load_timestamp of this EFilings.  # noqa: E501
        :rtype: datetime
        """
        return self._load_timestamp

    @load_timestamp.setter
    def load_timestamp(self, load_timestamp):
        """Sets the load_timestamp of this EFilings.

        Date the information was loaded into the FEC systems. This can be affected by reseting systems and other factors, refer to receipt_date for the day that the FEC received the paper or electronic document. Keep in mind that paper filings take more time to process and there can be a lag between load_date and receipt_date. This field can be helpful to identify paper records that have been processed recently.  # noqa: E501

        :param load_timestamp: The load_timestamp of this EFilings.  # noqa: E501
        :type: datetime
        """

        self._load_timestamp = load_timestamp

    @property
    def most_recent(self):
        """Gets the most_recent of this EFilings.  # noqa: E501


        :return: The most_recent of this EFilings.  # noqa: E501
        :rtype: bool
        """
        return self._most_recent

    @most_recent.setter
    def most_recent(self, most_recent):
        """Sets the most_recent of this EFilings.


        :param most_recent: The most_recent of this EFilings.  # noqa: E501
        :type: bool
        """

        self._most_recent = most_recent

    @property
    def most_recent_filing(self):
        """Gets the most_recent_filing of this EFilings.  # noqa: E501


        :return: The most_recent_filing of this EFilings.  # noqa: E501
        :rtype: int
        """
        return self._most_recent_filing

    @most_recent_filing.setter
    def most_recent_filing(self, most_recent_filing):
        """Sets the most_recent_filing of this EFilings.


        :param most_recent_filing: The most_recent_filing of this EFilings.  # noqa: E501
        :type: int
        """

        self._most_recent_filing = most_recent_filing

    @property
    def pdf_url(self):
        """Gets the pdf_url of this EFilings.  # noqa: E501


        :return: The pdf_url of this EFilings.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this EFilings.


        :param pdf_url: The pdf_url of this EFilings.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def receipt_date(self):
        """Gets the receipt_date of this EFilings.  # noqa: E501

        Date the FEC received the electronic or paper record  # noqa: E501

        :return: The receipt_date of this EFilings.  # noqa: E501
        :rtype: datetime
        """
        return self._receipt_date

    @receipt_date.setter
    def receipt_date(self, receipt_date):
        """Sets the receipt_date of this EFilings.

        Date the FEC received the electronic or paper record  # noqa: E501

        :param receipt_date: The receipt_date of this EFilings.  # noqa: E501
        :type: datetime
        """

        self._receipt_date = receipt_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EFilings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EFilings):
            return True

        return self.to_dict() != other.to_dict()
