# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ElectionDate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'active_election': 'bool',
        'create_date': 'datetime',
        'election_date': 'date',
        'election_district': 'int',
        'election_notes': 'str',
        'election_party': 'str',
        'election_state': 'str',
        'election_type_full': 'str',
        'election_type_id': 'str',
        'election_year': 'int',
        'office_sought': 'str',
        'primary_general_date': 'date',
        'update_date': 'datetime'
    }

    attribute_map = {
        'active_election': 'active_election',
        'create_date': 'create_date',
        'election_date': 'election_date',
        'election_district': 'election_district',
        'election_notes': 'election_notes',
        'election_party': 'election_party',
        'election_state': 'election_state',
        'election_type_full': 'election_type_full',
        'election_type_id': 'election_type_id',
        'election_year': 'election_year',
        'office_sought': 'office_sought',
        'primary_general_date': 'primary_general_date',
        'update_date': 'update_date'
    }

    def __init__(self, active_election=None, create_date=None, election_date=None, election_district=None, election_notes=None, election_party=None, election_state=None, election_type_full=None, election_type_id=None, election_year=None, office_sought=None, primary_general_date=None, update_date=None, local_vars_configuration=None):  # noqa: E501
        """ElectionDate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._active_election = None
        self._create_date = None
        self._election_date = None
        self._election_district = None
        self._election_notes = None
        self._election_party = None
        self._election_state = None
        self._election_type_full = None
        self._election_type_id = None
        self._election_year = None
        self._office_sought = None
        self._primary_general_date = None
        self._update_date = None
        self.discriminator = None

        if active_election is not None:
            self.active_election = active_election
        self.create_date = create_date
        self.election_date = election_date
        self.election_district = election_district
        self.election_notes = election_notes
        self.election_party = election_party
        self.election_state = election_state
        if election_type_full is not None:
            self.election_type_full = election_type_full
        self.election_type_id = election_type_id
        self.election_year = election_year
        self.office_sought = office_sought
        self.primary_general_date = primary_general_date
        self.update_date = update_date

    @property
    def active_election(self):
        """Gets the active_election of this ElectionDate.  # noqa: E501


        :return: The active_election of this ElectionDate.  # noqa: E501
        :rtype: bool
        """
        return self._active_election

    @active_election.setter
    def active_election(self, active_election):
        """Sets the active_election of this ElectionDate.


        :param active_election: The active_election of this ElectionDate.  # noqa: E501
        :type: bool
        """

        self._active_election = active_election

    @property
    def create_date(self):
        """Gets the create_date of this ElectionDate.  # noqa: E501

        Date the record was created  # noqa: E501

        :return: The create_date of this ElectionDate.  # noqa: E501
        :rtype: datetime
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date):
        """Sets the create_date of this ElectionDate.

        Date the record was created  # noqa: E501

        :param create_date: The create_date of this ElectionDate.  # noqa: E501
        :type: datetime
        """

        self._create_date = create_date

    @property
    def election_date(self):
        """Gets the election_date of this ElectionDate.  # noqa: E501

        Date of election  # noqa: E501

        :return: The election_date of this ElectionDate.  # noqa: E501
        :rtype: date
        """
        return self._election_date

    @election_date.setter
    def election_date(self, election_date):
        """Sets the election_date of this ElectionDate.

        Date of election  # noqa: E501

        :param election_date: The election_date of this ElectionDate.  # noqa: E501
        :type: date
        """

        self._election_date = election_date

    @property
    def election_district(self):
        """Gets the election_district of this ElectionDate.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The election_district of this ElectionDate.  # noqa: E501
        :rtype: int
        """
        return self._election_district

    @election_district.setter
    def election_district(self, election_district):
        """Sets the election_district of this ElectionDate.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param election_district: The election_district of this ElectionDate.  # noqa: E501
        :type: int
        """

        self._election_district = election_district

    @property
    def election_notes(self):
        """Gets the election_notes of this ElectionDate.  # noqa: E501


        :return: The election_notes of this ElectionDate.  # noqa: E501
        :rtype: str
        """
        return self._election_notes

    @election_notes.setter
    def election_notes(self, election_notes):
        """Sets the election_notes of this ElectionDate.


        :param election_notes: The election_notes of this ElectionDate.  # noqa: E501
        :type: str
        """

        self._election_notes = election_notes

    @property
    def election_party(self):
        """Gets the election_party of this ElectionDate.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The election_party of this ElectionDate.  # noqa: E501
        :rtype: str
        """
        return self._election_party

    @election_party.setter
    def election_party(self, election_party):
        """Sets the election_party of this ElectionDate.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param election_party: The election_party of this ElectionDate.  # noqa: E501
        :type: str
        """

        self._election_party = election_party

    @property
    def election_state(self):
        """Gets the election_state of this ElectionDate.  # noqa: E501

        US state or territory where a candidate runs for office  # noqa: E501

        :return: The election_state of this ElectionDate.  # noqa: E501
        :rtype: str
        """
        return self._election_state

    @election_state.setter
    def election_state(self, election_state):
        """Sets the election_state of this ElectionDate.

        US state or territory where a candidate runs for office  # noqa: E501

        :param election_state: The election_state of this ElectionDate.  # noqa: E501
        :type: str
        """

        self._election_state = election_state

    @property
    def election_type_full(self):
        """Gets the election_type_full of this ElectionDate.  # noqa: E501


        :return: The election_type_full of this ElectionDate.  # noqa: E501
        :rtype: str
        """
        return self._election_type_full

    @election_type_full.setter
    def election_type_full(self, election_type_full):
        """Sets the election_type_full of this ElectionDate.


        :param election_type_full: The election_type_full of this ElectionDate.  # noqa: E501
        :type: str
        """

        self._election_type_full = election_type_full

    @property
    def election_type_id(self):
        """Gets the election_type_id of this ElectionDate.  # noqa: E501

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :return: The election_type_id of this ElectionDate.  # noqa: E501
        :rtype: str
        """
        return self._election_type_id

    @election_type_id.setter
    def election_type_id(self, election_type_id):
        """Sets the election_type_id of this ElectionDate.

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :param election_type_id: The election_type_id of this ElectionDate.  # noqa: E501
        :type: str
        """

        self._election_type_id = election_type_id

    @property
    def election_year(self):
        """Gets the election_year of this ElectionDate.  # noqa: E501

        Year of election  # noqa: E501

        :return: The election_year of this ElectionDate.  # noqa: E501
        :rtype: int
        """
        return self._election_year

    @election_year.setter
    def election_year(self, election_year):
        """Sets the election_year of this ElectionDate.

        Year of election  # noqa: E501

        :param election_year: The election_year of this ElectionDate.  # noqa: E501
        :type: int
        """

        self._election_year = election_year

    @property
    def office_sought(self):
        """Gets the office_sought of this ElectionDate.  # noqa: E501

        Federal office candidate runs for: H, S or P  # noqa: E501

        :return: The office_sought of this ElectionDate.  # noqa: E501
        :rtype: str
        """
        return self._office_sought

    @office_sought.setter
    def office_sought(self, office_sought):
        """Sets the office_sought of this ElectionDate.

        Federal office candidate runs for: H, S or P  # noqa: E501

        :param office_sought: The office_sought of this ElectionDate.  # noqa: E501
        :type: str
        """

        self._office_sought = office_sought

    @property
    def primary_general_date(self):
        """Gets the primary_general_date of this ElectionDate.  # noqa: E501


        :return: The primary_general_date of this ElectionDate.  # noqa: E501
        :rtype: date
        """
        return self._primary_general_date

    @primary_general_date.setter
    def primary_general_date(self, primary_general_date):
        """Sets the primary_general_date of this ElectionDate.


        :param primary_general_date: The primary_general_date of this ElectionDate.  # noqa: E501
        :type: date
        """

        self._primary_general_date = primary_general_date

    @property
    def update_date(self):
        """Gets the update_date of this ElectionDate.  # noqa: E501

        Date the record was updated  # noqa: E501

        :return: The update_date of this ElectionDate.  # noqa: E501
        :rtype: datetime
        """
        return self._update_date

    @update_date.setter
    def update_date(self, update_date):
        """Sets the update_date of this ElectionDate.

        Date the record was updated  # noqa: E501

        :param update_date: The update_date of this ElectionDate.  # noqa: E501
        :type: datetime
        """

        self._update_date = update_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ElectionDate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ElectionDate):
            return True

        return self.to_dict() != other.to_dict()
