# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ElectionSummary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'count': 'int',
        'disbursements': 'float',
        'independent_expenditures': 'float',
        'receipts': 'float'
    }

    attribute_map = {
        'count': 'count',
        'disbursements': 'disbursements',
        'independent_expenditures': 'independent_expenditures',
        'receipts': 'receipts'
    }

    def __init__(self, count=None, disbursements=None, independent_expenditures=None, receipts=None, local_vars_configuration=None):  # noqa: E501
        """ElectionSummary - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._count = None
        self._disbursements = None
        self._independent_expenditures = None
        self._receipts = None
        self.discriminator = None

        if count is not None:
            self.count = count
        if disbursements is not None:
            self.disbursements = disbursements
        if independent_expenditures is not None:
            self.independent_expenditures = independent_expenditures
        if receipts is not None:
            self.receipts = receipts

    @property
    def count(self):
        """Gets the count of this ElectionSummary.  # noqa: E501


        :return: The count of this ElectionSummary.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this ElectionSummary.


        :param count: The count of this ElectionSummary.  # noqa: E501
        :type: int
        """

        self._count = count

    @property
    def disbursements(self):
        """Gets the disbursements of this ElectionSummary.  # noqa: E501


        :return: The disbursements of this ElectionSummary.  # noqa: E501
        :rtype: float
        """
        return self._disbursements

    @disbursements.setter
    def disbursements(self, disbursements):
        """Sets the disbursements of this ElectionSummary.


        :param disbursements: The disbursements of this ElectionSummary.  # noqa: E501
        :type: float
        """

        self._disbursements = disbursements

    @property
    def independent_expenditures(self):
        """Gets the independent_expenditures of this ElectionSummary.  # noqa: E501


        :return: The independent_expenditures of this ElectionSummary.  # noqa: E501
        :rtype: float
        """
        return self._independent_expenditures

    @independent_expenditures.setter
    def independent_expenditures(self, independent_expenditures):
        """Sets the independent_expenditures of this ElectionSummary.


        :param independent_expenditures: The independent_expenditures of this ElectionSummary.  # noqa: E501
        :type: float
        """

        self._independent_expenditures = independent_expenditures

    @property
    def receipts(self):
        """Gets the receipts of this ElectionSummary.  # noqa: E501


        :return: The receipts of this ElectionSummary.  # noqa: E501
        :rtype: float
        """
        return self._receipts

    @receipts.setter
    def receipts(self, receipts):
        """Sets the receipts of this ElectionSummary.


        :param receipts: The receipts of this ElectionSummary.  # noqa: E501
        :type: float
        """

        self._receipts = receipts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ElectionSummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ElectionSummary):
            return True

        return self.to_dict() != other.to_dict()
