# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class EntityReceiptDisbursementTotals(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cumulative_candidate_disbursements': 'float',
        'cumulative_candidate_receipts': 'float',
        'cumulative_pac_disbursements': 'float',
        'cumulative_pac_receipts': 'float',
        'cumulative_party_disbursements': 'float',
        'cumulative_party_receipts': 'float',
        'cycle': 'int',
        'end_date': 'date'
    }

    attribute_map = {
        'cumulative_candidate_disbursements': 'cumulative_candidate_disbursements',
        'cumulative_candidate_receipts': 'cumulative_candidate_receipts',
        'cumulative_pac_disbursements': 'cumulative_pac_disbursements',
        'cumulative_pac_receipts': 'cumulative_pac_receipts',
        'cumulative_party_disbursements': 'cumulative_party_disbursements',
        'cumulative_party_receipts': 'cumulative_party_receipts',
        'cycle': 'cycle',
        'end_date': 'end_date'
    }

    def __init__(self, cumulative_candidate_disbursements=None, cumulative_candidate_receipts=None, cumulative_pac_disbursements=None, cumulative_pac_receipts=None, cumulative_party_disbursements=None, cumulative_party_receipts=None, cycle=None, end_date=None, local_vars_configuration=None):  # noqa: E501
        """EntityReceiptDisbursementTotals - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cumulative_candidate_disbursements = None
        self._cumulative_candidate_receipts = None
        self._cumulative_pac_disbursements = None
        self._cumulative_pac_receipts = None
        self._cumulative_party_disbursements = None
        self._cumulative_party_receipts = None
        self._cycle = None
        self._end_date = None
        self.discriminator = None

        self.cumulative_candidate_disbursements = cumulative_candidate_disbursements
        self.cumulative_candidate_receipts = cumulative_candidate_receipts
        self.cumulative_pac_disbursements = cumulative_pac_disbursements
        self.cumulative_pac_receipts = cumulative_pac_receipts
        self.cumulative_party_disbursements = cumulative_party_disbursements
        self.cumulative_party_receipts = cumulative_party_receipts
        self.cycle = cycle
        if end_date is not None:
            self.end_date = end_date

    @property
    def cumulative_candidate_disbursements(self):
        """Gets the cumulative_candidate_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501

        Cumulative candidate disbursements in a two year period, adjusted to avoid double counting.  # noqa: E501

        :return: The cumulative_candidate_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: float
        """
        return self._cumulative_candidate_disbursements

    @cumulative_candidate_disbursements.setter
    def cumulative_candidate_disbursements(self, cumulative_candidate_disbursements):
        """Sets the cumulative_candidate_disbursements of this EntityReceiptDisbursementTotals.

        Cumulative candidate disbursements in a two year period, adjusted to avoid double counting.  # noqa: E501

        :param cumulative_candidate_disbursements: The cumulative_candidate_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: float
        """

        self._cumulative_candidate_disbursements = cumulative_candidate_disbursements

    @property
    def cumulative_candidate_receipts(self):
        """Gets the cumulative_candidate_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501

        Cumulative candidate receipts in a two year period, adjusted to avoid double counting.  # noqa: E501

        :return: The cumulative_candidate_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: float
        """
        return self._cumulative_candidate_receipts

    @cumulative_candidate_receipts.setter
    def cumulative_candidate_receipts(self, cumulative_candidate_receipts):
        """Sets the cumulative_candidate_receipts of this EntityReceiptDisbursementTotals.

        Cumulative candidate receipts in a two year period, adjusted to avoid double counting.  # noqa: E501

        :param cumulative_candidate_receipts: The cumulative_candidate_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: float
        """

        self._cumulative_candidate_receipts = cumulative_candidate_receipts

    @property
    def cumulative_pac_disbursements(self):
        """Gets the cumulative_pac_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501

        Cumulative PAC disbursements in a two year period, adjusted to avoid double counting.  # noqa: E501

        :return: The cumulative_pac_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: float
        """
        return self._cumulative_pac_disbursements

    @cumulative_pac_disbursements.setter
    def cumulative_pac_disbursements(self, cumulative_pac_disbursements):
        """Sets the cumulative_pac_disbursements of this EntityReceiptDisbursementTotals.

        Cumulative PAC disbursements in a two year period, adjusted to avoid double counting.  # noqa: E501

        :param cumulative_pac_disbursements: The cumulative_pac_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: float
        """

        self._cumulative_pac_disbursements = cumulative_pac_disbursements

    @property
    def cumulative_pac_receipts(self):
        """Gets the cumulative_pac_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501

        Cumulative PAC recipts in a two year period, adjusted to avoid double counting.  # noqa: E501

        :return: The cumulative_pac_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: float
        """
        return self._cumulative_pac_receipts

    @cumulative_pac_receipts.setter
    def cumulative_pac_receipts(self, cumulative_pac_receipts):
        """Sets the cumulative_pac_receipts of this EntityReceiptDisbursementTotals.

        Cumulative PAC recipts in a two year period, adjusted to avoid double counting.  # noqa: E501

        :param cumulative_pac_receipts: The cumulative_pac_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: float
        """

        self._cumulative_pac_receipts = cumulative_pac_receipts

    @property
    def cumulative_party_disbursements(self):
        """Gets the cumulative_party_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501

        Cumulative party disbursements in a two year period, adjusted to avoid double counting.  # noqa: E501

        :return: The cumulative_party_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: float
        """
        return self._cumulative_party_disbursements

    @cumulative_party_disbursements.setter
    def cumulative_party_disbursements(self, cumulative_party_disbursements):
        """Sets the cumulative_party_disbursements of this EntityReceiptDisbursementTotals.

        Cumulative party disbursements in a two year period, adjusted to avoid double counting.  # noqa: E501

        :param cumulative_party_disbursements: The cumulative_party_disbursements of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: float
        """

        self._cumulative_party_disbursements = cumulative_party_disbursements

    @property
    def cumulative_party_receipts(self):
        """Gets the cumulative_party_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501

        Cumulative party receipts in a two year period, adjusted to avoid double counting.  # noqa: E501

        :return: The cumulative_party_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: float
        """
        return self._cumulative_party_receipts

    @cumulative_party_receipts.setter
    def cumulative_party_receipts(self, cumulative_party_receipts):
        """Sets the cumulative_party_receipts of this EntityReceiptDisbursementTotals.

        Cumulative party receipts in a two year period, adjusted to avoid double counting.  # noqa: E501

        :param cumulative_party_receipts: The cumulative_party_receipts of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: float
        """

        self._cumulative_party_receipts = cumulative_party_receipts

    @property
    def cycle(self):
        """Gets the cycle of this EntityReceiptDisbursementTotals.  # noqa: E501

         Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this EntityReceiptDisbursementTotals.

         Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def end_date(self):
        """Gets the end_date of this EntityReceiptDisbursementTotals.  # noqa: E501


        :return: The end_date of this EntityReceiptDisbursementTotals.  # noqa: E501
        :rtype: date
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this EntityReceiptDisbursementTotals.


        :param end_date: The end_date of this EntityReceiptDisbursementTotals.  # noqa: E501
        :type: date
        """

        self._end_date = end_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntityReceiptDisbursementTotals):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EntityReceiptDisbursementTotals):
            return True

        return self.to_dict() != other.to_dict()
