# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class Filings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amendment_chain': 'list[float]',
        'amendment_indicator': 'str',
        'amendment_version': 'int',
        'beginning_image_number': 'str',
        'candidate_id': 'str',
        'candidate_name': 'str',
        'cash_on_hand_beginning_period': 'float',
        'cash_on_hand_end_period': 'float',
        'committee_id': 'str',
        'committee_name': 'str',
        'committee_type': 'str',
        'coverage_end_date': 'date',
        'coverage_start_date': 'date',
        'csv_url': 'str',
        'cycle': 'int',
        'debts_owed_by_committee': 'float',
        'debts_owed_to_committee': 'float',
        'document_description': 'str',
        'document_type': 'str',
        'document_type_full': 'str',
        'election_year': 'int',
        'ending_image_number': 'str',
        'fec_file_id': 'str',
        'fec_url': 'str',
        'file_number': 'int',
        'form_category': 'str',
        'form_type': 'str',
        'house_personal_funds': 'float',
        'html_url': 'str',
        'is_amended': 'bool',
        'means_filed': 'str',
        'most_recent': 'bool',
        'most_recent_file_number': 'int',
        'net_donations': 'float',
        'office': 'str',
        'opposition_personal_funds': 'float',
        'pages': 'int',
        'party': 'str',
        'pdf_url': 'str',
        'previous_file_number': 'int',
        'primary_general_indicator': 'str',
        'receipt_date': 'date',
        'report_type': 'str',
        'report_type_full': 'str',
        'report_year': 'int',
        'request_type': 'str',
        'senate_personal_funds': 'float',
        'state': 'str',
        'sub_id': 'str',
        'total_communication_cost': 'float',
        'total_disbursements': 'float',
        'total_independent_expenditures': 'float',
        'total_individual_contributions': 'float',
        'total_receipts': 'float',
        'treasurer_name': 'str',
        'update_date': 'date'
    }

    attribute_map = {
        'amendment_chain': 'amendment_chain',
        'amendment_indicator': 'amendment_indicator',
        'amendment_version': 'amendment_version',
        'beginning_image_number': 'beginning_image_number',
        'candidate_id': 'candidate_id',
        'candidate_name': 'candidate_name',
        'cash_on_hand_beginning_period': 'cash_on_hand_beginning_period',
        'cash_on_hand_end_period': 'cash_on_hand_end_period',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'committee_type': 'committee_type',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'csv_url': 'csv_url',
        'cycle': 'cycle',
        'debts_owed_by_committee': 'debts_owed_by_committee',
        'debts_owed_to_committee': 'debts_owed_to_committee',
        'document_description': 'document_description',
        'document_type': 'document_type',
        'document_type_full': 'document_type_full',
        'election_year': 'election_year',
        'ending_image_number': 'ending_image_number',
        'fec_file_id': 'fec_file_id',
        'fec_url': 'fec_url',
        'file_number': 'file_number',
        'form_category': 'form_category',
        'form_type': 'form_type',
        'house_personal_funds': 'house_personal_funds',
        'html_url': 'html_url',
        'is_amended': 'is_amended',
        'means_filed': 'means_filed',
        'most_recent': 'most_recent',
        'most_recent_file_number': 'most_recent_file_number',
        'net_donations': 'net_donations',
        'office': 'office',
        'opposition_personal_funds': 'opposition_personal_funds',
        'pages': 'pages',
        'party': 'party',
        'pdf_url': 'pdf_url',
        'previous_file_number': 'previous_file_number',
        'primary_general_indicator': 'primary_general_indicator',
        'receipt_date': 'receipt_date',
        'report_type': 'report_type',
        'report_type_full': 'report_type_full',
        'report_year': 'report_year',
        'request_type': 'request_type',
        'senate_personal_funds': 'senate_personal_funds',
        'state': 'state',
        'sub_id': 'sub_id',
        'total_communication_cost': 'total_communication_cost',
        'total_disbursements': 'total_disbursements',
        'total_independent_expenditures': 'total_independent_expenditures',
        'total_individual_contributions': 'total_individual_contributions',
        'total_receipts': 'total_receipts',
        'treasurer_name': 'treasurer_name',
        'update_date': 'update_date'
    }

    def __init__(self, amendment_chain=None, amendment_indicator=None, amendment_version=None, beginning_image_number=None, candidate_id=None, candidate_name=None, cash_on_hand_beginning_period=None, cash_on_hand_end_period=None, committee_id=None, committee_name=None, committee_type=None, coverage_end_date=None, coverage_start_date=None, csv_url=None, cycle=None, debts_owed_by_committee=None, debts_owed_to_committee=None, document_description=None, document_type=None, document_type_full=None, election_year=None, ending_image_number=None, fec_file_id=None, fec_url=None, file_number=None, form_category=None, form_type=None, house_personal_funds=None, html_url=None, is_amended=None, means_filed=None, most_recent=None, most_recent_file_number=None, net_donations=None, office=None, opposition_personal_funds=None, pages=None, party=None, pdf_url=None, previous_file_number=None, primary_general_indicator=None, receipt_date=None, report_type=None, report_type_full=None, report_year=None, request_type=None, senate_personal_funds=None, state=None, sub_id=None, total_communication_cost=None, total_disbursements=None, total_independent_expenditures=None, total_individual_contributions=None, total_receipts=None, treasurer_name=None, update_date=None, local_vars_configuration=None):  # noqa: E501
        """Filings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amendment_chain = None
        self._amendment_indicator = None
        self._amendment_version = None
        self._beginning_image_number = None
        self._candidate_id = None
        self._candidate_name = None
        self._cash_on_hand_beginning_period = None
        self._cash_on_hand_end_period = None
        self._committee_id = None
        self._committee_name = None
        self._committee_type = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._csv_url = None
        self._cycle = None
        self._debts_owed_by_committee = None
        self._debts_owed_to_committee = None
        self._document_description = None
        self._document_type = None
        self._document_type_full = None
        self._election_year = None
        self._ending_image_number = None
        self._fec_file_id = None
        self._fec_url = None
        self._file_number = None
        self._form_category = None
        self._form_type = None
        self._house_personal_funds = None
        self._html_url = None
        self._is_amended = None
        self._means_filed = None
        self._most_recent = None
        self._most_recent_file_number = None
        self._net_donations = None
        self._office = None
        self._opposition_personal_funds = None
        self._pages = None
        self._party = None
        self._pdf_url = None
        self._previous_file_number = None
        self._primary_general_indicator = None
        self._receipt_date = None
        self._report_type = None
        self._report_type_full = None
        self._report_year = None
        self._request_type = None
        self._senate_personal_funds = None
        self._state = None
        self._sub_id = None
        self._total_communication_cost = None
        self._total_disbursements = None
        self._total_independent_expenditures = None
        self._total_individual_contributions = None
        self._total_receipts = None
        self._treasurer_name = None
        self._update_date = None
        self.discriminator = None

        self.amendment_chain = amendment_chain
        self.amendment_indicator = amendment_indicator
        self.amendment_version = amendment_version
        if beginning_image_number is not None:
            self.beginning_image_number = beginning_image_number
        self.candidate_id = candidate_id
        self.candidate_name = candidate_name
        self.cash_on_hand_beginning_period = cash_on_hand_beginning_period
        self.cash_on_hand_end_period = cash_on_hand_end_period
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.committee_type = committee_type
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        if csv_url is not None:
            self.csv_url = csv_url
        self.cycle = cycle
        self.debts_owed_by_committee = debts_owed_by_committee
        self.debts_owed_to_committee = debts_owed_to_committee
        if document_description is not None:
            self.document_description = document_description
        self.document_type = document_type
        self.document_type_full = document_type_full
        self.election_year = election_year
        if ending_image_number is not None:
            self.ending_image_number = ending_image_number
        if fec_file_id is not None:
            self.fec_file_id = fec_file_id
        if fec_url is not None:
            self.fec_url = fec_url
        self.file_number = file_number
        self.form_category = form_category
        self.form_type = form_type
        self.house_personal_funds = house_personal_funds
        self.html_url = html_url
        self.is_amended = is_amended
        self.means_filed = means_filed
        self.most_recent = most_recent
        self.most_recent_file_number = most_recent_file_number
        self.net_donations = net_donations
        self.office = office
        self.opposition_personal_funds = opposition_personal_funds
        self.pages = pages
        self.party = party
        self.pdf_url = pdf_url
        self.previous_file_number = previous_file_number
        self.primary_general_indicator = primary_general_indicator
        self.receipt_date = receipt_date
        self.report_type = report_type
        self.report_type_full = report_type_full
        self.report_year = report_year
        self.request_type = request_type
        self.senate_personal_funds = senate_personal_funds
        self.state = state
        if sub_id is not None:
            self.sub_id = sub_id
        self.total_communication_cost = total_communication_cost
        self.total_disbursements = total_disbursements
        self.total_independent_expenditures = total_independent_expenditures
        self.total_individual_contributions = total_individual_contributions
        self.total_receipts = total_receipts
        self.treasurer_name = treasurer_name
        self.update_date = update_date

    @property
    def amendment_chain(self):
        """Gets the amendment_chain of this Filings.  # noqa: E501


        :return: The amendment_chain of this Filings.  # noqa: E501
        :rtype: list[float]
        """
        return self._amendment_chain

    @amendment_chain.setter
    def amendment_chain(self, amendment_chain):
        """Sets the amendment_chain of this Filings.


        :param amendment_chain: The amendment_chain of this Filings.  # noqa: E501
        :type: list[float]
        """

        self._amendment_chain = amendment_chain

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this Filings.  # noqa: E501

         The first value in the chain is the original filing.  The ordering in the chain reflects the order the amendments were filed up to the amendment being viewed.   # noqa: E501

        :return: The amendment_indicator of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this Filings.

         The first value in the chain is the original filing.  The ordering in the chain reflects the order the amendments were filed up to the amendment being viewed.   # noqa: E501

        :param amendment_indicator: The amendment_indicator of this Filings.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def amendment_version(self):
        """Gets the amendment_version of this Filings.  # noqa: E501


        :return: The amendment_version of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._amendment_version

    @amendment_version.setter
    def amendment_version(self, amendment_version):
        """Sets the amendment_version of this Filings.


        :param amendment_version: The amendment_version of this Filings.  # noqa: E501
        :type: int
        """

        self._amendment_version = amendment_version

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this Filings.  # noqa: E501


        :return: The beginning_image_number of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this Filings.


        :param beginning_image_number: The beginning_image_number of this Filings.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def candidate_id(self):
        """Gets the candidate_id of this Filings.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this Filings.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this Filings.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_name(self):
        """Gets the candidate_name of this Filings.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this Filings.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this Filings.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def cash_on_hand_beginning_period(self):
        """Gets the cash_on_hand_beginning_period of this Filings.  # noqa: E501

        Balance for the committee at the start of the two-year period  # noqa: E501

        :return: The cash_on_hand_beginning_period of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_beginning_period

    @cash_on_hand_beginning_period.setter
    def cash_on_hand_beginning_period(self, cash_on_hand_beginning_period):
        """Sets the cash_on_hand_beginning_period of this Filings.

        Balance for the committee at the start of the two-year period  # noqa: E501

        :param cash_on_hand_beginning_period: The cash_on_hand_beginning_period of this Filings.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_beginning_period = cash_on_hand_beginning_period

    @property
    def cash_on_hand_end_period(self):
        """Gets the cash_on_hand_end_period of this Filings.  # noqa: E501

        Ending cash balance on the most recent filing  # noqa: E501

        :return: The cash_on_hand_end_period of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_end_period

    @cash_on_hand_end_period.setter
    def cash_on_hand_end_period(self, cash_on_hand_end_period):
        """Sets the cash_on_hand_end_period of this Filings.

        Ending cash balance on the most recent filing  # noqa: E501

        :param cash_on_hand_end_period: The cash_on_hand_end_period of this Filings.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_end_period = cash_on_hand_end_period

    @property
    def committee_id(self):
        """Gets the committee_id of this Filings.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this Filings.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this Filings.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this Filings.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this Filings.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this Filings.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def committee_type(self):
        """Gets the committee_type of this Filings.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this Filings.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type: The committee_type of this Filings.  # noqa: E501
        :type: str
        """

        self._committee_type = committee_type

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this Filings.  # noqa: E501

        Ending date of the reporting period  # noqa: E501

        :return: The coverage_end_date of this Filings.  # noqa: E501
        :rtype: date
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this Filings.

        Ending date of the reporting period  # noqa: E501

        :param coverage_end_date: The coverage_end_date of this Filings.  # noqa: E501
        :type: date
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this Filings.  # noqa: E501

        Beginning date of the reporting period  # noqa: E501

        :return: The coverage_start_date of this Filings.  # noqa: E501
        :rtype: date
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this Filings.

        Beginning date of the reporting period  # noqa: E501

        :param coverage_start_date: The coverage_start_date of this Filings.  # noqa: E501
        :type: date
        """

        self._coverage_start_date = coverage_start_date

    @property
    def csv_url(self):
        """Gets the csv_url of this Filings.  # noqa: E501


        :return: The csv_url of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._csv_url

    @csv_url.setter
    def csv_url(self, csv_url):
        """Sets the csv_url of this Filings.


        :param csv_url: The csv_url of this Filings.  # noqa: E501
        :type: str
        """

        self._csv_url = csv_url

    @property
    def cycle(self):
        """Gets the cycle of this Filings.  # noqa: E501

         Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :return: The cycle of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this Filings.

         Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.   # noqa: E501

        :param cycle: The cycle of this Filings.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def debts_owed_by_committee(self):
        """Gets the debts_owed_by_committee of this Filings.  # noqa: E501

        Debts owed by the committee  # noqa: E501

        :return: The debts_owed_by_committee of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_by_committee

    @debts_owed_by_committee.setter
    def debts_owed_by_committee(self, debts_owed_by_committee):
        """Sets the debts_owed_by_committee of this Filings.

        Debts owed by the committee  # noqa: E501

        :param debts_owed_by_committee: The debts_owed_by_committee of this Filings.  # noqa: E501
        :type: float
        """

        self._debts_owed_by_committee = debts_owed_by_committee

    @property
    def debts_owed_to_committee(self):
        """Gets the debts_owed_to_committee of this Filings.  # noqa: E501

        Debts owed to the committee  # noqa: E501

        :return: The debts_owed_to_committee of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_to_committee

    @debts_owed_to_committee.setter
    def debts_owed_to_committee(self, debts_owed_to_committee):
        """Sets the debts_owed_to_committee of this Filings.

        Debts owed to the committee  # noqa: E501

        :param debts_owed_to_committee: The debts_owed_to_committee of this Filings.  # noqa: E501
        :type: float
        """

        self._debts_owed_to_committee = debts_owed_to_committee

    @property
    def document_description(self):
        """Gets the document_description of this Filings.  # noqa: E501


        :return: The document_description of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._document_description

    @document_description.setter
    def document_description(self, document_description):
        """Sets the document_description of this Filings.


        :param document_description: The document_description of this Filings.  # noqa: E501
        :type: str
        """

        self._document_description = document_description

    @property
    def document_type(self):
        """Gets the document_type of this Filings.  # noqa: E501

         The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice   # noqa: E501

        :return: The document_type of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._document_type

    @document_type.setter
    def document_type(self, document_type):
        """Sets the document_type of this Filings.

         The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice   # noqa: E501

        :param document_type: The document_type of this Filings.  # noqa: E501
        :type: str
        """

        self._document_type = document_type

    @property
    def document_type_full(self):
        """Gets the document_type_full of this Filings.  # noqa: E501

         The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice   # noqa: E501

        :return: The document_type_full of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._document_type_full

    @document_type_full.setter
    def document_type_full(self, document_type_full):
        """Sets the document_type_full of this Filings.

         The type of document for documents other than reports:     - 2 24 Hour Contribution Notice     - 4 48 Hour Contribution Notice     - A Debt Settlement Statement     - B Acknowledgment of Receipt of Debt Settlement Statement     - C RFAI: Debt Settlement First Notice     - D Commission Debt Settlement Review     - E Commission Response TO Debt Settlement Request     - F Administrative Termination     - G Debt Settlement Plan Amendment     - H Disavowal Notice     - I Disavowal Response     - J Conduit Report     - K Termination Approval     - L Repeat Non-Filer Notice     - M Filing Frequency Change Notice     - N Paper Amendment to Electronic Report     - O Acknowledgment of Filing Frequency Change     - S RFAI: Debt Settlement Second     - T Miscellaneous Report TO FEC     - V Repeat Violation Notice (441A OR 441B)     - P Notice of Paper Filing     - R F3L Filing Frequency Change Notice     - Q Acknowledgment of F3L Filing Frequency Change     - U Unregistered Committee Notice   # noqa: E501

        :param document_type_full: The document_type_full of this Filings.  # noqa: E501
        :type: str
        """

        self._document_type_full = document_type_full

    @property
    def election_year(self):
        """Gets the election_year of this Filings.  # noqa: E501

        Year of election  # noqa: E501

        :return: The election_year of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._election_year

    @election_year.setter
    def election_year(self, election_year):
        """Sets the election_year of this Filings.

        Year of election  # noqa: E501

        :param election_year: The election_year of this Filings.  # noqa: E501
        :type: int
        """

        self._election_year = election_year

    @property
    def ending_image_number(self):
        """Gets the ending_image_number of this Filings.  # noqa: E501


        :return: The ending_image_number of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._ending_image_number

    @ending_image_number.setter
    def ending_image_number(self, ending_image_number):
        """Sets the ending_image_number of this Filings.


        :param ending_image_number: The ending_image_number of this Filings.  # noqa: E501
        :type: str
        """

        self._ending_image_number = ending_image_number

    @property
    def fec_file_id(self):
        """Gets the fec_file_id of this Filings.  # noqa: E501


        :return: The fec_file_id of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._fec_file_id

    @fec_file_id.setter
    def fec_file_id(self, fec_file_id):
        """Sets the fec_file_id of this Filings.


        :param fec_file_id: The fec_file_id of this Filings.  # noqa: E501
        :type: str
        """

        self._fec_file_id = fec_file_id

    @property
    def fec_url(self):
        """Gets the fec_url of this Filings.  # noqa: E501


        :return: The fec_url of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._fec_url

    @fec_url.setter
    def fec_url(self, fec_url):
        """Sets the fec_url of this Filings.


        :param fec_url: The fec_url of this Filings.  # noqa: E501
        :type: str
        """

        self._fec_url = fec_url

    @property
    def file_number(self):
        """Gets the file_number of this Filings.  # noqa: E501


        :return: The file_number of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this Filings.


        :param file_number: The file_number of this Filings.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def form_category(self):
        """Gets the form_category of this Filings.  # noqa: E501

         The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ   # noqa: E501

        :return: The form_category of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._form_category

    @form_category.setter
    def form_category(self, form_category):
        """Sets the form_category of this Filings.

         The forms filed are categorized based on the nature of the filing:     - REPORT F3, F3X, F3P, F3L, F4, F5, F7, F13     - NOTICE F5, F24, F6, F9, F10, F11     - STATEMENT F1, F2     - OTHER F1M, F8, F99, F12, FRQ   # noqa: E501

        :param form_category: The form_category of this Filings.  # noqa: E501
        :type: str
        """

        self._form_category = form_category

    @property
    def form_type(self):
        """Gets the form_type of this Filings.  # noqa: E501

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :return: The form_type of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._form_type

    @form_type.setter
    def form_type(self, form_type):
        """Sets the form_type of this Filings.

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :param form_type: The form_type of this Filings.  # noqa: E501
        :type: str
        """

        self._form_type = form_type

    @property
    def house_personal_funds(self):
        """Gets the house_personal_funds of this Filings.  # noqa: E501


        :return: The house_personal_funds of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._house_personal_funds

    @house_personal_funds.setter
    def house_personal_funds(self, house_personal_funds):
        """Sets the house_personal_funds of this Filings.


        :param house_personal_funds: The house_personal_funds of this Filings.  # noqa: E501
        :type: float
        """

        self._house_personal_funds = house_personal_funds

    @property
    def html_url(self):
        """Gets the html_url of this Filings.  # noqa: E501

         HTML link to the filing.   # noqa: E501

        :return: The html_url of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """Sets the html_url of this Filings.

         HTML link to the filing.   # noqa: E501

        :param html_url: The html_url of this Filings.  # noqa: E501
        :type: str
        """

        self._html_url = html_url

    @property
    def is_amended(self):
        """Gets the is_amended of this Filings.  # noqa: E501


        :return: The is_amended of this Filings.  # noqa: E501
        :rtype: bool
        """
        return self._is_amended

    @is_amended.setter
    def is_amended(self, is_amended):
        """Sets the is_amended of this Filings.


        :param is_amended: The is_amended of this Filings.  # noqa: E501
        :type: bool
        """

        self._is_amended = is_amended

    @property
    def means_filed(self):
        """Gets the means_filed of this Filings.  # noqa: E501

        The method used to file with the FEC, either electronic or on paper.  # noqa: E501

        :return: The means_filed of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._means_filed

    @means_filed.setter
    def means_filed(self, means_filed):
        """Sets the means_filed of this Filings.

        The method used to file with the FEC, either electronic or on paper.  # noqa: E501

        :param means_filed: The means_filed of this Filings.  # noqa: E501
        :type: str
        """

        self._means_filed = means_filed

    @property
    def most_recent(self):
        """Gets the most_recent of this Filings.  # noqa: E501


        :return: The most_recent of this Filings.  # noqa: E501
        :rtype: bool
        """
        return self._most_recent

    @most_recent.setter
    def most_recent(self, most_recent):
        """Sets the most_recent of this Filings.


        :param most_recent: The most_recent of this Filings.  # noqa: E501
        :type: bool
        """

        self._most_recent = most_recent

    @property
    def most_recent_file_number(self):
        """Gets the most_recent_file_number of this Filings.  # noqa: E501


        :return: The most_recent_file_number of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._most_recent_file_number

    @most_recent_file_number.setter
    def most_recent_file_number(self, most_recent_file_number):
        """Sets the most_recent_file_number of this Filings.


        :param most_recent_file_number: The most_recent_file_number of this Filings.  # noqa: E501
        :type: int
        """

        self._most_recent_file_number = most_recent_file_number

    @property
    def net_donations(self):
        """Gets the net_donations of this Filings.  # noqa: E501


        :return: The net_donations of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._net_donations

    @net_donations.setter
    def net_donations(self, net_donations):
        """Sets the net_donations of this Filings.


        :param net_donations: The net_donations of this Filings.  # noqa: E501
        :type: float
        """

        self._net_donations = net_donations

    @property
    def office(self):
        """Gets the office of this Filings.  # noqa: E501

        Federal office candidate runs for: H, S or P  # noqa: E501

        :return: The office of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._office

    @office.setter
    def office(self, office):
        """Sets the office of this Filings.

        Federal office candidate runs for: H, S or P  # noqa: E501

        :param office: The office of this Filings.  # noqa: E501
        :type: str
        """

        self._office = office

    @property
    def opposition_personal_funds(self):
        """Gets the opposition_personal_funds of this Filings.  # noqa: E501


        :return: The opposition_personal_funds of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._opposition_personal_funds

    @opposition_personal_funds.setter
    def opposition_personal_funds(self, opposition_personal_funds):
        """Sets the opposition_personal_funds of this Filings.


        :param opposition_personal_funds: The opposition_personal_funds of this Filings.  # noqa: E501
        :type: float
        """

        self._opposition_personal_funds = opposition_personal_funds

    @property
    def pages(self):
        """Gets the pages of this Filings.  # noqa: E501

         Number of pages in the document   # noqa: E501

        :return: The pages of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._pages

    @pages.setter
    def pages(self, pages):
        """Sets the pages of this Filings.

         Number of pages in the document   # noqa: E501

        :param pages: The pages of this Filings.  # noqa: E501
        :type: int
        """

        self._pages = pages

    @property
    def party(self):
        """Gets the party of this Filings.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The party of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._party

    @party.setter
    def party(self, party):
        """Sets the party of this Filings.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param party: The party of this Filings.  # noqa: E501
        :type: str
        """

        self._party = party

    @property
    def pdf_url(self):
        """Gets the pdf_url of this Filings.  # noqa: E501


        :return: The pdf_url of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this Filings.


        :param pdf_url: The pdf_url of this Filings.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def previous_file_number(self):
        """Gets the previous_file_number of this Filings.  # noqa: E501


        :return: The previous_file_number of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._previous_file_number

    @previous_file_number.setter
    def previous_file_number(self, previous_file_number):
        """Sets the previous_file_number of this Filings.


        :param previous_file_number: The previous_file_number of this Filings.  # noqa: E501
        :type: int
        """

        self._previous_file_number = previous_file_number

    @property
    def primary_general_indicator(self):
        """Gets the primary_general_indicator of this Filings.  # noqa: E501


        :return: The primary_general_indicator of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._primary_general_indicator

    @primary_general_indicator.setter
    def primary_general_indicator(self, primary_general_indicator):
        """Sets the primary_general_indicator of this Filings.


        :param primary_general_indicator: The primary_general_indicator of this Filings.  # noqa: E501
        :type: str
        """

        self._primary_general_indicator = primary_general_indicator

    @property
    def receipt_date(self):
        """Gets the receipt_date of this Filings.  # noqa: E501

        Date the FEC received the electronic or paper record  # noqa: E501

        :return: The receipt_date of this Filings.  # noqa: E501
        :rtype: date
        """
        return self._receipt_date

    @receipt_date.setter
    def receipt_date(self, receipt_date):
        """Sets the receipt_date of this Filings.

        Date the FEC received the electronic or paper record  # noqa: E501

        :param receipt_date: The receipt_date of this Filings.  # noqa: E501
        :type: date
        """

        self._receipt_date = receipt_date

    @property
    def report_type(self):
        """Gets the report_type of this Filings.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this Filings.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this Filings.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_type_full(self):
        """Gets the report_type_full of this Filings.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type_full of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._report_type_full

    @report_type_full.setter
    def report_type_full(self, report_type_full):
        """Sets the report_type_full of this Filings.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type_full: The report_type_full of this Filings.  # noqa: E501
        :type: str
        """

        self._report_type_full = report_type_full

    @property
    def report_year(self):
        """Gets the report_year of this Filings.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this Filings.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this Filings.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this Filings.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def request_type(self):
        """Gets the request_type of this Filings.  # noqa: E501


        :return: The request_type of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._request_type

    @request_type.setter
    def request_type(self, request_type):
        """Sets the request_type of this Filings.


        :param request_type: The request_type of this Filings.  # noqa: E501
        :type: str
        """

        self._request_type = request_type

    @property
    def senate_personal_funds(self):
        """Gets the senate_personal_funds of this Filings.  # noqa: E501


        :return: The senate_personal_funds of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._senate_personal_funds

    @senate_personal_funds.setter
    def senate_personal_funds(self, senate_personal_funds):
        """Sets the senate_personal_funds of this Filings.


        :param senate_personal_funds: The senate_personal_funds of this Filings.  # noqa: E501
        :type: float
        """

        self._senate_personal_funds = senate_personal_funds

    @property
    def state(self):
        """Gets the state of this Filings.  # noqa: E501

        US state or territory where a candidate runs for office  # noqa: E501

        :return: The state of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Filings.

        US state or territory where a candidate runs for office  # noqa: E501

        :param state: The state of this Filings.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def sub_id(self):
        """Gets the sub_id of this Filings.  # noqa: E501


        :return: The sub_id of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this Filings.


        :param sub_id: The sub_id of this Filings.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def total_communication_cost(self):
        """Gets the total_communication_cost of this Filings.  # noqa: E501


        :return: The total_communication_cost of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._total_communication_cost

    @total_communication_cost.setter
    def total_communication_cost(self, total_communication_cost):
        """Sets the total_communication_cost of this Filings.


        :param total_communication_cost: The total_communication_cost of this Filings.  # noqa: E501
        :type: float
        """

        self._total_communication_cost = total_communication_cost

    @property
    def total_disbursements(self):
        """Gets the total_disbursements of this Filings.  # noqa: E501


        :return: The total_disbursements of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._total_disbursements

    @total_disbursements.setter
    def total_disbursements(self, total_disbursements):
        """Sets the total_disbursements of this Filings.


        :param total_disbursements: The total_disbursements of this Filings.  # noqa: E501
        :type: float
        """

        self._total_disbursements = total_disbursements

    @property
    def total_independent_expenditures(self):
        """Gets the total_independent_expenditures of this Filings.  # noqa: E501


        :return: The total_independent_expenditures of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._total_independent_expenditures

    @total_independent_expenditures.setter
    def total_independent_expenditures(self, total_independent_expenditures):
        """Sets the total_independent_expenditures of this Filings.


        :param total_independent_expenditures: The total_independent_expenditures of this Filings.  # noqa: E501
        :type: float
        """

        self._total_independent_expenditures = total_independent_expenditures

    @property
    def total_individual_contributions(self):
        """Gets the total_individual_contributions of this Filings.  # noqa: E501


        :return: The total_individual_contributions of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._total_individual_contributions

    @total_individual_contributions.setter
    def total_individual_contributions(self, total_individual_contributions):
        """Sets the total_individual_contributions of this Filings.


        :param total_individual_contributions: The total_individual_contributions of this Filings.  # noqa: E501
        :type: float
        """

        self._total_individual_contributions = total_individual_contributions

    @property
    def total_receipts(self):
        """Gets the total_receipts of this Filings.  # noqa: E501


        :return: The total_receipts of this Filings.  # noqa: E501
        :rtype: float
        """
        return self._total_receipts

    @total_receipts.setter
    def total_receipts(self, total_receipts):
        """Sets the total_receipts of this Filings.


        :param total_receipts: The total_receipts of this Filings.  # noqa: E501
        :type: float
        """

        self._total_receipts = total_receipts

    @property
    def treasurer_name(self):
        """Gets the treasurer_name of this Filings.  # noqa: E501

        Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.  # noqa: E501

        :return: The treasurer_name of this Filings.  # noqa: E501
        :rtype: str
        """
        return self._treasurer_name

    @treasurer_name.setter
    def treasurer_name(self, treasurer_name):
        """Sets the treasurer_name of this Filings.

        Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.  # noqa: E501

        :param treasurer_name: The treasurer_name of this Filings.  # noqa: E501
        :type: str
        """

        self._treasurer_name = treasurer_name

    @property
    def update_date(self):
        """Gets the update_date of this Filings.  # noqa: E501


        :return: The update_date of this Filings.  # noqa: E501
        :rtype: date
        """
        return self._update_date

    @update_date.setter
    def update_date(self, update_date):
        """Sets the update_date of this Filings.


        :param update_date: The update_date of this Filings.  # noqa: E501
        :type: date
        """

        self._update_date = update_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Filings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Filings):
            return True

        return self.to_dict() != other.to_dict()
