# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class InlineResponseDefault1(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'admin_fines': 'list[InlineResponseDefault1AdminFines]',
        'adrs': 'list[InlineResponseDefault1Adrs]',
        'advisory_opinions': 'list[InlineResponseDefault1AdvisoryOpinions]',
        'murs': 'list[InlineResponseDefault1Murs]',
        'regulations': 'list[InlineResponseDefault1Regulations]',
        'statutes': 'list[InlineResponseDefault1Statutes]',
        'total_admin_fines': 'int',
        'total_adrs': 'int',
        'total_advisory_opinions': 'int',
        'total_all': 'int',
        'total_murs': 'int',
        'total_regulations': 'int',
        'total_statutes': 'int'
    }

    attribute_map = {
        'admin_fines': 'admin_fines',
        'adrs': 'adrs',
        'advisory_opinions': 'advisory_opinions',
        'murs': 'murs',
        'regulations': 'regulations',
        'statutes': 'statutes',
        'total_admin_fines': 'total_admin_fines',
        'total_adrs': 'total_adrs',
        'total_advisory_opinions': 'total_advisory_opinions',
        'total_all': 'total_all',
        'total_murs': 'total_murs',
        'total_regulations': 'total_regulations',
        'total_statutes': 'total_statutes'
    }

    def __init__(self, admin_fines=None, adrs=None, advisory_opinions=None, murs=None, regulations=None, statutes=None, total_admin_fines=None, total_adrs=None, total_advisory_opinions=None, total_all=None, total_murs=None, total_regulations=None, total_statutes=None, local_vars_configuration=None):  # noqa: E501
        """InlineResponseDefault1 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._admin_fines = None
        self._adrs = None
        self._advisory_opinions = None
        self._murs = None
        self._regulations = None
        self._statutes = None
        self._total_admin_fines = None
        self._total_adrs = None
        self._total_advisory_opinions = None
        self._total_all = None
        self._total_murs = None
        self._total_regulations = None
        self._total_statutes = None
        self.discriminator = None

        if admin_fines is not None:
            self.admin_fines = admin_fines
        if adrs is not None:
            self.adrs = adrs
        if advisory_opinions is not None:
            self.advisory_opinions = advisory_opinions
        if murs is not None:
            self.murs = murs
        if regulations is not None:
            self.regulations = regulations
        if statutes is not None:
            self.statutes = statutes
        if total_admin_fines is not None:
            self.total_admin_fines = total_admin_fines
        if total_adrs is not None:
            self.total_adrs = total_adrs
        if total_advisory_opinions is not None:
            self.total_advisory_opinions = total_advisory_opinions
        if total_all is not None:
            self.total_all = total_all
        if total_murs is not None:
            self.total_murs = total_murs
        if total_regulations is not None:
            self.total_regulations = total_regulations
        if total_statutes is not None:
            self.total_statutes = total_statutes

    @property
    def admin_fines(self):
        """Gets the admin_fines of this InlineResponseDefault1.  # noqa: E501


        :return: The admin_fines of this InlineResponseDefault1.  # noqa: E501
        :rtype: list[InlineResponseDefault1AdminFines]
        """
        return self._admin_fines

    @admin_fines.setter
    def admin_fines(self, admin_fines):
        """Sets the admin_fines of this InlineResponseDefault1.


        :param admin_fines: The admin_fines of this InlineResponseDefault1.  # noqa: E501
        :type: list[InlineResponseDefault1AdminFines]
        """

        self._admin_fines = admin_fines

    @property
    def adrs(self):
        """Gets the adrs of this InlineResponseDefault1.  # noqa: E501


        :return: The adrs of this InlineResponseDefault1.  # noqa: E501
        :rtype: list[InlineResponseDefault1Adrs]
        """
        return self._adrs

    @adrs.setter
    def adrs(self, adrs):
        """Sets the adrs of this InlineResponseDefault1.


        :param adrs: The adrs of this InlineResponseDefault1.  # noqa: E501
        :type: list[InlineResponseDefault1Adrs]
        """

        self._adrs = adrs

    @property
    def advisory_opinions(self):
        """Gets the advisory_opinions of this InlineResponseDefault1.  # noqa: E501


        :return: The advisory_opinions of this InlineResponseDefault1.  # noqa: E501
        :rtype: list[InlineResponseDefault1AdvisoryOpinions]
        """
        return self._advisory_opinions

    @advisory_opinions.setter
    def advisory_opinions(self, advisory_opinions):
        """Sets the advisory_opinions of this InlineResponseDefault1.


        :param advisory_opinions: The advisory_opinions of this InlineResponseDefault1.  # noqa: E501
        :type: list[InlineResponseDefault1AdvisoryOpinions]
        """

        self._advisory_opinions = advisory_opinions

    @property
    def murs(self):
        """Gets the murs of this InlineResponseDefault1.  # noqa: E501


        :return: The murs of this InlineResponseDefault1.  # noqa: E501
        :rtype: list[InlineResponseDefault1Murs]
        """
        return self._murs

    @murs.setter
    def murs(self, murs):
        """Sets the murs of this InlineResponseDefault1.


        :param murs: The murs of this InlineResponseDefault1.  # noqa: E501
        :type: list[InlineResponseDefault1Murs]
        """

        self._murs = murs

    @property
    def regulations(self):
        """Gets the regulations of this InlineResponseDefault1.  # noqa: E501


        :return: The regulations of this InlineResponseDefault1.  # noqa: E501
        :rtype: list[InlineResponseDefault1Regulations]
        """
        return self._regulations

    @regulations.setter
    def regulations(self, regulations):
        """Sets the regulations of this InlineResponseDefault1.


        :param regulations: The regulations of this InlineResponseDefault1.  # noqa: E501
        :type: list[InlineResponseDefault1Regulations]
        """

        self._regulations = regulations

    @property
    def statutes(self):
        """Gets the statutes of this InlineResponseDefault1.  # noqa: E501


        :return: The statutes of this InlineResponseDefault1.  # noqa: E501
        :rtype: list[InlineResponseDefault1Statutes]
        """
        return self._statutes

    @statutes.setter
    def statutes(self, statutes):
        """Sets the statutes of this InlineResponseDefault1.


        :param statutes: The statutes of this InlineResponseDefault1.  # noqa: E501
        :type: list[InlineResponseDefault1Statutes]
        """

        self._statutes = statutes

    @property
    def total_admin_fines(self):
        """Gets the total_admin_fines of this InlineResponseDefault1.  # noqa: E501

        Total number of Admin Fines matching the search criteria  # noqa: E501

        :return: The total_admin_fines of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_admin_fines

    @total_admin_fines.setter
    def total_admin_fines(self, total_admin_fines):
        """Sets the total_admin_fines of this InlineResponseDefault1.

        Total number of Admin Fines matching the search criteria  # noqa: E501

        :param total_admin_fines: The total_admin_fines of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_admin_fines = total_admin_fines

    @property
    def total_adrs(self):
        """Gets the total_adrs of this InlineResponseDefault1.  # noqa: E501

        Total number of ADRs matching the search criteria  # noqa: E501

        :return: The total_adrs of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_adrs

    @total_adrs.setter
    def total_adrs(self, total_adrs):
        """Sets the total_adrs of this InlineResponseDefault1.

        Total number of ADRs matching the search criteria  # noqa: E501

        :param total_adrs: The total_adrs of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_adrs = total_adrs

    @property
    def total_advisory_opinions(self):
        """Gets the total_advisory_opinions of this InlineResponseDefault1.  # noqa: E501

        Total number of Advisory Opinions matching the search criteria  # noqa: E501

        :return: The total_advisory_opinions of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_advisory_opinions

    @total_advisory_opinions.setter
    def total_advisory_opinions(self, total_advisory_opinions):
        """Sets the total_advisory_opinions of this InlineResponseDefault1.

        Total number of Advisory Opinions matching the search criteria  # noqa: E501

        :param total_advisory_opinions: The total_advisory_opinions of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_advisory_opinions = total_advisory_opinions

    @property
    def total_all(self):
        """Gets the total_all of this InlineResponseDefault1.  # noqa: E501

        Total number of legal documents matching the search criteria  # noqa: E501

        :return: The total_all of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_all

    @total_all.setter
    def total_all(self, total_all):
        """Sets the total_all of this InlineResponseDefault1.

        Total number of legal documents matching the search criteria  # noqa: E501

        :param total_all: The total_all of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_all = total_all

    @property
    def total_murs(self):
        """Gets the total_murs of this InlineResponseDefault1.  # noqa: E501

        Total number of MURs matching the search criteria  # noqa: E501

        :return: The total_murs of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_murs

    @total_murs.setter
    def total_murs(self, total_murs):
        """Sets the total_murs of this InlineResponseDefault1.

        Total number of MURs matching the search criteria  # noqa: E501

        :param total_murs: The total_murs of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_murs = total_murs

    @property
    def total_regulations(self):
        """Gets the total_regulations of this InlineResponseDefault1.  # noqa: E501

        Total number of Regulations matching the search criteria  # noqa: E501

        :return: The total_regulations of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_regulations

    @total_regulations.setter
    def total_regulations(self, total_regulations):
        """Sets the total_regulations of this InlineResponseDefault1.

        Total number of Regulations matching the search criteria  # noqa: E501

        :param total_regulations: The total_regulations of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_regulations = total_regulations

    @property
    def total_statutes(self):
        """Gets the total_statutes of this InlineResponseDefault1.  # noqa: E501

        Total number of Statutes matching the search criteria  # noqa: E501

        :return: The total_statutes of this InlineResponseDefault1.  # noqa: E501
        :rtype: int
        """
        return self._total_statutes

    @total_statutes.setter
    def total_statutes(self, total_statutes):
        """Sets the total_statutes of this InlineResponseDefault1.

        Total number of Statutes matching the search criteria  # noqa: E501

        :param total_statutes: The total_statutes of this InlineResponseDefault1.  # noqa: E501
        :type: int
        """

        self._total_statutes = total_statutes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineResponseDefault1):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineResponseDefault1):
            return True

        return self.to_dict() != other.to_dict()
