# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class InlineResponseDefault1AdminFines(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'challenge_outcome': 'str',
        'challenge_receipt_date': 'date',
        'check_amount': 'float',
        'commission_votes': 'list[InlineResponseDefault1CommissionVotes]',
        'committee_id': 'str',
        'doc_id': 'str',
        'document_highlights': 'object',
        'documents': 'list[InlineResponseDefault1Documents]',
        'final_determination_amount': 'float',
        'final_determination_date': 'date',
        'highlights': 'list[str]',
        'name': 'str',
        'no': 'str',
        'petition_court_decision_date': 'date',
        'petition_court_filing_date': 'date',
        'reason_to_believe_action_date': 'date',
        'reason_to_believe_fine_amount': 'float',
        'report_type': 'str',
        'report_year': 'str',
        'treasury_referral_amount': 'float',
        'treasury_referral_date': 'date',
        'url': 'str'
    }

    attribute_map = {
        'challenge_outcome': 'challenge_outcome',
        'challenge_receipt_date': 'challenge_receipt_date',
        'check_amount': 'check_amount',
        'commission_votes': 'commission_votes',
        'committee_id': 'committee_id',
        'doc_id': 'doc_id',
        'document_highlights': 'document_highlights',
        'documents': 'documents',
        'final_determination_amount': 'final_determination_amount',
        'final_determination_date': 'final_determination_date',
        'highlights': 'highlights',
        'name': 'name',
        'no': 'no',
        'petition_court_decision_date': 'petition_court_decision_date',
        'petition_court_filing_date': 'petition_court_filing_date',
        'reason_to_believe_action_date': 'reason_to_believe_action_date',
        'reason_to_believe_fine_amount': 'reason_to_believe_fine_amount',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'treasury_referral_amount': 'treasury_referral_amount',
        'treasury_referral_date': 'treasury_referral_date',
        'url': 'url'
    }

    def __init__(self, challenge_outcome=None, challenge_receipt_date=None, check_amount=None, commission_votes=None, committee_id=None, doc_id=None, document_highlights=None, documents=None, final_determination_amount=None, final_determination_date=None, highlights=None, name=None, no=None, petition_court_decision_date=None, petition_court_filing_date=None, reason_to_believe_action_date=None, reason_to_believe_fine_amount=None, report_type=None, report_year=None, treasury_referral_amount=None, treasury_referral_date=None, url=None, local_vars_configuration=None):  # noqa: E501
        """InlineResponseDefault1AdminFines - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._challenge_outcome = None
        self._challenge_receipt_date = None
        self._check_amount = None
        self._commission_votes = None
        self._committee_id = None
        self._doc_id = None
        self._document_highlights = None
        self._documents = None
        self._final_determination_amount = None
        self._final_determination_date = None
        self._highlights = None
        self._name = None
        self._no = None
        self._petition_court_decision_date = None
        self._petition_court_filing_date = None
        self._reason_to_believe_action_date = None
        self._reason_to_believe_fine_amount = None
        self._report_type = None
        self._report_year = None
        self._treasury_referral_amount = None
        self._treasury_referral_date = None
        self._url = None
        self.discriminator = None

        if challenge_outcome is not None:
            self.challenge_outcome = challenge_outcome
        if challenge_receipt_date is not None:
            self.challenge_receipt_date = challenge_receipt_date
        if check_amount is not None:
            self.check_amount = check_amount
        if commission_votes is not None:
            self.commission_votes = commission_votes
        if committee_id is not None:
            self.committee_id = committee_id
        if doc_id is not None:
            self.doc_id = doc_id
        if document_highlights is not None:
            self.document_highlights = document_highlights
        if documents is not None:
            self.documents = documents
        if final_determination_amount is not None:
            self.final_determination_amount = final_determination_amount
        if final_determination_date is not None:
            self.final_determination_date = final_determination_date
        if highlights is not None:
            self.highlights = highlights
        if name is not None:
            self.name = name
        if no is not None:
            self.no = no
        if petition_court_decision_date is not None:
            self.petition_court_decision_date = petition_court_decision_date
        if petition_court_filing_date is not None:
            self.petition_court_filing_date = petition_court_filing_date
        if reason_to_believe_action_date is not None:
            self.reason_to_believe_action_date = reason_to_believe_action_date
        if reason_to_believe_fine_amount is not None:
            self.reason_to_believe_fine_amount = reason_to_believe_fine_amount
        if report_type is not None:
            self.report_type = report_type
        if report_year is not None:
            self.report_year = report_year
        if treasury_referral_amount is not None:
            self.treasury_referral_amount = treasury_referral_amount
        if treasury_referral_date is not None:
            self.treasury_referral_date = treasury_referral_date
        if url is not None:
            self.url = url

    @property
    def challenge_outcome(self):
        """Gets the challenge_outcome of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The challenge_outcome of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._challenge_outcome

    @challenge_outcome.setter
    def challenge_outcome(self, challenge_outcome):
        """Sets the challenge_outcome of this InlineResponseDefault1AdminFines.


        :param challenge_outcome: The challenge_outcome of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._challenge_outcome = challenge_outcome

    @property
    def challenge_receipt_date(self):
        """Gets the challenge_receipt_date of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The challenge_receipt_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: date
        """
        return self._challenge_receipt_date

    @challenge_receipt_date.setter
    def challenge_receipt_date(self, challenge_receipt_date):
        """Sets the challenge_receipt_date of this InlineResponseDefault1AdminFines.


        :param challenge_receipt_date: The challenge_receipt_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: date
        """

        self._challenge_receipt_date = challenge_receipt_date

    @property
    def check_amount(self):
        """Gets the check_amount of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The check_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: float
        """
        return self._check_amount

    @check_amount.setter
    def check_amount(self, check_amount):
        """Sets the check_amount of this InlineResponseDefault1AdminFines.


        :param check_amount: The check_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: float
        """

        self._check_amount = check_amount

    @property
    def commission_votes(self):
        """Gets the commission_votes of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The commission_votes of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: list[InlineResponseDefault1CommissionVotes]
        """
        return self._commission_votes

    @commission_votes.setter
    def commission_votes(self, commission_votes):
        """Sets the commission_votes of this InlineResponseDefault1AdminFines.


        :param commission_votes: The commission_votes of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: list[InlineResponseDefault1CommissionVotes]
        """

        self._commission_votes = commission_votes

    @property
    def committee_id(self):
        """Gets the committee_id of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The committee_id of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this InlineResponseDefault1AdminFines.


        :param committee_id: The committee_id of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def doc_id(self):
        """Gets the doc_id of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The doc_id of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._doc_id

    @doc_id.setter
    def doc_id(self, doc_id):
        """Sets the doc_id of this InlineResponseDefault1AdminFines.


        :param doc_id: The doc_id of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._doc_id = doc_id

    @property
    def document_highlights(self):
        """Gets the document_highlights of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The document_highlights of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: object
        """
        return self._document_highlights

    @document_highlights.setter
    def document_highlights(self, document_highlights):
        """Sets the document_highlights of this InlineResponseDefault1AdminFines.


        :param document_highlights: The document_highlights of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: object
        """

        self._document_highlights = document_highlights

    @property
    def documents(self):
        """Gets the documents of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The documents of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: list[InlineResponseDefault1Documents]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """Sets the documents of this InlineResponseDefault1AdminFines.


        :param documents: The documents of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: list[InlineResponseDefault1Documents]
        """

        self._documents = documents

    @property
    def final_determination_amount(self):
        """Gets the final_determination_amount of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The final_determination_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: float
        """
        return self._final_determination_amount

    @final_determination_amount.setter
    def final_determination_amount(self, final_determination_amount):
        """Sets the final_determination_amount of this InlineResponseDefault1AdminFines.


        :param final_determination_amount: The final_determination_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: float
        """

        self._final_determination_amount = final_determination_amount

    @property
    def final_determination_date(self):
        """Gets the final_determination_date of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The final_determination_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: date
        """
        return self._final_determination_date

    @final_determination_date.setter
    def final_determination_date(self, final_determination_date):
        """Sets the final_determination_date of this InlineResponseDefault1AdminFines.


        :param final_determination_date: The final_determination_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: date
        """

        self._final_determination_date = final_determination_date

    @property
    def highlights(self):
        """Gets the highlights of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The highlights of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: list[str]
        """
        return self._highlights

    @highlights.setter
    def highlights(self, highlights):
        """Sets the highlights of this InlineResponseDefault1AdminFines.


        :param highlights: The highlights of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: list[str]
        """

        self._highlights = highlights

    @property
    def name(self):
        """Gets the name of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The name of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this InlineResponseDefault1AdminFines.


        :param name: The name of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def no(self):
        """Gets the no of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The no of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._no

    @no.setter
    def no(self, no):
        """Sets the no of this InlineResponseDefault1AdminFines.


        :param no: The no of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._no = no

    @property
    def petition_court_decision_date(self):
        """Gets the petition_court_decision_date of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The petition_court_decision_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: date
        """
        return self._petition_court_decision_date

    @petition_court_decision_date.setter
    def petition_court_decision_date(self, petition_court_decision_date):
        """Sets the petition_court_decision_date of this InlineResponseDefault1AdminFines.


        :param petition_court_decision_date: The petition_court_decision_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: date
        """

        self._petition_court_decision_date = petition_court_decision_date

    @property
    def petition_court_filing_date(self):
        """Gets the petition_court_filing_date of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The petition_court_filing_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: date
        """
        return self._petition_court_filing_date

    @petition_court_filing_date.setter
    def petition_court_filing_date(self, petition_court_filing_date):
        """Sets the petition_court_filing_date of this InlineResponseDefault1AdminFines.


        :param petition_court_filing_date: The petition_court_filing_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: date
        """

        self._petition_court_filing_date = petition_court_filing_date

    @property
    def reason_to_believe_action_date(self):
        """Gets the reason_to_believe_action_date of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The reason_to_believe_action_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: date
        """
        return self._reason_to_believe_action_date

    @reason_to_believe_action_date.setter
    def reason_to_believe_action_date(self, reason_to_believe_action_date):
        """Sets the reason_to_believe_action_date of this InlineResponseDefault1AdminFines.


        :param reason_to_believe_action_date: The reason_to_believe_action_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: date
        """

        self._reason_to_believe_action_date = reason_to_believe_action_date

    @property
    def reason_to_believe_fine_amount(self):
        """Gets the reason_to_believe_fine_amount of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The reason_to_believe_fine_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: float
        """
        return self._reason_to_believe_fine_amount

    @reason_to_believe_fine_amount.setter
    def reason_to_believe_fine_amount(self, reason_to_believe_fine_amount):
        """Sets the reason_to_believe_fine_amount of this InlineResponseDefault1AdminFines.


        :param reason_to_believe_fine_amount: The reason_to_believe_fine_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: float
        """

        self._reason_to_believe_fine_amount = reason_to_believe_fine_amount

    @property
    def report_type(self):
        """Gets the report_type of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The report_type of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this InlineResponseDefault1AdminFines.


        :param report_type: The report_type of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The report_year of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this InlineResponseDefault1AdminFines.


        :param report_year: The report_year of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._report_year = report_year

    @property
    def treasury_referral_amount(self):
        """Gets the treasury_referral_amount of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The treasury_referral_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: float
        """
        return self._treasury_referral_amount

    @treasury_referral_amount.setter
    def treasury_referral_amount(self, treasury_referral_amount):
        """Sets the treasury_referral_amount of this InlineResponseDefault1AdminFines.


        :param treasury_referral_amount: The treasury_referral_amount of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: float
        """

        self._treasury_referral_amount = treasury_referral_amount

    @property
    def treasury_referral_date(self):
        """Gets the treasury_referral_date of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The treasury_referral_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: date
        """
        return self._treasury_referral_date

    @treasury_referral_date.setter
    def treasury_referral_date(self, treasury_referral_date):
        """Sets the treasury_referral_date of this InlineResponseDefault1AdminFines.


        :param treasury_referral_date: The treasury_referral_date of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: date
        """

        self._treasury_referral_date = treasury_referral_date

    @property
    def url(self):
        """Gets the url of this InlineResponseDefault1AdminFines.  # noqa: E501


        :return: The url of this InlineResponseDefault1AdminFines.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this InlineResponseDefault1AdminFines.


        :param url: The url of this InlineResponseDefault1AdminFines.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineResponseDefault1AdminFines):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineResponseDefault1AdminFines):
            return True

        return self.to_dict() != other.to_dict()
