# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class InlineResponseDefault1Documents1(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'category': 'str',
        'date': 'date',
        'description': 'str',
        'document_id': 'int',
        'url': 'str'
    }

    attribute_map = {
        'category': 'category',
        'date': 'date',
        'description': 'description',
        'document_id': 'document_id',
        'url': 'url'
    }

    def __init__(self, category=None, date=None, description=None, document_id=None, url=None, local_vars_configuration=None):  # noqa: E501
        """InlineResponseDefault1Documents1 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._category = None
        self._date = None
        self._description = None
        self._document_id = None
        self._url = None
        self.discriminator = None

        if category is not None:
            self.category = category
        if date is not None:
            self.date = date
        if description is not None:
            self.description = description
        if document_id is not None:
            self.document_id = document_id
        if url is not None:
            self.url = url

    @property
    def category(self):
        """Gets the category of this InlineResponseDefault1Documents1.  # noqa: E501


        :return: The category of this InlineResponseDefault1Documents1.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this InlineResponseDefault1Documents1.


        :param category: The category of this InlineResponseDefault1Documents1.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def date(self):
        """Gets the date of this InlineResponseDefault1Documents1.  # noqa: E501


        :return: The date of this InlineResponseDefault1Documents1.  # noqa: E501
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this InlineResponseDefault1Documents1.


        :param date: The date of this InlineResponseDefault1Documents1.  # noqa: E501
        :type: date
        """

        self._date = date

    @property
    def description(self):
        """Gets the description of this InlineResponseDefault1Documents1.  # noqa: E501


        :return: The description of this InlineResponseDefault1Documents1.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this InlineResponseDefault1Documents1.


        :param description: The description of this InlineResponseDefault1Documents1.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def document_id(self):
        """Gets the document_id of this InlineResponseDefault1Documents1.  # noqa: E501


        :return: The document_id of this InlineResponseDefault1Documents1.  # noqa: E501
        :rtype: int
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """Sets the document_id of this InlineResponseDefault1Documents1.


        :param document_id: The document_id of this InlineResponseDefault1Documents1.  # noqa: E501
        :type: int
        """

        self._document_id = document_id

    @property
    def url(self):
        """Gets the url of this InlineResponseDefault1Documents1.  # noqa: E501


        :return: The url of this InlineResponseDefault1Documents1.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this InlineResponseDefault1Documents1.


        :param url: The url of this InlineResponseDefault1Documents1.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineResponseDefault1Documents1):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineResponseDefault1Documents1):
            return True

        return self.to_dict() != other.to_dict()
