# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class InlineResponseDefault3Results(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_code': 'str',
        'action_code_full': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_full': 'str',
        'candidate_office_state': 'str',
        'candidate_office_state_full': 'str',
        'candidate_prefix': 'str',
        'candidate_suffix': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'cycle': 'int',
        'due_date_terms': 'str',
        'election_type': 'str',
        'election_type_full': 'str',
        'entity_type': 'str',
        'entity_type_full': 'str',
        'fec_committee_id': 'str',
        'fec_election_type_full': 'str',
        'fec_election_type_year': 'str',
        'file_number': 'int',
        'filing_form': 'str',
        'image_number': 'str',
        'incurred_date': 'date',
        'interest_rate_terms': 'str',
        'line_number': 'str',
        'link_id': 'int',
        'load_date': 'datetime',
        'loan_balance': 'float',
        'loan_source_city': 'str',
        'loan_source_first_name': 'str',
        'loan_source_last_name': 'str',
        'loan_source_middle_name': 'str',
        'loan_source_name': 'str',
        'loan_source_prefix': 'str',
        'loan_source_state': 'str',
        'loan_source_street_1': 'str',
        'loan_source_street_2': 'str',
        'loan_source_suffix': 'str',
        'loan_source_zip': 'int',
        'memo_code': 'str',
        'memo_text': 'str',
        'original_loan_amount': 'float',
        'original_sub_id': 'int',
        'payment_to_date': 'float',
        'pdf_url': 'str',
        'personally_funded': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_a_line_number': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'secured_ind': 'str',
        'sub_id': 'str',
        'transaction_id': 'str'
    }

    attribute_map = {
        'action_code': 'action_code',
        'action_code_full': 'action_code_full',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_full': 'candidate_office_full',
        'candidate_office_state': 'candidate_office_state',
        'candidate_office_state_full': 'candidate_office_state_full',
        'candidate_prefix': 'candidate_prefix',
        'candidate_suffix': 'candidate_suffix',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'cycle': 'cycle',
        'due_date_terms': 'due_date_terms',
        'election_type': 'election_type',
        'election_type_full': 'election_type_full',
        'entity_type': 'entity_type',
        'entity_type_full': 'entity_type_full',
        'fec_committee_id': 'fec_committee_id',
        'fec_election_type_full': 'fec_election_type_full',
        'fec_election_type_year': 'fec_election_type_year',
        'file_number': 'file_number',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'incurred_date': 'incurred_date',
        'interest_rate_terms': 'interest_rate_terms',
        'line_number': 'line_number',
        'link_id': 'link_id',
        'load_date': 'load_date',
        'loan_balance': 'loan_balance',
        'loan_source_city': 'loan_source_city',
        'loan_source_first_name': 'loan_source_first_name',
        'loan_source_last_name': 'loan_source_last_name',
        'loan_source_middle_name': 'loan_source_middle_name',
        'loan_source_name': 'loan_source_name',
        'loan_source_prefix': 'loan_source_prefix',
        'loan_source_state': 'loan_source_state',
        'loan_source_street_1': 'loan_source_street_1',
        'loan_source_street_2': 'loan_source_street_2',
        'loan_source_suffix': 'loan_source_suffix',
        'loan_source_zip': 'loan_source_zip',
        'memo_code': 'memo_code',
        'memo_text': 'memo_text',
        'original_loan_amount': 'original_loan_amount',
        'original_sub_id': 'original_sub_id',
        'payment_to_date': 'payment_to_date',
        'pdf_url': 'pdf_url',
        'personally_funded': 'personally_funded',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_a_line_number': 'schedule_a_line_number',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'secured_ind': 'secured_ind',
        'sub_id': 'sub_id',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, action_code=None, action_code_full=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_district=None, candidate_office_full=None, candidate_office_state=None, candidate_office_state_full=None, candidate_prefix=None, candidate_suffix=None, committee=None, committee_id=None, cycle=None, due_date_terms=None, election_type=None, election_type_full=None, entity_type=None, entity_type_full=None, fec_committee_id=None, fec_election_type_full=None, fec_election_type_year=None, file_number=None, filing_form=None, image_number=None, incurred_date=None, interest_rate_terms=None, line_number=None, link_id=None, load_date=None, loan_balance=None, loan_source_city=None, loan_source_first_name=None, loan_source_last_name=None, loan_source_middle_name=None, loan_source_name=None, loan_source_prefix=None, loan_source_state=None, loan_source_street_1=None, loan_source_street_2=None, loan_source_suffix=None, loan_source_zip=None, memo_code=None, memo_text=None, original_loan_amount=None, original_sub_id=None, payment_to_date=None, pdf_url=None, personally_funded=None, report_type=None, report_year=None, schedule_a_line_number=None, schedule_type=None, schedule_type_full=None, secured_ind=None, sub_id=None, transaction_id=None, local_vars_configuration=None):  # noqa: E501
        """InlineResponseDefault3Results - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_code = None
        self._action_code_full = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_full = None
        self._candidate_office_state = None
        self._candidate_office_state_full = None
        self._candidate_prefix = None
        self._candidate_suffix = None
        self._committee = None
        self._committee_id = None
        self._cycle = None
        self._due_date_terms = None
        self._election_type = None
        self._election_type_full = None
        self._entity_type = None
        self._entity_type_full = None
        self._fec_committee_id = None
        self._fec_election_type_full = None
        self._fec_election_type_year = None
        self._file_number = None
        self._filing_form = None
        self._image_number = None
        self._incurred_date = None
        self._interest_rate_terms = None
        self._line_number = None
        self._link_id = None
        self._load_date = None
        self._loan_balance = None
        self._loan_source_city = None
        self._loan_source_first_name = None
        self._loan_source_last_name = None
        self._loan_source_middle_name = None
        self._loan_source_name = None
        self._loan_source_prefix = None
        self._loan_source_state = None
        self._loan_source_street_1 = None
        self._loan_source_street_2 = None
        self._loan_source_suffix = None
        self._loan_source_zip = None
        self._memo_code = None
        self._memo_text = None
        self._original_loan_amount = None
        self._original_sub_id = None
        self._payment_to_date = None
        self._pdf_url = None
        self._personally_funded = None
        self._report_type = None
        self._report_year = None
        self._schedule_a_line_number = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._secured_ind = None
        self._sub_id = None
        self._transaction_id = None
        self.discriminator = None

        self.action_code = action_code
        self.action_code_full = action_code_full
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_full = candidate_office_full
        self.candidate_office_state = candidate_office_state
        self.candidate_office_state_full = candidate_office_state_full
        self.candidate_prefix = candidate_prefix
        self.candidate_suffix = candidate_suffix
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.cycle = cycle
        self.due_date_terms = due_date_terms
        self.election_type = election_type
        self.election_type_full = election_type_full
        self.entity_type = entity_type
        self.entity_type_full = entity_type_full
        self.fec_committee_id = fec_committee_id
        self.fec_election_type_full = fec_election_type_full
        self.fec_election_type_year = fec_election_type_year
        self.file_number = file_number
        self.filing_form = filing_form
        self.image_number = image_number
        self.incurred_date = incurred_date
        self.interest_rate_terms = interest_rate_terms
        self.line_number = line_number
        self.link_id = link_id
        self.load_date = load_date
        self.loan_balance = loan_balance
        self.loan_source_city = loan_source_city
        self.loan_source_first_name = loan_source_first_name
        self.loan_source_last_name = loan_source_last_name
        self.loan_source_middle_name = loan_source_middle_name
        self.loan_source_name = loan_source_name
        self.loan_source_prefix = loan_source_prefix
        self.loan_source_state = loan_source_state
        self.loan_source_street_1 = loan_source_street_1
        self.loan_source_street_2 = loan_source_street_2
        self.loan_source_suffix = loan_source_suffix
        self.loan_source_zip = loan_source_zip
        self.memo_code = memo_code
        self.memo_text = memo_text
        self.original_loan_amount = original_loan_amount
        self.original_sub_id = original_sub_id
        self.payment_to_date = payment_to_date
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.personally_funded = personally_funded
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_a_line_number = schedule_a_line_number
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        self.secured_ind = secured_ind
        if sub_id is not None:
            self.sub_id = sub_id
        self.transaction_id = transaction_id

    @property
    def action_code(self):
        """Gets the action_code of this InlineResponseDefault3Results.  # noqa: E501


        :return: The action_code of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._action_code

    @action_code.setter
    def action_code(self, action_code):
        """Sets the action_code of this InlineResponseDefault3Results.


        :param action_code: The action_code of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._action_code = action_code

    @property
    def action_code_full(self):
        """Gets the action_code_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The action_code_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._action_code_full

    @action_code_full.setter
    def action_code_full(self, action_code_full):
        """Sets the action_code_full of this InlineResponseDefault3Results.


        :param action_code_full: The action_code_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._action_code_full = action_code_full

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_first_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this InlineResponseDefault3Results.


        :param candidate_first_name: The candidate_first_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this InlineResponseDefault3Results.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this InlineResponseDefault3Results.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_last_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this InlineResponseDefault3Results.


        :param candidate_last_name: The candidate_last_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_middle_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this InlineResponseDefault3Results.


        :param candidate_middle_name: The candidate_middle_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this InlineResponseDefault3Results.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this InlineResponseDefault3Results.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_office of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this InlineResponseDefault3Results.


        :param candidate_office: The candidate_office of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this InlineResponseDefault3Results.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The candidate_office_district of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this InlineResponseDefault3Results.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param candidate_office_district: The candidate_office_district of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_full(self):
        """Gets the candidate_office_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_office_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_full

    @candidate_office_full.setter
    def candidate_office_full(self, candidate_office_full):
        """Sets the candidate_office_full of this InlineResponseDefault3Results.


        :param candidate_office_full: The candidate_office_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_full = candidate_office_full

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_office_state of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this InlineResponseDefault3Results.


        :param candidate_office_state: The candidate_office_state of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_office_state_full(self):
        """Gets the candidate_office_state_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_office_state_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state_full

    @candidate_office_state_full.setter
    def candidate_office_state_full(self, candidate_office_state_full):
        """Sets the candidate_office_state_full of this InlineResponseDefault3Results.


        :param candidate_office_state_full: The candidate_office_state_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_state_full = candidate_office_state_full

    @property
    def candidate_prefix(self):
        """Gets the candidate_prefix of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_prefix of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_prefix

    @candidate_prefix.setter
    def candidate_prefix(self, candidate_prefix):
        """Sets the candidate_prefix of this InlineResponseDefault3Results.


        :param candidate_prefix: The candidate_prefix of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_prefix = candidate_prefix

    @property
    def candidate_suffix(self):
        """Gets the candidate_suffix of this InlineResponseDefault3Results.  # noqa: E501


        :return: The candidate_suffix of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_suffix

    @candidate_suffix.setter
    def candidate_suffix(self, candidate_suffix):
        """Sets the candidate_suffix of this InlineResponseDefault3Results.


        :param candidate_suffix: The candidate_suffix of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._candidate_suffix = candidate_suffix

    @property
    def committee(self):
        """Gets the committee of this InlineResponseDefault3Results.  # noqa: E501


        :return: The committee of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this InlineResponseDefault3Results.


        :param committee: The committee of this InlineResponseDefault3Results.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this InlineResponseDefault3Results.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this InlineResponseDefault3Results.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def cycle(self):
        """Gets the cycle of this InlineResponseDefault3Results.  # noqa: E501


        :return: The cycle of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this InlineResponseDefault3Results.


        :param cycle: The cycle of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def due_date_terms(self):
        """Gets the due_date_terms of this InlineResponseDefault3Results.  # noqa: E501


        :return: The due_date_terms of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._due_date_terms

    @due_date_terms.setter
    def due_date_terms(self, due_date_terms):
        """Sets the due_date_terms of this InlineResponseDefault3Results.


        :param due_date_terms: The due_date_terms of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._due_date_terms = due_date_terms

    @property
    def election_type(self):
        """Gets the election_type of this InlineResponseDefault3Results.  # noqa: E501


        :return: The election_type of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._election_type

    @election_type.setter
    def election_type(self, election_type):
        """Sets the election_type of this InlineResponseDefault3Results.


        :param election_type: The election_type of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._election_type = election_type

    @property
    def election_type_full(self):
        """Gets the election_type_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The election_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._election_type_full

    @election_type_full.setter
    def election_type_full(self, election_type_full):
        """Sets the election_type_full of this InlineResponseDefault3Results.


        :param election_type_full: The election_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._election_type_full = election_type_full

    @property
    def entity_type(self):
        """Gets the entity_type of this InlineResponseDefault3Results.  # noqa: E501


        :return: The entity_type of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this InlineResponseDefault3Results.


        :param entity_type: The entity_type of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def entity_type_full(self):
        """Gets the entity_type_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The entity_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._entity_type_full

    @entity_type_full.setter
    def entity_type_full(self, entity_type_full):
        """Sets the entity_type_full of this InlineResponseDefault3Results.


        :param entity_type_full: The entity_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._entity_type_full = entity_type_full

    @property
    def fec_committee_id(self):
        """Gets the fec_committee_id of this InlineResponseDefault3Results.  # noqa: E501


        :return: The fec_committee_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._fec_committee_id

    @fec_committee_id.setter
    def fec_committee_id(self, fec_committee_id):
        """Sets the fec_committee_id of this InlineResponseDefault3Results.


        :param fec_committee_id: The fec_committee_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._fec_committee_id = fec_committee_id

    @property
    def fec_election_type_full(self):
        """Gets the fec_election_type_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The fec_election_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_type_full

    @fec_election_type_full.setter
    def fec_election_type_full(self, fec_election_type_full):
        """Sets the fec_election_type_full of this InlineResponseDefault3Results.


        :param fec_election_type_full: The fec_election_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._fec_election_type_full = fec_election_type_full

    @property
    def fec_election_type_year(self):
        """Gets the fec_election_type_year of this InlineResponseDefault3Results.  # noqa: E501


        :return: The fec_election_type_year of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_type_year

    @fec_election_type_year.setter
    def fec_election_type_year(self, fec_election_type_year):
        """Sets the fec_election_type_year of this InlineResponseDefault3Results.


        :param fec_election_type_year: The fec_election_type_year of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._fec_election_type_year = fec_election_type_year

    @property
    def file_number(self):
        """Gets the file_number of this InlineResponseDefault3Results.  # noqa: E501


        :return: The file_number of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this InlineResponseDefault3Results.


        :param file_number: The file_number of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filing_form(self):
        """Gets the filing_form of this InlineResponseDefault3Results.  # noqa: E501


        :return: The filing_form of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this InlineResponseDefault3Results.


        :param filing_form: The filing_form of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this InlineResponseDefault3Results.  # noqa: E501

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :return: The image_number of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this InlineResponseDefault3Results.

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :param image_number: The image_number of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def incurred_date(self):
        """Gets the incurred_date of this InlineResponseDefault3Results.  # noqa: E501


        :return: The incurred_date of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: date
        """
        return self._incurred_date

    @incurred_date.setter
    def incurred_date(self, incurred_date):
        """Sets the incurred_date of this InlineResponseDefault3Results.


        :param incurred_date: The incurred_date of this InlineResponseDefault3Results.  # noqa: E501
        :type: date
        """

        self._incurred_date = incurred_date

    @property
    def interest_rate_terms(self):
        """Gets the interest_rate_terms of this InlineResponseDefault3Results.  # noqa: E501


        :return: The interest_rate_terms of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._interest_rate_terms

    @interest_rate_terms.setter
    def interest_rate_terms(self, interest_rate_terms):
        """Sets the interest_rate_terms of this InlineResponseDefault3Results.


        :param interest_rate_terms: The interest_rate_terms of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._interest_rate_terms = interest_rate_terms

    @property
    def line_number(self):
        """Gets the line_number of this InlineResponseDefault3Results.  # noqa: E501


        :return: The line_number of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this InlineResponseDefault3Results.


        :param line_number: The line_number of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def link_id(self):
        """Gets the link_id of this InlineResponseDefault3Results.  # noqa: E501


        :return: The link_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this InlineResponseDefault3Results.


        :param link_id: The link_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def load_date(self):
        """Gets the load_date of this InlineResponseDefault3Results.  # noqa: E501


        :return: The load_date of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: datetime
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this InlineResponseDefault3Results.


        :param load_date: The load_date of this InlineResponseDefault3Results.  # noqa: E501
        :type: datetime
        """

        self._load_date = load_date

    @property
    def loan_balance(self):
        """Gets the loan_balance of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_balance of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: float
        """
        return self._loan_balance

    @loan_balance.setter
    def loan_balance(self, loan_balance):
        """Sets the loan_balance of this InlineResponseDefault3Results.


        :param loan_balance: The loan_balance of this InlineResponseDefault3Results.  # noqa: E501
        :type: float
        """

        self._loan_balance = loan_balance

    @property
    def loan_source_city(self):
        """Gets the loan_source_city of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_city of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_city

    @loan_source_city.setter
    def loan_source_city(self, loan_source_city):
        """Sets the loan_source_city of this InlineResponseDefault3Results.


        :param loan_source_city: The loan_source_city of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_city = loan_source_city

    @property
    def loan_source_first_name(self):
        """Gets the loan_source_first_name of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_first_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_first_name

    @loan_source_first_name.setter
    def loan_source_first_name(self, loan_source_first_name):
        """Sets the loan_source_first_name of this InlineResponseDefault3Results.


        :param loan_source_first_name: The loan_source_first_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_first_name = loan_source_first_name

    @property
    def loan_source_last_name(self):
        """Gets the loan_source_last_name of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_last_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_last_name

    @loan_source_last_name.setter
    def loan_source_last_name(self, loan_source_last_name):
        """Sets the loan_source_last_name of this InlineResponseDefault3Results.


        :param loan_source_last_name: The loan_source_last_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_last_name = loan_source_last_name

    @property
    def loan_source_middle_name(self):
        """Gets the loan_source_middle_name of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_middle_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_middle_name

    @loan_source_middle_name.setter
    def loan_source_middle_name(self, loan_source_middle_name):
        """Sets the loan_source_middle_name of this InlineResponseDefault3Results.


        :param loan_source_middle_name: The loan_source_middle_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_middle_name = loan_source_middle_name

    @property
    def loan_source_name(self):
        """Gets the loan_source_name of this InlineResponseDefault3Results.  # noqa: E501

        Source of the loan (i.e., bank loan, brokerage account, credit card, home equity line of credit,               other line of credit, or personal funds of the candidate  # noqa: E501

        :return: The loan_source_name of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_name

    @loan_source_name.setter
    def loan_source_name(self, loan_source_name):
        """Sets the loan_source_name of this InlineResponseDefault3Results.

        Source of the loan (i.e., bank loan, brokerage account, credit card, home equity line of credit,               other line of credit, or personal funds of the candidate  # noqa: E501

        :param loan_source_name: The loan_source_name of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_name = loan_source_name

    @property
    def loan_source_prefix(self):
        """Gets the loan_source_prefix of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_prefix of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_prefix

    @loan_source_prefix.setter
    def loan_source_prefix(self, loan_source_prefix):
        """Sets the loan_source_prefix of this InlineResponseDefault3Results.


        :param loan_source_prefix: The loan_source_prefix of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_prefix = loan_source_prefix

    @property
    def loan_source_state(self):
        """Gets the loan_source_state of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_state of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_state

    @loan_source_state.setter
    def loan_source_state(self, loan_source_state):
        """Sets the loan_source_state of this InlineResponseDefault3Results.


        :param loan_source_state: The loan_source_state of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_state = loan_source_state

    @property
    def loan_source_street_1(self):
        """Gets the loan_source_street_1 of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_street_1 of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_street_1

    @loan_source_street_1.setter
    def loan_source_street_1(self, loan_source_street_1):
        """Sets the loan_source_street_1 of this InlineResponseDefault3Results.


        :param loan_source_street_1: The loan_source_street_1 of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_street_1 = loan_source_street_1

    @property
    def loan_source_street_2(self):
        """Gets the loan_source_street_2 of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_street_2 of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_street_2

    @loan_source_street_2.setter
    def loan_source_street_2(self, loan_source_street_2):
        """Sets the loan_source_street_2 of this InlineResponseDefault3Results.


        :param loan_source_street_2: The loan_source_street_2 of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_street_2 = loan_source_street_2

    @property
    def loan_source_suffix(self):
        """Gets the loan_source_suffix of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_suffix of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._loan_source_suffix

    @loan_source_suffix.setter
    def loan_source_suffix(self, loan_source_suffix):
        """Sets the loan_source_suffix of this InlineResponseDefault3Results.


        :param loan_source_suffix: The loan_source_suffix of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._loan_source_suffix = loan_source_suffix

    @property
    def loan_source_zip(self):
        """Gets the loan_source_zip of this InlineResponseDefault3Results.  # noqa: E501


        :return: The loan_source_zip of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._loan_source_zip

    @loan_source_zip.setter
    def loan_source_zip(self, loan_source_zip):
        """Sets the loan_source_zip of this InlineResponseDefault3Results.


        :param loan_source_zip: The loan_source_zip of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._loan_source_zip = loan_source_zip

    @property
    def memo_code(self):
        """Gets the memo_code of this InlineResponseDefault3Results.  # noqa: E501


        :return: The memo_code of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this InlineResponseDefault3Results.


        :param memo_code: The memo_code of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_text(self):
        """Gets the memo_text of this InlineResponseDefault3Results.  # noqa: E501


        :return: The memo_text of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this InlineResponseDefault3Results.


        :param memo_text: The memo_text of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def original_loan_amount(self):
        """Gets the original_loan_amount of this InlineResponseDefault3Results.  # noqa: E501


        :return: The original_loan_amount of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: float
        """
        return self._original_loan_amount

    @original_loan_amount.setter
    def original_loan_amount(self, original_loan_amount):
        """Sets the original_loan_amount of this InlineResponseDefault3Results.


        :param original_loan_amount: The original_loan_amount of this InlineResponseDefault3Results.  # noqa: E501
        :type: float
        """

        self._original_loan_amount = original_loan_amount

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this InlineResponseDefault3Results.  # noqa: E501


        :return: The original_sub_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this InlineResponseDefault3Results.


        :param original_sub_id: The original_sub_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._original_sub_id = original_sub_id

    @property
    def payment_to_date(self):
        """Gets the payment_to_date of this InlineResponseDefault3Results.  # noqa: E501


        :return: The payment_to_date of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: float
        """
        return self._payment_to_date

    @payment_to_date.setter
    def payment_to_date(self, payment_to_date):
        """Sets the payment_to_date of this InlineResponseDefault3Results.


        :param payment_to_date: The payment_to_date of this InlineResponseDefault3Results.  # noqa: E501
        :type: float
        """

        self._payment_to_date = payment_to_date

    @property
    def pdf_url(self):
        """Gets the pdf_url of this InlineResponseDefault3Results.  # noqa: E501


        :return: The pdf_url of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this InlineResponseDefault3Results.


        :param pdf_url: The pdf_url of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def personally_funded(self):
        """Gets the personally_funded of this InlineResponseDefault3Results.  # noqa: E501


        :return: The personally_funded of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._personally_funded

    @personally_funded.setter
    def personally_funded(self, personally_funded):
        """Sets the personally_funded of this InlineResponseDefault3Results.


        :param personally_funded: The personally_funded of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._personally_funded = personally_funded

    @property
    def report_type(self):
        """Gets the report_type of this InlineResponseDefault3Results.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this InlineResponseDefault3Results.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this InlineResponseDefault3Results.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this InlineResponseDefault3Results.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_a_line_number(self):
        """Gets the schedule_a_line_number of this InlineResponseDefault3Results.  # noqa: E501


        :return: The schedule_a_line_number of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: int
        """
        return self._schedule_a_line_number

    @schedule_a_line_number.setter
    def schedule_a_line_number(self, schedule_a_line_number):
        """Sets the schedule_a_line_number of this InlineResponseDefault3Results.


        :param schedule_a_line_number: The schedule_a_line_number of this InlineResponseDefault3Results.  # noqa: E501
        :type: int
        """

        self._schedule_a_line_number = schedule_a_line_number

    @property
    def schedule_type(self):
        """Gets the schedule_type of this InlineResponseDefault3Results.  # noqa: E501


        :return: The schedule_type of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this InlineResponseDefault3Results.


        :param schedule_type: The schedule_type of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this InlineResponseDefault3Results.  # noqa: E501


        :return: The schedule_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this InlineResponseDefault3Results.


        :param schedule_type_full: The schedule_type_full of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def secured_ind(self):
        """Gets the secured_ind of this InlineResponseDefault3Results.  # noqa: E501


        :return: The secured_ind of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._secured_ind

    @secured_ind.setter
    def secured_ind(self, secured_ind):
        """Sets the secured_ind of this InlineResponseDefault3Results.


        :param secured_ind: The secured_ind of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._secured_ind = secured_ind

    @property
    def sub_id(self):
        """Gets the sub_id of this InlineResponseDefault3Results.  # noqa: E501


        :return: The sub_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this InlineResponseDefault3Results.


        :param sub_id: The sub_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def transaction_id(self):
        """Gets the transaction_id of this InlineResponseDefault3Results.  # noqa: E501


        :return: The transaction_id of this InlineResponseDefault3Results.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this InlineResponseDefault3Results.


        :param transaction_id: The transaction_id of this InlineResponseDefault3Results.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineResponseDefault3Results):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineResponseDefault3Results):
            return True

        return self.to_dict() != other.to_dict()
