# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class InlineResponseDefault4Results(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_code': 'str',
        'action_code_full': 'str',
        'amount_incurred_period': 'float',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_state': 'str',
        'candidate_office_state_full': 'str',
        'canidate_name': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'committee_name': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_id': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'creditor_debtor_city': 'str',
        'creditor_debtor_first_name': 'str',
        'creditor_debtor_id': 'str',
        'creditor_debtor_last_name': 'str',
        'creditor_debtor_middle_name': 'str',
        'creditor_debtor_name': 'str',
        'creditor_debtor_prefix': 'str',
        'creditor_debtor_state': 'str',
        'creditor_debtor_street1': 'str',
        'creditor_debtor_street2': 'str',
        'creditor_debtor_suffix': 'str',
        'election_cycle': 'int',
        'entity_type': 'str',
        'file_number': 'int',
        'filing_form': 'str',
        'image_number': 'str',
        'line_number': 'str',
        'link_id': 'int',
        'load_date': 'date',
        'nature_of_debt': 'str',
        'original_sub_id': 'int',
        'outstanding_balance_beginning_of_period': 'float',
        'outstanding_balance_close_of_period': 'float',
        'payment_period': 'float',
        'pdf_url': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'sub_id': 'str',
        'transaction_id': 'str'
    }

    attribute_map = {
        'action_code': 'action_code',
        'action_code_full': 'action_code_full',
        'amount_incurred_period': 'amount_incurred_period',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_state': 'candidate_office_state',
        'candidate_office_state_full': 'candidate_office_state_full',
        'canidate_name': 'canidate_name',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_id': 'conduit_committee_id',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'creditor_debtor_city': 'creditor_debtor_city',
        'creditor_debtor_first_name': 'creditor_debtor_first_name',
        'creditor_debtor_id': 'creditor_debtor_id',
        'creditor_debtor_last_name': 'creditor_debtor_last_name',
        'creditor_debtor_middle_name': 'creditor_debtor_middle_name',
        'creditor_debtor_name': 'creditor_debtor_name',
        'creditor_debtor_prefix': 'creditor_debtor_prefix',
        'creditor_debtor_state': 'creditor_debtor_state',
        'creditor_debtor_street1': 'creditor_debtor_street1',
        'creditor_debtor_street2': 'creditor_debtor_street2',
        'creditor_debtor_suffix': 'creditor_debtor_suffix',
        'election_cycle': 'election_cycle',
        'entity_type': 'entity_type',
        'file_number': 'file_number',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'line_number': 'line_number',
        'link_id': 'link_id',
        'load_date': 'load_date',
        'nature_of_debt': 'nature_of_debt',
        'original_sub_id': 'original_sub_id',
        'outstanding_balance_beginning_of_period': 'outstanding_balance_beginning_of_period',
        'outstanding_balance_close_of_period': 'outstanding_balance_close_of_period',
        'payment_period': 'payment_period',
        'pdf_url': 'pdf_url',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'sub_id': 'sub_id',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, action_code=None, action_code_full=None, amount_incurred_period=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_office=None, candidate_office_district=None, candidate_office_state=None, candidate_office_state_full=None, canidate_name=None, committee=None, committee_id=None, committee_name=None, conduit_committee_city=None, conduit_committee_id=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, creditor_debtor_city=None, creditor_debtor_first_name=None, creditor_debtor_id=None, creditor_debtor_last_name=None, creditor_debtor_middle_name=None, creditor_debtor_name=None, creditor_debtor_prefix=None, creditor_debtor_state=None, creditor_debtor_street1=None, creditor_debtor_street2=None, creditor_debtor_suffix=None, election_cycle=None, entity_type=None, file_number=None, filing_form=None, image_number=None, line_number=None, link_id=None, load_date=None, nature_of_debt=None, original_sub_id=None, outstanding_balance_beginning_of_period=None, outstanding_balance_close_of_period=None, payment_period=None, pdf_url=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, sub_id=None, transaction_id=None, local_vars_configuration=None):  # noqa: E501
        """InlineResponseDefault4Results - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_code = None
        self._action_code_full = None
        self._amount_incurred_period = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_state = None
        self._candidate_office_state_full = None
        self._canidate_name = None
        self._committee = None
        self._committee_id = None
        self._committee_name = None
        self._conduit_committee_city = None
        self._conduit_committee_id = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._creditor_debtor_city = None
        self._creditor_debtor_first_name = None
        self._creditor_debtor_id = None
        self._creditor_debtor_last_name = None
        self._creditor_debtor_middle_name = None
        self._creditor_debtor_name = None
        self._creditor_debtor_prefix = None
        self._creditor_debtor_state = None
        self._creditor_debtor_street1 = None
        self._creditor_debtor_street2 = None
        self._creditor_debtor_suffix = None
        self._election_cycle = None
        self._entity_type = None
        self._file_number = None
        self._filing_form = None
        self._image_number = None
        self._line_number = None
        self._link_id = None
        self._load_date = None
        self._nature_of_debt = None
        self._original_sub_id = None
        self._outstanding_balance_beginning_of_period = None
        self._outstanding_balance_close_of_period = None
        self._payment_period = None
        self._pdf_url = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._sub_id = None
        self._transaction_id = None
        self.discriminator = None

        self.action_code = action_code
        self.action_code_full = action_code_full
        self.amount_incurred_period = amount_incurred_period
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_state = candidate_office_state
        self.candidate_office_state_full = candidate_office_state_full
        self.canidate_name = canidate_name
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_id = conduit_committee_id
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        self.creditor_debtor_city = creditor_debtor_city
        self.creditor_debtor_first_name = creditor_debtor_first_name
        self.creditor_debtor_id = creditor_debtor_id
        self.creditor_debtor_last_name = creditor_debtor_last_name
        self.creditor_debtor_middle_name = creditor_debtor_middle_name
        self.creditor_debtor_name = creditor_debtor_name
        self.creditor_debtor_prefix = creditor_debtor_prefix
        self.creditor_debtor_state = creditor_debtor_state
        self.creditor_debtor_street1 = creditor_debtor_street1
        self.creditor_debtor_street2 = creditor_debtor_street2
        self.creditor_debtor_suffix = creditor_debtor_suffix
        self.election_cycle = election_cycle
        self.entity_type = entity_type
        self.file_number = file_number
        self.filing_form = filing_form
        self.image_number = image_number
        self.line_number = line_number
        self.link_id = link_id
        self.load_date = load_date
        self.nature_of_debt = nature_of_debt
        self.original_sub_id = original_sub_id
        self.outstanding_balance_beginning_of_period = outstanding_balance_beginning_of_period
        self.outstanding_balance_close_of_period = outstanding_balance_close_of_period
        self.payment_period = payment_period
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        if sub_id is not None:
            self.sub_id = sub_id
        self.transaction_id = transaction_id

    @property
    def action_code(self):
        """Gets the action_code of this InlineResponseDefault4Results.  # noqa: E501


        :return: The action_code of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._action_code

    @action_code.setter
    def action_code(self, action_code):
        """Sets the action_code of this InlineResponseDefault4Results.


        :param action_code: The action_code of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._action_code = action_code

    @property
    def action_code_full(self):
        """Gets the action_code_full of this InlineResponseDefault4Results.  # noqa: E501


        :return: The action_code_full of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._action_code_full

    @action_code_full.setter
    def action_code_full(self, action_code_full):
        """Sets the action_code_full of this InlineResponseDefault4Results.


        :param action_code_full: The action_code_full of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._action_code_full = action_code_full

    @property
    def amount_incurred_period(self):
        """Gets the amount_incurred_period of this InlineResponseDefault4Results.  # noqa: E501


        :return: The amount_incurred_period of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: float
        """
        return self._amount_incurred_period

    @amount_incurred_period.setter
    def amount_incurred_period(self, amount_incurred_period):
        """Sets the amount_incurred_period of this InlineResponseDefault4Results.


        :param amount_incurred_period: The amount_incurred_period of this InlineResponseDefault4Results.  # noqa: E501
        :type: float
        """

        self._amount_incurred_period = amount_incurred_period

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The candidate_first_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this InlineResponseDefault4Results.


        :param candidate_first_name: The candidate_first_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this InlineResponseDefault4Results.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this InlineResponseDefault4Results.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The candidate_last_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this InlineResponseDefault4Results.


        :param candidate_last_name: The candidate_last_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this InlineResponseDefault4Results.  # noqa: E501


        :return: The candidate_office of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this InlineResponseDefault4Results.


        :param candidate_office: The candidate_office of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this InlineResponseDefault4Results.  # noqa: E501


        :return: The candidate_office_district of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this InlineResponseDefault4Results.


        :param candidate_office_district: The candidate_office_district of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this InlineResponseDefault4Results.  # noqa: E501


        :return: The candidate_office_state of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this InlineResponseDefault4Results.


        :param candidate_office_state: The candidate_office_state of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_office_state_full(self):
        """Gets the candidate_office_state_full of this InlineResponseDefault4Results.  # noqa: E501


        :return: The candidate_office_state_full of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state_full

    @candidate_office_state_full.setter
    def candidate_office_state_full(self, candidate_office_state_full):
        """Sets the candidate_office_state_full of this InlineResponseDefault4Results.


        :param candidate_office_state_full: The candidate_office_state_full of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_state_full = candidate_office_state_full

    @property
    def canidate_name(self):
        """Gets the canidate_name of this InlineResponseDefault4Results.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The canidate_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._canidate_name

    @canidate_name.setter
    def canidate_name(self, canidate_name):
        """Sets the canidate_name of this InlineResponseDefault4Results.

        Name of candidate running for office  # noqa: E501

        :param canidate_name: The canidate_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._canidate_name = canidate_name

    @property
    def committee(self):
        """Gets the committee of this InlineResponseDefault4Results.  # noqa: E501


        :return: The committee of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this InlineResponseDefault4Results.


        :param committee: The committee of this InlineResponseDefault4Results.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this InlineResponseDefault4Results.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this InlineResponseDefault4Results.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this InlineResponseDefault4Results.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this InlineResponseDefault4Results.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_city of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this InlineResponseDefault4Results.


        :param conduit_committee_city: The conduit_committee_city of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_id(self):
        """Gets the conduit_committee_id of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_id

    @conduit_committee_id.setter
    def conduit_committee_id(self, conduit_committee_id):
        """Sets the conduit_committee_id of this InlineResponseDefault4Results.


        :param conduit_committee_id: The conduit_committee_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_id = conduit_committee_id

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this InlineResponseDefault4Results.


        :param conduit_committee_name: The conduit_committee_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_state of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this InlineResponseDefault4Results.


        :param conduit_committee_state: The conduit_committee_state of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_street1 of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this InlineResponseDefault4Results.


        :param conduit_committee_street1: The conduit_committee_street1 of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_street2 of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this InlineResponseDefault4Results.


        :param conduit_committee_street2: The conduit_committee_street2 of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this InlineResponseDefault4Results.  # noqa: E501


        :return: The conduit_committee_zip of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this InlineResponseDefault4Results.


        :param conduit_committee_zip: The conduit_committee_zip of this InlineResponseDefault4Results.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def creditor_debtor_city(self):
        """Gets the creditor_debtor_city of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_city of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_city

    @creditor_debtor_city.setter
    def creditor_debtor_city(self, creditor_debtor_city):
        """Sets the creditor_debtor_city of this InlineResponseDefault4Results.


        :param creditor_debtor_city: The creditor_debtor_city of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_city = creditor_debtor_city

    @property
    def creditor_debtor_first_name(self):
        """Gets the creditor_debtor_first_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_first_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_first_name

    @creditor_debtor_first_name.setter
    def creditor_debtor_first_name(self, creditor_debtor_first_name):
        """Sets the creditor_debtor_first_name of this InlineResponseDefault4Results.


        :param creditor_debtor_first_name: The creditor_debtor_first_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_first_name = creditor_debtor_first_name

    @property
    def creditor_debtor_id(self):
        """Gets the creditor_debtor_id of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_id

    @creditor_debtor_id.setter
    def creditor_debtor_id(self, creditor_debtor_id):
        """Sets the creditor_debtor_id of this InlineResponseDefault4Results.


        :param creditor_debtor_id: The creditor_debtor_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_id = creditor_debtor_id

    @property
    def creditor_debtor_last_name(self):
        """Gets the creditor_debtor_last_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_last_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_last_name

    @creditor_debtor_last_name.setter
    def creditor_debtor_last_name(self, creditor_debtor_last_name):
        """Sets the creditor_debtor_last_name of this InlineResponseDefault4Results.


        :param creditor_debtor_last_name: The creditor_debtor_last_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_last_name = creditor_debtor_last_name

    @property
    def creditor_debtor_middle_name(self):
        """Gets the creditor_debtor_middle_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_middle_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_middle_name

    @creditor_debtor_middle_name.setter
    def creditor_debtor_middle_name(self, creditor_debtor_middle_name):
        """Sets the creditor_debtor_middle_name of this InlineResponseDefault4Results.


        :param creditor_debtor_middle_name: The creditor_debtor_middle_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_middle_name = creditor_debtor_middle_name

    @property
    def creditor_debtor_name(self):
        """Gets the creditor_debtor_name of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_name of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_name

    @creditor_debtor_name.setter
    def creditor_debtor_name(self, creditor_debtor_name):
        """Sets the creditor_debtor_name of this InlineResponseDefault4Results.


        :param creditor_debtor_name: The creditor_debtor_name of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_name = creditor_debtor_name

    @property
    def creditor_debtor_prefix(self):
        """Gets the creditor_debtor_prefix of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_prefix of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_prefix

    @creditor_debtor_prefix.setter
    def creditor_debtor_prefix(self, creditor_debtor_prefix):
        """Sets the creditor_debtor_prefix of this InlineResponseDefault4Results.


        :param creditor_debtor_prefix: The creditor_debtor_prefix of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_prefix = creditor_debtor_prefix

    @property
    def creditor_debtor_state(self):
        """Gets the creditor_debtor_state of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_state of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_state

    @creditor_debtor_state.setter
    def creditor_debtor_state(self, creditor_debtor_state):
        """Sets the creditor_debtor_state of this InlineResponseDefault4Results.


        :param creditor_debtor_state: The creditor_debtor_state of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_state = creditor_debtor_state

    @property
    def creditor_debtor_street1(self):
        """Gets the creditor_debtor_street1 of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_street1 of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_street1

    @creditor_debtor_street1.setter
    def creditor_debtor_street1(self, creditor_debtor_street1):
        """Sets the creditor_debtor_street1 of this InlineResponseDefault4Results.


        :param creditor_debtor_street1: The creditor_debtor_street1 of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_street1 = creditor_debtor_street1

    @property
    def creditor_debtor_street2(self):
        """Gets the creditor_debtor_street2 of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_street2 of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_street2

    @creditor_debtor_street2.setter
    def creditor_debtor_street2(self, creditor_debtor_street2):
        """Sets the creditor_debtor_street2 of this InlineResponseDefault4Results.


        :param creditor_debtor_street2: The creditor_debtor_street2 of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_street2 = creditor_debtor_street2

    @property
    def creditor_debtor_suffix(self):
        """Gets the creditor_debtor_suffix of this InlineResponseDefault4Results.  # noqa: E501


        :return: The creditor_debtor_suffix of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._creditor_debtor_suffix

    @creditor_debtor_suffix.setter
    def creditor_debtor_suffix(self, creditor_debtor_suffix):
        """Sets the creditor_debtor_suffix of this InlineResponseDefault4Results.


        :param creditor_debtor_suffix: The creditor_debtor_suffix of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._creditor_debtor_suffix = creditor_debtor_suffix

    @property
    def election_cycle(self):
        """Gets the election_cycle of this InlineResponseDefault4Results.  # noqa: E501


        :return: The election_cycle of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: int
        """
        return self._election_cycle

    @election_cycle.setter
    def election_cycle(self, election_cycle):
        """Sets the election_cycle of this InlineResponseDefault4Results.


        :param election_cycle: The election_cycle of this InlineResponseDefault4Results.  # noqa: E501
        :type: int
        """

        self._election_cycle = election_cycle

    @property
    def entity_type(self):
        """Gets the entity_type of this InlineResponseDefault4Results.  # noqa: E501


        :return: The entity_type of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this InlineResponseDefault4Results.


        :param entity_type: The entity_type of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def file_number(self):
        """Gets the file_number of this InlineResponseDefault4Results.  # noqa: E501


        :return: The file_number of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this InlineResponseDefault4Results.


        :param file_number: The file_number of this InlineResponseDefault4Results.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filing_form(self):
        """Gets the filing_form of this InlineResponseDefault4Results.  # noqa: E501


        :return: The filing_form of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this InlineResponseDefault4Results.


        :param filing_form: The filing_form of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this InlineResponseDefault4Results.  # noqa: E501

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :return: The image_number of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this InlineResponseDefault4Results.

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :param image_number: The image_number of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def line_number(self):
        """Gets the line_number of this InlineResponseDefault4Results.  # noqa: E501


        :return: The line_number of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this InlineResponseDefault4Results.


        :param line_number: The line_number of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def link_id(self):
        """Gets the link_id of this InlineResponseDefault4Results.  # noqa: E501


        :return: The link_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this InlineResponseDefault4Results.


        :param link_id: The link_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def load_date(self):
        """Gets the load_date of this InlineResponseDefault4Results.  # noqa: E501


        :return: The load_date of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: date
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this InlineResponseDefault4Results.


        :param load_date: The load_date of this InlineResponseDefault4Results.  # noqa: E501
        :type: date
        """

        self._load_date = load_date

    @property
    def nature_of_debt(self):
        """Gets the nature_of_debt of this InlineResponseDefault4Results.  # noqa: E501


        :return: The nature_of_debt of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._nature_of_debt

    @nature_of_debt.setter
    def nature_of_debt(self, nature_of_debt):
        """Sets the nature_of_debt of this InlineResponseDefault4Results.


        :param nature_of_debt: The nature_of_debt of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._nature_of_debt = nature_of_debt

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this InlineResponseDefault4Results.  # noqa: E501


        :return: The original_sub_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: int
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this InlineResponseDefault4Results.


        :param original_sub_id: The original_sub_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: int
        """

        self._original_sub_id = original_sub_id

    @property
    def outstanding_balance_beginning_of_period(self):
        """Gets the outstanding_balance_beginning_of_period of this InlineResponseDefault4Results.  # noqa: E501


        :return: The outstanding_balance_beginning_of_period of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: float
        """
        return self._outstanding_balance_beginning_of_period

    @outstanding_balance_beginning_of_period.setter
    def outstanding_balance_beginning_of_period(self, outstanding_balance_beginning_of_period):
        """Sets the outstanding_balance_beginning_of_period of this InlineResponseDefault4Results.


        :param outstanding_balance_beginning_of_period: The outstanding_balance_beginning_of_period of this InlineResponseDefault4Results.  # noqa: E501
        :type: float
        """

        self._outstanding_balance_beginning_of_period = outstanding_balance_beginning_of_period

    @property
    def outstanding_balance_close_of_period(self):
        """Gets the outstanding_balance_close_of_period of this InlineResponseDefault4Results.  # noqa: E501


        :return: The outstanding_balance_close_of_period of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: float
        """
        return self._outstanding_balance_close_of_period

    @outstanding_balance_close_of_period.setter
    def outstanding_balance_close_of_period(self, outstanding_balance_close_of_period):
        """Sets the outstanding_balance_close_of_period of this InlineResponseDefault4Results.


        :param outstanding_balance_close_of_period: The outstanding_balance_close_of_period of this InlineResponseDefault4Results.  # noqa: E501
        :type: float
        """

        self._outstanding_balance_close_of_period = outstanding_balance_close_of_period

    @property
    def payment_period(self):
        """Gets the payment_period of this InlineResponseDefault4Results.  # noqa: E501


        :return: The payment_period of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: float
        """
        return self._payment_period

    @payment_period.setter
    def payment_period(self, payment_period):
        """Sets the payment_period of this InlineResponseDefault4Results.


        :param payment_period: The payment_period of this InlineResponseDefault4Results.  # noqa: E501
        :type: float
        """

        self._payment_period = payment_period

    @property
    def pdf_url(self):
        """Gets the pdf_url of this InlineResponseDefault4Results.  # noqa: E501


        :return: The pdf_url of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this InlineResponseDefault4Results.


        :param pdf_url: The pdf_url of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def report_type(self):
        """Gets the report_type of this InlineResponseDefault4Results.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this InlineResponseDefault4Results.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this InlineResponseDefault4Results.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this InlineResponseDefault4Results.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this InlineResponseDefault4Results.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this InlineResponseDefault4Results.  # noqa: E501


        :return: The schedule_type of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this InlineResponseDefault4Results.


        :param schedule_type: The schedule_type of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this InlineResponseDefault4Results.  # noqa: E501


        :return: The schedule_type_full of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this InlineResponseDefault4Results.


        :param schedule_type_full: The schedule_type_full of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def sub_id(self):
        """Gets the sub_id of this InlineResponseDefault4Results.  # noqa: E501


        :return: The sub_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this InlineResponseDefault4Results.


        :param sub_id: The sub_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def transaction_id(self):
        """Gets the transaction_id of this InlineResponseDefault4Results.  # noqa: E501


        :return: The transaction_id of this InlineResponseDefault4Results.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this InlineResponseDefault4Results.


        :param transaction_id: The transaction_id of this InlineResponseDefault4Results.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineResponseDefault4Results):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineResponseDefault4Results):
            return True

        return self.to_dict() != other.to_dict()
