# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class InlineResponseDefault5Results(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_code': 'str',
        'action_code_full': 'str',
        'aggregate_general_election_expenditure': 'str',
        'back_reference_schedule_name': 'str',
        'back_reference_transaction_id': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_full': 'str',
        'candidate_office_state': 'str',
        'candidate_office_state_full': 'str',
        'candidate_prefix': 'str',
        'candidate_suffix': 'str',
        'catolog_code': 'str',
        'catolog_code_full': 'str',
        'committee': 'CommitteeHistory',
        'committee_designated_coordinated_expenditure_indicator': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_id': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'designated_committee_id': 'str',
        'designated_committee_name': 'str',
        'election_cycle': 'int',
        'entity_type': 'str',
        'entity_type_desc': 'str',
        'expenditure_amount': 'int',
        'expenditure_date': 'datetime',
        'expenditure_purpose_full': 'str',
        'expenditure_type': 'str',
        'expenditure_type_full': 'str',
        'file_number': 'int',
        'filing_form': 'str',
        'image_number': 'str',
        'line_number': 'str',
        'link_id': 'int',
        'load_date': 'datetime',
        'memo_code': 'str',
        'memo_code_full': 'str',
        'memo_text': 'str',
        'original_sub_id': 'int',
        'payee_first_name': 'str',
        'payee_last_name': 'str',
        'payee_middle_name': 'str',
        'payee_name': 'str',
        'pdf_url': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'sub_id': 'str',
        'subordinate_committee': 'CommitteeHistory',
        'subordinate_committee_id': 'str',
        'transaction_id': 'str',
        'unlimited_spending_flag': 'str',
        'unlimited_spending_flag_full': 'str'
    }

    attribute_map = {
        'action_code': 'action_code',
        'action_code_full': 'action_code_full',
        'aggregate_general_election_expenditure': 'aggregate_general_election_expenditure',
        'back_reference_schedule_name': 'back_reference_schedule_name',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_full': 'candidate_office_full',
        'candidate_office_state': 'candidate_office_state',
        'candidate_office_state_full': 'candidate_office_state_full',
        'candidate_prefix': 'candidate_prefix',
        'candidate_suffix': 'candidate_suffix',
        'catolog_code': 'catolog_code',
        'catolog_code_full': 'catolog_code_full',
        'committee': 'committee',
        'committee_designated_coordinated_expenditure_indicator': 'committee_designated_coordinated_expenditure_indicator',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_id': 'conduit_committee_id',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'designated_committee_id': 'designated_committee_id',
        'designated_committee_name': 'designated_committee_name',
        'election_cycle': 'election_cycle',
        'entity_type': 'entity_type',
        'entity_type_desc': 'entity_type_desc',
        'expenditure_amount': 'expenditure_amount',
        'expenditure_date': 'expenditure_date',
        'expenditure_purpose_full': 'expenditure_purpose_full',
        'expenditure_type': 'expenditure_type',
        'expenditure_type_full': 'expenditure_type_full',
        'file_number': 'file_number',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'line_number': 'line_number',
        'link_id': 'link_id',
        'load_date': 'load_date',
        'memo_code': 'memo_code',
        'memo_code_full': 'memo_code_full',
        'memo_text': 'memo_text',
        'original_sub_id': 'original_sub_id',
        'payee_first_name': 'payee_first_name',
        'payee_last_name': 'payee_last_name',
        'payee_middle_name': 'payee_middle_name',
        'payee_name': 'payee_name',
        'pdf_url': 'pdf_url',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'sub_id': 'sub_id',
        'subordinate_committee': 'subordinate_committee',
        'subordinate_committee_id': 'subordinate_committee_id',
        'transaction_id': 'transaction_id',
        'unlimited_spending_flag': 'unlimited_spending_flag',
        'unlimited_spending_flag_full': 'unlimited_spending_flag_full'
    }

    def __init__(self, action_code=None, action_code_full=None, aggregate_general_election_expenditure=None, back_reference_schedule_name=None, back_reference_transaction_id=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_district=None, candidate_office_full=None, candidate_office_state=None, candidate_office_state_full=None, candidate_prefix=None, candidate_suffix=None, catolog_code=None, catolog_code_full=None, committee=None, committee_designated_coordinated_expenditure_indicator=None, committee_id=None, committee_name=None, conduit_committee_city=None, conduit_committee_id=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, designated_committee_id=None, designated_committee_name=None, election_cycle=None, entity_type=None, entity_type_desc=None, expenditure_amount=None, expenditure_date=None, expenditure_purpose_full=None, expenditure_type=None, expenditure_type_full=None, file_number=None, filing_form=None, image_number=None, line_number=None, link_id=None, load_date=None, memo_code=None, memo_code_full=None, memo_text=None, original_sub_id=None, payee_first_name=None, payee_last_name=None, payee_middle_name=None, payee_name=None, pdf_url=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, sub_id=None, subordinate_committee=None, subordinate_committee_id=None, transaction_id=None, unlimited_spending_flag=None, unlimited_spending_flag_full=None, local_vars_configuration=None):  # noqa: E501
        """InlineResponseDefault5Results - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_code = None
        self._action_code_full = None
        self._aggregate_general_election_expenditure = None
        self._back_reference_schedule_name = None
        self._back_reference_transaction_id = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_full = None
        self._candidate_office_state = None
        self._candidate_office_state_full = None
        self._candidate_prefix = None
        self._candidate_suffix = None
        self._catolog_code = None
        self._catolog_code_full = None
        self._committee = None
        self._committee_designated_coordinated_expenditure_indicator = None
        self._committee_id = None
        self._committee_name = None
        self._conduit_committee_city = None
        self._conduit_committee_id = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._designated_committee_id = None
        self._designated_committee_name = None
        self._election_cycle = None
        self._entity_type = None
        self._entity_type_desc = None
        self._expenditure_amount = None
        self._expenditure_date = None
        self._expenditure_purpose_full = None
        self._expenditure_type = None
        self._expenditure_type_full = None
        self._file_number = None
        self._filing_form = None
        self._image_number = None
        self._line_number = None
        self._link_id = None
        self._load_date = None
        self._memo_code = None
        self._memo_code_full = None
        self._memo_text = None
        self._original_sub_id = None
        self._payee_first_name = None
        self._payee_last_name = None
        self._payee_middle_name = None
        self._payee_name = None
        self._pdf_url = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._sub_id = None
        self._subordinate_committee = None
        self._subordinate_committee_id = None
        self._transaction_id = None
        self._unlimited_spending_flag = None
        self._unlimited_spending_flag_full = None
        self.discriminator = None

        self.action_code = action_code
        self.action_code_full = action_code_full
        self.aggregate_general_election_expenditure = aggregate_general_election_expenditure
        self.back_reference_schedule_name = back_reference_schedule_name
        self.back_reference_transaction_id = back_reference_transaction_id
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_full = candidate_office_full
        self.candidate_office_state = candidate_office_state
        self.candidate_office_state_full = candidate_office_state_full
        self.candidate_prefix = candidate_prefix
        self.candidate_suffix = candidate_suffix
        self.catolog_code = catolog_code
        self.catolog_code_full = catolog_code_full
        if committee is not None:
            self.committee = committee
        self.committee_designated_coordinated_expenditure_indicator = committee_designated_coordinated_expenditure_indicator
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_id = conduit_committee_id
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        self.designated_committee_id = designated_committee_id
        self.designated_committee_name = designated_committee_name
        self.election_cycle = election_cycle
        self.entity_type = entity_type
        self.entity_type_desc = entity_type_desc
        self.expenditure_amount = expenditure_amount
        self.expenditure_date = expenditure_date
        self.expenditure_purpose_full = expenditure_purpose_full
        self.expenditure_type = expenditure_type
        self.expenditure_type_full = expenditure_type_full
        self.file_number = file_number
        self.filing_form = filing_form
        self.image_number = image_number
        self.line_number = line_number
        self.link_id = link_id
        self.load_date = load_date
        self.memo_code = memo_code
        self.memo_code_full = memo_code_full
        self.memo_text = memo_text
        self.original_sub_id = original_sub_id
        self.payee_first_name = payee_first_name
        self.payee_last_name = payee_last_name
        self.payee_middle_name = payee_middle_name
        self.payee_name = payee_name
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        if sub_id is not None:
            self.sub_id = sub_id
        if subordinate_committee is not None:
            self.subordinate_committee = subordinate_committee
        self.subordinate_committee_id = subordinate_committee_id
        self.transaction_id = transaction_id
        self.unlimited_spending_flag = unlimited_spending_flag
        self.unlimited_spending_flag_full = unlimited_spending_flag_full

    @property
    def action_code(self):
        """Gets the action_code of this InlineResponseDefault5Results.  # noqa: E501


        :return: The action_code of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._action_code

    @action_code.setter
    def action_code(self, action_code):
        """Sets the action_code of this InlineResponseDefault5Results.


        :param action_code: The action_code of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._action_code = action_code

    @property
    def action_code_full(self):
        """Gets the action_code_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The action_code_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._action_code_full

    @action_code_full.setter
    def action_code_full(self, action_code_full):
        """Sets the action_code_full of this InlineResponseDefault5Results.


        :param action_code_full: The action_code_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._action_code_full = action_code_full

    @property
    def aggregate_general_election_expenditure(self):
        """Gets the aggregate_general_election_expenditure of this InlineResponseDefault5Results.  # noqa: E501


        :return: The aggregate_general_election_expenditure of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._aggregate_general_election_expenditure

    @aggregate_general_election_expenditure.setter
    def aggregate_general_election_expenditure(self, aggregate_general_election_expenditure):
        """Sets the aggregate_general_election_expenditure of this InlineResponseDefault5Results.


        :param aggregate_general_election_expenditure: The aggregate_general_election_expenditure of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._aggregate_general_election_expenditure = aggregate_general_election_expenditure

    @property
    def back_reference_schedule_name(self):
        """Gets the back_reference_schedule_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The back_reference_schedule_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_name

    @back_reference_schedule_name.setter
    def back_reference_schedule_name(self, back_reference_schedule_name):
        """Sets the back_reference_schedule_name of this InlineResponseDefault5Results.


        :param back_reference_schedule_name: The back_reference_schedule_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_name = back_reference_schedule_name

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The back_reference_transaction_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this InlineResponseDefault5Results.


        :param back_reference_transaction_id: The back_reference_transaction_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_first_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this InlineResponseDefault5Results.


        :param candidate_first_name: The candidate_first_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this InlineResponseDefault5Results.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this InlineResponseDefault5Results.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_last_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this InlineResponseDefault5Results.


        :param candidate_last_name: The candidate_last_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_middle_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this InlineResponseDefault5Results.


        :param candidate_middle_name: The candidate_middle_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this InlineResponseDefault5Results.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this InlineResponseDefault5Results.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_office of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this InlineResponseDefault5Results.


        :param candidate_office: The candidate_office of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_office_district of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this InlineResponseDefault5Results.


        :param candidate_office_district: The candidate_office_district of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_full(self):
        """Gets the candidate_office_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_office_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_full

    @candidate_office_full.setter
    def candidate_office_full(self, candidate_office_full):
        """Sets the candidate_office_full of this InlineResponseDefault5Results.


        :param candidate_office_full: The candidate_office_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_full = candidate_office_full

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_office_state of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this InlineResponseDefault5Results.


        :param candidate_office_state: The candidate_office_state of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_office_state_full(self):
        """Gets the candidate_office_state_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_office_state_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state_full

    @candidate_office_state_full.setter
    def candidate_office_state_full(self, candidate_office_state_full):
        """Sets the candidate_office_state_full of this InlineResponseDefault5Results.


        :param candidate_office_state_full: The candidate_office_state_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_office_state_full = candidate_office_state_full

    @property
    def candidate_prefix(self):
        """Gets the candidate_prefix of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_prefix of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_prefix

    @candidate_prefix.setter
    def candidate_prefix(self, candidate_prefix):
        """Sets the candidate_prefix of this InlineResponseDefault5Results.


        :param candidate_prefix: The candidate_prefix of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_prefix = candidate_prefix

    @property
    def candidate_suffix(self):
        """Gets the candidate_suffix of this InlineResponseDefault5Results.  # noqa: E501


        :return: The candidate_suffix of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._candidate_suffix

    @candidate_suffix.setter
    def candidate_suffix(self, candidate_suffix):
        """Sets the candidate_suffix of this InlineResponseDefault5Results.


        :param candidate_suffix: The candidate_suffix of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._candidate_suffix = candidate_suffix

    @property
    def catolog_code(self):
        """Gets the catolog_code of this InlineResponseDefault5Results.  # noqa: E501


        :return: The catolog_code of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._catolog_code

    @catolog_code.setter
    def catolog_code(self, catolog_code):
        """Sets the catolog_code of this InlineResponseDefault5Results.


        :param catolog_code: The catolog_code of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._catolog_code = catolog_code

    @property
    def catolog_code_full(self):
        """Gets the catolog_code_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The catolog_code_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._catolog_code_full

    @catolog_code_full.setter
    def catolog_code_full(self, catolog_code_full):
        """Sets the catolog_code_full of this InlineResponseDefault5Results.


        :param catolog_code_full: The catolog_code_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._catolog_code_full = catolog_code_full

    @property
    def committee(self):
        """Gets the committee of this InlineResponseDefault5Results.  # noqa: E501


        :return: The committee of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this InlineResponseDefault5Results.


        :param committee: The committee of this InlineResponseDefault5Results.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_designated_coordinated_expenditure_indicator(self):
        """Gets the committee_designated_coordinated_expenditure_indicator of this InlineResponseDefault5Results.  # noqa: E501


        :return: The committee_designated_coordinated_expenditure_indicator of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._committee_designated_coordinated_expenditure_indicator

    @committee_designated_coordinated_expenditure_indicator.setter
    def committee_designated_coordinated_expenditure_indicator(self, committee_designated_coordinated_expenditure_indicator):
        """Sets the committee_designated_coordinated_expenditure_indicator of this InlineResponseDefault5Results.


        :param committee_designated_coordinated_expenditure_indicator: The committee_designated_coordinated_expenditure_indicator of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._committee_designated_coordinated_expenditure_indicator = committee_designated_coordinated_expenditure_indicator

    @property
    def committee_id(self):
        """Gets the committee_id of this InlineResponseDefault5Results.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this InlineResponseDefault5Results.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The committee_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this InlineResponseDefault5Results.


        :param committee_name: The committee_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_city of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this InlineResponseDefault5Results.


        :param conduit_committee_city: The conduit_committee_city of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_id(self):
        """Gets the conduit_committee_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_id

    @conduit_committee_id.setter
    def conduit_committee_id(self, conduit_committee_id):
        """Sets the conduit_committee_id of this InlineResponseDefault5Results.


        :param conduit_committee_id: The conduit_committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_id = conduit_committee_id

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this InlineResponseDefault5Results.


        :param conduit_committee_name: The conduit_committee_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_state of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this InlineResponseDefault5Results.


        :param conduit_committee_state: The conduit_committee_state of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_street1 of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this InlineResponseDefault5Results.


        :param conduit_committee_street1: The conduit_committee_street1 of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_street2 of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this InlineResponseDefault5Results.


        :param conduit_committee_street2: The conduit_committee_street2 of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this InlineResponseDefault5Results.  # noqa: E501


        :return: The conduit_committee_zip of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this InlineResponseDefault5Results.


        :param conduit_committee_zip: The conduit_committee_zip of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def designated_committee_id(self):
        """Gets the designated_committee_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The designated_committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._designated_committee_id

    @designated_committee_id.setter
    def designated_committee_id(self, designated_committee_id):
        """Sets the designated_committee_id of this InlineResponseDefault5Results.


        :param designated_committee_id: The designated_committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._designated_committee_id = designated_committee_id

    @property
    def designated_committee_name(self):
        """Gets the designated_committee_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The designated_committee_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._designated_committee_name

    @designated_committee_name.setter
    def designated_committee_name(self, designated_committee_name):
        """Sets the designated_committee_name of this InlineResponseDefault5Results.


        :param designated_committee_name: The designated_committee_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._designated_committee_name = designated_committee_name

    @property
    def election_cycle(self):
        """Gets the election_cycle of this InlineResponseDefault5Results.  # noqa: E501


        :return: The election_cycle of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._election_cycle

    @election_cycle.setter
    def election_cycle(self, election_cycle):
        """Sets the election_cycle of this InlineResponseDefault5Results.


        :param election_cycle: The election_cycle of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._election_cycle = election_cycle

    @property
    def entity_type(self):
        """Gets the entity_type of this InlineResponseDefault5Results.  # noqa: E501


        :return: The entity_type of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this InlineResponseDefault5Results.


        :param entity_type: The entity_type of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def entity_type_desc(self):
        """Gets the entity_type_desc of this InlineResponseDefault5Results.  # noqa: E501


        :return: The entity_type_desc of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._entity_type_desc

    @entity_type_desc.setter
    def entity_type_desc(self, entity_type_desc):
        """Sets the entity_type_desc of this InlineResponseDefault5Results.


        :param entity_type_desc: The entity_type_desc of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._entity_type_desc = entity_type_desc

    @property
    def expenditure_amount(self):
        """Gets the expenditure_amount of this InlineResponseDefault5Results.  # noqa: E501


        :return: The expenditure_amount of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._expenditure_amount

    @expenditure_amount.setter
    def expenditure_amount(self, expenditure_amount):
        """Sets the expenditure_amount of this InlineResponseDefault5Results.


        :param expenditure_amount: The expenditure_amount of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._expenditure_amount = expenditure_amount

    @property
    def expenditure_date(self):
        """Gets the expenditure_date of this InlineResponseDefault5Results.  # noqa: E501


        :return: The expenditure_date of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: datetime
        """
        return self._expenditure_date

    @expenditure_date.setter
    def expenditure_date(self, expenditure_date):
        """Sets the expenditure_date of this InlineResponseDefault5Results.


        :param expenditure_date: The expenditure_date of this InlineResponseDefault5Results.  # noqa: E501
        :type: datetime
        """

        self._expenditure_date = expenditure_date

    @property
    def expenditure_purpose_full(self):
        """Gets the expenditure_purpose_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The expenditure_purpose_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._expenditure_purpose_full

    @expenditure_purpose_full.setter
    def expenditure_purpose_full(self, expenditure_purpose_full):
        """Sets the expenditure_purpose_full of this InlineResponseDefault5Results.


        :param expenditure_purpose_full: The expenditure_purpose_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._expenditure_purpose_full = expenditure_purpose_full

    @property
    def expenditure_type(self):
        """Gets the expenditure_type of this InlineResponseDefault5Results.  # noqa: E501


        :return: The expenditure_type of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._expenditure_type

    @expenditure_type.setter
    def expenditure_type(self, expenditure_type):
        """Sets the expenditure_type of this InlineResponseDefault5Results.


        :param expenditure_type: The expenditure_type of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._expenditure_type = expenditure_type

    @property
    def expenditure_type_full(self):
        """Gets the expenditure_type_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The expenditure_type_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._expenditure_type_full

    @expenditure_type_full.setter
    def expenditure_type_full(self, expenditure_type_full):
        """Sets the expenditure_type_full of this InlineResponseDefault5Results.


        :param expenditure_type_full: The expenditure_type_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._expenditure_type_full = expenditure_type_full

    @property
    def file_number(self):
        """Gets the file_number of this InlineResponseDefault5Results.  # noqa: E501


        :return: The file_number of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this InlineResponseDefault5Results.


        :param file_number: The file_number of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filing_form(self):
        """Gets the filing_form of this InlineResponseDefault5Results.  # noqa: E501


        :return: The filing_form of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this InlineResponseDefault5Results.


        :param filing_form: The filing_form of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this InlineResponseDefault5Results.  # noqa: E501

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :return: The image_number of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this InlineResponseDefault5Results.

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :param image_number: The image_number of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def line_number(self):
        """Gets the line_number of this InlineResponseDefault5Results.  # noqa: E501


        :return: The line_number of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this InlineResponseDefault5Results.


        :param line_number: The line_number of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def link_id(self):
        """Gets the link_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The link_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this InlineResponseDefault5Results.


        :param link_id: The link_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def load_date(self):
        """Gets the load_date of this InlineResponseDefault5Results.  # noqa: E501


        :return: The load_date of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: datetime
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this InlineResponseDefault5Results.


        :param load_date: The load_date of this InlineResponseDefault5Results.  # noqa: E501
        :type: datetime
        """

        self._load_date = load_date

    @property
    def memo_code(self):
        """Gets the memo_code of this InlineResponseDefault5Results.  # noqa: E501


        :return: The memo_code of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this InlineResponseDefault5Results.


        :param memo_code: The memo_code of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_code_full(self):
        """Gets the memo_code_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The memo_code_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._memo_code_full

    @memo_code_full.setter
    def memo_code_full(self, memo_code_full):
        """Sets the memo_code_full of this InlineResponseDefault5Results.


        :param memo_code_full: The memo_code_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._memo_code_full = memo_code_full

    @property
    def memo_text(self):
        """Gets the memo_text of this InlineResponseDefault5Results.  # noqa: E501


        :return: The memo_text of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this InlineResponseDefault5Results.


        :param memo_text: The memo_text of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The original_sub_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this InlineResponseDefault5Results.


        :param original_sub_id: The original_sub_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._original_sub_id = original_sub_id

    @property
    def payee_first_name(self):
        """Gets the payee_first_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The payee_first_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._payee_first_name

    @payee_first_name.setter
    def payee_first_name(self, payee_first_name):
        """Sets the payee_first_name of this InlineResponseDefault5Results.


        :param payee_first_name: The payee_first_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._payee_first_name = payee_first_name

    @property
    def payee_last_name(self):
        """Gets the payee_last_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The payee_last_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._payee_last_name

    @payee_last_name.setter
    def payee_last_name(self, payee_last_name):
        """Sets the payee_last_name of this InlineResponseDefault5Results.


        :param payee_last_name: The payee_last_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._payee_last_name = payee_last_name

    @property
    def payee_middle_name(self):
        """Gets the payee_middle_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The payee_middle_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._payee_middle_name

    @payee_middle_name.setter
    def payee_middle_name(self, payee_middle_name):
        """Sets the payee_middle_name of this InlineResponseDefault5Results.


        :param payee_middle_name: The payee_middle_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._payee_middle_name = payee_middle_name

    @property
    def payee_name(self):
        """Gets the payee_name of this InlineResponseDefault5Results.  # noqa: E501


        :return: The payee_name of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._payee_name

    @payee_name.setter
    def payee_name(self, payee_name):
        """Sets the payee_name of this InlineResponseDefault5Results.


        :param payee_name: The payee_name of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._payee_name = payee_name

    @property
    def pdf_url(self):
        """Gets the pdf_url of this InlineResponseDefault5Results.  # noqa: E501


        :return: The pdf_url of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this InlineResponseDefault5Results.


        :param pdf_url: The pdf_url of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def report_type(self):
        """Gets the report_type of this InlineResponseDefault5Results.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this InlineResponseDefault5Results.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this InlineResponseDefault5Results.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this InlineResponseDefault5Results.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this InlineResponseDefault5Results.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this InlineResponseDefault5Results.  # noqa: E501


        :return: The schedule_type of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this InlineResponseDefault5Results.


        :param schedule_type: The schedule_type of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The schedule_type_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this InlineResponseDefault5Results.


        :param schedule_type_full: The schedule_type_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def sub_id(self):
        """Gets the sub_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The sub_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this InlineResponseDefault5Results.


        :param sub_id: The sub_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def subordinate_committee(self):
        """Gets the subordinate_committee of this InlineResponseDefault5Results.  # noqa: E501


        :return: The subordinate_committee of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._subordinate_committee

    @subordinate_committee.setter
    def subordinate_committee(self, subordinate_committee):
        """Sets the subordinate_committee of this InlineResponseDefault5Results.


        :param subordinate_committee: The subordinate_committee of this InlineResponseDefault5Results.  # noqa: E501
        :type: CommitteeHistory
        """

        self._subordinate_committee = subordinate_committee

    @property
    def subordinate_committee_id(self):
        """Gets the subordinate_committee_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The subordinate_committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._subordinate_committee_id

    @subordinate_committee_id.setter
    def subordinate_committee_id(self, subordinate_committee_id):
        """Sets the subordinate_committee_id of this InlineResponseDefault5Results.


        :param subordinate_committee_id: The subordinate_committee_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._subordinate_committee_id = subordinate_committee_id

    @property
    def transaction_id(self):
        """Gets the transaction_id of this InlineResponseDefault5Results.  # noqa: E501


        :return: The transaction_id of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this InlineResponseDefault5Results.


        :param transaction_id: The transaction_id of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def unlimited_spending_flag(self):
        """Gets the unlimited_spending_flag of this InlineResponseDefault5Results.  # noqa: E501


        :return: The unlimited_spending_flag of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._unlimited_spending_flag

    @unlimited_spending_flag.setter
    def unlimited_spending_flag(self, unlimited_spending_flag):
        """Sets the unlimited_spending_flag of this InlineResponseDefault5Results.


        :param unlimited_spending_flag: The unlimited_spending_flag of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._unlimited_spending_flag = unlimited_spending_flag

    @property
    def unlimited_spending_flag_full(self):
        """Gets the unlimited_spending_flag_full of this InlineResponseDefault5Results.  # noqa: E501


        :return: The unlimited_spending_flag_full of this InlineResponseDefault5Results.  # noqa: E501
        :rtype: str
        """
        return self._unlimited_spending_flag_full

    @unlimited_spending_flag_full.setter
    def unlimited_spending_flag_full(self, unlimited_spending_flag_full):
        """Sets the unlimited_spending_flag_full of this InlineResponseDefault5Results.


        :param unlimited_spending_flag_full: The unlimited_spending_flag_full of this InlineResponseDefault5Results.  # noqa: E501
        :type: str
        """

        self._unlimited_spending_flag_full = unlimited_spending_flag_full

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineResponseDefault5Results):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineResponseDefault5Results):
            return True

        return self.to_dict() != other.to_dict()
