# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class OperationsLog(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amendment_indicator': 'str',
        'beginning_image_number': 'str',
        'candidate_committee_id': 'str',
        'coverage_end_date': 'datetime',
        'coverage_start_date': 'datetime',
        'ending_image_number': 'str',
        'form_type': 'str',
        'receipt_date': 'datetime',
        'report_type': 'str',
        'report_year': 'int',
        'status_num': 'int',
        'sub_id': 'int',
        'summary_data_complete_date': 'datetime',
        'summary_data_verification_date': 'datetime',
        'transaction_data_complete_date': 'date'
    }

    attribute_map = {
        'amendment_indicator': 'amendment_indicator',
        'beginning_image_number': 'beginning_image_number',
        'candidate_committee_id': 'candidate_committee_id',
        'coverage_end_date': 'coverage_end_date',
        'coverage_start_date': 'coverage_start_date',
        'ending_image_number': 'ending_image_number',
        'form_type': 'form_type',
        'receipt_date': 'receipt_date',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'status_num': 'status_num',
        'sub_id': 'sub_id',
        'summary_data_complete_date': 'summary_data_complete_date',
        'summary_data_verification_date': 'summary_data_verification_date',
        'transaction_data_complete_date': 'transaction_data_complete_date'
    }

    def __init__(self, amendment_indicator=None, beginning_image_number=None, candidate_committee_id=None, coverage_end_date=None, coverage_start_date=None, ending_image_number=None, form_type=None, receipt_date=None, report_type=None, report_year=None, status_num=None, sub_id=None, summary_data_complete_date=None, summary_data_verification_date=None, transaction_data_complete_date=None, local_vars_configuration=None):  # noqa: E501
        """OperationsLog - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amendment_indicator = None
        self._beginning_image_number = None
        self._candidate_committee_id = None
        self._coverage_end_date = None
        self._coverage_start_date = None
        self._ending_image_number = None
        self._form_type = None
        self._receipt_date = None
        self._report_type = None
        self._report_year = None
        self._status_num = None
        self._sub_id = None
        self._summary_data_complete_date = None
        self._summary_data_verification_date = None
        self._transaction_data_complete_date = None
        self.discriminator = None

        self.amendment_indicator = amendment_indicator
        self.beginning_image_number = beginning_image_number
        self.candidate_committee_id = candidate_committee_id
        self.coverage_end_date = coverage_end_date
        self.coverage_start_date = coverage_start_date
        self.ending_image_number = ending_image_number
        self.form_type = form_type
        self.receipt_date = receipt_date
        self.report_type = report_type
        self.report_year = report_year
        self.status_num = status_num
        if sub_id is not None:
            self.sub_id = sub_id
        self.summary_data_complete_date = summary_data_complete_date
        self.summary_data_verification_date = summary_data_verification_date
        self.transaction_data_complete_date = transaction_data_complete_date

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this OperationsLog.  # noqa: E501

        Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.   # noqa: E501

        :return: The amendment_indicator of this OperationsLog.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this OperationsLog.

        Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.   # noqa: E501

        :param amendment_indicator: The amendment_indicator of this OperationsLog.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this OperationsLog.  # noqa: E501

         Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.   # noqa: E501

        :return: The beginning_image_number of this OperationsLog.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this OperationsLog.

         Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.   # noqa: E501

        :param beginning_image_number: The beginning_image_number of this OperationsLog.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def candidate_committee_id(self):
        """Gets the candidate_committee_id of this OperationsLog.  # noqa: E501

         A unique identifier of the registered filer.   # noqa: E501

        :return: The candidate_committee_id of this OperationsLog.  # noqa: E501
        :rtype: str
        """
        return self._candidate_committee_id

    @candidate_committee_id.setter
    def candidate_committee_id(self, candidate_committee_id):
        """Sets the candidate_committee_id of this OperationsLog.

         A unique identifier of the registered filer.   # noqa: E501

        :param candidate_committee_id: The candidate_committee_id of this OperationsLog.  # noqa: E501
        :type: str
        """

        self._candidate_committee_id = candidate_committee_id

    @property
    def coverage_end_date(self):
        """Gets the coverage_end_date of this OperationsLog.  # noqa: E501

        Ending date of the reporting period  # noqa: E501

        :return: The coverage_end_date of this OperationsLog.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_end_date

    @coverage_end_date.setter
    def coverage_end_date(self, coverage_end_date):
        """Sets the coverage_end_date of this OperationsLog.

        Ending date of the reporting period  # noqa: E501

        :param coverage_end_date: The coverage_end_date of this OperationsLog.  # noqa: E501
        :type: datetime
        """

        self._coverage_end_date = coverage_end_date

    @property
    def coverage_start_date(self):
        """Gets the coverage_start_date of this OperationsLog.  # noqa: E501

        Beginning date of the reporting period  # noqa: E501

        :return: The coverage_start_date of this OperationsLog.  # noqa: E501
        :rtype: datetime
        """
        return self._coverage_start_date

    @coverage_start_date.setter
    def coverage_start_date(self, coverage_start_date):
        """Sets the coverage_start_date of this OperationsLog.

        Beginning date of the reporting period  # noqa: E501

        :param coverage_start_date: The coverage_start_date of this OperationsLog.  # noqa: E501
        :type: datetime
        """

        self._coverage_start_date = coverage_start_date

    @property
    def ending_image_number(self):
        """Gets the ending_image_number of this OperationsLog.  # noqa: E501

        Image number is an unique identifier for each page the electronic or paper report. The last image number corresponds to the image number for the last page of the document.  # noqa: E501

        :return: The ending_image_number of this OperationsLog.  # noqa: E501
        :rtype: str
        """
        return self._ending_image_number

    @ending_image_number.setter
    def ending_image_number(self, ending_image_number):
        """Sets the ending_image_number of this OperationsLog.

        Image number is an unique identifier for each page the electronic or paper report. The last image number corresponds to the image number for the last page of the document.  # noqa: E501

        :param ending_image_number: The ending_image_number of this OperationsLog.  # noqa: E501
        :type: str
        """

        self._ending_image_number = ending_image_number

    @property
    def form_type(self):
        """Gets the form_type of this OperationsLog.  # noqa: E501

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :return: The form_type of this OperationsLog.  # noqa: E501
        :rtype: str
        """
        return self._form_type

    @form_type.setter
    def form_type(self, form_type):
        """Sets the form_type of this OperationsLog.

        The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information   # noqa: E501

        :param form_type: The form_type of this OperationsLog.  # noqa: E501
        :type: str
        """

        self._form_type = form_type

    @property
    def receipt_date(self):
        """Gets the receipt_date of this OperationsLog.  # noqa: E501

        Date the FEC received the electronic or paper record  # noqa: E501

        :return: The receipt_date of this OperationsLog.  # noqa: E501
        :rtype: datetime
        """
        return self._receipt_date

    @receipt_date.setter
    def receipt_date(self, receipt_date):
        """Sets the receipt_date of this OperationsLog.

        Date the FEC received the electronic or paper record  # noqa: E501

        :param receipt_date: The receipt_date of this OperationsLog.  # noqa: E501
        :type: datetime
        """

        self._receipt_date = receipt_date

    @property
    def report_type(self):
        """Gets the report_type of this OperationsLog.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this OperationsLog.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this OperationsLog.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this OperationsLog.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this OperationsLog.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this OperationsLog.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this OperationsLog.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this OperationsLog.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def status_num(self):
        """Gets the status_num of this OperationsLog.  # noqa: E501

         Status of the transactional report.     -0- Transaction is entered            into the system.           But not verified.     -1- Transaction is verified.   # noqa: E501

        :return: The status_num of this OperationsLog.  # noqa: E501
        :rtype: int
        """
        return self._status_num

    @status_num.setter
    def status_num(self, status_num):
        """Sets the status_num of this OperationsLog.

         Status of the transactional report.     -0- Transaction is entered            into the system.           But not verified.     -1- Transaction is verified.   # noqa: E501

        :param status_num: The status_num of this OperationsLog.  # noqa: E501
        :type: int
        """

        self._status_num = status_num

    @property
    def sub_id(self):
        """Gets the sub_id of this OperationsLog.  # noqa: E501

         A unique identifier of the transactional report.   # noqa: E501

        :return: The sub_id of this OperationsLog.  # noqa: E501
        :rtype: int
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this OperationsLog.

         A unique identifier of the transactional report.   # noqa: E501

        :param sub_id: The sub_id of this OperationsLog.  # noqa: E501
        :type: int
        """

        self._sub_id = sub_id

    @property
    def summary_data_complete_date(self):
        """Gets the summary_data_complete_date of this OperationsLog.  # noqa: E501

         Date when the report is entered into the database   # noqa: E501

        :return: The summary_data_complete_date of this OperationsLog.  # noqa: E501
        :rtype: datetime
        """
        return self._summary_data_complete_date

    @summary_data_complete_date.setter
    def summary_data_complete_date(self, summary_data_complete_date):
        """Sets the summary_data_complete_date of this OperationsLog.

         Date when the report is entered into the database   # noqa: E501

        :param summary_data_complete_date: The summary_data_complete_date of this OperationsLog.  # noqa: E501
        :type: datetime
        """

        self._summary_data_complete_date = summary_data_complete_date

    @property
    def summary_data_verification_date(self):
        """Gets the summary_data_verification_date of this OperationsLog.  # noqa: E501

         Same day or a day after the report is loaded in the database   # noqa: E501

        :return: The summary_data_verification_date of this OperationsLog.  # noqa: E501
        :rtype: datetime
        """
        return self._summary_data_verification_date

    @summary_data_verification_date.setter
    def summary_data_verification_date(self, summary_data_verification_date):
        """Sets the summary_data_verification_date of this OperationsLog.

         Same day or a day after the report is loaded in the database   # noqa: E501

        :param summary_data_verification_date: The summary_data_verification_date of this OperationsLog.  # noqa: E501
        :type: datetime
        """

        self._summary_data_verification_date = summary_data_verification_date

    @property
    def transaction_data_complete_date(self):
        """Gets the transaction_data_complete_date of this OperationsLog.  # noqa: E501

         Date when the report is processed completely   # noqa: E501

        :return: The transaction_data_complete_date of this OperationsLog.  # noqa: E501
        :rtype: date
        """
        return self._transaction_data_complete_date

    @transaction_data_complete_date.setter
    def transaction_data_complete_date(self, transaction_data_complete_date):
        """Sets the transaction_data_complete_date of this OperationsLog.

         Date when the report is processed completely   # noqa: E501

        :param transaction_data_complete_date: The transaction_data_complete_date of this OperationsLog.  # noqa: E501
        :type: date
        """

        self._transaction_data_complete_date = transaction_data_complete_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperationsLog):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OperationsLog):
            return True

        return self.to_dict() != other.to_dict()
