# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class PresidentialByCandidate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_party_affiliation': 'str',
        'contributor_state': 'str',
        'election_year': 'int',
        'net_receipts': 'float',
        'rounded_net_receipts': 'float'
    }

    attribute_map = {
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_party_affiliation': 'candidate_party_affiliation',
        'contributor_state': 'contributor_state',
        'election_year': 'election_year',
        'net_receipts': 'net_receipts',
        'rounded_net_receipts': 'rounded_net_receipts'
    }

    def __init__(self, candidate_id=None, candidate_last_name=None, candidate_party_affiliation=None, contributor_state=None, election_year=None, net_receipts=None, rounded_net_receipts=None, local_vars_configuration=None):  # noqa: E501
        """PresidentialByCandidate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_party_affiliation = None
        self._contributor_state = None
        self._election_year = None
        self._net_receipts = None
        self._rounded_net_receipts = None
        self.discriminator = None

        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_party_affiliation = candidate_party_affiliation
        self.contributor_state = contributor_state
        self.election_year = election_year
        self.net_receipts = net_receipts
        self.rounded_net_receipts = rounded_net_receipts

    @property
    def candidate_id(self):
        """Gets the candidate_id of this PresidentialByCandidate.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   -P00000001    All candidates   -P00000002    Democrasts   -P00000003    Republicans   # noqa: E501

        :return: The candidate_id of this PresidentialByCandidate.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this PresidentialByCandidate.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   -P00000001    All candidates   -P00000002    Democrasts   -P00000003    Republicans   # noqa: E501

        :param candidate_id: The candidate_id of this PresidentialByCandidate.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this PresidentialByCandidate.  # noqa: E501

         Candidate last name   # noqa: E501

        :return: The candidate_last_name of this PresidentialByCandidate.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this PresidentialByCandidate.

         Candidate last name   # noqa: E501

        :param candidate_last_name: The candidate_last_name of this PresidentialByCandidate.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_party_affiliation(self):
        """Gets the candidate_party_affiliation of this PresidentialByCandidate.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The candidate_party_affiliation of this PresidentialByCandidate.  # noqa: E501
        :rtype: str
        """
        return self._candidate_party_affiliation

    @candidate_party_affiliation.setter
    def candidate_party_affiliation(self, candidate_party_affiliation):
        """Sets the candidate_party_affiliation of this PresidentialByCandidate.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param candidate_party_affiliation: The candidate_party_affiliation of this PresidentialByCandidate.  # noqa: E501
        :type: str
        """

        self._candidate_party_affiliation = candidate_party_affiliation

    @property
    def contributor_state(self):
        """Gets the contributor_state of this PresidentialByCandidate.  # noqa: E501

        State of contributor  # noqa: E501

        :return: The contributor_state of this PresidentialByCandidate.  # noqa: E501
        :rtype: str
        """
        return self._contributor_state

    @contributor_state.setter
    def contributor_state(self, contributor_state):
        """Sets the contributor_state of this PresidentialByCandidate.

        State of contributor  # noqa: E501

        :param contributor_state: The contributor_state of this PresidentialByCandidate.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                contributor_state is not None and len(contributor_state) > 2):
            raise ValueError('Invalid value for `contributor_state`, length must be less than or equal to `2`')  # noqa: E501

        self._contributor_state = contributor_state

    @property
    def election_year(self):
        """Gets the election_year of this PresidentialByCandidate.  # noqa: E501

        Year of election  # noqa: E501

        :return: The election_year of this PresidentialByCandidate.  # noqa: E501
        :rtype: int
        """
        return self._election_year

    @election_year.setter
    def election_year(self, election_year):
        """Sets the election_year of this PresidentialByCandidate.

        Year of election  # noqa: E501

        :param election_year: The election_year of this PresidentialByCandidate.  # noqa: E501
        :type: int
        """

        self._election_year = election_year

    @property
    def net_receipts(self):
        """Gets the net_receipts of this PresidentialByCandidate.  # noqa: E501

        Net contributions  # noqa: E501

        :return: The net_receipts of this PresidentialByCandidate.  # noqa: E501
        :rtype: float
        """
        return self._net_receipts

    @net_receipts.setter
    def net_receipts(self, net_receipts):
        """Sets the net_receipts of this PresidentialByCandidate.

        Net contributions  # noqa: E501

        :param net_receipts: The net_receipts of this PresidentialByCandidate.  # noqa: E501
        :type: float
        """

        self._net_receipts = net_receipts

    @property
    def rounded_net_receipts(self):
        """Gets the rounded_net_receipts of this PresidentialByCandidate.  # noqa: E501

         Net receipts, in millions   # noqa: E501

        :return: The rounded_net_receipts of this PresidentialByCandidate.  # noqa: E501
        :rtype: float
        """
        return self._rounded_net_receipts

    @rounded_net_receipts.setter
    def rounded_net_receipts(self, rounded_net_receipts):
        """Sets the rounded_net_receipts of this PresidentialByCandidate.

         Net receipts, in millions   # noqa: E501

        :param rounded_net_receipts: The rounded_net_receipts of this PresidentialByCandidate.  # noqa: E501
        :type: float
        """

        self._rounded_net_receipts = rounded_net_receipts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PresidentialByCandidate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PresidentialByCandidate):
            return True

        return self.to_dict() != other.to_dict()
