# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class PresidentialBySize(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'candidate_id': 'str',
        'contribution_receipt_amount': 'float',
        'election_year': 'int',
        'size': 'int',
        'size_range_id': 'int'
    }

    attribute_map = {
        'candidate_id': 'candidate_id',
        'contribution_receipt_amount': 'contribution_receipt_amount',
        'election_year': 'election_year',
        'size': 'size',
        'size_range_id': 'size_range_id'
    }

    def __init__(self, candidate_id=None, contribution_receipt_amount=None, election_year=None, size=None, size_range_id=None, local_vars_configuration=None):  # noqa: E501
        """PresidentialBySize - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._candidate_id = None
        self._contribution_receipt_amount = None
        self._election_year = None
        self._size = None
        self._size_range_id = None
        self.discriminator = None

        self.candidate_id = candidate_id
        self.contribution_receipt_amount = contribution_receipt_amount
        self.election_year = election_year
        self.size = size
        self.size_range_id = size_range_id

    @property
    def candidate_id(self):
        """Gets the candidate_id of this PresidentialBySize.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   -P00000001    All candidates   -P00000002    Democrasts   -P00000003    Republicans   # noqa: E501

        :return: The candidate_id of this PresidentialBySize.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this PresidentialBySize.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   -P00000001    All candidates   -P00000002    Democrasts   -P00000003    Republicans   # noqa: E501

        :param candidate_id: The candidate_id of this PresidentialBySize.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                candidate_id is not None and len(candidate_id) > 0):
            raise ValueError('Invalid value for `candidate_id`, length must be less than or equal to `0`')  # noqa: E501

        self._candidate_id = candidate_id

    @property
    def contribution_receipt_amount(self):
        """Gets the contribution_receipt_amount of this PresidentialBySize.  # noqa: E501

         Contributions received   # noqa: E501

        :return: The contribution_receipt_amount of this PresidentialBySize.  # noqa: E501
        :rtype: float
        """
        return self._contribution_receipt_amount

    @contribution_receipt_amount.setter
    def contribution_receipt_amount(self, contribution_receipt_amount):
        """Sets the contribution_receipt_amount of this PresidentialBySize.

         Contributions received   # noqa: E501

        :param contribution_receipt_amount: The contribution_receipt_amount of this PresidentialBySize.  # noqa: E501
        :type: float
        """

        self._contribution_receipt_amount = contribution_receipt_amount

    @property
    def election_year(self):
        """Gets the election_year of this PresidentialBySize.  # noqa: E501

        Year of election  # noqa: E501

        :return: The election_year of this PresidentialBySize.  # noqa: E501
        :rtype: int
        """
        return self._election_year

    @election_year.setter
    def election_year(self, election_year):
        """Sets the election_year of this PresidentialBySize.

        Year of election  # noqa: E501

        :param election_year: The election_year of this PresidentialBySize.  # noqa: E501
        :type: int
        """

        self._election_year = election_year

    @property
    def size(self):
        """Gets the size of this PresidentialBySize.  # noqa: E501

         The total all contributions in the following ranges: ```   -0    $200 and under   -200  $200.01 - $499.99   -500  $500 - $999.99   -1000 $1000 - $1999.99   -2000 $2000 + ``` Unitemized contributions are included in the `0` category.   # noqa: E501

        :return: The size of this PresidentialBySize.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this PresidentialBySize.

         The total all contributions in the following ranges: ```   -0    $200 and under   -200  $200.01 - $499.99   -500  $500 - $999.99   -1000 $1000 - $1999.99   -2000 $2000 + ``` Unitemized contributions are included in the `0` category.   # noqa: E501

        :param size: The size of this PresidentialBySize.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def size_range_id(self):
        """Gets the size_range_id of this PresidentialBySize.  # noqa: E501

         The total all contributions range id.   # noqa: E501

        :return: The size_range_id of this PresidentialBySize.  # noqa: E501
        :rtype: int
        """
        return self._size_range_id

    @size_range_id.setter
    def size_range_id(self, size_range_id):
        """Sets the size_range_id of this PresidentialBySize.

         The total all contributions range id.   # noqa: E501

        :param size_range_id: The size_range_id of this PresidentialBySize.  # noqa: E501
        :type: int
        """

        self._size_range_id = size_range_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PresidentialBySize):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PresidentialBySize):
            return True

        return self.to_dict() != other.to_dict()
